/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateScheduledTaskCategoriesTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateScheduledTaskCategoriesTranslations.class);
    private Map<Long, String> scheduledTaskCategoriesNames = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_scheduled_tasks_cat_tr";
        this.sequenceName = "pm_scheduledtaskscat_tr_id_seq";
        this.entityTableName = "pm_scheduled_tasks_category";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, name as name FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.scheduledTaskCategoriesNames.put(resultSet.getLong("id"), resultSet.getString("name"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.scheduledTaskCategoriesNames, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            InsertStatement insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getScheduledTaskCategoriesNames() {
        return this.scheduledTaskCategoriesNames;
    }

    public void setScheduledTaskCategoriesNames(Map<Long, String> scheduledTaskCategoriesNames) {
        this.scheduledTaskCategoriesNames = scheduledTaskCategoriesNames;
    }
}

