/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.dashboard;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropUniqueConstraintsPmDashboardDefaultMssql
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(DropUniqueConstraintsPmDashboardDefaultMssql.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList statements = new ArrayList();
        String query = "SELECT kc.name AS constraint_name FROM sys.tables t INNER JOIN sys.indexes i ON t.object_id = i.object_id INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id INNER JOIN sys.key_constraints kc ON i.object_id = kc.parent_object_id AND i.index_id = kc.unique_index_id WHERE t.name = 'pm_dashboard_default'   AND i.is_unique_constraint = 1   AND (     (c.name = 'group_id' AND NOT EXISTS (       SELECT 1       FROM sys.key_constraints kc2       INNER JOIN sys.indexes i2 ON kc2.parent_object_id = i2.object_id AND kc2.unique_index_id = i2.index_id       INNER JOIN sys.index_columns ic2 ON i2.object_id = ic2.object_id AND i2.index_id = ic2.index_id       INNER JOIN sys.columns c2 ON ic2.object_id = c2.object_id AND ic2.column_id = c2.column_id       WHERE t.object_id = kc2.parent_object_id         AND i2.is_unique_constraint = 1         AND c2.name = 'group_id'         AND c.name <> 'group_id'     ))     OR     (c.name = 'user_id' AND NOT EXISTS (       SELECT 1       FROM sys.key_constraints kc3       INNER JOIN sys.indexes i3 ON kc3.parent_object_id = i3.object_id AND kc3.unique_index_id = i3.index_id       INNER JOIN sys.index_columns ic3 ON i3.object_id = ic3.object_id AND i3.index_id = ic3.index_id       INNER JOIN sys.columns c3 ON ic3.object_id = c3.object_id AND ic3.column_id = c3.column_id       WHERE t.object_id = kc3.parent_object_id         AND i3.is_unique_constraint = 1         AND c3.name = 'user_id'         AND c.name <> 'user_id'     ))   );";
        HashSet<String> uniqueConstraintsToDelete = new HashSet<String>();
        try (ResultSet resultSet = connection.prepareStatement("SELECT kc.name AS constraint_name FROM sys.tables t INNER JOIN sys.indexes i ON t.object_id = i.object_id INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id INNER JOIN sys.key_constraints kc ON i.object_id = kc.parent_object_id AND i.index_id = kc.unique_index_id WHERE t.name = 'pm_dashboard_default'   AND i.is_unique_constraint = 1   AND (     (c.name = 'group_id' AND NOT EXISTS (       SELECT 1       FROM sys.key_constraints kc2       INNER JOIN sys.indexes i2 ON kc2.parent_object_id = i2.object_id AND kc2.unique_index_id = i2.index_id       INNER JOIN sys.index_columns ic2 ON i2.object_id = ic2.object_id AND i2.index_id = ic2.index_id       INNER JOIN sys.columns c2 ON ic2.object_id = c2.object_id AND ic2.column_id = c2.column_id       WHERE t.object_id = kc2.parent_object_id         AND i2.is_unique_constraint = 1         AND c2.name = 'group_id'         AND c.name <> 'group_id'     ))     OR     (c.name = 'user_id' AND NOT EXISTS (       SELECT 1       FROM sys.key_constraints kc3       INNER JOIN sys.indexes i3 ON kc3.parent_object_id = i3.object_id AND kc3.unique_index_id = i3.index_id       INNER JOIN sys.index_columns ic3 ON i3.object_id = ic3.object_id AND i3.index_id = ic3.index_id       INNER JOIN sys.columns c3 ON ic3.object_id = c3.object_id AND ic3.column_id = c3.column_id       WHERE t.object_id = kc3.parent_object_id         AND i3.is_unique_constraint = 1         AND c3.name = 'user_id'         AND c.name <> 'user_id'     ))   );").executeQuery();){
            while (resultSet.next()) {
                uniqueConstraintsToDelete.add(resultSet.getString("constraint_name"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching unique constraints for pm_dashboard_default table", (Throwable)e);
        }
        uniqueConstraintsToDelete.forEach(constraintName -> statements.add(this.generateDropUniqueConstraintStatement((String)constraintName)));
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateDropUniqueConstraintStatement(String constraintName) {
        return new RawSqlStatement(String.format("ALTER TABLE pm_dashboard_default DROP CONSTRAINT %s", constraintName));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

