--------------------------------------------------------
--  DDL for Table ACTIVITIES
--------------------------------------------------------

  CREATE TABLE "ACTIVITIES"
   (	"ID" VARCHAR2(100 BYTE),
	"ACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"PROCESS" NUMBER(19,0),
	"THERESOURCE" NUMBER(19,0),
	"PDEFNAME" VARCHAR2(200 BYTE),
	"PROCESSID" VARCHAR2(200 BYTE),
	"RESOURCEID" VARCHAR2(100 BYTE),
	"STATE" NUMBER(19,0),
	"BLOCKACTIVITYID" VARCHAR2(100 BYTE),
	"PERFORMER" VARCHAR2(100 BYTE),
	"ISPERFORMERASYNCHRONOUS" NUMBER(*,0),
	"PRIORITY" NUMBER(*,0),
	"NAME" VARCHAR2(254 BYTE),
	"ACTIVATED" NUMBER(*,0),
	"ACCEPTED" NUMBER(*,0),
	"LASTSTATETIME" NUMBER(*,0),
	"LIMITTIME" NUMBER(*,0),
	"DESCRIPTION" VARCHAR2(254 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ACTIVITYDATA
--------------------------------------------------------

  CREATE TABLE "ACTIVITYDATA"
   (	"ACTIVITY" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUE" BLOB,
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,20),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"ISRESULT" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table ACTIVITYDATABLOBS
--------------------------------------------------------

  CREATE TABLE "ACTIVITYDATABLOBS"
   (	"ACTIVITYDATAWOB" NUMBER(19,0),
	"VARIABLEVALUE" BLOB,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table ACTIVITYDATAWOB
--------------------------------------------------------

  CREATE TABLE "ACTIVITYDATAWOB"
   (	"ACTIVITY" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,20),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"ISRESULT" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ACTIVITYSTATEEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "ACTIVITYSTATEEVENTAUDITS"
   (	"KEYVALUE" VARCHAR2(30 BYTE),
	"NAME" VARCHAR2(50 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ACTIVITYSTATES
--------------------------------------------------------

  CREATE TABLE "ACTIVITYSTATES"
   (	"KEYVALUE" VARCHAR2(30 BYTE),
	"NAME" VARCHAR2(50 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ANDJOINTABLE
--------------------------------------------------------

  CREATE TABLE "ANDJOINTABLE"
   (	"PROCESS" NUMBER(19,0),
	"ACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITY" NUMBER(19,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ASSIGNMENTEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "ASSIGNMENTEVENTAUDITS"
   (	"UTCTIME" VARCHAR2(254 BYTE),
	"THETYPE" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(100 BYTE),
	"ACTIVITYNAME" VARCHAR2(254 BYTE),
	"PROCESSID" VARCHAR2(100 BYTE),
	"PROCESSNAME" VARCHAR2(254 BYTE),
	"PROCESSDEFINITIONNAME" VARCHAR2(200 BYTE),
	"PROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"ACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"PROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PACKAGEID" VARCHAR2(90 BYTE),
	"OLDRESOURCEUSERNAME" VARCHAR2(100 BYTE),
	"OLDRESOURCENAME" VARCHAR2(100 BYTE),
	"NEWRESOURCEUSERNAME" VARCHAR2(100 BYTE),
	"NEWRESOURCENAME" VARCHAR2(100 BYTE),
	"ISACCEPTED" NUMBER(*,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE TABLE "ASSIGNMENTSTABLE"
   (	"ACTIVITY" NUMBER(19,0),
	"THERESOURCE" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(100 BYTE),
	"ACTIVITYPROCESSID" VARCHAR2(100 BYTE),
	"ACTIVITYPROCESSDEFNAME" VARCHAR2(200 BYTE),
	"RESOURCEID" VARCHAR2(100 BYTE),
	"ISACCEPTED" NUMBER(*,0),
	"ISVALID" NUMBER(*,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table COUNTERS
--------------------------------------------------------

  CREATE TABLE "COUNTERS"
   (	"NAME" VARCHAR2(100 BYTE),
	"THE_NUMBER" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table CREATEPROCESSEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "CREATEPROCESSEVENTAUDITS"
   (	"UTCTIME" VARCHAR2(254 BYTE),
	"THETYPE" NUMBER(19,0),
	"PROCESSID" VARCHAR2(100 BYTE),
	"PROCESSNAME" VARCHAR2(254 BYTE),
	"PROCESSDEFINITIONNAME" VARCHAR2(200 BYTE),
	"PROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"PROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PACKAGEID" VARCHAR2(90 BYTE),
	"PACTIVITYID" VARCHAR2(100 BYTE),
	"PPROCESSID" VARCHAR2(100 BYTE),
	"PPROCESSNAME" VARCHAR2(254 BYTE),
	"PPROCESSDEFINITIONNAME" VARCHAR2(200 BYTE),
	"PPROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"PACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"PACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"PPROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PPACKAGEID" VARCHAR2(90 BYTE),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DATAEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "DATAEVENTAUDITS"
   (	"UTCTIME" VARCHAR2(254 BYTE),
	"THETYPE" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(100 BYTE),
	"ACTIVITYNAME" VARCHAR2(254 BYTE),
	"PROCESSID" VARCHAR2(100 BYTE),
	"PROCESSNAME" VARCHAR2(254 BYTE),
	"PROCESSDEFINITIONNAME" VARCHAR2(200 BYTE),
	"PROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"ACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"PROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PACKAGEID" VARCHAR2(90 BYTE),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEADLINES
--------------------------------------------------------

  CREATE TABLE "DEADLINES"
   (	"PROCESS" NUMBER(19,0),
	"ACTIVITY" NUMBER(19,0),
	"CNT" NUMBER(19,0),
	"TIMELIMIT" NUMBER(*,0),
	"EXCEPTIONNAME" VARCHAR2(100 BYTE),
	"ISSYNCHRONOUS" NUMBER(*,0),
	"ISEXECUTED" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EVENTTYPES
--------------------------------------------------------

  CREATE TABLE "EVENTTYPES"
   (	"KEYVALUE" VARCHAR2(30 BYTE),
	"NAME" VARCHAR2(50 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table GROUPGROUPTABLE
--------------------------------------------------------

  CREATE TABLE "GROUPGROUPTABLE"
   (	"SUB_GID" NUMBER(19,0),
	"GROUPID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table GROUPTABLE
--------------------------------------------------------

  CREATE TABLE "GROUPTABLE"
   (	"GROUPID" VARCHAR2(100 BYTE),
	"DESCRIPTION" VARCHAR2(254 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table GROUPUSER
--------------------------------------------------------

  CREATE TABLE "GROUPUSER"
   (	"USERNAME" VARCHAR2(100 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table GROUPUSERPACKLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "GROUPUSERPACKLEVELPARTICIPANT"
   (	"PARTICIPANTOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table GROUPUSERPROCLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "GROUPUSERPROCLEVELPARTICIPANT"
   (	"PARTICIPANTOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table LOCKTABLE
--------------------------------------------------------

  CREATE TABLE "LOCKTABLE"
   (	"ENGINENAME" VARCHAR2(100 BYTE),
	"ID" VARCHAR2(100 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table NEWEVENTAUDITDATA
--------------------------------------------------------

  CREATE TABLE "NEWEVENTAUDITDATA"
   (	"DATAEVENTAUDIT" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUE" BLOB,
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,0),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table NEWEVENTAUDITDATABLOBS
--------------------------------------------------------

  CREATE TABLE "NEWEVENTAUDITDATABLOBS"
   (	"NEWEVENTAUDITDATAWOB" NUMBER(19,0),
	"VARIABLEVALUE" BLOB,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table NEWEVENTAUDITDATAWOB
--------------------------------------------------------

  CREATE TABLE "NEWEVENTAUDITDATAWOB"
   (	"DATAEVENTAUDIT" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,0),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table NEXTXPDLVERSIONS
--------------------------------------------------------

  CREATE TABLE "NEXTXPDLVERSIONS"
   (	"XPDLID" VARCHAR2(90 BYTE),
	"NEXTVERSION" VARCHAR2(20 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table NORMALUSER
--------------------------------------------------------

  CREATE TABLE "NORMALUSER"
   (	"USERNAME" VARCHAR2(100 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table OBJECTID
--------------------------------------------------------

  CREATE TABLE "OBJECTID"
   (	"NEXT" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table OLDEVENTAUDITDATA
--------------------------------------------------------

  CREATE TABLE "OLDEVENTAUDITDATA"
   (	"DATAEVENTAUDIT" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUE" BLOB,
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,0),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table OLDEVENTAUDITDATABLOBS
--------------------------------------------------------

  CREATE TABLE "OLDEVENTAUDITDATABLOBS"
   (	"OLDEVENTAUDITDATAWOB" NUMBER(19,0),
	"VARIABLEVALUE" BLOB,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table OLDEVENTAUDITDATAWOB
--------------------------------------------------------

  CREATE TABLE "OLDEVENTAUDITDATAWOB"
   (	"DATAEVENTAUDIT" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,0),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "PACKLEVELPARTICIPANT"
   (	"PARTICIPANT_ID" VARCHAR2(90 BYTE),
	"PACKAGEOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELXPDLAPP
--------------------------------------------------------

  CREATE TABLE "PACKLEVELXPDLAPP"
   (	"APPLICATION_ID" VARCHAR2(90 BYTE),
	"PACKAGEOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  CREATE TABLE "PACKLEVELXPDLAPPTAAPPDETAIL"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  CREATE TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  CREATE TABLE "PACKLEVELXPDLAPPTAAPPUSER"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PACKLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  CREATE TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIONS
--------------------------------------------------------

  CREATE TABLE "PM_ACTIONS"
   (	"ID" NUMBER(19,0),
	"DOCCLASSID" NUMBER(19,0),
	"ACTIONNAME" VARCHAR2(255 CHAR),
	"ACTIONSOURCE" VARCHAR2(255 CHAR),
	"ACTIONTYPE" VARCHAR2(255 CHAR),
	"ACTIONVALUE" VARCHAR2(255 CHAR),
	"ACTIONVALUE2" VARCHAR2(4000 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVATEDTIMES
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVATEDTIMES"
   (	"ID" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(255 CHAR),
	"ACTIVATEDTIME" NUMBER(19,0),
	"ACTIVATED" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITYCOMMENTS
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITYCOMMENTS"
   (	"ID" NUMBER(19,0),
	"PROCESSID" VARCHAR2(255 CHAR),
	"ACTIVITYID" VARCHAR2(255 CHAR),
	"USERID" VARCHAR2(255 CHAR),
	"ACTIVITY_COMMENT" VARCHAR2(4000 CHAR),
	"TIMESTAMP" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITY_DOCUMENT"
   (	"ID" NUMBER(19,0),
	"ADDEDHERE" NUMBER(1,0),
	"date" TIMESTAMP (6),
	"ACTIVITY" NUMBER(19,0),
	"FILEID" NUMBER(19,0),
	"PROCESS" NUMBER(19,0),
	"USERID" NUMBER(19,0),
	"VERSION" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITYREDIRECTION
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITYREDIRECTION"
   (	"ID" NUMBER(19,0),
	"ACTIVITYDEFID" VARCHAR2(255 CHAR),
	"PROCESSDEFID" VARCHAR2(255 CHAR),
	"SOURCEUSER" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITYREDIRECTION_GROUPS
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITYREDIRECTION_GROUPS"
   (	"REDIRECTION" NUMBER(19,0),
	"TARGETGROUP" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITYREDIRECTION_USERS
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITYREDIRECTION_USERS"
   (	"REDIRECTION" NUMBER(19,0),
	"TARGETUSER" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITY_STATUS
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITY_STATUS"
   (	"STATUS_ID" NUMBER(19,0),
	"PROCESS_ID" VARCHAR2(100 CHAR),
	"ACTIVITY_ID" VARCHAR2(100 CHAR),
	"ACTIVITY_ACCEPTANCE_TIME" NUMBER(19,0),
	"STATUS_TYPE" NUMBER(10,0),
	"STATUS_IS_NEWEST" NUMBER(1,0),
	"STATUS_DATE" TIMESTAMP (6),
	"STATUS_AUTHOR" VARCHAR2(100 CHAR),
	"STATUS_MESSAGE" LONG,
	"CHECK_FORM_ACCEPT" NUMBER(1,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ACTIVITY_TRANSLATION
--------------------------------------------------------

  CREATE TABLE "PM_ACTIVITY_TRANSLATION"
   (	"PACKAGEID" VARCHAR2(254 CHAR),
	"PROCESSDEFID" VARCHAR2(254 CHAR),
	"ACTIVITYDEFID" VARCHAR2(254 CHAR),
	"LANGUAGE" VARCHAR2(254 CHAR),
	"NAME" VARCHAR2(254 CHAR),
	"DESCRIPTION" LONG
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ADVANCESEARCHVARIABLES
--------------------------------------------------------

  CREATE TABLE "PM_ADVANCESEARCHVARIABLES"
   (	"ID" NUMBER(19,0),
	"VIEWID" VARCHAR2(255 CHAR),
	"NAME" VARCHAR2(255 CHAR),
	"VALUE" VARCHAR2(1024 CHAR),
	"VALUE2" VARCHAR2(1024 CHAR),
	"SORTTYPE" VARCHAR2(255 CHAR),
	"POSITION" VARCHAR2(255 CHAR),
	"ACTIVE" VARCHAR2(255 CHAR),
	"UPPERCASE" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_AUDITS
--------------------------------------------------------

  CREATE TABLE "PM_AUDITS"
   (	"ID" NUMBER(19,0),
	"USERID" VARCHAR2(128 CHAR),
	"IPADDRESS" VARCHAR2(255 CHAR),
	"THREADID" VARCHAR2(255 CHAR),
	"AUDITTYPE" VARCHAR2(255 CHAR),
	"AUDITSTARTED" NUMBER(19,0),
	"AUDITSTOPPED" NUMBER(19,0),
	"AUDITDURATION" NUMBER(19,0),
	"AUDITSUCCESS" NUMBER(1,0),
	"AUDITPARAMS" LONG
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DELEGATEDACTIVITIES
--------------------------------------------------------

  CREATE TABLE "PM_DELEGATEDACTIVITIES"
   (	"ID" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(255 CHAR),
	"USERID" VARCHAR2(255 CHAR),
	"DELEGATEDUSER" VARCHAR2(255 CHAR),
	"TRANSFERTYPE" VARCHAR2(20 CHAR) NOT NULL,
	"INACTIVE" NUMBER(1,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DEVICES
--------------------------------------------------------

  CREATE TABLE "PM_DEVICES"
   (	"ID" NUMBER(19,0),
	"DEVICEFREESPACE" NUMBER(19,0),
	"DEVICENAME" VARCHAR2(255 CHAR),
	"DEVICEPATH" VARCHAR2(255 CHAR),
	"DEVICESIZE" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DIRECTORIES
--------------------------------------------------------

  CREATE TABLE "PM_DIRECTORIES"
   (	"ID" NUMBER(19,0),
	"DIRECTORYFREESPACE" NUMBER(19,0),
	"DIRECTORYNAME" VARCHAR2(255 CHAR),
	"DIRECTORYSIZE" NUMBER(19,0),
	"DIRECTORYTHRESHOLD" NUMBER(19,0),
	"DEVICEID" NUMBER(19,0),
	"ROOTDIRECTORYID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOCCLASSCONDITIONPROTECTION
--------------------------------------------------------

  CREATE TABLE "PM_DOCCLASSCONDITIONPROTECTION"
   (	"ID" NUMBER(19,0),
	"CONDITION" VARCHAR2(255 CHAR),
	"CONDITIONTYPE" VARCHAR2(255 CHAR),
	"ISGROUP" NUMBER(1,0),
	"PROTECTOR" VARCHAR2(255 CHAR),
	"USERID" VARCHAR2(255 CHAR),
	"DOCCLASSID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOCCLASSES
--------------------------------------------------------

  CREATE TABLE "PM_DOCCLASSES"
   (	"ID" NUMBER(19,0),
	"DOCCLASSNAME" VARCHAR2(255 CHAR),
	"DOCCLASSDESCRIPTION" VARCHAR2(255 CHAR),
	"DOCCLASSEXPIRETIONDATE" VARCHAR2(255 CHAR),
	"DOCCLASSEXPIRETIONTYPE" VARCHAR2(255 CHAR),
	"DOCCLASSDIRECTORYID" NUMBER(19,0),
	"DOCCLASSENCODING" VARCHAR2(255 CHAR),
	"DOCCLASSCOMPRESSING" VARCHAR2(255 CHAR),
	"DOCCLASSFTSSERVERID" NUMBER(19,0),
	"CIPHERALGORITHM" VARCHAR2(255 CHAR),
	"KEYLENGTH" NUMBER(19,0),
	"DOCCLASSORDERID" NUMBER(19,0),
	"DOCCLASSINDEXPATH" VARCHAR2(255 CHAR),
	"DOCCLASSINDEX" VARCHAR2(255 CHAR),
	"LOGICALCONN" VARCHAR2(255 CHAR),
	"MAXFILESIZE" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOCCLASSPROTECTION
--------------------------------------------------------

  CREATE TABLE "PM_DOCCLASSPROTECTION"
   (	"DOCCLASSID" NUMBER(19,0),
	"ISGROUP" NUMBER(1,0),
	"RESOURCEID" VARCHAR2(255 CHAR),
	"LOGICALCONNECTION" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOCUMENTTEMPLATE
--------------------------------------------------------

  CREATE TABLE "PM_DOCUMENTTEMPLATE"
   (	"ID" NUMBER(19,0),
	"TEMPLATENAME" VARCHAR2(255 CHAR),
	"TEMPLATEPATH" VARCHAR2(255 CHAR),
	"PROCESSID" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOCUMENT_VIEWS
--------------------------------------------------------

  CREATE TABLE "PM_DOCUMENT_VIEWS"
   (	"DOCUMENT_VIEW_ID" NUMBER(19,0),
	"DOCUMENT_VIEW_NAME" VARCHAR2(255 CHAR),
	"DOCUMENT_VIEW_DESC" VARCHAR2(255 CHAR),
	"PROC_DEF_ID" VARCHAR2(255 CHAR),
	"TASK_DEF_ID" VARCHAR2(255 CHAR),
	"USER_ID" VARCHAR2(255 CHAR),
	"DOC_CLASS_ID" NUMBER(19,0),
	"IS_DESCENDING" NUMBER(1,0),
	"AMOUNT" NUMBER(10,0),
	"REGEX" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_DOMAINSERVERS
--------------------------------------------------------

  CREATE TABLE "PM_DOMAINSERVERS"
   (	"ID" NUMBER(19,0),
	"DOMAINNAME" VARCHAR2(255 CHAR),
	"DOMAINSERVERADRES" VARCHAR2(255 CHAR),
	"DOMAINSERVERPORT" NUMBER(19,0),
	"DOMAINUSER" VARCHAR2(255 CHAR),
	"DOMAINUSERPASSWORD" VARCHAR2(255 CHAR),
	"DOMAINBASESEARCH" VARCHAR2(255 CHAR),
	"USERNAMETEMPLATE" VARCHAR2(255 CHAR),
	"DOMAINSPNEGO" VARCHAR2(255 CHAR),
	"USERNAMEMAPPING" VARCHAR2(255 CHAR),
	"FIRSTNAMEMAPPING" VARCHAR2(255 CHAR),
	"LASTNAMEMAPPING" VARCHAR2(255 CHAR),
	"EMAILMAPPING" VARCHAR2(255 CHAR),
	"MEMBERMAPPING" VARCHAR2(255 CHAR),
	"MEMBEROFMAPPING" VARCHAR2(255 CHAR),
	"NUMBERMAPPING" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_EMAILNOTIFICATION
--------------------------------------------------------

  CREATE TABLE "PM_EMAILNOTIFICATION"
   (	"ID" NUMBER(19,0),
	"SPROCESSTYPENAME" VARCHAR2(255 CHAR),
	"STASKNAME" VARCHAR2(255 CHAR),
	"SUSERNAME" VARCHAR2(255 CHAR),
	"SISGROUP" VARCHAR2(255 CHAR),
	"SNOTIFICATIONTYPE" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_FILES
--------------------------------------------------------

  CREATE TABLE "PM_FILES"
   (	"ID" NUMBER(19,0),
	"FILE_DATE" TIMESTAMP (6),
	"NAME" VARCHAR2(255 CHAR),
	"ORG_NAME" VARCHAR2(255 CHAR),
	"PATH" VARCHAR2(255 CHAR),
	"UPLOADER" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(255 CHAR),
	"FILE_SIZE" NUMBER(19,0),
	"COMPRESSED" VARCHAR2(255 CHAR),
	"ENCRYPTED" VARCHAR2(255 CHAR),
	"CIPHERALGORITHM" VARCHAR2(255 CHAR),
	"CIPHERKEY" VARCHAR2(255 CHAR),
	"DOCCLASSID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_FILE_VERSIONS
--------------------------------------------------------

  CREATE TABLE "PM_FILE_VERSIONS"
   (	"ID" NUMBER(19,0),
	"FILEID" NUMBER(19,0),
	"PARENT_FILEID" NUMBER(19,0),
	"CHECKOUT_DATE" DATE,
	"CHECKIN_DATE" DATE,
	"CHECKOUT_USER" VARCHAR2(255 CHAR),
	"STATE" VARCHAR2(255 CHAR),
	"FILE_COMMENT" VARCHAR2(255 CHAR),
	"REPLACE_DATE" DATE,
	"VERSION" NUMBER(19,0),
	"NEWEST_FILEID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_INDECIES
--------------------------------------------------------

  CREATE TABLE "PM_INDECIES"
   (	"ID" NUMBER(19,0),
	"DOCCLASSID" NUMBER(19,0),
	"INDEXNAME" VARCHAR2(255 CHAR),
	"INDEXDESCRIPTION" VARCHAR2(255 CHAR),
	"INDEXTYPE" VARCHAR2(255 CHAR),
	"INDEXVALUES" VARCHAR2(4000 CHAR),
	"INDEXORDERID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_LICENSE
--------------------------------------------------------

  CREATE TABLE "PM_LICENSE"
   (	"ID" NUMBER(19,0),
	"DATES" BLOB,
	"LICENSEDATA" BLOB,
	"PUBLICKEY" BLOB
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS"
 LOB ("DATES") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES )
 LOB ("LICENSEDATA") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES )
 LOB ("PUBLICKEY") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES ) ;
  --------------------------------------------------------
--  DDL for Table PM_TRIAL
--------------------------------------------------------

  CREATE TABLE "PM_TRIAL"
   (	"ID" NUMBER(19,0),
	"DATA" BLOB
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS"
 LOB ("DATA") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES ) ;
--------------------------------------------------------
--  DDL for Table PM_LINKCONNECTION
--------------------------------------------------------

  CREATE TABLE "PM_LINKCONNECTION"
   (	"ID" NUMBER(19,0),
	"LINKID" NUMBER(19,0),
	"LINKINDEXID" NUMBER(19,0),
	"DOCCLASSID" NUMBER(19,0),
	"INDEXID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_LINKINDECIES
--------------------------------------------------------

  CREATE TABLE "PM_LINKINDECIES"
   (	"ID" NUMBER(19,0),
	"LINKID" NUMBER(19,0),
	"INDEXNAME" VARCHAR2(255 CHAR),
	"INDEXDESCRIPTION" VARCHAR2(255 CHAR),
	"INDEXTYPE" VARCHAR2(255 CHAR),
	"INDEXVALUES" VARCHAR2(4000 CHAR),
	"INDEXORDER" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_LINKS
--------------------------------------------------------

  CREATE TABLE "PM_LINKS"
   (	"ID" NUMBER(19,0),
	"LINKNAME" VARCHAR2(255 CHAR),
	"LINKDESCRIPTION" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_NOTIFICATIONDEF
--------------------------------------------------------

  CREATE TABLE "PM_NOTIFICATIONDEF"
   (	"ID" NUMBER(19,0),
	"NAME" VARCHAR2(255 CHAR),
	"SUBJECT" VARCHAR2(255 CHAR),
	"TEMPLATEPATH" VARCHAR2(4000 CHAR),
	"CONDITIONTYPE" VARCHAR2(255 CHAR),
	"CONDITIONVARNAME" VARCHAR2(255 CHAR),
	"CONDITIONVAL" VARCHAR2(255 CHAR),
	"RECIPIENTPERFORMER" NUMBER(1,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_NOTIFICATIONPROCACT
--------------------------------------------------------

  CREATE TABLE "PM_NOTIFICATIONPROCACT"
   (	"ID" NUMBER(19,0),
	"NOTIFICATIONDEFID" VARCHAR2(255 CHAR),
	"PROCESSDEFID" VARCHAR2(255 CHAR),
	"ACTIVITYDEFID" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_NOTIFICATIONRECIPIENT
--------------------------------------------------------

  CREATE TABLE "PM_NOTIFICATIONRECIPIENT"
   (	"ID" NUMBER(19,0),
	"NOTIFICATIONDEFID" VARCHAR2(255 CHAR),
	"RECIPIENTTYPE" VARCHAR2(255 CHAR),
	"RECIPIENTVAL" VARCHAR2(255 CHAR),
	"RECIPIENTEXCLUDED" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_NOTIFICATIONS
--------------------------------------------------------

  CREATE TABLE "PM_NOTIFICATIONS"
   (	"ID" NUMBER(19,0),
	"NOTIFICATIONDEFID" VARCHAR2(255 CHAR),
	"PROCESSID" VARCHAR2(255 CHAR),
	"ACTIVITYID" VARCHAR2(255 CHAR),
	"RECIPIENTUSERIDS" LONG
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_OPENED_FILES
--------------------------------------------------------

  CREATE TABLE "PM_OPENED_FILES"
   (	"ID" NUMBER(19,0),
	"FILEID" NUMBER(19,0),
	"USERNAME" VARCHAR2(255 CHAR),
	"FILENAME" VARCHAR2(255 CHAR),
	"SESSIONID" VARCHAR2(255 CHAR),
	"DATEOFOPEN" TIMESTAMP (6)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_OPERATION_PANEL
--------------------------------------------------------

  CREATE TABLE "PM_OPERATION_PANEL"
   (	"OPERATION_PANEL_ID" NUMBER(19,0),
	"USERID" VARCHAR2(255 CHAR),
	"NAME" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_OPERATION_PANEL_PARAMETERS
--------------------------------------------------------

  CREATE TABLE "PM_OPERATION_PANEL_PARAMETERS"
   (	"OPERATION_PANEL_PARAMETER_ID" NUMBER(19,0),
	"NAME" VARCHAR2(255 CHAR),
	"TYPE" VARCHAR2(255 CHAR),
	"PARAMS" VARCHAR2(255 CHAR),
	"IS_COUNT" NUMBER(1,0),
	"POSITION" NUMBER(19,0),
	"OPERATION_PANEL_ID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ORGANIZATIONALUNITS
--------------------------------------------------------

  CREATE TABLE "PM_ORGANIZATIONALUNITS"
   (	"ID" NUMBER(19,0),
	"ORGANIZATIONALUNITNAME" VARCHAR2(255 CHAR),
	"ORGANIZATIONALUNITSYMBOL" VARCHAR2(255 CHAR),
	"DIRECTORPOSITIONID" NUMBER(19,0),
	"HIGHERORGANIZATIONALUNITID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_PLUGINS_CONFIGURATION
--------------------------------------------------------

  CREATE TABLE "PM_PLUGINS_CONFIGURATION"
   (	"ID" VARCHAR2(255 CHAR),
	"PLUGIN_NAME" VARCHAR2(255 CHAR),
	"ENTRY_FILE_NAME" VARCHAR2(255 CHAR),
	"PLUGIN_FILE_NAME" VARCHAR2(255 CHAR),
	"PLUGIN_FILE_MD5" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_POSITION_ROLE
--------------------------------------------------------

  CREATE TABLE "PM_POSITION_ROLE"
   (	"POSITIONID" NUMBER(19,0),
	"ROLEID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_POSITIONS
--------------------------------------------------------

  CREATE TABLE "PM_POSITIONS"
   (	"ID" NUMBER(19,0),
	"POSITIONNAME" VARCHAR2(255 CHAR),
	"POSITIONSYMBOL" VARCHAR2(255 CHAR),
	"HIGHERPOSITIONID" NUMBER(19,0),
	"ORGANIZATIONALUNITID" NUMBER(19,0),
	"USERID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_PROCESSDATA
--------------------------------------------------------

  CREATE TABLE "PM_PROCESSDATA"
   (	"ID" NUMBER(19,0),
	"SPROCESSFIELDNAME" VARCHAR2(255 CHAR),
	"SPROCESSFIELDVALUE" VARCHAR2(255 CHAR),
	"SPROCESSTYPENAME" VARCHAR2(255 CHAR),
	"STASKTYPENAME" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_PROCESS_TRANSLATION
--------------------------------------------------------

  CREATE TABLE "PM_PROCESS_TRANSLATION"
   (	"PROCESSID" VARCHAR2(255 CHAR),
	"LANGUAGE" VARCHAR2(255 CHAR),
	"NAME" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_PROCESSTYPES
--------------------------------------------------------

  CREATE TABLE "PM_PROCESSTYPES"
   (	"ID" NUMBER(19,0),
	"SPROCESSTYPENAME" VARCHAR2(255 CHAR),
	"SPROCESSINDECESTABLE" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_REPORTLISTVARIABLEVALUE
--------------------------------------------------------

  CREATE TABLE "PM_REPORTLISTVARIABLEVALUE"
   (	"ID" NUMBER(19,0),
	"VARIABLEID" NUMBER(19,0),
	"LISTVALUEID" VARCHAR2(255 CHAR),
	"LISTVALUEDISPLAY" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_REPORTS
--------------------------------------------------------

  CREATE TABLE "PM_REPORTS"
   (	"ID" NUMBER(19,0),
	"VIEWID" NUMBER(19,0),
	"REPORTNAME" VARCHAR2(255 CHAR),
	"REPORTDESCR" VARCHAR2(255 CHAR),
	"ACCESSLEVEL" VARCHAR2(255 CHAR),
	"USERNAME" VARCHAR2(255 CHAR),
	"SHOWFORMONRESULT" VARCHAR2(255 CHAR),
	"CANFILTERRESULT" VARCHAR2(255 CHAR),
	"REPORTTYPE" VARCHAR2(255 CHAR),
	"REPORTDEFINITIONPATH" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_REPORTSPROTECTION
--------------------------------------------------------

  CREATE TABLE "PM_REPORTSPROTECTION"
   (	"ID" NUMBER(19,0),
	"REPORTID" VARCHAR2(255 CHAR),
	"SHAREUSERID" VARCHAR2(255 CHAR),
	"ISGROUP" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_REPORTVARIABLE
--------------------------------------------------------

  CREATE TABLE "PM_REPORTVARIABLE"
   (	"ID" NUMBER(19,0),
	"REPORTID" VARCHAR2(255 CHAR),
	"NAME" VARCHAR2(255 CHAR),
	"VIEWNAME" VARCHAR2(255 CHAR),
	"SORTTYPE" VARCHAR2(255 CHAR),
	"POSITION" VARCHAR2(255 CHAR),
	"ACTIVE" VARCHAR2(255 CHAR),
	"GROUPED" VARCHAR2(255 CHAR),
	"SUM" VARCHAR2(255 CHAR),
	"AVG" VARCHAR2(255 CHAR),
	"MIN" VARCHAR2(255 CHAR),
	"MAX" VARCHAR2(255 CHAR),
	"COUNT" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_RIGHTS
--------------------------------------------------------

  CREATE TABLE "PM_RIGHTS"
   (	"ID" NUMBER(19,0),
	"RIGHT_TYPE" NUMBER(3,0),
	"RESOURCE_ID" VARCHAR2(100 CHAR),
	"IS_RESOURCE_A_GROUP" NUMBER(1,0),
	"RIGHT_LEVEL" VARCHAR2(768 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_ROLES
--------------------------------------------------------

  CREATE TABLE "PM_ROLES"
   (	"ID" NUMBER(19,0),
	"PACKAGEID" VARCHAR2(255 CHAR),
	"PROCESSDEFID" VARCHAR2(255 CHAR),
	"ROLEID" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_SCHEDULED_TASKS
--------------------------------------------------------

  CREATE TABLE "PM_SCHEDULED_TASKS"
   (	"SCHEDULED_TASK_ID" NUMBER(19,0),
	"NAME" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(255 CHAR),
	"IS_ACTIVE" NUMBER(1,0),
	"IS_PROCESSING" NUMBER(1,0),
	"SAVEHISTORY" NUMBER(1,0),
	"CLASS_NAME" VARCHAR2(255 CHAR),
	"METHOD_NAME" VARCHAR2(255 CHAR),
	"FIRST_RUN" TIMESTAMP (6),
	"NEXT_RUN" TIMESTAMP (6),
	"LAST_RUN" TIMESTAMP (6),
	"PERIOD_MILISECONDS" NUMBER(19,0),
	"CATEGORY_ID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;

  --------------------------------------------------------
  --  DDL for Table PM_SCHEDULED_TASKS_COMPONENT
  --------------------------------------------------------

  CREATE TABLE "PM_SCHEDULED_TASKS_COMPONENT" (
	"ID" NUMBER(19,0) NOT NULL,
	"PLUGINID" VARCHAR2(255 CHAR) NOT NULL,
	"SCHEDULEDTASKID" NUMBER(19,0) NOT NULL,
  CONSTRAINT "pm_scheduledtaskscomp_pk" PRIMARY KEY ("ID")
  )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;

  CREATE SEQUENCE "PM_SCHEDULEDTASKSCOMP_SEQ"
    START WITH 1
    INCREMENT BY 1
    NOMAXVALUE
    NOCYCLE;

--------------------------------------------------------
--  DDL for Table PM_SCHEDULED_TASKS_CATEGORY
--------------------------------------------------------

  CREATE TABLE "PM_SCHEDULED_TASKS_CATEGORY"
   (	"ID" NUMBER(19,0),
	"NAME" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_SCHEDULED_TASKS_HISTORY
--------------------------------------------------------

  CREATE TABLE "PM_SCHEDULED_TASKS_HISTORY"
   (	"ID" NUMBER(19,0),
	"STARTDATE" TIMESTAMP (6),
	"FINISHDATE" TIMESTAMP (6),
	"SUCCESS" NUMBER(1,0),
	"RESULT" VARCHAR2(1000 CHAR),
	"TASKID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_SCHEDULED_TASKS_PARAMETERS
--------------------------------------------------------

  CREATE TABLE "PM_SCHEDULED_TASKS_PARAMETERS"
   (	"SCHEDULED_TASK_PARAMETER_ID" NUMBER(19,0),
	"PARAMETER_TYPE" VARCHAR2(255 CHAR),
	"PARAMETER_VALUE" VARCHAR2(255 CHAR),
	"PARAMETER_POSITION" NUMBER(10,0),
	"SCHEDULED_TASK_ID" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_SUBSTITUTIONS
--------------------------------------------------------

  CREATE TABLE "PM_SUBSTITUTIONS"
   (	"ID" NUMBER(19,0),
	"PROCESSDEFID" VARCHAR2(255 CHAR),
	"ROLE" NUMBER(19,0),
	"SUBSTITUTED" NUMBER(19,0),
	"SUBSTITUTE" NUMBER(19,0),
	"STARTDATE" NUMBER(19,0),
	"FINISHDATE" NUMBER(19,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USERCALENDARSHARE
--------------------------------------------------------

  CREATE TABLE "PM_USERCALENDARSHARE"
   (	"ID" NUMBER(19,0),
	"OWNERID" VARCHAR2(255 CHAR),
	"SHAREUSERID" VARCHAR2(255 CHAR),
	"ISGROUP" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USERDATA
--------------------------------------------------------

  CREATE TABLE "PM_USERDATA"
   (	"ID" NUMBER(19,0),
	"USERID" NUMBER(19,0),
	"USERFIELDNAME" VARCHAR2(255 CHAR),
	"USERFIELDVALUE" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USER_NOTIFICATION_CONFIGS
--------------------------------------------------------

  CREATE TABLE "PM_USER_NOTIFICATION_CONFIGS"
   (	"ID" NUMBER(19,0),
	"PROCESSDEFID" VARCHAR2(255 CHAR),
	"LANG" VARCHAR2(255 CHAR),
	"PROCESSEND" VARCHAR2(2500 CHAR),
	"ACTIVITYEND" VARCHAR2(2500 CHAR),
	"ACTIVITYDELIVER" VARCHAR2(2500 CHAR),
	"ENABLED" NUMBER(1,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USER_NOTIFICATIONS
--------------------------------------------------------

  CREATE TABLE "PM_USER_NOTIFICATIONS"
   (	"ID" NUMBER(19,0),
	"SENDER" VARCHAR2(255 CHAR),
	"NOTIFDATE" TIMESTAMP (6),
	"MESSAGE" VARCHAR2(4000 CHAR),
	"RECEIVER" VARCHAR2(255 CHAR),
	"CONFIRMED" NUMBER(1,0),
	"FAILURE" NUMBER(1,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USERSEARCHVIEWS
--------------------------------------------------------

  CREATE TABLE "PM_USERSEARCHVIEWS"
   (	"ID" NUMBER(19,0),
	"VAL" VARCHAR2(4000 CHAR),
	"VIEWNAME" VARCHAR2(255 CHAR),
	"VIEWDESCR" VARCHAR2(255 CHAR),
	"ACCESSLEVEL" VARCHAR2(255 CHAR),
	"SOURCE" VARCHAR2(255 CHAR),
	"USERNAME" VARCHAR2(255 CHAR),
	"SHOWFORMONRESULT" VARCHAR2(255 CHAR),
	"ACCEPTMANYTASKS" VARCHAR2(255 CHAR),
	"SHOWSEARCHRESULTONRESULT" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_USERSEARCHVIEWSPROTECTION
--------------------------------------------------------

  CREATE TABLE "PM_USERSEARCHVIEWSPROTECTION"
   (	"ID" NUMBER(19,0),
	"VIEWID" VARCHAR2(255 CHAR),
	"SHAREUSERID" VARCHAR2(255 CHAR),
	"ISGROUP" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VARIABLE_DISTINGUISH
--------------------------------------------------------

  CREATE TABLE "PM_VARIABLE_DISTINGUISH"
   (	"VARIABLE_DISTINGUISH_ID" NUMBER(19,0),
	"VARIABLEID" VARCHAR2(255 CHAR),
	"VARIABLENAME" VARCHAR2(255 CHAR),
	"VARIABLEVALUE" LONG,
	"VARIABLEVALUE2" VARCHAR2(255 CHAR),
	"VIEWID" VARCHAR2(255 CHAR),
	"IMAGEPATH" VARCHAR2(255 CHAR),
	"VARIABLEVIEWTYPE" VARCHAR2(255 CHAR),
	"VARIABLEFORMAT" VARCHAR2(255 CHAR),
	"COLOR" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VARIABLE_SET_TEMP
--------------------------------------------------------

  CREATE TABLE "PM_VARIABLE_SET_TEMP"
   (	"PROCESS_ID" VARCHAR2(100 CHAR),
	"ACTIVITY_ID" VARCHAR2(100 CHAR),
	"VARIABLE_ID" VARCHAR2(100 CHAR),
	"VARIABLE_VALUE" LONG
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VCOLUMNS
--------------------------------------------------------

  CREATE TABLE "PM_VCOLUMNS"
   (	"TABLEID" VARCHAR2(255 CHAR),
	"ID" VARCHAR2(255 CHAR),
	"MODIFIED" TIMESTAMP (6),
	"NAME" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(1024 CHAR),
	"TYPEID" VARCHAR2(256 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VTABLES
--------------------------------------------------------

  CREATE TABLE "PM_VTABLES"
   (	"ID" VARCHAR2(255 CHAR),
	"NAME" VARCHAR2(255 CHAR),
	"DESCRIPTION" VARCHAR2(1024 CHAR),
	"USERID" VARCHAR2(255 CHAR),
	"VTABLE_ROWS" NUMBER(10,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VTYPES
--------------------------------------------------------

  CREATE TABLE "PM_VTYPES"
   (	"ID" VARCHAR2(256 CHAR),
	"NAME" VARCHAR2(512 CHAR),
	"DESCRIPTION" VARCHAR2(1024 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PM_VVALUES
--------------------------------------------------------

  CREATE TABLE "PM_VVALUES"
   (	"TABLEID" VARCHAR2(255 CHAR),
	"COLUMNID" VARCHAR2(255 CHAR),
	"VVALUE_ROWID" NUMBER(10,0),
	"MODIFIED" TIMESTAMP (6),
	"CELLVALUE" VARCHAR2(1024 CHAR),
	"USERID" VARCHAR2(255 CHAR)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSDATA
--------------------------------------------------------

  CREATE TABLE "PROCESSDATA"
   (	"PROCESS" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUE" BLOB,
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,20),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table PROCESSDATABLOBS
--------------------------------------------------------

  CREATE TABLE "PROCESSDATABLOBS"
   (	"PROCESSDATAWOB" NUMBER(19,0),
	"VARIABLEVALUE" BLOB,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("VARIABLEVALUE") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table PROCESSDATAWOB
--------------------------------------------------------

  CREATE TABLE "PROCESSDATAWOB"
   (	"PROCESS" NUMBER(19,0),
	"VARIABLEDEFINITIONID" VARCHAR2(100 BYTE),
	"VARIABLETYPE" NUMBER(*,0),
	"VARIABLEVALUEVCHAR" VARCHAR2(4000 BYTE),
	"VARIABLEVALUEDBL" NUMBER(*,20),
	"VARIABLEVALUELONG" NUMBER(*,0),
	"VARIABLEVALUEDATE" DATE,
	"VARIABLEVALUEBOOL" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSDEFINITIONS
--------------------------------------------------------

  CREATE TABLE "PROCESSDEFINITIONS"
   (	"NAME" VARCHAR2(200 BYTE),
	"PACKAGEID" VARCHAR2(90 BYTE),
	"PROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PROCESSDEFINITIONCREATED" NUMBER(*,0),
	"PROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"STATE" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSES
--------------------------------------------------------

  CREATE TABLE "PROCESSES"
   (	"ID" VARCHAR2(100 BYTE),
	"PROCESSDEFINITION" NUMBER(19,0),
	"PDEFNAME" VARCHAR2(200 BYTE),
	"ACTIVITYREQUESTERID" VARCHAR2(100 BYTE),
	"ACTIVITYREQUESTERPROCESSID" VARCHAR2(100 BYTE),
	"RESOURCEREQUESTERID" VARCHAR2(100 BYTE),
	"EXTERNALREQUESTERCLASSNAME" VARCHAR2(254 BYTE),
	"STATE" NUMBER(19,0),
	"PRIORITY" NUMBER(*,0),
	"NAME" VARCHAR2(254 BYTE),
	"CREATED" NUMBER(*,0),
	"STARTED" NUMBER(*,0),
	"LASTSTATETIME" NUMBER(*,0),
	"LIMITTIME" NUMBER(*,0),
	"DESCRIPTION" VARCHAR2(254 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSREQUESTERS
--------------------------------------------------------

  CREATE TABLE "PROCESSREQUESTERS"
   (	"ID" VARCHAR2(100 BYTE),
	"ACTIVITYREQUESTER" NUMBER(19,0),
	"RESOURCEREQUESTER" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSSTATEEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "PROCESSSTATEEVENTAUDITS"
   (	"KEYVALUE" VARCHAR2(30 BYTE),
	"NAME" VARCHAR2(50 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCESSSTATES
--------------------------------------------------------

  CREATE TABLE "PROCESSSTATES"
   (	"KEYVALUE" VARCHAR2(30 BYTE),
	"NAME" VARCHAR2(50 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "PROCLEVELPARTICIPANT"
   (	"PARTICIPANT_ID" VARCHAR2(90 BYTE),
	"PROCESSOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELXPDLAPP
--------------------------------------------------------

  CREATE TABLE "PROCLEVELXPDLAPP"
   (	"APPLICATION_ID" VARCHAR2(90 BYTE),
	"PROCESSOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  CREATE TABLE "PROCLEVELXPDLAPPTAAPPDETAIL"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  CREATE TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  CREATE TABLE "PROCLEVELXPDLAPPTAAPPUSER"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PROCLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  CREATE TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP"
   (	"XPDL_APPOID" NUMBER(19,0),
	"TOOLAGENTOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table RESOURCESTABLE
--------------------------------------------------------

  CREATE TABLE "RESOURCESTABLE"
   (	"USERNAME" VARCHAR2(100 BYTE),
	"NAME" VARCHAR2(100 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table STATEEVENTAUDITS
--------------------------------------------------------

  CREATE TABLE "STATEEVENTAUDITS"
   (	"UTCTIME" VARCHAR2(254 BYTE),
	"THETYPE" NUMBER(19,0),
	"ACTIVITYID" VARCHAR2(100 BYTE),
	"ACTIVITYNAME" VARCHAR2(254 BYTE),
	"PROCESSID" VARCHAR2(100 BYTE),
	"PROCESSNAME" VARCHAR2(254 BYTE),
	"PROCESSDEFINITIONNAME" VARCHAR2(200 BYTE),
	"PROCESSDEFINITIONVERSION" VARCHAR2(20 BYTE),
	"ACTIVITYDEFINITIONID" VARCHAR2(90 BYTE),
	"ACTIVITYSETDEFINITIONID" VARCHAR2(90 BYTE),
	"PROCESSDEFINITIONID" VARCHAR2(90 BYTE),
	"PACKAGEID" VARCHAR2(90 BYTE),
	"OLDPROCESSSTATE" NUMBER(19,0),
	"NEWPROCESSSTATE" NUMBER(19,0),
	"OLDACTIVITYSTATE" NUMBER(19,0),
	"NEWACTIVITYSTATE" NUMBER(19,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TOOLAGENTAPP
--------------------------------------------------------

  CREATE TABLE "TOOLAGENTAPP"
   (	"TOOL_AGENT_NAME" VARCHAR2(250 BYTE),
	"APP_NAME" VARCHAR2(90 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TOOLAGENTAPPDETAIL
--------------------------------------------------------

  CREATE TABLE "TOOLAGENTAPPDETAIL"
   (	"APP_MODE" NUMBER(10,0),
	"TOOLAGENT_APPOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TOOLAGENTAPPDETAILUSER
--------------------------------------------------------

  CREATE TABLE "TOOLAGENTAPPDETAILUSER"
   (	"TOOLAGENT_APPOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TOOLAGENTAPPUSER
--------------------------------------------------------

  CREATE TABLE "TOOLAGENTAPPUSER"
   (	"TOOLAGENT_APPOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TOOLAGENTUSER
--------------------------------------------------------

  CREATE TABLE "TOOLAGENTUSER"
   (	"USERNAME" VARCHAR2(100 BYTE),
	"PWD" VARCHAR2(100 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table USERGROUPTABLE
--------------------------------------------------------

  CREATE TABLE "USERGROUPTABLE"
   (	"USERID" NUMBER(19,0),
	"GROUPID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table USERPACKLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "USERPACKLEVELPARTICIPANT"
   (	"PARTICIPANTOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table USERPROCLEVELPARTICIPANT
--------------------------------------------------------

  CREATE TABLE "USERPROCLEVELPARTICIPANT"
   (	"PARTICIPANTOID" NUMBER(19,0),
	"USEROID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table USERTABLE
--------------------------------------------------------

  CREATE TABLE "USERTABLE"
   (	"USERID" VARCHAR2(100 BYTE),
	"FIRSTNAME" VARCHAR2(50 BYTE),
	"LASTNAME" VARCHAR2(50 BYTE),
	"PASSWD" VARCHAR2(50 BYTE),
	"EMAIL" VARCHAR2(254 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0),
	"ACTIVE" NUMBER(1,0) DEFAULT 1,
	"number" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLAPPLICATIONPACKAGE
--------------------------------------------------------

  CREATE TABLE "XPDLAPPLICATIONPACKAGE"
   (	"PACKAGE_ID" VARCHAR2(90 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLAPPLICATIONPROCESS
--------------------------------------------------------

  CREATE TABLE "XPDLAPPLICATIONPROCESS"
   (	"PROCESS_ID" VARCHAR2(90 BYTE),
	"PACKAGEOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLDATA
--------------------------------------------------------

  CREATE TABLE "XPDLDATA"
   (	"XPDLCONTENT" BLOB,
	"XPDLCLASSCONTENT" BLOB,
	"XPDL" NUMBER(19,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("XPDLCONTENT") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT))
 LOB ("XPDLCLASSCONTENT") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table XPDLHISTORY
--------------------------------------------------------

  CREATE TABLE "XPDLHISTORY"
   (	"XPDLID" VARCHAR2(90 BYTE),
	"XPDLVERSION" VARCHAR2(20 BYTE),
	"XPDLCLASSVERSION" NUMBER(*,0),
	"XPDLUPLOADTIME" DATE,
	"XPDLHISTORYUPLOADTIME" DATE,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLHISTORYDATA
--------------------------------------------------------

  CREATE TABLE "XPDLHISTORYDATA"
   (	"XPDLCONTENT" BLOB,
	"XPDLCLASSCONTENT" BLOB,
	"XPDLHISTORY" NUMBER(19,0),
	"CNT" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"
 LOB ("XPDLCONTENT") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT))
 LOB ("XPDLCLASSCONTENT") STORE AS SECUREFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table XPDLPARTICIPANTPACKAGE
--------------------------------------------------------

  CREATE TABLE "XPDLPARTICIPANTPACKAGE"
   (	"PACKAGE_ID" VARCHAR2(90 BYTE),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLPARTICIPANTPROCESS
--------------------------------------------------------

  CREATE TABLE "XPDLPARTICIPANTPROCESS"
   (	"PROCESS_ID" VARCHAR2(90 BYTE),
	"PACKAGEOID" NUMBER(19,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLREFERENCES
--------------------------------------------------------

  CREATE TABLE "XPDLREFERENCES"
   (	"REFERREDXPDLID" VARCHAR2(90 BYTE),
	"REFERRINGXPDL" NUMBER(19,0),
	"REFERREDXPDLNUMBER" NUMBER(*,0),
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table XPDLS
--------------------------------------------------------

  CREATE TABLE "XPDLS"
   (	"XPDLID" VARCHAR2(90 BYTE),
	"XPDLVERSION" VARCHAR2(20 BYTE),
	"XPDLCLASSVERSION" NUMBER(*,0),
	"XPDLUPLOADTIME" DATE,
	"OID" NUMBER(19,0),
	"VERSION" NUMBER(*,0)
   )
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Sequence FILES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "FILES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence FILE_VERSIONS_FILE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "FILE_VERSIONS_FILE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence OPENED_FILES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "OPENED_FILES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ACTIONS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ACTIONS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ACTIVATEDTIMES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ACTIVATEDTIMES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ACTIVITYCOMMENTS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ACTIVITYCOMMENTS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ACTIVITY_DOCUMENT_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ACTIVITY_DOCUMENT_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ACTIVITYREDIRECTION_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ACTIVITYREDIRECTION_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_AS_STATUS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_AS_STATUS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ASV_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ASV_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_AUDITS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_AUDITS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DCCP_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DCCP_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DELEGATEDACTIVITIES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DELEGATEDACTIVITIES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DEVICES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DEVICES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DIRECTORIES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DIRECTORIES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DOCCLASSES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DOCCLASSES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DOCUMENTTEMPLATE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DOCUMENTTEMPLATE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DOCUMENT_VIEW_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DOCUMENT_VIEW_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_DOMAINSERVERS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_DOMAINSERVERS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_EMAILNOTIFICATION_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_EMAILNOTIFICATION_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_INDECIES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_INDECIES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_LICENSE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_LICENSE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_LINKCONNECTION_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_LINKCONNECTION_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_LINKINDECIES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_LINKINDECIES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_LINKS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_LINKS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_NOTIFICATIONDEF_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_NOTIFICATIONDEF_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_NOTIFICATIONPROCACT_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_NOTIFICATIONPROCACT_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_NOTIFICATIONS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_NOTIFICATIONS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_NR_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_NR_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_OP_OPID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_OP_OPID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_OPP_OPPID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_OPP_OPPID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ORGANIZATIONALUNITS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ORGANIZATIONALUNITS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_POSITIONS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_POSITIONS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_PROCESSDATA_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_PROCESSDATA_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_REPORTS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_REPORTS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_REPORTSPROTECTION_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_REPORTSPROTECTION_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_REPORTVARIABLE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_REPORTVARIABLE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_RIGHTS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_RIGHTS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_RLVV_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_RLVV_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_ROLES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_ROLES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_SCHEDULED_TASK_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_SCHEDULED_TASK_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_STC_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_STC_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_STH_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_STH_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_STP_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_STP_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_SUBSTITUTIONS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_SUBSTITUTIONS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_USERCALENDARSHARE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_USERCALENDARSHARE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_USERDATA_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_USERDATA_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_USERSEARCHVIEWS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_USERSEARCHVIEWS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_USVP_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_USVP_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PM_VARIABLE_DISTINGUISH_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PM_VARIABLE_DISTINGUISH_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PROCTYPES_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "PROCTYPES_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence USER_NOTIF_CONFIG_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "USER_NOTIF_CONFIG_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence USER_NOTIFS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "USER_NOTIFS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.running','open.running','1000001','0');
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.not_running.not_started','open.not_running.not_started','1000003','0');
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.not_running.suspended','open.not_running.suspended','1000005','0');
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.completed','closed.completed','1000007','0');
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.terminated','closed.terminated','1000009','0');
Insert into ACTIVITYSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.aborted','closed.aborted','1000011','0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_usertable','plusworkflow','1495433114189','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_usertable','plusworkflow','1495433114464','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_file_versions','plusworkflow','1495433114698','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_substitutions','plusworkflow','1495433114939','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_notificationprocact','plusworkflow','1495433115181','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usersearchviewsprotection','plusworkflow','1495433115420','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usersearchviews','plusworkflow','1495433115657','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_advancesearchvariables','plusworkflow','1495433115895','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_reportvariable','plusworkflow','1495433116151','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_reports','plusworkflow','1495433116388','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_rights','plusworkflow','1495433116625','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_rights','plusworkflow','1495433116869','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_indecies','plusworkflow','1495433117102','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_notifications','plusworkflow','1495433117339','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_deadlines','plusworkflow','1495433117577','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_deadlines','plusworkflow','1495433117817','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_usergrouptable','plusworkflow','1495433118052','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activity_document','plusworkflow','1495433118287','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_activity_document','plusworkflow','1495433118522','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i03_pm_activity_document','plusworkflow','1495433118762','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i04_pm_activity_document','plusworkflow','1495433118784','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activitycomments','plusworkflow','1495433119023','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_delegatedactivities','plusworkflow','1495433119286','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_delegatedactivities','plusworkflow','1495433119527','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_docclassconditionprotection','plusworkflow','1495433119769','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_docclassconditionprotection','plusworkflow','1495433120006','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activity_status','plusworkflow','1495433120239','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_document_views','plusworkflow','1495433120476','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_user_notifications','plusworkflow','1495433120709','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_user_notifications','plusworkflow','1495433120949','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usercalendarshare','plusworkflow','1495433121183','EXECUTED',null,'3.1.32');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_max_file_size','plusworkflow','1495434340282','EXECUTED',null,'3.1.39');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_docclass_protection','plusworkflow','1495434540004','EXECUTED',null,'3.1.67');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparameter', 'plusworkflow', '1495434540005', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparametercategory', 'plusworkflow', '1495434540006', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparameter', 'plusworkflow', '1495434540007', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparametercategory', 'plusworkflow', '1495434540008', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparametercombovalues', 'plusworkflow', '1495434540009', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparametercombovalues', 'plusworkflow', '1495434540010', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.Optional_category', 'plusworkflow', '1495434540011', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.Views.Enabled_param', 'plusworkflow', '1495434540012', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.UserAccount.Enabled_param', 'plusworkflow', '1495434540013', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_General_category', 'plusworkflow', '1495434540014', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_UniversalPassword_param', 'plusworkflow', '1495434540015', 'EXECUTED', null, '3.2.0');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_domain_server_mapping_columns', 'plusworkflow', '1495434540016', 'EXECUTED', null, '3.2.2');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_number_to_long_parameters', 'plusworkflow', '1495434540017', 'EXECUTED', null, '3.2.6');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_valuedouble_column', 'plusworkflow', '1495434540017', 'EXECUTED', null, '3.2.6');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_scheduled_tasks_component', 'plusworkflow', '1495434540018', 'EXECUTED', null, '3.2.12');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_scheduledtaskscomp_seq', 'plusworkflow', '1495434540019', 'EXECUTED', null, '3.2.12');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_trial', 'plusworkflow', '1495434540020', 'EXECUTED', null, '3.2.15');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_trial_id_seq', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.15');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_externaldb_conf', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_externaldbconf_id_seq', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_pm_querydatachooser_query', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_pm_querydatachooser_countquery', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_querydatachooser', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_querydatachooser_id_seq', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.20');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_ShowCalendarCart_param', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.31');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_cascadeOnDelete_pm_failedloggingregister', 'plusworkflow', '1495434540021', 'EXECUTED', null, '3.2.45');
Insert into DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_ShowStatistics_param', 'plusworkflow', '1495434540021', 'EXECUTED', null, '4.0.0');
Insert into GROUPTABLE (GROUPID,DESCRIPTION,OID,VERSION) values ('Administrators',null,'1000012','0');
Insert into OBJECTID (NEXT) values ('1000200');
Insert into PM_SCHEDULED_TASKS_CATEGORY (ID,NAME) values ('1','Wdrożenie');
Insert into PM_SCHEDULED_TASKS_CATEGORY (ID,NAME) values ('2','System');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.running','open.running','1000000','0');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.not_running.not_started','open.not_running.not_started','1000002','0');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('open.not_running.suspended','open.not_running.suspended','1000004','0');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.completed','closed.completed','1000006','0');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.terminated','closed.terminated','1000008','0');
Insert into PROCESSSTATES (KEYVALUE,NAME,OID,VERSION) values ('closed.aborted','closed.aborted','1000010','0');
Insert into RESOURCESTABLE (USERNAME,NAME,OID,VERSION) values ('admin',null,'1000015','0');
Insert into USERGROUPTABLE (USERID,GROUPID,OID,VERSION) values ('1000013','1000012','1000014','0');
Insert into USERTABLE (USERID,FIRSTNAME,LASTNAME,PASSWD,EMAIL,OID,VERSION,ACTIVE,"number") values ('admin','Administrator','PlusWorkflow','73d7665487f88c55adb98e90a84f579728032f46',null,'1000013','0','1',null);
Insert into PM_RIGHTS (ID,RIGHT_TYPE,RESOURCE_ID,IS_RESOURCE_A_GROUP,RIGHT_LEVEL) values (pm_rights_id_seq.nextval,'0','admin',0,'system');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.String', 'napis', 'typ napisowy');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.Float', 'liczba rzeczywista', 'liczba rzeczywista');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.Boolean', 'wartość logiczna', 'wartość logiczna');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.util.Date', 'data', 'data');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.Integer', 'liczba całkowita', 'liczba całkowita');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.Long', 'duża liczba całkowita', 'duża liczba całkowita');
Insert into PM_VTYPES (ID, NAME, DESCRIPTION) values ('java.lang.Double', 'duża liczba rzeczywista', 'duża liczba rzeczywista');
--------------------------------------------------------
--  DDL for Index ASSIGNMENTEVENTAUDITS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ASSIGNMENTEVENTAUDITS_OID" ON "ASSIGNMENTEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELXPDLAPP_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELXPDLAPP_OID" ON "PACKLEVELXPDLAPP" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_ACTIVITYSTATES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_ACTIVITYSTATES" ON "ACTIVITYSTATES" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_DEADLINES
--------------------------------------------------------

  CREATE INDEX "I01_DEADLINES" ON "DEADLINES" ("PROCESS")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_REPORTS
--------------------------------------------------------

  CREATE INDEX "I01_PM_REPORTS" ON "PM_REPORTS" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_CN0LF0L2YUH5UWVPI86BL1DSR
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_CN0LF0L2YUH5UWVPI86BL1DSR" ON "PM_DOCCLASSES" ("DOCCLASSNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_EVENTTYPES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_EVENTTYPES" ON "EVENTTYPES" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLHISTORY
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLHISTORY" ON "XPDLHISTORY" ("XPDLID", "XPDLVERSION")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELXPDLAPPTOOL10
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELXPDLAPPTOOL10" ON "PACKLEVELXPDLAPPTOOLAGENTAPP" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_TOOLAGENTAPPDETAIL
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_TOOLAGENTAPPDETAIL" ON "TOOLAGENTAPPDETAIL" ("APP_MODE", "TOOLAGENT_APPOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_OLDEVENTAUDITDATABLOBS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_OLDEVENTAUDITDATABLOBS" ON "OLDEVENTAUDITDATABLOBS" ("OLDEVENTAUDITDATAWOB")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index TOOLAGENTAPPUSER_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "TOOLAGENTAPPUSER_OID" ON "TOOLAGENTAPPUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index GROUPTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPTABLE_OID" ON "GROUPTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELXPDLAPP
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELXPDLAPP" ON "PROCLEVELXPDLAPP" ("APPLICATION_ID", "PROCESSOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_DOCCLASSCONDITIONPROT
--------------------------------------------------------

  CREATE INDEX "I01_PM_DOCCLASSCONDITIONPROT" ON "PM_DOCCLASSCONDITIONPROTECTION" ("DOCCLASSID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_GROUPTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_GROUPTABLE" ON "GROUPTABLE" ("GROUPID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_GROUPUSERPROCLEVELPA17
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_GROUPUSERPROCLEVELPA17" ON "GROUPUSERPROCLEVELPARTICIPANT" ("PARTICIPANTOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_RIGHTS
--------------------------------------------------------

  CREATE INDEX "I01_PM_RIGHTS" ON "PM_RIGHTS" ("RIGHT_LEVEL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index NEWEVENTAUDITDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "NEWEVENTAUDITDATA_OID" ON "NEWEVENTAUDITDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index USERPACKLEVELPARTICIPAN12
--------------------------------------------------------

  CREATE UNIQUE INDEX "USERPACKLEVELPARTICIPAN12" ON "USERPACKLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ANDJOINTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ANDJOINTABLE_OID" ON "ANDJOINTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELPARTICIPANT_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELPARTICIPANT_OID" ON "PACKLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_DEADLINES
--------------------------------------------------------

  CREATE INDEX "I02_DEADLINES" ON "DEADLINES" ("ACTIVITY")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_ACTIVITY_STATUS
--------------------------------------------------------

  CREATE INDEX "I01_PM_ACTIVITY_STATUS" ON "PM_ACTIVITY_STATUS" ("PROCESS_ID", "STATUS_TYPE", "STATUS_IS_NEWEST", "STATUS_ID", "ACTIVITY_ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index TOOLAGENTUSER_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "TOOLAGENTUSER_OID" ON "TOOLAGENTUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_OLDEVENTAUDITDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_OLDEVENTAUDITDATA" ON "OLDEVENTAUDITDATA" ("DATAEVENTAUDIT", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index TOOLAGENTAPPDETAILUSER_O9
--------------------------------------------------------

  CREATE UNIQUE INDEX "TOOLAGENTAPPDETAILUSER_O9" ON "TOOLAGENTAPPDETAILUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index STATEEVENTAUDITS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "STATEEVENTAUDITS_OID" ON "STATEEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLPARTICIPANTPROCESS_O4
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLPARTICIPANTPROCESS_O4" ON "XPDLPARTICIPANTPROCESS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index GROUPUSERPACKLEVELPARTI16
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPUSERPACKLEVELPARTI16" ON "GROUPUSERPACKLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLAPPLICATIONPACKAGE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLAPPLICATIONPACKAGE" ON "XPDLAPPLICATIONPACKAGE" ("PACKAGE_ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_TOOLAGENTUSER
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_TOOLAGENTUSER" ON "TOOLAGENTUSER" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_GROUPUSER
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_GROUPUSER" ON "GROUPUSER" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSSTATEEVENTAUDI0
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSSTATEEVENTAUDI0" ON "PROCESSSTATEEVENTAUDITS" ("KEYVALUE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELXPDLAPPTAAP38
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELXPDLAPPTAAP38" ON "PROCLEVELXPDLAPPTAAPPDETAILUSR" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELPARTICIPANT
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELPARTICIPANT" ON "PROCLEVELPARTICIPANT" ("PARTICIPANT_ID", "PROCESSOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_NEXTXPDLVERSIONS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_NEXTXPDLVERSIONS" ON "NEXTXPDLVERSIONS" ("XPDLID", "NEXTVERSION")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_PM_DELEGATEDACTIVITIES
--------------------------------------------------------

  CREATE INDEX "I02_PM_DELEGATEDACTIVITIES" ON "PM_DELEGATEDACTIVITIES" ("DELEGATEDUSER")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index NEWEVENTAUDITDATAWOB_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "NEWEVENTAUDITDATAWOB_OID" ON "NEWEVENTAUDITDATAWOB" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index OLDEVENTAUDITDATAWOB_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "OLDEVENTAUDITDATAWOB_OID" ON "OLDEVENTAUDITDATAWOB" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_USERPROCLEVELPARTICIP5
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_USERPROCLEVELPARTICIP5" ON "USERPROCLEVELPARTICIPANT" ("PARTICIPANTOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELPARTICIPANT
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELPARTICIPANT" ON "PACKLEVELPARTICIPANT" ("PARTICIPANT_ID", "PACKAGEOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_ACTIVITIES
--------------------------------------------------------

  CREATE INDEX "I2_ACTIVITIES" ON "ACTIVITIES" ("PROCESS", "ACTIVITYSETDEFINITIONID", "ACTIVITYDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I4_PROCESSES
--------------------------------------------------------

  CREATE INDEX "I4_PROCESSES" ON "PROCESSES" ("ACTIVITYREQUESTERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELXPDLAPPTAAPPUS37
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELXPDLAPPTAAPPUS37" ON "PROCLEVELXPDLAPPTAAPPUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_REPORTVARIABLE
--------------------------------------------------------

  CREATE INDEX "I01_PM_REPORTVARIABLE" ON "PM_REPORTVARIABLE" ("REPORTID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITYSTATES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITYSTATES_OID" ON "ACTIVITYSTATES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index OLDEVENTAUDITDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "OLDEVENTAUDITDATA_OID" ON "OLDEVENTAUDITDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELXPDLAPPTAAPPUS21
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELXPDLAPPTAAPPUS21" ON "PACKLEVELXPDLAPPTAAPPUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_ACTIVITYCOMMENTS
--------------------------------------------------------

  CREATE INDEX "I01_PM_ACTIVITYCOMMENTS" ON "PM_ACTIVITYCOMMENTS" ("PROCESSID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  CREATE INDEX "I02_PM_ACTIVITY_DOCUMENT" ON "PM_ACTIVITY_DOCUMENT" ("ACTIVITY")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_CREATEPROCESSEVENTAUD6
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_CREATEPROCESSEVENTAUD6" ON "CREATEPROCESSEVENTAUDITS" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_USERSEARCHVIEWSPROT
--------------------------------------------------------

  CREATE INDEX "I01_PM_USERSEARCHVIEWSPROT" ON "PM_USERSEARCHVIEWSPROTECTION" ("SHAREUSERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_STATEEVENTAUDITS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_STATEEVENTAUDITS" ON "STATEEVENTAUDITS" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELXPDLAPPTOOL26
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELXPDLAPPTOOL26" ON "PROCLEVELXPDLAPPTOOLAGENTAPP" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_NEWEVENTAUDITDATAWOB
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_NEWEVENTAUDITDATAWOB" ON "NEWEVENTAUDITDATAWOB" ("DATAEVENTAUDIT", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELXPDLAPPTAAP30
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELXPDLAPPTAAP30" ON "PROCLEVELXPDLAPPTAAPPDETAIL" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index USERGROUPTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "USERGROUPTABLE_OID" ON "USERGROUPTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSDATA_OID" ON "PROCESSDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_DEADLINES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_DEADLINES" ON "DEADLINES" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSDATAWOB_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSDATAWOB_OID" ON "PROCESSDATAWOB" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLHISTORY_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLHISTORY_OID" ON "XPDLHISTORY" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_TOOLAGENTAPP
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_TOOLAGENTAPP" ON "TOOLAGENTAPP" ("TOOL_AGENT_NAME", "APP_NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index GROUPUSERPROCLEVELPARTI20
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPUSERPROCLEVELPARTI20" ON "GROUPUSERPROCLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_COUNTERS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_COUNTERS" ON "COUNTERS" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITIES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITIES_OID" ON "ACTIVITIES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_ACTIVITYSTATEEVENTAUD4
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_ACTIVITYSTATEEVENTAUD4" ON "ACTIVITYSTATEEVENTAUDITS" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I03_PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  CREATE INDEX "I03_PM_ACTIVITY_DOCUMENT" ON "PM_ACTIVITY_DOCUMENT" ("FILEID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index NEXTXPDLVERSIONS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "NEXTXPDLVERSIONS_OID" ON "NEXTXPDLVERSIONS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITYSTATEEVENTAUD3
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITYSTATEEVENTAUD3" ON "ACTIVITYSTATEEVENTAUDITS" ("KEYVALUE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_USERCALENDARSHARE
--------------------------------------------------------

  CREATE INDEX "I01_PM_USERCALENDARSHARE" ON "PM_USERCALENDARSHARE" ("SHAREUSERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLREFERENCES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLREFERENCES" ON "XPDLREFERENCES" ("REFERREDXPDLID", "REFERRINGXPDL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELXPDLAPP_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELXPDLAPP_OID" ON "PROCLEVELXPDLAPP" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_QT2QKW71TES14FVISAW2IPK0D
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_QT2QKW71TES14FVISAW2IPK0D" ON "PM_SCHEDULED_TASKS_CATEGORY" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_SUBSTITUTIONS
--------------------------------------------------------

  CREATE INDEX "I01_PM_SUBSTITUTIONS" ON "PM_SUBSTITUTIONS" ("SUBSTITUTED")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITYDATABLOBS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITYDATABLOBS" ON "ACTIVITYDATABLOBS" ("ACTIVITYDATAWOB")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELXPDLAPPTAAPPDE41
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELXPDLAPPTAAPPDE41" ON "PROCLEVELXPDLAPPTAAPPDETAILUSR" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELXPDLAPP
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELXPDLAPP" ON "PACKLEVELXPDLAPP" ("APPLICATION_ID", "PACKAGEOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I5_ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE INDEX "I5_ASSIGNMENTSTABLE" ON "ASSIGNMENTSTABLE" ("RESOURCEID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSDEFINITIONS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSDEFINITIONS" ON "PROCESSDEFINITIONS" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I5_PROCESSES
--------------------------------------------------------

  CREATE INDEX "I5_PROCESSES" ON "PROCESSES" ("RESOURCEREQUESTERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_GROUPGROUPTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_GROUPGROUPTABLE" ON "GROUPGROUPTABLE" ("SUB_GID", "GROUPID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_FILE_VERSIONS
--------------------------------------------------------

  CREATE INDEX "I01_PM_FILE_VERSIONS" ON "PM_FILE_VERSIONS" ("NEWEST_FILEID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_GROUPGROUPTABLE
--------------------------------------------------------

  CREATE INDEX "I2_GROUPGROUPTABLE" ON "GROUPGROUPTABLE" ("GROUPID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEADLINES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "DEADLINES_OID" ON "DEADLINES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_XPDLDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_XPDLDATA" ON "XPDLDATA" ("XPDL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_USERTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_USERTABLE" ON "USERTABLE" ("USERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSDATAWOB
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSDATAWOB" ON "PROCESSDATAWOB" ("PROCESS", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLAPPLICATIONPACKAGE_O0
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLAPPLICATIONPACKAGE_O0" ON "XPDLAPPLICATIONPACKAGE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_DEADLINES
--------------------------------------------------------

  CREATE INDEX "I2_DEADLINES" ON "DEADLINES" ("PROCESS", "TIMELIMIT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLAPPLICATIONPROCESS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLAPPLICATIONPROCESS" ON "XPDLAPPLICATIONPROCESS" ("PROCESS_ID", "PACKAGEOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_NOTIFICATIONS
--------------------------------------------------------

  CREATE INDEX "I01_PM_NOTIFICATIONS" ON "PM_NOTIFICATIONS" ("PROCESSID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITYSTATEEVENTAUDITS5
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITYSTATEEVENTAUDITS5" ON "ACTIVITYSTATEEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLREFERENCES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLREFERENCES_OID" ON "XPDLREFERENCES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_INDECIES
--------------------------------------------------------

  CREATE INDEX "I01_PM_INDECIES" ON "PM_INDECIES" ("DOCCLASSID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE INDEX "I3_ASSIGNMENTSTABLE" ON "ASSIGNMENTSTABLE" ("THERESOURCE", "ISVALID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_PROCESSREQUESTERS
--------------------------------------------------------

  CREATE INDEX "I2_PROCESSREQUESTERS" ON "PROCESSREQUESTERS" ("ACTIVITYREQUESTER")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_PM_RIGHTS
--------------------------------------------------------

  CREATE INDEX "I02_PM_RIGHTS" ON "PM_RIGHTS" ("RESOURCE_ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index RESOURCESTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "RESOURCESTABLE_OID" ON "RESOURCESTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I04_PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  CREATE INDEX "I04_PM_ACTIVITY_DOCUMENT" ON "PM_ACTIVITY_DOCUMENT" ("USERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITIES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITIES" ON "ACTIVITIES" ("ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITYSTATES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITYSTATES" ON "ACTIVITYSTATES" ("KEYVALUE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELXPDLAPPTAAPPDE17
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELXPDLAPPTAAPPDE17" ON "PACKLEVELXPDLAPPTAAPPDETAIL" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index GROUPUSER_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPUSER_OID" ON "GROUPUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLDATA_OID" ON "XPDLDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_PM_DOCCLASSCONDITIONPROT
--------------------------------------------------------

  CREATE INDEX "I02_PM_DOCCLASSCONDITIONPROT" ON "PM_DOCCLASSCONDITIONPROTECTION" ("USERID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ASSIGNMENTSTABLE" ON "ASSIGNMENTSTABLE" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLS_OID" ON "XPDLS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_TOOLAGENTAPPUSER
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_TOOLAGENTAPPUSER" ON "TOOLAGENTAPPUSER" ("TOOLAGENT_APPOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_RESOURCESTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_RESOURCESTABLE" ON "RESOURCESTABLE" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ASSIGNMENTEVENTAUDITS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ASSIGNMENTEVENTAUDITS" ON "ASSIGNMENTEVENTAUDITS" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSREQUESTERS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSREQUESTERS" ON "PROCESSREQUESTERS" ("ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITYDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITYDATA_OID" ON "ACTIVITYDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELXPDLAPPTOOLAGE29
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELXPDLAPPTOOLAGE29" ON "PROCLEVELXPDLAPPTOOLAGENTAPP" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ASSIGNMENTSTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ASSIGNMENTSTABLE_OID" ON "ASSIGNMENTSTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSES_OID" ON "PROCESSES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_PROCESSSTATES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_PROCESSSTATES" ON "PROCESSSTATES" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_USERGROUPTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_USERGROUPTABLE" ON "USERGROUPTABLE" ("USERID", "GROUPID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITYDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITYDATA" ON "ACTIVITYDATA" ("ACTIVITY", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITYDATAWOB_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITYDATAWOB_OID" ON "ACTIVITYDATAWOB" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELXPDLAPPTAAPPDE33
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELXPDLAPPTAAPPDE33" ON "PROCLEVELXPDLAPPTAAPPDETAIL" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLHISTORYDATA_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLHISTORYDATA_OID" ON "XPDLHISTORYDATA" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_EVENTTYPES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_EVENTTYPES" ON "EVENTTYPES" ("KEYVALUE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSES" ON "PROCESSES" ("ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_LOCKTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_LOCKTABLE" ON "LOCKTABLE" ("ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_PROCESSREQUESTERS
--------------------------------------------------------

  CREATE INDEX "I3_PROCESSREQUESTERS" ON "PROCESSREQUESTERS" ("RESOURCEREQUESTER")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_NOTIFICATIONPROCACT
--------------------------------------------------------

  CREATE INDEX "I01_PM_NOTIFICATIONPROCACT" ON "PM_NOTIFICATIONPROCACT" ("NOTIFICATIONDEFID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_DELEGATEDACTIVITIES
--------------------------------------------------------

  CREATE INDEX "I01_PM_DELEGATEDACTIVITIES" ON "PM_DELEGATEDACTIVITIES" ("ACTIVITYID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLAPPLICATIONPROCESS_O2
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLAPPLICATIONPROCESS_O2" ON "XPDLAPPLICATIONPROCESS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_DEADLINES
--------------------------------------------------------

  CREATE INDEX "I3_DEADLINES" ON "DEADLINES" ("ACTIVITY", "TIMELIMIT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_USERGROUPTABLE
--------------------------------------------------------

  CREATE INDEX "I01_USERGROUPTABLE" ON "USERGROUPTABLE" ("GROUPID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELXPDLAPPTAAP22
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELXPDLAPPTAAP22" ON "PACKLEVELXPDLAPPTAAPPDETAILUSR" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DATAEVENTAUDITS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "DATAEVENTAUDITS_OID" ON "DATAEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCLEVELXPDLAPPTAAP34
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCLEVELXPDLAPPTAAP34" ON "PROCLEVELXPDLAPPTAAPPUSER" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index OLDEVENTAUDITDATABLOBS_17
--------------------------------------------------------

  CREATE UNIQUE INDEX "OLDEVENTAUDITDATABLOBS_17" ON "OLDEVENTAUDITDATABLOBS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_ASSIGNMENTSTABLE" ON "ASSIGNMENTSTABLE" ("ACTIVITY", "THERESOURCE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_USERSEARCHVIEWS
--------------------------------------------------------

  CREATE INDEX "I01_PM_USERSEARCHVIEWS" ON "PM_USERSEARCHVIEWS" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSSTATES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSSTATES_OID" ON "PROCESSSTATES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELXPDLAPPTAAPPDE25
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELXPDLAPPTAAPPDE25" ON "PACKLEVELXPDLAPPTAAPPDETAILUSR" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSDEFINITIONS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSDEFINITIONS_OID" ON "PROCESSDEFINITIONS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index USERPROCLEVELPARTICIPANT8
--------------------------------------------------------

  CREATE UNIQUE INDEX "USERPROCLEVELPARTICIPANT8" ON "USERPROCLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_NEWEVENTAUDITDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_NEWEVENTAUDITDATA" ON "NEWEVENTAUDITDATA" ("DATAEVENTAUDIT", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_DOCUMENT_VIEWS
--------------------------------------------------------

  CREATE INDEX "I01_PM_DOCUMENT_VIEWS" ON "PM_DOCUMENT_VIEWS" ("PROC_DEF_ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSREQUESTERS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSREQUESTERS_OID" ON "PROCESSREQUESTERS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index TOOLAGENTAPPDETAIL_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "TOOLAGENTAPPDETAIL_OID" ON "TOOLAGENTAPPDETAIL" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_USERTABLE
--------------------------------------------------------

  CREATE INDEX "I01_USERTABLE" ON "USERTABLE" ("FIRSTNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index ACTIVITYDATABLOBS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "ACTIVITYDATABLOBS_OID" ON "ACTIVITYDATABLOBS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index CREATEPROCESSEVENTAUDITS8
--------------------------------------------------------

  CREATE UNIQUE INDEX "CREATEPROCESSEVENTAUDITS8" ON "CREATEPROCESSEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_ANDJOINTABLE
--------------------------------------------------------

  CREATE INDEX "I3_ANDJOINTABLE" ON "ANDJOINTABLE" ("ACTIVITY")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_DATAEVENTAUDITS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_DATAEVENTAUDITS" ON "DATAEVENTAUDITS" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSDATABLOBS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSDATABLOBS_OID" ON "PROCESSDATABLOBS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLDATA" ON "XPDLDATA" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLPARTICIPANTPACKAGE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLPARTICIPANTPACKAGE" ON "XPDLPARTICIPANTPACKAGE" ("PACKAGE_ID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLS" ON "XPDLS" ("XPDLID", "XPDLVERSION")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCESSSTATEEVENTAUDITS_2
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCESSSTATEEVENTAUDITS_2" ON "PROCESSSTATEEVENTAUDITS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index XPDLPARTICIPANTPACKAGE_O0
--------------------------------------------------------

  CREATE UNIQUE INDEX "XPDLPARTICIPANTPACKAGE_O0" ON "XPDLPARTICIPANTPACKAGE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLHISTORYDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLHISTORYDATA" ON "XPDLHISTORYDATA" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  CREATE INDEX "I01_PM_ACTIVITY_DOCUMENT" ON "PM_ACTIVITY_DOCUMENT" ("PROCESS")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_QYKK3S5TQ5JOIXVFK2DB40F08
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_QYKK3S5TQ5JOIXVFK2DB40F08" ON "PM_POSITIONS" ("POSITIONSYMBOL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_USERTABLE
--------------------------------------------------------

  CREATE INDEX "I02_USERTABLE" ON "USERTABLE" ("LASTNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_ANDJOINTABLE
--------------------------------------------------------

  CREATE INDEX "I2_ANDJOINTABLE" ON "ANDJOINTABLE" ("PROCESS", "ACTIVITYSETDEFINITIONID", "ACTIVITYDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index COUNTERS_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "COUNTERS_OID" ON "COUNTERS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_NEWEVENTAUDITDATABLOBS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_NEWEVENTAUDITDATABLOBS" ON "NEWEVENTAUDITDATABLOBS" ("NEWEVENTAUDITDATAWOB")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I4_ASSIGNMENTSTABLE
--------------------------------------------------------

  CREATE INDEX "I4_ASSIGNMENTSTABLE" ON "ASSIGNMENTSTABLE" ("ACTIVITYID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_NORMALUSER
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_NORMALUSER" ON "NORMALUSER" ("USERNAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PROCLEVELPARTICIPANT_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "PROCLEVELPARTICIPANT_OID" ON "PROCLEVELPARTICIPANT" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index NORMALUSER_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "NORMALUSER_OID" ON "NORMALUSER" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index GROUPGROUPTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPGROUPTABLE_OID" ON "GROUPGROUPTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSDATABLOBS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSDATABLOBS" ON "PROCESSDATABLOBS" ("PROCESSDATAWOB")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PACKLEVELXPDLAPPTOOLAGE13
--------------------------------------------------------

  CREATE UNIQUE INDEX "PACKLEVELXPDLAPPTOOLAGE13" ON "PACKLEVELXPDLAPPTOOLAGENTAPP" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I02_PM_USER_NOTIFICATIONS
--------------------------------------------------------

  CREATE INDEX "I02_PM_USER_NOTIFICATIONS" ON "PM_USER_NOTIFICATIONS" ("RECEIVER", "FAILURE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_ACTIVITIES
--------------------------------------------------------

  CREATE INDEX "I3_ACTIVITIES" ON "ACTIVITIES" ("PROCESS", "STATE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_USER_NOTIFICATIONS
--------------------------------------------------------

  CREATE INDEX "I01_PM_USER_NOTIFICATIONS" ON "PM_USER_NOTIFICATIONS" ("RECEIVER", "CONFIRMED")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_OLDEVENTAUDITDATAWOB
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_OLDEVENTAUDITDATAWOB" ON "OLDEVENTAUDITDATAWOB" ("DATAEVENTAUDIT", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_PROCESSES
--------------------------------------------------------

  CREATE INDEX "I2_PROCESSES" ON "PROCESSES" ("PROCESSDEFINITION")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_8TQMIYI7S0FLXYIP7JAGN783L
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_8TQMIYI7S0FLXYIP7JAGN783L" ON "PM_ORGANIZATIONALUNITS" ("ORGANIZATIONALUNITSYMBOL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_MW4QT93VFVL3ELXFANT6J6M9X
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_MW4QT93VFVL3ELXFANT6J6M9X" ON "PM_RIGHTS" ("RESOURCE_ID", "IS_RESOURCE_A_GROUP", "RIGHT_LEVEL")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index USERTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "USERTABLE_OID" ON "USERTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I3_PROCESSES
--------------------------------------------------------

  CREATE INDEX "I3_PROCESSES" ON "PROCESSES" ("STATE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ANDJOINTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ANDJOINTABLE" ON "ANDJOINTABLE" ("CNT")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELXPDLAPPTAAP18
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELXPDLAPPTAAP18" ON "PACKLEVELXPDLAPPTAAPPUSER" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index NEWEVENTAUDITDATABLOBS_21
--------------------------------------------------------

  CREATE UNIQUE INDEX "NEWEVENTAUDITDATABLOBS_21" ON "NEWEVENTAUDITDATABLOBS" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_GROUPUSERPACKLEVELPA13
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_GROUPUSERPACKLEVELPA13" ON "GROUPUSERPACKLEVELPARTICIPANT" ("PARTICIPANTOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_PROCESSSTATEEVENTAUDI1
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_PROCESSSTATEEVENTAUDI1" ON "PROCESSSTATEEVENTAUDITS" ("NAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_ACTIVITYDATAWOB
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_ACTIVITYDATAWOB" ON "ACTIVITYDATAWOB" ("ACTIVITY", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_XPDLPARTICIPANTPROCESS
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_XPDLPARTICIPANTPROCESS" ON "XPDLPARTICIPANTPROCESS" ("PROCESS_ID", "PACKAGEOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index EVENTTYPES_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "EVENTTYPES_OID" ON "EVENTTYPES" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PACKLEVELXPDLAPPTAAP14
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PACKLEVELXPDLAPPTAAP14" ON "PACKLEVELXPDLAPPTAAPPDETAIL" ("XPDL_APPOID", "TOOLAGENTOID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index LOCKTABLE_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "LOCKTABLE_OID" ON "LOCKTABLE" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I2_LOCKTABLE
--------------------------------------------------------

  CREATE UNIQUE INDEX "I2_LOCKTABLE" ON "LOCKTABLE" ("ID", "ENGINENAME")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index TOOLAGENTAPP_OID
--------------------------------------------------------

  CREATE UNIQUE INDEX "TOOLAGENTAPP_OID" ON "TOOLAGENTAPP" ("OID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_5G95E5RTEV82DSY4EI5QTNDE2
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_5G95E5RTEV82DSY4EI5QTNDE2" ON "PM_FILE_VERSIONS" ("FILEID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_TOOLAGENTAPPDETAILUSER
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_TOOLAGENTAPPDETAILUSER" ON "TOOLAGENTAPPDETAILUSER" ("TOOLAGENT_APPOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index UK_3C75UP0LI4G2D0WAMLDNXW1KR
--------------------------------------------------------

  CREATE UNIQUE INDEX "UK_3C75UP0LI4G2D0WAMLDNXW1KR" ON "PM_PLUGINS_CONFIGURATION" ("PLUGIN_FILE_MD5")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSSTATES
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSSTATES" ON "PROCESSSTATES" ("KEYVALUE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_USERPACKLEVELPARTICIP9
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_USERPACKLEVELPARTICIP9" ON "USERPACKLEVELPARTICIPANT" ("PARTICIPANTOID", "USEROID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I01_PM_ADVANCESEARCHVARIABLES
--------------------------------------------------------

  CREATE INDEX "I01_PM_ADVANCESEARCHVARIABLES" ON "PM_ADVANCESEARCHVARIABLES" ("VIEWID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index I1_PROCESSDATA
--------------------------------------------------------

  CREATE UNIQUE INDEX "I1_PROCESSDATA" ON "PROCESSDATA" ("PROCESS", "VARIABLEDEFINITIONID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table XPDLPARTICIPANTPACKAGE
--------------------------------------------------------

  ALTER TABLE "XPDLPARTICIPANTPACKAGE" MODIFY ("PACKAGE_ID" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPACKAGE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPACKAGE" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPACKAGE" ADD CONSTRAINT "XPDLPARTICIPANTPACKAGE_O0" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_REPORTLISTVARIABLEVALUE
--------------------------------------------------------

  ALTER TABLE "PM_REPORTLISTVARIABLEVALUE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_REPORTLISTVARIABLEVALUE" MODIFY ("VARIABLEID" NOT NULL ENABLE);
  ALTER TABLE "PM_REPORTLISTVARIABLEVALUE" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table NEWEVENTAUDITDATAWOB
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATAWOB" ADD CONSTRAINT "NEWEVENTAUDITDATAWOB_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NEWEVENTAUDITDATAWOB" MODIFY ("DATAEVENTAUDIT" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATAWOB" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATAWOB" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATAWOB" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATAWOB" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITYREDIRECTION
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYREDIRECTION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table XPDLHISTORY
--------------------------------------------------------

  ALTER TABLE "XPDLHISTORY" MODIFY ("XPDLID" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("XPDLVERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("XPDLCLASSVERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("XPDLUPLOADTIME" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("XPDLHISTORYUPLOADTIME" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORY" ADD CONSTRAINT "XPDLHISTORY_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_DOCUMENTTEMPLATE
--------------------------------------------------------

  ALTER TABLE "PM_DOCUMENTTEMPLATE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCUMENTTEMPLATE" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table GROUPUSERPROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPROCLEVELPARTI20" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" MODIFY ("PARTICIPANTOID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ORGANIZATIONALUNITS
--------------------------------------------------------

  ALTER TABLE "PM_ORGANIZATIONALUNITS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ORGANIZATIONALUNITS" MODIFY ("ORGANIZATIONALUNITSYMBOL" NOT NULL ENABLE);
  ALTER TABLE "PM_ORGANIZATIONALUNITS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_ORGANIZATIONALUNITS" ADD CONSTRAINT "UK_8TQMIYI7S0FLXYIP7JAGN783L" UNIQUE ("ORGANIZATIONALUNITSYMBOL")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSDATAWOB
--------------------------------------------------------

  ALTER TABLE "PROCESSDATAWOB" ADD CONSTRAINT "PROCESSDATAWOB_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSDATAWOB" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATAWOB" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATAWOB" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATAWOB" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATAWOB" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table ACTIVITYDATABLOBS
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATABLOBS" ADD CONSTRAINT "ACTIVITYDATABLOBS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITYDATABLOBS" MODIFY ("ACTIVITYDATAWOB" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATABLOBS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATABLOBS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_POSITION_ROLE
--------------------------------------------------------

  ALTER TABLE "PM_POSITION_ROLE" MODIFY ("POSITIONID" NOT NULL ENABLE);
  ALTER TABLE "PM_POSITION_ROLE" MODIFY ("ROLEID" NOT NULL ENABLE);
  ALTER TABLE "PM_POSITION_ROLE" ADD PRIMARY KEY ("POSITIONID", "ROLEID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table NEWEVENTAUDITDATA
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATA" ADD CONSTRAINT "NEWEVENTAUDITDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NEWEVENTAUDITDATA" MODIFY ("DATAEVENTAUDIT" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATA" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATA" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATA" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_OPERATION_PANEL
--------------------------------------------------------

  ALTER TABLE "PM_OPERATION_PANEL" MODIFY ("OPERATION_PANEL_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_OPERATION_PANEL" ADD PRIMARY KEY ("OPERATION_PANEL_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VTYPES
--------------------------------------------------------

  ALTER TABLE "PM_VTYPES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VTYPES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "PROCLEVELPARTICIPANT" ADD CONSTRAINT "PROCLEVELPARTICIPANT_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELPARTICIPANT" MODIFY ("PARTICIPANT_ID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELPARTICIPANT" MODIFY ("PROCESSOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table TOOLAGENTAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPDETAIL" MODIFY ("APP_MODE" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAIL" MODIFY ("TOOLAGENT_APPOID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAIL" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAIL" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAIL" ADD CONSTRAINT "TOOLAGENTAPPDETAIL_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_INDECIES
--------------------------------------------------------

  ALTER TABLE "PM_INDECIES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_INDECIES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_LICENSE
--------------------------------------------------------

  ALTER TABLE "PM_LICENSE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_LICENSE" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_LINKS
--------------------------------------------------------

  ALTER TABLE "PM_LINKS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_LINKS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSDATABLOBS
--------------------------------------------------------

  ALTER TABLE "PROCESSDATABLOBS" ADD CONSTRAINT "PROCESSDATABLOBS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSDATABLOBS" MODIFY ("PROCESSDATAWOB" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATABLOBS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATABLOBS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table XPDLPARTICIPANTPROCESS
--------------------------------------------------------

  ALTER TABLE "XPDLPARTICIPANTPROCESS" MODIFY ("PROCESS_ID" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPROCESS" MODIFY ("PACKAGEOID" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPROCESS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPROCESS" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLPARTICIPANTPROCESS" ADD CONSTRAINT "XPDLPARTICIPANTPROCESS_O4" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table COUNTERS
--------------------------------------------------------

  ALTER TABLE "COUNTERS" ADD CONSTRAINT "COUNTERS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "COUNTERS" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "COUNTERS" MODIFY ("THE_NUMBER" NOT NULL ENABLE);
  ALTER TABLE "COUNTERS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "COUNTERS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_LINKCONNECTION
--------------------------------------------------------

  ALTER TABLE "PM_LINKCONNECTION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_LINKCONNECTION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_NOTIFICATIONS
--------------------------------------------------------

  ALTER TABLE "PM_NOTIFICATIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONS" MODIFY ("NOTIFICATIONDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONS" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPUS37" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table TOOLAGENTAPP
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPP" MODIFY ("TOOL_AGENT_NAME" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPP" MODIFY ("APP_NAME" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPP" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPP" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPP" ADD CONSTRAINT "TOOLAGENTAPP_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PACKLEVELXPDLAPP
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPP" ADD CONSTRAINT "PACKLEVELXPDLAPP_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPP" MODIFY ("APPLICATION_ID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPP" MODIFY ("PACKAGEOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPP" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPP" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIVATEDTIMES
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVATEDTIMES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVATEDTIMES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_SCHEDULED_TASKS
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("SCHEDULED_TASK_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("IS_ACTIVE" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("IS_PROCESSING" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("CLASS_NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("METHOD_NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" MODIFY ("FIRST_RUN" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS" ADD PRIMARY KEY ("SCHEDULED_TASK_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PROCLEVELXPDLAPPTOOLAGE29" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table NORMALUSER
--------------------------------------------------------

  ALTER TABLE "NORMALUSER" ADD CONSTRAINT "NORMALUSER_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NORMALUSER" MODIFY ("USERNAME" NOT NULL ENABLE);
  ALTER TABLE "NORMALUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "NORMALUSER" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table XPDLDATA
--------------------------------------------------------

  ALTER TABLE "XPDLDATA" MODIFY ("XPDLCONTENT" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" MODIFY ("XPDLCLASSCONTENT" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" MODIFY ("XPDL" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLDATA" ADD CONSTRAINT "XPDLDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table GROUPUSER
--------------------------------------------------------

  ALTER TABLE "GROUPUSER" ADD CONSTRAINT "GROUPUSER_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "GROUPUSER" MODIFY ("USERNAME" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSER" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_DOMAINSERVERS
--------------------------------------------------------

  ALTER TABLE "PM_DOMAINSERVERS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOMAINSERVERS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCLEVELXPDLAPP
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPP" ADD CONSTRAINT "PROCLEVELXPDLAPP_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPP" MODIFY ("APPLICATION_ID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPP" MODIFY ("PROCESSOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPP" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPP" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ADVANCESEARCHVARIABLES
--------------------------------------------------------

  ALTER TABLE "PM_ADVANCESEARCHVARIABLES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ADVANCESEARCHVARIABLES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_AUDITS
--------------------------------------------------------

  ALTER TABLE "PM_AUDITS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_AUDITS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_NOTIFICATIONPROCACT
--------------------------------------------------------

  ALTER TABLE "PM_NOTIFICATIONPROCACT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONPROCACT" MODIFY ("NOTIFICATIONDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONPROCACT" MODIFY ("PROCESSDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONPROCACT" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_SCHEDULED_TASKS_HISTORY
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" MODIFY ("STARTDATE" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" MODIFY ("SUCCESS" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" MODIFY ("TASKID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_SUBSTITUTIONS
--------------------------------------------------------

  ALTER TABLE "PM_SUBSTITUTIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SUBSTITUTIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VVALUES
--------------------------------------------------------

  ALTER TABLE "PM_VVALUES" MODIFY ("TABLEID" NOT NULL ENABLE);
  ALTER TABLE "PM_VVALUES" MODIFY ("COLUMNID" NOT NULL ENABLE);
  ALTER TABLE "PM_VVALUES" MODIFY ("VVALUE_ROWID" NOT NULL ENABLE);
  ALTER TABLE "PM_VVALUES" MODIFY ("MODIFIED" NOT NULL ENABLE);
  ALTER TABLE "PM_VVALUES" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "PM_VVALUES" ADD PRIMARY KEY ("TABLEID", "COLUMNID", "VVALUE_ROWID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table GROUPGROUPTABLE
--------------------------------------------------------

  ALTER TABLE "GROUPGROUPTABLE" ADD CONSTRAINT "GROUPGROUPTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "GROUPGROUPTABLE" MODIFY ("SUB_GID" NOT NULL ENABLE);
  ALTER TABLE "GROUPGROUPTABLE" MODIFY ("GROUPID" NOT NULL ENABLE);
  ALTER TABLE "GROUPGROUPTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "GROUPGROUPTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_USERSEARCHVIEWS
--------------------------------------------------------

  ALTER TABLE "PM_USERSEARCHVIEWS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERSEARCHVIEWS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_USERSEARCHVIEWSPROTECTION
--------------------------------------------------------

  ALTER TABLE "PM_USERSEARCHVIEWSPROTECTION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERSEARCHVIEWSPROTECTION" MODIFY ("VIEWID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERSEARCHVIEWSPROTECTION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table RESOURCESTABLE
--------------------------------------------------------

  ALTER TABLE "RESOURCESTABLE" ADD CONSTRAINT "RESOURCESTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "RESOURCESTABLE" MODIFY ("USERNAME" NOT NULL ENABLE);
  ALTER TABLE "RESOURCESTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "RESOURCESTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table USERPACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "USERPACKLEVELPARTICIPANT" MODIFY ("PARTICIPANTOID" NOT NULL ENABLE);
  ALTER TABLE "USERPACKLEVELPARTICIPANT" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "USERPACKLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "USERPACKLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "USERPACKLEVELPARTICIPANT" ADD CONSTRAINT "USERPACKLEVELPARTICIPAN12" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table XPDLAPPLICATIONPROCESS
--------------------------------------------------------

  ALTER TABLE "XPDLAPPLICATIONPROCESS" MODIFY ("PROCESS_ID" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPROCESS" MODIFY ("PACKAGEOID" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPROCESS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPROCESS" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPROCESS" ADD CONSTRAINT "XPDLAPPLICATIONPROCESS_O2" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table XPDLS
--------------------------------------------------------

  ALTER TABLE "XPDLS" MODIFY ("XPDLID" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" MODIFY ("XPDLVERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" MODIFY ("XPDLCLASSVERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" MODIFY ("XPDLUPLOADTIME" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLS" ADD CONSTRAINT "XPDLS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_DEVICES
--------------------------------------------------------

  ALTER TABLE "PM_DEVICES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DEVICES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ACTIVITYSTATEEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "ACTIVITYSTATEEVENTAUDITS" ADD CONSTRAINT "ACTIVITYSTATEEVENTAUDITS5" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITYSTATEEVENTAUDITS" MODIFY ("KEYVALUE" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATEEVENTAUDITS" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATEEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATEEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_LINKINDECIES
--------------------------------------------------------

  ALTER TABLE "PM_LINKINDECIES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_LINKINDECIES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_USER_NOTIFICATION_CONFIGS
--------------------------------------------------------

  ALTER TABLE "PM_USER_NOTIFICATION_CONFIGS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATION_CONFIGS" MODIFY ("PROCESSDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATION_CONFIGS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("ADDEDHERE" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("date" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("FILEID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITY_STATUS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("STATUS_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("PROCESS_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("ACTIVITY_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("STATUS_TYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("STATUS_IS_NEWEST" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("STATUS_DATE" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" MODIFY ("STATUS_AUTHOR" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_STATUS" ADD PRIMARY KEY ("STATUS_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_DIRECTORIES
--------------------------------------------------------

  ALTER TABLE "PM_DIRECTORIES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DIRECTORIES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VARIABLE_DISTINGUISH
--------------------------------------------------------

  ALTER TABLE "PM_VARIABLE_DISTINGUISH" MODIFY ("VARIABLE_DISTINGUISH_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VARIABLE_DISTINGUISH" ADD PRIMARY KEY ("VARIABLE_DISTINGUISH_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table STATEEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("UTCTIME" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("THETYPE" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("PROCESSDEFINITIONNAME" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("PROCESSDEFINITIONVERSION" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("PROCESSDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "STATEEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_NOTIFICATIONRECIPIENT
--------------------------------------------------------

  ALTER TABLE "PM_NOTIFICATIONRECIPIENT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONRECIPIENT" MODIFY ("NOTIFICATIONDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONRECIPIENT" MODIFY ("RECIPIENTTYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONRECIPIENT" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_USERDATA
--------------------------------------------------------

  ALTER TABLE "PM_USERDATA" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERDATA" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERDATA" MODIFY ("USERFIELDNAME" NOT NULL ENABLE);
  ALTER TABLE "PM_USERDATA" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSES
--------------------------------------------------------

  ALTER TABLE "PROCESSES" ADD CONSTRAINT "PROCESSES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("PROCESSDEFINITION" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("PDEFNAME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("RESOURCEREQUESTERID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("STATE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("CREATED" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("LASTSTATETIME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("LIMITTIME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PROCESSSTATEEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "PROCESSSTATEEVENTAUDITS" ADD CONSTRAINT "PROCESSSTATEEVENTAUDITS_2" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSSTATEEVENTAUDITS" MODIFY ("KEYVALUE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATEEVENTAUDITS" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATEEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATEEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table CREATEPROCESSEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "CREATEPROCESSEVENTAUDITS" ADD CONSTRAINT "CREATEPROCESSEVENTAUDITS8" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("UTCTIME" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("THETYPE" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("PROCESSDEFINITIONNAME" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("PROCESSDEFINITIONVERSION" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("PROCESSDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "CREATEPROCESSEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table OBJECTID
--------------------------------------------------------

  ALTER TABLE "OBJECTID" MODIFY ("NEXT" NOT NULL ENABLE);
  ALTER TABLE "OBJECTID" ADD PRIMARY KEY ("NEXT")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSSTATES
--------------------------------------------------------

  ALTER TABLE "PROCESSSTATES" ADD CONSTRAINT "PROCESSSTATES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSSTATES" MODIFY ("KEYVALUE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATES" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSSTATES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_POSITIONS
--------------------------------------------------------

  ALTER TABLE "PM_POSITIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_POSITIONS" MODIFY ("POSITIONSYMBOL" NOT NULL ENABLE);
  ALTER TABLE "PM_POSITIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_POSITIONS" ADD CONSTRAINT "UK_QYKK3S5TQ5JOIXVFK2DB40F08" UNIQUE ("POSITIONSYMBOL")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table TOOLAGENTAPPUSER
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPUSER" MODIFY ("TOOLAGENT_APPOID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPUSER" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPUSER" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPUSER" ADD CONSTRAINT "TOOLAGENTAPPUSER_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_DELEGATEDACTIVITIES
--------------------------------------------------------

  ALTER TABLE "PM_DELEGATEDACTIVITIES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DELEGATEDACTIVITIES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VCOLUMNS
--------------------------------------------------------

  ALTER TABLE "PM_VCOLUMNS" MODIFY ("TABLEID" NOT NULL ENABLE);
  ALTER TABLE "PM_VCOLUMNS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VCOLUMNS" MODIFY ("MODIFIED" NOT NULL ENABLE);
  ALTER TABLE "PM_VCOLUMNS" ADD PRIMARY KEY ("TABLEID", "ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VTABLES
--------------------------------------------------------

  ALTER TABLE "PM_VTABLES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VTABLES" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "PM_VTABLES" MODIFY ("VTABLE_ROWS" NOT NULL ENABLE);
  ALTER TABLE "PM_VTABLES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table DEADLINES
--------------------------------------------------------

  ALTER TABLE "DEADLINES" ADD CONSTRAINT "DEADLINES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "DEADLINES" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("ACTIVITY" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("TIMELIMIT" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("EXCEPTIONNAME" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("ISSYNCHRONOUS" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("ISEXECUTED" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "DEADLINES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITYREDIRECTION_GROUPS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION_GROUPS" MODIFY ("REDIRECTION" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYREDIRECTION_GROUPS" MODIFY ("TARGETGROUP" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYREDIRECTION_GROUPS" ADD PRIMARY KEY ("REDIRECTION", "TARGETGROUP")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PACKLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE25" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_FILE_VERSIONS
--------------------------------------------------------

  ALTER TABLE "PM_FILE_VERSIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_FILE_VERSIONS" MODIFY ("FILEID" NOT NULL ENABLE);
  ALTER TABLE "PM_FILE_VERSIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_FILE_VERSIONS" ADD CONSTRAINT "UK_5G95E5RTEV82DSY4EI5QTNDE2" UNIQUE ("FILEID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_USERCALENDARSHARE
--------------------------------------------------------

  ALTER TABLE "PM_USERCALENDARSHARE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USERCALENDARSHARE" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table DATAEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "DATAEVENTAUDITS" ADD CONSTRAINT "DATAEVENTAUDITS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("UTCTIME" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("THETYPE" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("PROCESSDEFINITIONNAME" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("PROCESSDEFINITIONVERSION" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("PROCESSDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "DATAEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table OLDEVENTAUDITDATABLOBS
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATABLOBS" ADD CONSTRAINT "OLDEVENTAUDITDATABLOBS_17" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "OLDEVENTAUDITDATABLOBS" MODIFY ("OLDEVENTAUDITDATAWOB" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATABLOBS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATABLOBS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_PROCESS_TRANSLATION
--------------------------------------------------------

  ALTER TABLE "PM_PROCESS_TRANSLATION" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "PM_PROCESS_TRANSLATION" MODIFY ("LANGUAGE" NOT NULL ENABLE);
  ALTER TABLE "PM_PROCESS_TRANSLATION" ADD PRIMARY KEY ("PROCESSID", "LANGUAGE")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ACTIVITYDATA
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATA" ADD CONSTRAINT "ACTIVITYDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITYDATA" MODIFY ("ACTIVITY" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATA" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATA" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATA" MODIFY ("ISRESULT" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATA" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table NEXTXPDLVERSIONS
--------------------------------------------------------

  ALTER TABLE "NEXTXPDLVERSIONS" ADD CONSTRAINT "NEXTXPDLVERSIONS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NEXTXPDLVERSIONS" MODIFY ("XPDLID" NOT NULL ENABLE);
  ALTER TABLE "NEXTXPDLVERSIONS" MODIFY ("NEXTVERSION" NOT NULL ENABLE);
  ALTER TABLE "NEXTXPDLVERSIONS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "NEXTXPDLVERSIONS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PROCLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE33" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table TOOLAGENTAPPDETAILUSER
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPDETAILUSER" MODIFY ("TOOLAGENT_APPOID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAILUSER" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAILUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAILUSER" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTAPPDETAILUSER" ADD CONSTRAINT "TOOLAGENTAPPDETAILUSER_O9" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_ROLES
--------------------------------------------------------

  ALTER TABLE "PM_ROLES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ROLES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_USER_NOTIFICATIONS
--------------------------------------------------------

  ALTER TABLE "PM_USER_NOTIFICATIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATIONS" MODIFY ("SENDER" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATIONS" MODIFY ("NOTIFDATE" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATIONS" MODIFY ("MESSAGE" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATIONS" MODIFY ("RECEIVER" NOT NULL ENABLE);
  ALTER TABLE "PM_USER_NOTIFICATIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITYREDIRECTION_USERS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION_USERS" MODIFY ("REDIRECTION" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYREDIRECTION_USERS" MODIFY ("TARGETUSER" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYREDIRECTION_USERS" ADD PRIMARY KEY ("REDIRECTION", "TARGETUSER")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_SCHEDULED_TASKS_PARAMETERS
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" MODIFY ("SCHEDULED_TASK_PARAMETER_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" MODIFY ("PARAMETER_TYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" MODIFY ("PARAMETER_VALUE" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" MODIFY ("PARAMETER_POSITION" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" MODIFY ("SCHEDULED_TASK_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" ADD PRIMARY KEY ("SCHEDULED_TASK_PARAMETER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_VARIABLE_SET_TEMP
--------------------------------------------------------

  ALTER TABLE "PM_VARIABLE_SET_TEMP" MODIFY ("PROCESS_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VARIABLE_SET_TEMP" MODIFY ("ACTIVITY_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VARIABLE_SET_TEMP" MODIFY ("VARIABLE_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_VARIABLE_SET_TEMP" ADD PRIMARY KEY ("PROCESS_ID", "ACTIVITY_ID", "VARIABLE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table USERTABLE
--------------------------------------------------------

  ALTER TABLE "USERTABLE" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "USERTABLE" MODIFY ("PASSWD" NOT NULL ENABLE);
  ALTER TABLE "USERTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "USERTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "USERTABLE" ADD CONSTRAINT "USERTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ACTIVITYSTATES
--------------------------------------------------------

  ALTER TABLE "ACTIVITYSTATES" ADD CONSTRAINT "ACTIVITYSTATES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITYSTATES" MODIFY ("KEYVALUE" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATES" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYSTATES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_DOCCLASSCONDITIONPROTECTION
--------------------------------------------------------

  ALTER TABLE "PM_DOCCLASSCONDITIONPROTECTION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSCONDITIONPROTECTION" MODIFY ("ISGROUP" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSCONDITIONPROTECTION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_REPORTS
--------------------------------------------------------

  ALTER TABLE "PM_REPORTS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_REPORTS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table NEWEVENTAUDITDATABLOBS
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATABLOBS" ADD CONSTRAINT "NEWEVENTAUDITDATABLOBS_21" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NEWEVENTAUDITDATABLOBS" MODIFY ("NEWEVENTAUDITDATAWOB" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATABLOBS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "NEWEVENTAUDITDATABLOBS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIONS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIONS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIONS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ASSIGNMENTEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "ASSIGNMENTEVENTAUDITS" ADD CONSTRAINT "ASSIGNMENTEVENTAUDITS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("UTCTIME" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("THETYPE" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("ACTIVITYID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("PROCESSDEFINITIONNAME" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("PROCESSDEFINITIONVERSION" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("ACTIVITYDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("PROCESSDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("NEWRESOURCEUSERNAME" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("ISACCEPTED" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTEVENTAUDITS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_NOTIFICATIONDEF
--------------------------------------------------------

  ALTER TABLE "PM_NOTIFICATIONDEF" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONDEF" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONDEF" MODIFY ("SUBJECT" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONDEF" MODIFY ("TEMPLATEPATH" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONDEF" MODIFY ("CONDITIONTYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_NOTIFICATIONDEF" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_PLUGINS_CONFIGURATION
--------------------------------------------------------

  ALTER TABLE "PM_PLUGINS_CONFIGURATION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" MODIFY ("PLUGIN_NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" MODIFY ("ENTRY_FILE_NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" MODIFY ("PLUGIN_FILE_NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" MODIFY ("PLUGIN_FILE_MD5" NOT NULL ENABLE);
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_PLUGINS_CONFIGURATION" ADD CONSTRAINT "UK_3C75UP0LI4G2D0WAMLDNXW1KR" UNIQUE ("PLUGIN_FILE_MD5")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table LOCKTABLE
--------------------------------------------------------

  ALTER TABLE "LOCKTABLE" ADD CONSTRAINT "LOCKTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "LOCKTABLE" MODIFY ("ENGINENAME" NOT NULL ENABLE);
  ALTER TABLE "LOCKTABLE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "LOCKTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "LOCKTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table OLDEVENTAUDITDATAWOB
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATAWOB" ADD CONSTRAINT "OLDEVENTAUDITDATAWOB_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "OLDEVENTAUDITDATAWOB" MODIFY ("DATAEVENTAUDIT" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATAWOB" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATAWOB" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATAWOB" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATAWOB" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_SCHEDULED_TASKS_CATEGORY
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS_CATEGORY" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_CATEGORY" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_SCHEDULED_TASKS_CATEGORY" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_SCHEDULED_TASKS_CATEGORY" ADD CONSTRAINT "UK_QT2QKW71TES14FVISAW2IPK0D" UNIQUE ("NAME")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE41" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "PACKLEVELPARTICIPANT" ADD CONSTRAINT "PACKLEVELPARTICIPANT_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELPARTICIPANT" MODIFY ("PARTICIPANT_ID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELPARTICIPANT" MODIFY ("PACKAGEOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PACKLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE17" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PROCESSREQUESTERS
--------------------------------------------------------

  ALTER TABLE "PROCESSREQUESTERS" ADD CONSTRAINT "PROCESSREQUESTERS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSREQUESTERS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSREQUESTERS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSREQUESTERS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_DOCCLASSES
--------------------------------------------------------

  ALTER TABLE "PM_DOCCLASSES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSES" MODIFY ("DOCCLASSNAME" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_DOCCLASSES" ADD CONSTRAINT "UK_CN0LF0L2YUH5UWVPI86BL1DSR" UNIQUE ("DOCCLASSNAME")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_FILES
--------------------------------------------------------

  ALTER TABLE "PM_FILES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_FILES" MODIFY ("DOCCLASSID" NOT NULL ENABLE);
  ALTER TABLE "PM_FILES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_PROCESSTYPES
--------------------------------------------------------

  ALTER TABLE "PM_PROCESSTYPES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_PROCESSTYPES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ASSIGNMENTSTABLE
--------------------------------------------------------

  ALTER TABLE "ASSIGNMENTSTABLE" ADD CONSTRAINT "ASSIGNMENTSTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ACTIVITY" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("THERESOURCE" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ACTIVITYID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ACTIVITYPROCESSID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ACTIVITYPROCESSDEFNAME" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("RESOURCEID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ISACCEPTED" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("ISVALID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ASSIGNMENTSTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table GROUPTABLE
--------------------------------------------------------

  ALTER TABLE "GROUPTABLE" ADD CONSTRAINT "GROUPTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "GROUPTABLE" MODIFY ("GROUPID" NOT NULL ENABLE);
  ALTER TABLE "GROUPTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "GROUPTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITYCOMMENTS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYCOMMENTS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITYCOMMENTS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ACTIVITYDATAWOB
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATAWOB" ADD CONSTRAINT "ACTIVITYDATAWOB_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("ACTIVITY" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("ISRESULT" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITYDATAWOB" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table ACTIVITIES
--------------------------------------------------------

  ALTER TABLE "ACTIVITIES" ADD CONSTRAINT "ACTIVITIES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ACTIVITIES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("ACTIVITYDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("PDEFNAME" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("PROCESSID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("STATE" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("ACTIVATED" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("LASTSTATETIME" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("LIMITTIME" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ACTIVITIES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table GROUPUSERPACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPACKLEVELPARTI16" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" MODIFY ("PARTICIPANTOID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table XPDLHISTORYDATA
--------------------------------------------------------

  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("XPDLCONTENT" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("XPDLCLASSCONTENT" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("XPDLHISTORY" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLHISTORYDATA" ADD CONSTRAINT "XPDLHISTORYDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_OPENED_FILES
--------------------------------------------------------

  ALTER TABLE "PM_OPENED_FILES" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_OPENED_FILES" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_REPORTVARIABLE
--------------------------------------------------------

  ALTER TABLE "PM_REPORTVARIABLE" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_REPORTVARIABLE" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table ANDJOINTABLE
--------------------------------------------------------

  ALTER TABLE "ANDJOINTABLE" ADD CONSTRAINT "ANDJOINTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "ANDJOINTABLE" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "ANDJOINTABLE" MODIFY ("ACTIVITYDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "ANDJOINTABLE" MODIFY ("ACTIVITY" NOT NULL ENABLE);
  ALTER TABLE "ANDJOINTABLE" MODIFY ("CNT" NOT NULL ENABLE);
  ALTER TABLE "ANDJOINTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "ANDJOINTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PACKLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PACKLEVELXPDLAPPTOOLAGE13" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_ACTIVITY_TRANSLATION
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITY_TRANSLATION" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_TRANSLATION" MODIFY ("PROCESSDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_TRANSLATION" MODIFY ("ACTIVITYDEFID" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_TRANSLATION" MODIFY ("LANGUAGE" NOT NULL ENABLE);
  ALTER TABLE "PM_ACTIVITY_TRANSLATION" ADD PRIMARY KEY ("PACKAGEID", "PROCESSDEFID", "ACTIVITYDEFID", "LANGUAGE")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 164
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_DOCUMENT_VIEWS
--------------------------------------------------------

  ALTER TABLE "PM_DOCUMENT_VIEWS" MODIFY ("DOCUMENT_VIEW_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCUMENT_VIEWS" MODIFY ("IS_DESCENDING" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCUMENT_VIEWS" MODIFY ("AMOUNT" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCUMENT_VIEWS" ADD PRIMARY KEY ("DOCUMENT_VIEW_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table EVENTTYPES
--------------------------------------------------------

  ALTER TABLE "EVENTTYPES" ADD CONSTRAINT "EVENTTYPES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "EVENTTYPES" MODIFY ("KEYVALUE" NOT NULL ENABLE);
  ALTER TABLE "EVENTTYPES" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "EVENTTYPES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "EVENTTYPES" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_RIGHTS
--------------------------------------------------------

  ALTER TABLE "PM_RIGHTS" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_RIGHTS" MODIFY ("RIGHT_TYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_RIGHTS" MODIFY ("RESOURCE_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_RIGHTS" MODIFY ("IS_RESOURCE_A_GROUP" NOT NULL ENABLE);
  ALTER TABLE "PM_RIGHTS" MODIFY ("RIGHT_LEVEL" NOT NULL ENABLE);
  ALTER TABLE "PM_RIGHTS" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PM_RIGHTS" ADD CONSTRAINT "UK_MW4QT93VFVL3ELXFANT6J6M9X" UNIQUE ("RESOURCE_ID", "IS_RESOURCE_A_GROUP", "RIGHT_LEVEL")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSDEFINITIONS
--------------------------------------------------------

  ALTER TABLE "PROCESSDEFINITIONS" ADD CONSTRAINT "PROCESSDEFINITIONS_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("PACKAGEID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("PROCESSDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("PROCESSDEFINITIONCREATED" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("PROCESSDEFINITIONVERSION" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("STATE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDEFINITIONS" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PACKLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPUS21" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" MODIFY ("XPDL_APPOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" MODIFY ("TOOLAGENTOID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_PROCESSDATA
--------------------------------------------------------

  ALTER TABLE "PM_PROCESSDATA" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_PROCESSDATA" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table TOOLAGENTUSER
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTUSER" MODIFY ("USERNAME" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTUSER" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTUSER" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "TOOLAGENTUSER" ADD CONSTRAINT "TOOLAGENTUSER_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table XPDLAPPLICATIONPACKAGE
--------------------------------------------------------

  ALTER TABLE "XPDLAPPLICATIONPACKAGE" MODIFY ("PACKAGE_ID" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPACKAGE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPACKAGE" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLAPPLICATIONPACKAGE" ADD CONSTRAINT "XPDLAPPLICATIONPACKAGE_O0" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table XPDLREFERENCES
--------------------------------------------------------

  ALTER TABLE "XPDLREFERENCES" MODIFY ("REFERREDXPDLID" NOT NULL ENABLE);
  ALTER TABLE "XPDLREFERENCES" MODIFY ("REFERRINGXPDL" NOT NULL ENABLE);
  ALTER TABLE "XPDLREFERENCES" MODIFY ("REFERREDXPDLNUMBER" NOT NULL ENABLE);
  ALTER TABLE "XPDLREFERENCES" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "XPDLREFERENCES" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "XPDLREFERENCES" ADD CONSTRAINT "XPDLREFERENCES_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_EMAILNOTIFICATION
--------------------------------------------------------

  ALTER TABLE "PM_EMAILNOTIFICATION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_EMAILNOTIFICATION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_OPERATION_PANEL_PARAMETERS
--------------------------------------------------------

  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" MODIFY ("OPERATION_PANEL_PARAMETER_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" MODIFY ("TYPE" NOT NULL ENABLE);
  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" MODIFY ("OPERATION_PANEL_ID" NOT NULL ENABLE);
  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" ADD PRIMARY KEY ("OPERATION_PANEL_PARAMETER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PROCESSDATA
--------------------------------------------------------

  ALTER TABLE "PROCESSDATA" ADD CONSTRAINT "PROCESSDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "PROCESSDATA" MODIFY ("PROCESS" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATA" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATA" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "PROCESSDATA" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table USERGROUPTABLE
--------------------------------------------------------

  ALTER TABLE "USERGROUPTABLE" MODIFY ("USERID" NOT NULL ENABLE);
  ALTER TABLE "USERGROUPTABLE" MODIFY ("GROUPID" NOT NULL ENABLE);
  ALTER TABLE "USERGROUPTABLE" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "USERGROUPTABLE" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "USERGROUPTABLE" ADD CONSTRAINT "USERGROUPTABLE_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table OLDEVENTAUDITDATA
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATA" ADD CONSTRAINT "OLDEVENTAUDITDATA_OID" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "OLDEVENTAUDITDATA" MODIFY ("DATAEVENTAUDIT" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATA" MODIFY ("VARIABLEDEFINITIONID" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATA" MODIFY ("VARIABLETYPE" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATA" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "OLDEVENTAUDITDATA" MODIFY ("VERSION" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PM_DOCCLASSPROTECTION
--------------------------------------------------------

  ALTER TABLE "PM_DOCCLASSPROTECTION" MODIFY ("DOCCLASSID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSPROTECTION" MODIFY ("ISGROUP" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSPROTECTION" MODIFY ("RESOURCEID" NOT NULL ENABLE);
  ALTER TABLE "PM_DOCCLASSPROTECTION" ADD PRIMARY KEY ("DOCCLASSID", "ISGROUP", "RESOURCEID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table PM_REPORTSPROTECTION
--------------------------------------------------------

  ALTER TABLE "PM_REPORTSPROTECTION" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "PM_REPORTSPROTECTION" ADD PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table USERPROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "USERPROCLEVELPARTICIPANT" MODIFY ("PARTICIPANTOID" NOT NULL ENABLE);
  ALTER TABLE "USERPROCLEVELPARTICIPANT" MODIFY ("USEROID" NOT NULL ENABLE);
  ALTER TABLE "USERPROCLEVELPARTICIPANT" MODIFY ("OID" NOT NULL ENABLE);
  ALTER TABLE "USERPROCLEVELPARTICIPANT" MODIFY ("VERSION" NOT NULL ENABLE);
  ALTER TABLE "USERPROCLEVELPARTICIPANT" ADD CONSTRAINT "USERPROCLEVELPARTICIPANT8" PRIMARY KEY ("OID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ACTIVITIES
--------------------------------------------------------

  ALTER TABLE "ACTIVITIES" ADD CONSTRAINT "ACTIVITIES_PROCESS" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
  ALTER TABLE "ACTIVITIES" ADD CONSTRAINT "ACTIVITIES_STATE" FOREIGN KEY ("STATE")
	  REFERENCES "ACTIVITYSTATES" ("OID") ENABLE;
  ALTER TABLE "ACTIVITIES" ADD CONSTRAINT "ACTIVITIES_THERESOURCE" FOREIGN KEY ("THERESOURCE")
	  REFERENCES "RESOURCESTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ACTIVITYDATA
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATA" ADD CONSTRAINT "ACTIVITYDATA_ACTIVITY" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ACTIVITYDATABLOBS
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATABLOBS" ADD CONSTRAINT "ACTIVITYDATABLOBS_ACTIVI5" FOREIGN KEY ("ACTIVITYDATAWOB")
	  REFERENCES "ACTIVITYDATAWOB" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ACTIVITYDATAWOB
--------------------------------------------------------

  ALTER TABLE "ACTIVITYDATAWOB" ADD CONSTRAINT "ACTIVITYDATAWOB_ACTIVITY" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ANDJOINTABLE
--------------------------------------------------------

  ALTER TABLE "ANDJOINTABLE" ADD CONSTRAINT "ANDJOINTABLE_ACTIVITY" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
  ALTER TABLE "ANDJOINTABLE" ADD CONSTRAINT "ANDJOINTABLE_PROCESS" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ASSIGNMENTEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "ASSIGNMENTEVENTAUDITS" ADD CONSTRAINT "ASSIGNMENTEVENTAUDITS_T13" FOREIGN KEY ("THETYPE")
	  REFERENCES "EVENTTYPES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table ASSIGNMENTSTABLE
--------------------------------------------------------

  ALTER TABLE "ASSIGNMENTSTABLE" ADD CONSTRAINT "ASSIGNMENTSTABLE_ACTIVITY" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
  ALTER TABLE "ASSIGNMENTSTABLE" ADD CONSTRAINT "ASSIGNMENTSTABLE_THERESO3" FOREIGN KEY ("THERESOURCE")
	  REFERENCES "RESOURCESTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table CREATEPROCESSEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "CREATEPROCESSEVENTAUDITS" ADD CONSTRAINT "CREATEPROCESSEVENTAUDITS7" FOREIGN KEY ("THETYPE")
	  REFERENCES "EVENTTYPES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table DATAEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "DATAEVENTAUDITS" ADD CONSTRAINT "DATAEVENTAUDITS_THETYPE" FOREIGN KEY ("THETYPE")
	  REFERENCES "EVENTTYPES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table DEADLINES
--------------------------------------------------------

  ALTER TABLE "DEADLINES" ADD CONSTRAINT "DEADLINES_ACTIVITY" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
  ALTER TABLE "DEADLINES" ADD CONSTRAINT "DEADLINES_PROCESS" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table GROUPGROUPTABLE
--------------------------------------------------------

  ALTER TABLE "GROUPGROUPTABLE" ADD CONSTRAINT "GROUPGROUPTABLE_GROUPID" FOREIGN KEY ("GROUPID")
	  REFERENCES "GROUPTABLE" ("OID") ENABLE;
  ALTER TABLE "GROUPGROUPTABLE" ADD CONSTRAINT "GROUPGROUPTABLE_SUB_GID" FOREIGN KEY ("SUB_GID")
	  REFERENCES "GROUPTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table GROUPUSERPACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPACKLEVELPARTI14" FOREIGN KEY ("PARTICIPANTOID")
	  REFERENCES "PACKLEVELPARTICIPANT" ("OID") ENABLE;
  ALTER TABLE "GROUPUSERPACKLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPACKLEVELPARTI15" FOREIGN KEY ("USEROID")
	  REFERENCES "GROUPUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table GROUPUSERPROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPROCLEVELPARTI18" FOREIGN KEY ("PARTICIPANTOID")
	  REFERENCES "PROCLEVELPARTICIPANT" ("OID") ENABLE;
  ALTER TABLE "GROUPUSERPROCLEVELPARTICIPANT" ADD CONSTRAINT "GROUPUSERPROCLEVELPARTI19" FOREIGN KEY ("USEROID")
	  REFERENCES "GROUPUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table NEWEVENTAUDITDATA
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATA" ADD CONSTRAINT "NEWEVENTAUDITDATA_DATAE18" FOREIGN KEY ("DATAEVENTAUDIT")
	  REFERENCES "DATAEVENTAUDITS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table NEWEVENTAUDITDATABLOBS
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATABLOBS" ADD CONSTRAINT "NEWEVENTAUDITDATABLOBS_20" FOREIGN KEY ("NEWEVENTAUDITDATAWOB")
	  REFERENCES "NEWEVENTAUDITDATAWOB" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table NEWEVENTAUDITDATAWOB
--------------------------------------------------------

  ALTER TABLE "NEWEVENTAUDITDATAWOB" ADD CONSTRAINT "NEWEVENTAUDITDATAWOB_DA19" FOREIGN KEY ("DATAEVENTAUDIT")
	  REFERENCES "DATAEVENTAUDITS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table OLDEVENTAUDITDATA
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATA" ADD CONSTRAINT "OLDEVENTAUDITDATA_DATAE14" FOREIGN KEY ("DATAEVENTAUDIT")
	  REFERENCES "DATAEVENTAUDITS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table OLDEVENTAUDITDATABLOBS
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATABLOBS" ADD CONSTRAINT "OLDEVENTAUDITDATABLOBS_16" FOREIGN KEY ("OLDEVENTAUDITDATAWOB")
	  REFERENCES "OLDEVENTAUDITDATAWOB" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table OLDEVENTAUDITDATAWOB
--------------------------------------------------------

  ALTER TABLE "OLDEVENTAUDITDATAWOB" ADD CONSTRAINT "OLDEVENTAUDITDATAWOB_DA15" FOREIGN KEY ("DATAEVENTAUDIT")
	  REFERENCES "DATAEVENTAUDITS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "PACKLEVELPARTICIPANT" ADD CONSTRAINT "PACKLEVELPARTICIPANT_PAC2" FOREIGN KEY ("PACKAGEOID")
	  REFERENCES "XPDLPARTICIPANTPACKAGE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELXPDLAPP
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPP" ADD CONSTRAINT "PACKLEVELXPDLAPP_PACKAGE3" FOREIGN KEY ("PACKAGEOID")
	  REFERENCES "XPDLAPPLICATIONPACKAGE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE15" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PACKLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE16" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPDETAIL" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE23" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PACKLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPDE24" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPDETAILUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPUS19" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PACKLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PACKLEVELXPDLAPPTAAPPUS20" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PACKLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PACKLEVELXPDLAPPTOOLAGE11" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PACKLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PACKLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PACKLEVELXPDLAPPTOOLAGE12" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPP" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ACTIONS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIONS" ADD CONSTRAINT "FK_J8BPHK6D8HQC438JVBPGLLVK6" FOREIGN KEY ("DOCCLASSID")
	  REFERENCES "PM_DOCCLASSES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ACTIVITY_DOCUMENT
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD CONSTRAINT "FK_92ASSDYL6QAJMNGOSUJR2XHNH" FOREIGN KEY ("ACTIVITY")
	  REFERENCES "ACTIVITIES" ("OID") ON DELETE CASCADE ENABLE;
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD CONSTRAINT "FK_6FBX8827LMFVDPB1G0JCWMNNV" FOREIGN KEY ("FILEID")
	  REFERENCES "PM_FILES" ("ID") ENABLE;
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD CONSTRAINT "FK_42WVRBSW0YF0J8HPSKCQ3096W" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD CONSTRAINT "FK_JDWG9TBE9XDWXC3BHFFDAPS86" FOREIGN KEY ("USERID")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
  ALTER TABLE "PM_ACTIVITY_DOCUMENT" ADD CONSTRAINT "FK_7O8AEHFV9SN3SLVT92LT9QTKM" FOREIGN KEY ("VERSION")
	  REFERENCES "PM_FILE_VERSIONS" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ACTIVITYREDIRECTION
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION" ADD CONSTRAINT "FK_O6U7QNMFF1AU8ND9PSBQ0S6WS" FOREIGN KEY ("SOURCEUSER")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ACTIVITYREDIRECTION_GROUPS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION_GROUPS" ADD CONSTRAINT "FK_6VWLTOFSQ2485GHW20XFCLD9M" FOREIGN KEY ("TARGETGROUP")
	  REFERENCES "GROUPTABLE" ("OID") ENABLE;
  ALTER TABLE "PM_ACTIVITYREDIRECTION_GROUPS" ADD CONSTRAINT "FK_EFYSD6MGPS4UHJ882Y2WJV6CB" FOREIGN KEY ("REDIRECTION")
	  REFERENCES "PM_ACTIVITYREDIRECTION" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ACTIVITYREDIRECTION_USERS
--------------------------------------------------------

  ALTER TABLE "PM_ACTIVITYREDIRECTION_USERS" ADD CONSTRAINT "FK_7R86W89TL7E93V6M6X0ATSA56" FOREIGN KEY ("TARGETUSER")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
  ALTER TABLE "PM_ACTIVITYREDIRECTION_USERS" ADD CONSTRAINT "FK_JGO839LT6W4NI79G6VJELK6Q8" FOREIGN KEY ("REDIRECTION")
	  REFERENCES "PM_ACTIVITYREDIRECTION" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_DIRECTORIES
--------------------------------------------------------

  ALTER TABLE "PM_DIRECTORIES" ADD CONSTRAINT "FK_85OXBEWNWAUQ6F84AYC8YU26H" FOREIGN KEY ("DEVICEID")
	  REFERENCES "PM_DEVICES" ("ID") ENABLE;
  ALTER TABLE "PM_DIRECTORIES" ADD CONSTRAINT "FK_18U81P51NS1C6MCJVKI6PJ13C" FOREIGN KEY ("ROOTDIRECTORYID")
	  REFERENCES "PM_DIRECTORIES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_DOCCLASSCONDITIONPROTECTION
--------------------------------------------------------

  ALTER TABLE "PM_DOCCLASSCONDITIONPROTECTION" ADD CONSTRAINT "FK_I5CCQELQAXR6IHGG61GCX0UCT" FOREIGN KEY ("DOCCLASSID")
	  REFERENCES "PM_DOCCLASSES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_DOCCLASSES
--------------------------------------------------------

  ALTER TABLE "PM_DOCCLASSES" ADD CONSTRAINT "FK_6LGIBE4CJ428MAHVPATN5SXOM" FOREIGN KEY ("DOCCLASSDIRECTORYID")
	  REFERENCES "PM_DIRECTORIES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_FILES
--------------------------------------------------------

  ALTER TABLE "PM_FILES" ADD CONSTRAINT "FK_IYBHE442I7RMBMSH9SAI36AKJ" FOREIGN KEY ("DOCCLASSID")
	  REFERENCES "PM_DOCCLASSES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_FILE_VERSIONS
--------------------------------------------------------

  ALTER TABLE "PM_FILE_VERSIONS" ADD CONSTRAINT "FK_5G95E5RTEV82DSY4EI5QTNDE2" FOREIGN KEY ("FILEID")
	  REFERENCES "PM_FILES" ("ID") ENABLE;
  ALTER TABLE "PM_FILE_VERSIONS" ADD CONSTRAINT "FK_72TLBY59E4NYQ7N67L22CD1JV" FOREIGN KEY ("NEWEST_FILEID")
	  REFERENCES "PM_FILES" ("ID") ENABLE;
  ALTER TABLE "PM_FILE_VERSIONS" ADD CONSTRAINT "FK_SOTKPBHYTPGXQCME4613OR9EL" FOREIGN KEY ("PARENT_FILEID")
	  REFERENCES "PM_FILES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_INDECIES
--------------------------------------------------------

  ALTER TABLE "PM_INDECIES" ADD CONSTRAINT "FK_L71M7JDUOKEQBP05NOTE87LK9" FOREIGN KEY ("DOCCLASSID")
	  REFERENCES "PM_DOCCLASSES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_LINKCONNECTION
--------------------------------------------------------

  ALTER TABLE "PM_LINKCONNECTION" ADD CONSTRAINT "FK_3AFP7Q3TABN0CLET0OHTEHJE1" FOREIGN KEY ("DOCCLASSID")
	  REFERENCES "PM_DOCCLASSES" ("ID") ENABLE;
  ALTER TABLE "PM_LINKCONNECTION" ADD CONSTRAINT "FK_D5XSFYMB2EA989YOSRR7K9TCM" FOREIGN KEY ("INDEXID")
	  REFERENCES "PM_INDECIES" ("ID") ENABLE;
  ALTER TABLE "PM_LINKCONNECTION" ADD CONSTRAINT "FK_AHQO7IH2HAG0YC9TQY0AVJ8Q5" FOREIGN KEY ("LINKID")
	  REFERENCES "PM_LINKS" ("ID") ENABLE;
  ALTER TABLE "PM_LINKCONNECTION" ADD CONSTRAINT "FK_FCPRTPGA9KXI2VK1P1F9W9TGU" FOREIGN KEY ("LINKINDEXID")
	  REFERENCES "PM_LINKINDECIES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_LINKINDECIES
--------------------------------------------------------

  ALTER TABLE "PM_LINKINDECIES" ADD CONSTRAINT "FK_NU4AJAVO7G1UGNAVUIRSO0O0C" FOREIGN KEY ("LINKID")
	  REFERENCES "PM_LINKS" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_OPERATION_PANEL_PARAMETERS
--------------------------------------------------------

  ALTER TABLE "PM_OPERATION_PANEL_PARAMETERS" ADD CONSTRAINT "FK_1AGA3412YHJ9JU42EIJRG5V90" FOREIGN KEY ("OPERATION_PANEL_ID")
	  REFERENCES "PM_OPERATION_PANEL" ("OPERATION_PANEL_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_ORGANIZATIONALUNITS
--------------------------------------------------------

  ALTER TABLE "PM_ORGANIZATIONALUNITS" ADD CONSTRAINT "FK_OJ19EYKQYP025V0IU7T56KIFO" FOREIGN KEY ("DIRECTORPOSITIONID")
	  REFERENCES "PM_POSITIONS" ("ID") ENABLE;
  ALTER TABLE "PM_ORGANIZATIONALUNITS" ADD CONSTRAINT "FK_9AMGDAP6GHG0JPNLT2F3YNOVB" FOREIGN KEY ("HIGHERORGANIZATIONALUNITID")
	  REFERENCES "PM_ORGANIZATIONALUNITS" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_POSITION_ROLE
--------------------------------------------------------

  ALTER TABLE "PM_POSITION_ROLE" ADD CONSTRAINT "FK_1IPTJPWGFMO8WSVS95SB9UQ0" FOREIGN KEY ("ROLEID")
	  REFERENCES "PM_ROLES" ("ID") ENABLE;
  ALTER TABLE "PM_POSITION_ROLE" ADD CONSTRAINT "FK_PX59CJC90BSCBJBUIJD2G6E6U" FOREIGN KEY ("POSITIONID")
	  REFERENCES "PM_POSITIONS" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_POSITIONS
--------------------------------------------------------

  ALTER TABLE "PM_POSITIONS" ADD CONSTRAINT "FK_3U1I14XG7C20GXV5T0Q81RILT" FOREIGN KEY ("HIGHERPOSITIONID")
	  REFERENCES "PM_POSITIONS" ("ID") ENABLE;
  ALTER TABLE "PM_POSITIONS" ADD CONSTRAINT "FK_L5DL4JFNE63RYTSX0UA7A851E" FOREIGN KEY ("ORGANIZATIONALUNITID")
	  REFERENCES "PM_ORGANIZATIONALUNITS" ("ID") ENABLE;
  ALTER TABLE "PM_POSITIONS" ADD CONSTRAINT "FK_9TA5VW7G06HEAW17JAVV38MNQ" FOREIGN KEY ("USERID")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_SCHEDULED_TASKS
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS" ADD CONSTRAINT "FK_B29CPXIJG24TEBQPD7LSXLJVM" FOREIGN KEY ("CATEGORY_ID")
	  REFERENCES "PM_SCHEDULED_TASKS_CATEGORY" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_SCHEDULED_TASKS_HISTORY
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS_HISTORY" ADD CONSTRAINT "FK_7RHYTF8LRQHL8345F35E3W76E" FOREIGN KEY ("TASKID")
	  REFERENCES "PM_SCHEDULED_TASKS" ("SCHEDULED_TASK_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_SCHEDULED_TASKS_PARAMETERS
--------------------------------------------------------

  ALTER TABLE "PM_SCHEDULED_TASKS_PARAMETERS" ADD CONSTRAINT "FK_G1XSEBBFRUF71FHTVV5THFR3E" FOREIGN KEY ("SCHEDULED_TASK_ID")
	  REFERENCES "PM_SCHEDULED_TASKS" ("SCHEDULED_TASK_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_SUBSTITUTIONS
--------------------------------------------------------

  ALTER TABLE "PM_SUBSTITUTIONS" ADD CONSTRAINT "FK_6W6RRT4YFKR0FFE8TPXLKBIVE" FOREIGN KEY ("ROLE")
	  REFERENCES "PM_ROLES" ("ID") ENABLE;
  ALTER TABLE "PM_SUBSTITUTIONS" ADD CONSTRAINT "FK_KX0WNI8XSWINCETLNRUAKV9FG" FOREIGN KEY ("SUBSTITUTED")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
  ALTER TABLE "PM_SUBSTITUTIONS" ADD CONSTRAINT "FK_QQUCQFSNBGFMEDK1RH7HOSR01" FOREIGN KEY ("SUBSTITUTE")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_USERDATA
--------------------------------------------------------

  ALTER TABLE "PM_USERDATA" ADD CONSTRAINT "FK_21DCY78O0PADSBBHB9I3DVOKL" FOREIGN KEY ("USERID")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_VCOLUMNS
--------------------------------------------------------

  ALTER TABLE "PM_VCOLUMNS" ADD CONSTRAINT "FK_8SDY1K5RJ0HRRJBTFPLGF4JPL" FOREIGN KEY ("TYPEID")
	  REFERENCES "PM_VTYPES" ("ID") ENABLE;
  ALTER TABLE "PM_VCOLUMNS" ADD CONSTRAINT "FK_LX10IP15RM7V0F0T886PJDM19" FOREIGN KEY ("TABLEID")
	  REFERENCES "PM_VTABLES" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PM_VVALUES
--------------------------------------------------------

  ALTER TABLE "PM_VVALUES" ADD CONSTRAINT "FK_PS2IW5FJ2HAVS4R2H3AE96OUP" FOREIGN KEY ("TABLEID", "COLUMNID")
	  REFERENCES "PM_VCOLUMNS" ("TABLEID", "ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCESSDATA
--------------------------------------------------------

  ALTER TABLE "PROCESSDATA" ADD CONSTRAINT "PROCESSDATA_PROCESS" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCESSDATABLOBS
--------------------------------------------------------

  ALTER TABLE "PROCESSDATABLOBS" ADD CONSTRAINT "PROCESSDATABLOBS_PROCESS4" FOREIGN KEY ("PROCESSDATAWOB")
	  REFERENCES "PROCESSDATAWOB" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCESSDATAWOB
--------------------------------------------------------

  ALTER TABLE "PROCESSDATAWOB" ADD CONSTRAINT "PROCESSDATAWOB_PROCESS" FOREIGN KEY ("PROCESS")
	  REFERENCES "PROCESSES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCESSES
--------------------------------------------------------

  ALTER TABLE "PROCESSES" ADD CONSTRAINT "PROCESSES_PROCESSDEFINIT0" FOREIGN KEY ("PROCESSDEFINITION")
	  REFERENCES "PROCESSDEFINITIONS" ("OID") ENABLE;
  ALTER TABLE "PROCESSES" ADD CONSTRAINT "PROCESSES_STATE" FOREIGN KEY ("STATE")
	  REFERENCES "PROCESSSTATES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCESSREQUESTERS
--------------------------------------------------------

  ALTER TABLE "PROCESSREQUESTERS" ADD CONSTRAINT "PROCESSREQUESTERS_ACTIVI1" FOREIGN KEY ("ACTIVITYREQUESTER")
	  REFERENCES "ACTIVITIES" ("OID") ENABLE;
  ALTER TABLE "PROCESSREQUESTERS" ADD CONSTRAINT "PROCESSREQUESTERS_RESOUR2" FOREIGN KEY ("RESOURCEREQUESTER")
	  REFERENCES "RESOURCESTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "PROCLEVELPARTICIPANT" ADD CONSTRAINT "PROCLEVELPARTICIPANT_PRO1" FOREIGN KEY ("PROCESSOID")
	  REFERENCES "XPDLPARTICIPANTPROCESS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELXPDLAPP
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPP" ADD CONSTRAINT "PROCLEVELXPDLAPP_PROCESS4" FOREIGN KEY ("PROCESSOID")
	  REFERENCES "XPDLAPPLICATIONPROCESS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELXPDLAPPTAAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE31" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PROCLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAIL" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE32" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPDETAIL" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELXPDLAPPTAAPPDETAILUSR
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE39" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PROCLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPDETAILUSR" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPDE40" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPDETAILUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELXPDLAPPTAAPPUSER
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPUS35" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PROCLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTAAPPUSER" ADD CONSTRAINT "PROCLEVELXPDLAPPTAAPPUS36" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPPUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PROCLEVELXPDLAPPTOOLAGENTAPP
--------------------------------------------------------

  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PROCLEVELXPDLAPPTOOLAGE27" FOREIGN KEY ("XPDL_APPOID")
	  REFERENCES "PROCLEVELXPDLAPP" ("OID") ENABLE;
  ALTER TABLE "PROCLEVELXPDLAPPTOOLAGENTAPP" ADD CONSTRAINT "PROCLEVELXPDLAPPTOOLAGE28" FOREIGN KEY ("TOOLAGENTOID")
	  REFERENCES "TOOLAGENTAPP" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table STATEEVENTAUDITS
--------------------------------------------------------

  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_NEWACT12" FOREIGN KEY ("NEWACTIVITYSTATE")
	  REFERENCES "ACTIVITYSTATEEVENTAUDITS" ("OID") ENABLE;
  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_NEWPRO10" FOREIGN KEY ("NEWPROCESSSTATE")
	  REFERENCES "PROCESSSTATEEVENTAUDITS" ("OID") ENABLE;
  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_OLDACT11" FOREIGN KEY ("OLDACTIVITYSTATE")
	  REFERENCES "ACTIVITYSTATEEVENTAUDITS" ("OID") ENABLE;
  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_OLDPROC9" FOREIGN KEY ("OLDPROCESSSTATE")
	  REFERENCES "PROCESSSTATEEVENTAUDITS" ("OID") ENABLE;
  ALTER TABLE "STATEEVENTAUDITS" ADD CONSTRAINT "STATEEVENTAUDITS_THETYPE" FOREIGN KEY ("THETYPE")
	  REFERENCES "EVENTTYPES" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table TOOLAGENTAPPDETAIL
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPDETAIL" ADD CONSTRAINT "TOOLAGENTAPPDETAIL_TOOLA5" FOREIGN KEY ("TOOLAGENT_APPOID")
	  REFERENCES "TOOLAGENTAPP" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table TOOLAGENTAPPDETAILUSER
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPDETAILUSER" ADD CONSTRAINT "TOOLAGENTAPPDETAILUSER_T7" FOREIGN KEY ("TOOLAGENT_APPOID")
	  REFERENCES "TOOLAGENTAPPDETAIL" ("OID") ENABLE;
  ALTER TABLE "TOOLAGENTAPPDETAILUSER" ADD CONSTRAINT "TOOLAGENTAPPDETAILUSER_U8" FOREIGN KEY ("USEROID")
	  REFERENCES "TOOLAGENTUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table TOOLAGENTAPPUSER
--------------------------------------------------------

  ALTER TABLE "TOOLAGENTAPPUSER" ADD CONSTRAINT "TOOLAGENTAPPUSER_TOOLAGE6" FOREIGN KEY ("TOOLAGENT_APPOID")
	  REFERENCES "TOOLAGENTAPP" ("OID") ENABLE;
  ALTER TABLE "TOOLAGENTAPPUSER" ADD CONSTRAINT "TOOLAGENTAPPUSER_USEROID" FOREIGN KEY ("USEROID")
	  REFERENCES "TOOLAGENTUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table USERGROUPTABLE
--------------------------------------------------------

  ALTER TABLE "USERGROUPTABLE" ADD CONSTRAINT "USERGROUPTABLE_GROUPID" FOREIGN KEY ("GROUPID")
	  REFERENCES "GROUPTABLE" ("OID") ENABLE;
  ALTER TABLE "USERGROUPTABLE" ADD CONSTRAINT "USERGROUPTABLE_USERID" FOREIGN KEY ("USERID")
	  REFERENCES "USERTABLE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table USERPACKLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "USERPACKLEVELPARTICIPANT" ADD CONSTRAINT "USERPACKLEVELPARTICIPAN10" FOREIGN KEY ("PARTICIPANTOID")
	  REFERENCES "PACKLEVELPARTICIPANT" ("OID") ENABLE;
  ALTER TABLE "USERPACKLEVELPARTICIPANT" ADD CONSTRAINT "USERPACKLEVELPARTICIPAN11" FOREIGN KEY ("USEROID")
	  REFERENCES "NORMALUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table USERPROCLEVELPARTICIPANT
--------------------------------------------------------

  ALTER TABLE "USERPROCLEVELPARTICIPANT" ADD CONSTRAINT "USERPROCLEVELPARTICIPANT6" FOREIGN KEY ("PARTICIPANTOID")
	  REFERENCES "PROCLEVELPARTICIPANT" ("OID") ENABLE;
  ALTER TABLE "USERPROCLEVELPARTICIPANT" ADD CONSTRAINT "USERPROCLEVELPARTICIPANT7" FOREIGN KEY ("USEROID")
	  REFERENCES "NORMALUSER" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table XPDLAPPLICATIONPROCESS
--------------------------------------------------------

  ALTER TABLE "XPDLAPPLICATIONPROCESS" ADD CONSTRAINT "XPDLAPPLICATIONPROCESS_P1" FOREIGN KEY ("PACKAGEOID")
	  REFERENCES "XPDLAPPLICATIONPACKAGE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table XPDLDATA
--------------------------------------------------------

  ALTER TABLE "XPDLDATA" ADD CONSTRAINT "XPDLDATA_XPDL" FOREIGN KEY ("XPDL")
	  REFERENCES "XPDLS" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table XPDLHISTORYDATA
--------------------------------------------------------

  ALTER TABLE "XPDLHISTORYDATA" ADD CONSTRAINT "XPDLHISTORYDATA_XPDLHIST0" FOREIGN KEY ("XPDLHISTORY")
	  REFERENCES "XPDLHISTORY" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table XPDLPARTICIPANTPROCESS
--------------------------------------------------------

  ALTER TABLE "XPDLPARTICIPANTPROCESS" ADD CONSTRAINT "XPDLPARTICIPANTPROCESS_P3" FOREIGN KEY ("PACKAGEOID")
	  REFERENCES "XPDLPARTICIPANTPACKAGE" ("OID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table XPDLREFERENCES
--------------------------------------------------------

  ALTER TABLE "XPDLREFERENCES" ADD CONSTRAINT "XPDLREFERENCES_REFERRING1" FOREIGN KEY ("REFERRINGXPDL")
	  REFERENCES "XPDLS" ("OID") ENABLE;


CREATE TABLE pm_systemparameter (
    id              NUMBER(19,0) NOT NULL PRIMARY KEY ENABLE,
    parameterkey    VARCHAR2(512) NOT NULL,
    categoryid      NUMBER(19,0) NOT NULL,
    parametertype   VARCHAR2(256) NOT NULL,
    removable       NUMBER(1,0) NOT NULL,
    valuestring     VARCHAR2(4000),
    valuelong       NUMBER(*,0),
    valuebool       NUMBER(1,0),
    valuedate       DATE,
    valuedouble     FLOAT
);

CREATE SEQUENCE "PM_SYSTEMPARAMETER_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER NOCYCLE;

CREATE TABLE pm_systemparametercategory (
    id            NUMBER(19,0) NOT NULL PRIMARY KEY ENABLE,
    categorykey   VARCHAR2(1024) NOT NULL
);

CREATE SEQUENCE "PM_SYSTEMPARAMETERCATEGORY_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER NOCYCLE;

INSERT INTO pm_systemparametercategory (
    id,
    categorykey
) VALUES (
    pm_systemparametercategory_seq.nextval,
    'Rights.Optional'
);

INSERT INTO pm_systemparameter (
    id,
    parameterkey,
    categoryid,
    parametertype,
    removable,
    valuebool
) VALUES (
    pm_systemparameter_seq.nextval,
    'Rights.UserAccount.Enabled',
    pm_systemparametercategory_seq.currval,
    'BOOLEAN',
    0,
    0
);

INSERT INTO pm_systemparameter (
    id,
    parameterkey,
    categoryid,
    parametertype,
    removable,
    valuebool
) VALUES (
    pm_systemparameter_seq.nextval,
    'Rights.Views.Enabled',
    pm_systemparametercategory_seq.currval,
    'BOOLEAN',
    0,
    0
);

INSERT INTO pm_systemparametercategory (
    id,
    categorykey
) VALUES (
    pm_systemparametercategory_seq.nextval,
    'General'
);

INSERT INTO pm_systemparameter (
    id,
    parameterkey,
    categoryid,
    parametertype,
    removable,
    valuestring
) VALUES (
    pm_systemparameter_seq.nextval,
    'UniversalPassword',
    pm_systemparametercategory_seq.currval,
    'PASSWORD',
    0,
    'WbqyS8mRTdyybVuPdF1SEM3cIGmM1MP02OBTjG5GrsY'
);

INSERT INTO pm_systemparameter (
    id,
    parameterkey,
    categoryid,
    parametertype,
    removable,
    valuebool
) VALUES (
    pm_systemparameter_seq.nextval,
    'ShowCalendarCart',
    pm_systemparametercategory_seq.currval,
    'BOOLEAN',
    0,
    0
);

INSERT INTO pm_systemparameter (
    id,
    parameterkey,
    categoryid,
    parametertype,
    removable,
    valuebool
) VALUES (
    pm_systemparameter_seq.nextval,
    'ShowStatistics',
    pm_systemparametercategory_seq.currval,
    'BOOLEAN',
    0,
    0
);

CREATE TABLE pm_systemparametercombovalues (
     id NUMBER(19,0) NOT NULL PRIMARY KEY ENABLE,
     ownerid NUMBER(19,0) NOT NULL,
     value VARCHAR2(4000) NOT NULL
);

CREATE SEQUENCE "PM_COMBOVALUES_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER NOCYCLE;

CREATE TABLE pm_externaldb_conf
(
  id NUMBER(19,0) NOT NULL PRIMARY KEY ENABLE,
  externalDBConfName VARCHAR2(1024),
  url VARCHAR2(1024),
  driver VARCHAR2(512),
  login VARCHAR2(256),
  password VARCHAR2(256)
);

CREATE SEQUENCE "externaldbconf_id_seq" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER NOCYCLE;

CREATE TABLE pm_querydatachooser
(
  id NUMBER(19,0) NOT NULL PRIMARY KEY ENABLE,
  name VARCHAR2(1024),
  query VARCHAR2(4000),
  parameters VARCHAR2(1024),
  countQuery VARCHAR2(4000),
  externalDB VARCHAR2(256),
  externalDBConfName VARCHAR2(1024),
  fullClassName VARCHAR2(512)
);

CREATE SEQUENCE "querydatachooser_id_seq" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER NOCYCLE;

CREATE INDEX "I4_ACTIVITIES" ON "ACTIVITIES" ("PROCESSID")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE( INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;


CREATE TABLE "PM_SEQUENCE_MAP"
(
	"SEQUENCE_HASHED_NAME" VARCHAR2(30 CHAR),
	"SEQUENCE_NAME" VARCHAR2(255 CHAR),
	CONSTRAINT "PM_SEQUENCE_MAP" PRIMARY KEY ("SEQUENCE_HASHED_NAME")
);

CREATE INDEX "I1_PM_AUDITS" ON "PM_AUDITS" ("USERID", "AUDITTYPE", "AUDITSTARTED", "AUDITSTOPPED")
PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
TABLESPACE "USERS" ;
