/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.dashboard;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropUniqueConstraintsPmDashboardDefaultPostgres
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(DropUniqueConstraintsPmDashboardDefaultPostgres.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList statements = new ArrayList();
        String query = "SELECT tc.constraint_name constraintName FROM information_schema.table_constraints tc LEFT JOIN information_schema.constraint_column_usage ccu ON tc.constraint_name = ccu.constraint_name WHERE tc.table_name = 'pm_dashboard_default' AND tc.constraint_type = 'UNIQUE' AND (     (ccu.column_name = 'group_id' AND NOT EXISTS (       SELECT 1       FROM information_schema.key_column_usage kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name <> 'group_id'     ))     OR     (ccu.column_name = 'user_id' AND NOT EXISTS (       SELECT 1       FROM information_schema.key_column_usage kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name <> 'user_id'     ))   );";
        HashSet<String> uniqueConstraintsToDelete = new HashSet<String>();
        try (ResultSet resultSet = connection.prepareStatement("SELECT tc.constraint_name constraintName FROM information_schema.table_constraints tc LEFT JOIN information_schema.constraint_column_usage ccu ON tc.constraint_name = ccu.constraint_name WHERE tc.table_name = 'pm_dashboard_default' AND tc.constraint_type = 'UNIQUE' AND (     (ccu.column_name = 'group_id' AND NOT EXISTS (       SELECT 1       FROM information_schema.key_column_usage kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name <> 'group_id'     ))     OR     (ccu.column_name = 'user_id' AND NOT EXISTS (       SELECT 1       FROM information_schema.key_column_usage kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name <> 'user_id'     ))   );").executeQuery();){
            while (resultSet.next()) {
                uniqueConstraintsToDelete.add(resultSet.getString("constraintName"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching unique constraints for pm_dashboard_default table", (Throwable)e);
        }
        uniqueConstraintsToDelete.forEach(constraintName -> statements.add(this.generateDropUniqueConstraintStatement((String)constraintName)));
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateDropUniqueConstraintStatement(String constraintName) {
        return new RawSqlStatement(String.format("ALTER TABLE pm_dashboard_default DROP CONSTRAINT %s", constraintName));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

