/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.views.builder;

import com.suncode.pwfl.changes.views.model.ActivityDetailsSearchModelDto;
import com.suncode.pwfl.changes.views.model.ExtraValueSearchModelDto;
import com.suncode.pwfl.changes.views.model.ExtrasSearchModelDto;
import com.suncode.pwfl.changes.views.model.ProcessDetailsSearchModelDto;
import com.suncode.pwfl.changes.views.model.ProcessVariablesSearchModelDto;
import com.suncode.pwfl.changes.views.model.SearchFormModelDto;
import com.suncode.pwfl.changes.views.model.SearchFormVariableDefinitionDto;
import com.suncode.pwfl.changes.views.model.ValueSearchModelDto;
import com.suncode.pwfl.changes.views.model.VariableSearchModelDto;
import com.suncode.pwfl.changes.views.variables.AdvanceVariableForm;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class SearchFormModelBuilder {
    public SearchFormModelDto buildSearchFormModel(AdvanceVariableForm[] advanceVariableForm) {
        String processDefId = advanceVariableForm[17].getValue();
        SearchFormModelDto searchFormModelDto = new SearchFormModelDto();
        searchFormModelDto.setActivityDetailsSearchModel(this.buildActivityDetailsSearchModelDto(advanceVariableForm));
        searchFormModelDto.setProcessDetailsSearchModel(this.buildProcessDetailsSearchModelDto(advanceVariableForm));
        searchFormModelDto.setProcessVariablesSearchModel(this.buildProcessVariablesSearchModelDto(advanceVariableForm));
        return searchFormModelDto;
    }

    private ActivityDetailsSearchModelDto buildActivityDetailsSearchModelDto(AdvanceVariableForm[] advanceVariableForm) {
        advanceVariableForm[9].setType("STRING");
        advanceVariableForm[10].setType("LISTBOX");
        advanceVariableForm[11].setType("STRING");
        advanceVariableForm[12].setType("DATETIME");
        advanceVariableForm[13].setType("DATETIME");
        advanceVariableForm[14].setType("INTEGER");
        advanceVariableForm[18].setType("STRING");
        ActivityDetailsSearchModelDto activityDetailsSearchModelDto = new ActivityDetailsSearchModelDto();
        activityDetailsSearchModelDto.setName(this.populateValueSearchModelDto(advanceVariableForm[9], false));
        activityDetailsSearchModelDto.setState(this.populateValueSearchModelDto(advanceVariableForm[10], false));
        activityDetailsSearchModelDto.setPerformer(this.populateValueSearchModelDto(advanceVariableForm[11], false));
        activityDetailsSearchModelDto.setCreatedDate(this.populateValueSearchModelDto(advanceVariableForm[12], true));
        activityDetailsSearchModelDto.setFinishedDate(this.populateValueSearchModelDto(advanceVariableForm[13], true));
        activityDetailsSearchModelDto.setDeadlineTimeDays(this.populateValueSearchModelDto(advanceVariableForm[14], true));
        activityDetailsSearchModelDto.setOnlyActivitiesToOpen(this.resolveBooleanValue(advanceVariableForm[15].getValue()));
        activityDetailsSearchModelDto.setOnlyMyActivities(this.resolveBooleanValue(advanceVariableForm[16].getValue()));
        activityDetailsSearchModelDto.setDeadlineName(this.populateValueSearchModelDto(advanceVariableForm[18], false));
        return activityDetailsSearchModelDto;
    }

    private ProcessDetailsSearchModelDto buildProcessDetailsSearchModelDto(AdvanceVariableForm[] advanceVariableForm) {
        advanceVariableForm[0].setType("LISTBOX");
        advanceVariableForm[1].setType("STRING");
        advanceVariableForm[2].setType("STRING");
        advanceVariableForm[3].setType("STRING");
        advanceVariableForm[4].setType("LISTBOX");
        advanceVariableForm[6].setType("DATETIME");
        advanceVariableForm[7].setType("DATETIME");
        advanceVariableForm[8].setType("INTEGER");
        ProcessDetailsSearchModelDto processDetailsSearchModelDto = new ProcessDetailsSearchModelDto();
        processDetailsSearchModelDto.setProcessDefinitionId(this.populateValueSearchModelDto(advanceVariableForm[0], false));
        processDetailsSearchModelDto.setName(this.populateValueSearchModelDto(advanceVariableForm[1], false));
        processDetailsSearchModelDto.setDescription(this.populateValueSearchModelDto(advanceVariableForm[2], false));
        processDetailsSearchModelDto.setInitiator(this.populateValueSearchModelDto(advanceVariableForm[3], false));
        processDetailsSearchModelDto.setState(this.populateValueSearchModelDto(advanceVariableForm[4], false));
        processDetailsSearchModelDto.setCreatedDate(this.populateValueSearchModelDto(advanceVariableForm[6], true));
        processDetailsSearchModelDto.setFinishedDate(this.populateValueSearchModelDto(advanceVariableForm[7], true));
        processDetailsSearchModelDto.setDeadlineTimeDays(this.populateValueSearchModelDto(advanceVariableForm[8], true));
        return processDetailsSearchModelDto;
    }

    private ProcessVariablesSearchModelDto buildProcessVariablesSearchModelDto(AdvanceVariableForm[] advanceVariableForm) {
        ProcessVariablesSearchModelDto processVariablesSearchModelDto = new ProcessVariablesSearchModelDto();
        String processDefinitionId = advanceVariableForm[17].getValue();
        processVariablesSearchModelDto.setProcessDefinitionId(processDefinitionId);
        ArrayList<VariableSearchModelDto> variables = new ArrayList<VariableSearchModelDto>();
        if (StringUtils.isNotBlank((String)processDefinitionId)) {
            processVariablesSearchModelDto.setShowResultsInOneRow(advanceVariableForm[19] != null && this.resolveBooleanValue(advanceVariableForm[19].getValue()));
            for (int i = 20; i < advanceVariableForm.length; ++i) {
                AdvanceVariableForm variable = advanceVariableForm[i];
                if (variable == null) continue;
                variables.add(this.populateVariableSearchModelDto(variable));
            }
        }
        processVariablesSearchModelDto.setVariables(variables);
        return processVariablesSearchModelDto;
    }

    public ExtrasSearchModelDto buildExtrasSearchModelDto(AdvanceVariableForm[] advanceVariableForm) {
        ExtrasSearchModelDto extrasSearchModelDto = new ExtrasSearchModelDto();
        ValueSearchModelDto showAttachedDocuments = new ValueSearchModelDto();
        showAttachedDocuments.setExtraValueSearchModel(new ExtraValueSearchModelDto());
        ValueSearchModelDto allowAttachedDocuments = new ValueSearchModelDto();
        allowAttachedDocuments.setExtraValueSearchModel(new ExtraValueSearchModelDto());
        if (advanceVariableForm[0] != null) {
            showAttachedDocuments = this.populateValueSearchModelDto(advanceVariableForm[0], false);
        }
        if (advanceVariableForm[1] != null) {
            allowAttachedDocuments = this.populateValueSearchModelDto(advanceVariableForm[1], false);
        }
        extrasSearchModelDto.setShowAttachedDocuments(showAttachedDocuments);
        extrasSearchModelDto.setAllowAttachDocuments(allowAttachedDocuments);
        return extrasSearchModelDto;
    }

    private ValueSearchModelDto populateValueSearchModelDto(AdvanceVariableForm advanceVariableForm, boolean forceRangeActive) {
        ValueSearchModelDto valueSearchModelDto = new ValueSearchModelDto();
        String value = advanceVariableForm.getValue();
        valueSearchModelDto.setValue(value);
        if (StringUtils.isNotBlank((String)value)) {
            valueSearchModelDto.setValues(advanceVariableForm.getValue().split(";"));
        }
        valueSearchModelDto.setFrom(value);
        valueSearchModelDto.setTo(advanceVariableForm.getValue2());
        valueSearchModelDto.setRangeActive(forceRangeActive || this.isRangeMode(advanceVariableForm.getSearchMode()));
        valueSearchModelDto.setType(advanceVariableForm.getType());
        ExtraValueSearchModelDto extraValueSearchModelDto = new ExtraValueSearchModelDto();
        String position = advanceVariableForm.getPosition();
        Integer variableDisplayPosition = this.getVariableDisplayPosition(position);
        extraValueSearchModelDto.setPosition(variableDisplayPosition);
        extraValueSearchModelDto.setFilterPosition(variableDisplayPosition);
        extraValueSearchModelDto.setIgnoreCase(this.resolveBooleanValue(advanceVariableForm.getUpperCase()));
        extraValueSearchModelDto.setShowColumn(this.resolveBooleanValue(advanceVariableForm.getActive()));
        extraValueSearchModelDto.setShowFilter(this.resolveBooleanValue(advanceVariableForm.getShowFilter()));
        extraValueSearchModelDto.setDisableFilter(this.resolveBooleanValue(advanceVariableForm.getDisableFilter()));
        extraValueSearchModelDto.setSortDirection(advanceVariableForm.getSortType());
        valueSearchModelDto.setExtraValueSearchModel(extraValueSearchModelDto);
        return valueSearchModelDto;
    }

    @Nullable
    private Integer getVariableDisplayPosition(String position) {
        if (StringUtils.isBlank((String)position)) {
            return null;
        }
        try {
            return Integer.valueOf(position);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public VariableSearchModelDto fromSearchFormVariableDefinitionDto(SearchFormVariableDefinitionDto searchFormVariableDefinitionDto) {
        VariableSearchModelDto variableSearchModelDto = new VariableSearchModelDto();
        variableSearchModelDto.setId(searchFormVariableDefinitionDto.getId());
        variableSearchModelDto.setName(searchFormVariableDefinitionDto.getName());
        ValueSearchModelDto valueSearchModelDto = new ValueSearchModelDto();
        valueSearchModelDto.setType(searchFormVariableDefinitionDto.getRawType());
        valueSearchModelDto.setSubType(searchFormVariableDefinitionDto.getRawSubType());
        valueSearchModelDto.setArray(searchFormVariableDefinitionDto.getIsArray());
        ExtraValueSearchModelDto extraValueSearchModelDto = new ExtraValueSearchModelDto();
        extraValueSearchModelDto.setPosition(999);
        extraValueSearchModelDto.setShowColumn(true);
        valueSearchModelDto.setExtraValueSearchModel(extraValueSearchModelDto);
        variableSearchModelDto.setValue(valueSearchModelDto);
        return variableSearchModelDto;
    }

    private VariableSearchModelDto populateVariableSearchModelDto(AdvanceVariableForm advanceVariableForm) {
        VariableSearchModelDto variableSearchModelDto = new VariableSearchModelDto();
        variableSearchModelDto.setId(advanceVariableForm.getName());
        variableSearchModelDto.setName(advanceVariableForm.getName());
        ValueSearchModelDto valueSearchModelDto = this.populateValueSearchModelDto(advanceVariableForm, false);
        boolean isRangeActive = this.isRangeMode(advanceVariableForm.getSearchMode());
        valueSearchModelDto.setRangeActive(isRangeActive);
        variableSearchModelDto.setValue(valueSearchModelDto);
        return variableSearchModelDto;
    }

    private boolean isRangeMode(String searchMode) {
        return searchMode != null && searchMode.equalsIgnoreCase("RANGE");
    }

    private boolean resolveBooleanValue(String value) {
        return StringUtils.isNotBlank((String)value) && value.equals("on");
    }
}

