/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateLinkIndicesTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateLinkIndicesTranslations.class);
    private Map<Long, String> linkIndicesNames = new HashMap<Long, String>();
    private Map<Long, String> linkIndicesDescriptions = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_linkindecies_translations";
        this.sequenceName = "pm_linkindecies_tr_id_seq";
        this.entityTableName = "pm_linkindecies";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, indexname as name, indexdescription as description FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.linkIndicesNames.put(resultSet.getLong("id"), resultSet.getString("name"));
                this.linkIndicesDescriptions.put(resultSet.getLong("id"), resultSet.getString("description"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        InsertStatement insertStatement;
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.linkIndicesNames, (String)translation.getKey());
        List<Long> translatedDescEntityIds = this.getTranslatedEntityId(this.linkIndicesDescriptions, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        for (Long id : translatedDescEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"DESCRIPTION");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getLinkIndicesNames() {
        return this.linkIndicesNames;
    }

    public Map<Long, String> getLinkIndicesDescriptions() {
        return this.linkIndicesDescriptions;
    }

    public void setLinkIndicesNames(Map<Long, String> linkIndicesNames) {
        this.linkIndicesNames = linkIndicesNames;
    }

    public void setLinkIndicesDescriptions(Map<Long, String> linkIndicesDescriptions) {
        this.linkIndicesDescriptions = linkIndicesDescriptions;
    }
}

