/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.indexes.rename;

import com.suncode.pwfl.changes.indexes.rename.RenameOrCreateIndex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenameOracleIndexes
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(RenameOracleIndexes.class);
    private final String fileName = System.getProperty("plusworkflow.home") + "/rename-indexes-log.txt";
    private final String findIndexNameQuery = "SELECT index_name FROM all_ind_columns WHERE table_name = '%s' AND INDEX_OWNER = (SELECT sys_context('userenv', 'current_schema') AS current_schema FROM dual) GROUP BY index_name HAVING SUM(CASE WHEN column_name NOT IN (%s) THEN 1 ELSE 0 END) = 0 AND LISTAGG( column_name, ',' ) WITHIN GROUP (ORDER BY column_position)='%s'";
    protected String tableName;
    protected List<RenameOrCreateIndex> indexes;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        if (StringUtils.isBlank((CharSequence)this.tableName) || CollectionUtils.isEmpty(this.indexes)) {
            return new SqlStatement[0];
        }
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName, true));){
            writer.write(String.format("Checking indexes for table %s", this.tableName));
            writer.newLine();
            int i = 0;
            for (RenameOrCreateIndex index : this.indexes) {
                String columnsParam1 = index.getColumns().stream().map(column -> String.format("'%s'", column)).collect(Collectors.joining(","));
                String columnsParam2 = index.getColumns().stream().collect(Collectors.joining(","));
                String query = String.format("SELECT index_name FROM all_ind_columns WHERE table_name = '%s' AND INDEX_OWNER = (SELECT sys_context('userenv', 'current_schema') AS current_schema FROM dual) GROUP BY index_name HAVING SUM(CASE WHEN column_name NOT IN (%s) THEN 1 ELSE 0 END) = 0 AND LISTAGG( column_name, ',' ) WITHIN GROUP (ORDER BY column_position)='%s'", this.tableName, columnsParam1, columnsParam2);
                try {
                    ResultSet resultSet = connection.prepareStatement(query).executeQuery();
                    try {
                        if (resultSet.next()) {
                            String currentIndexName = resultSet.getString("index_name");
                            if (!currentIndexName.equalsIgnoreCase(index.getNewName())) {
                                writer.write(String.format("Renaming index %s to %s", currentIndexName, index.getNewName()));
                                writer.newLine();
                                statements.add(this.generateRenameStatement(currentIndexName, index.getNewName()));
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)index.getCreateIndexStatement())) {
                            writer.write(String.format("Creating index %s with query: %s", index.getNewName(), index.getCreateIndexStatement()));
                            writer.newLine();
                            statements.add(new RawSqlStatement(index.getCreateIndexStatement()));
                        }
                        ++i;
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                catch (Exception e) {
                    log.error("Error fetching index {} for {} table", new Object[]{index.getNewName(), this.tableName, e});
                }
            }
            writer.write(String.format("%d/%d indexes processed", i, this.indexes.size()));
            writer.newLine();
            writer.newLine();
        }
        catch (IOException e) {
            log.error(String.format("Error on writing data to file: %s", this.fileName), (Throwable)e);
        }
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateRenameStatement(String oldName, String newName) {
        String query = String.format("ALTER INDEX %s RENAME TO %s", oldName, newName);
        return new RawSqlStatement(query);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

