/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.dashboard;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropUniqueConstraintsPmDashboardDefaultOracle
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(DropUniqueConstraintsPmDashboardDefaultOracle.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList statements = new ArrayList();
        String query = "SELECT ccu.constraint_name AS CONSTRAINT_NAME FROM all_constraints tc LEFT JOIN all_cons_columns ccu ON tc.constraint_name = ccu.constraint_name WHERE tc.table_name = 'PM_DASHBOARD_DEFAULT'   AND tc.constraint_type = 'U'   AND (     (ccu.column_name = 'GROUP_ID' AND NOT EXISTS (       SELECT 1       FROM all_cons_columns kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name != 'GROUP_ID'     ))     OR     (ccu.column_name = 'USER_ID' AND NOT EXISTS (       SELECT 1       FROM all_cons_columns kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name != 'USER_ID'     ))   )";
        HashSet<String> uniqueConstraintsToDelete = new HashSet<String>();
        try (ResultSet resultSet = connection.prepareStatement("SELECT ccu.constraint_name AS CONSTRAINT_NAME FROM all_constraints tc LEFT JOIN all_cons_columns ccu ON tc.constraint_name = ccu.constraint_name WHERE tc.table_name = 'PM_DASHBOARD_DEFAULT'   AND tc.constraint_type = 'U'   AND (     (ccu.column_name = 'GROUP_ID' AND NOT EXISTS (       SELECT 1       FROM all_cons_columns kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name != 'GROUP_ID'     ))     OR     (ccu.column_name = 'USER_ID' AND NOT EXISTS (       SELECT 1       FROM all_cons_columns kcu       WHERE kcu.table_name = tc.table_name       AND kcu.constraint_name = tc.constraint_name       AND kcu.column_name != 'USER_ID'     ))   )").executeQuery();){
            while (resultSet.next()) {
                uniqueConstraintsToDelete.add(resultSet.getString("CONSTRAINT_NAME"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching unique constraints for pm_dashboard_default table", (Throwable)e);
        }
        uniqueConstraintsToDelete.forEach(constraintName -> statements.add(this.generateDropUniqueConstraintStatement((String)constraintName)));
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateDropUniqueConstraintStatement(String constraintName) {
        return new RawSqlStatement(String.format("ALTER TABLE pm_dashboard_default DROP CONSTRAINT %s", constraintName));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

