CREATE TABLE "dbo"."pm_dashboard"
(
   "id" numeric(19,0) IDENTITY PRIMARY KEY,
   "created" datetime NOT NULL,
   "description" varchar(255),
   "name" varchar(100) NOT NULL,
   "owner_id" decimal(19,0) NOT NULL
)
GO
ALTER TABLE "dbo"."pm_dashboard"
ADD CONSTRAINT fk_pm_dashboard_usertable
FOREIGN KEY (owner_id)
REFERENCES "dbo"."UserTable"(oid) ON DELETE CASCADE
GO
CREATE UNIQUE INDEX uk_pm_dashboard_owner_id_name ON "dbo"."pm_dashboard"
(
  owner_id,
  name
)
GO

CREATE TABLE "dbo"."pm_dashboard_default"
(
   "id" numeric(19,0) IDENTITY PRIMARY KEY NOT NULL,
   "dashboard_id" numeric(19,0) NOT NULL,
   "group_id" decimal(19,0),
   "user_id" decimal(19,0)
)
GO
ALTER TABLE "dbo"."pm_dashboard_default"
ADD CONSTRAINT fk_pm_dashboard_default_usertable
FOREIGN KEY (user_id)
REFERENCES "dbo"."UserTable"(oid) ON DELETE CASCADE
GO
ALTER TABLE "dbo"."pm_dashboard_default"
ADD CONSTRAINT fk_pm_dashboard_default_pm_dashboard
FOREIGN KEY (dashboard_id)
REFERENCES "dbo"."pm_dashboard"(id)
GO
ALTER TABLE "dbo"."pm_dashboard_default"
ADD CONSTRAINT fk_pm_dashboard_default_grouptable
FOREIGN KEY (group_id)
REFERENCES "dbo"."GroupTable"(oid) ON DELETE CASCADE
GO
CREATE UNIQUE INDEX uk_pm_dashboard_default_group_id ON "dbo"."pm_dashboard_default"(user_id)
GO
CREATE UNIQUE INDEX uk_pm_dashboard_default_user_id ON "dbo"."pm_dashboard_default"(group_id)
GO

CREATE TABLE "dbo"."pm_dashboard_gadget"
(
   "id" numeric(19,0) IDENTITY PRIMARY KEY NOT NULL,
   "key" varchar(255) NOT NULL,
   "collapsed" tinyint NOT NULL,
   "height" int,
   "layoutorder" int,
   "positionX" int,
   "width" int,
   "dashboard_id" numeric(19,0) NOT NULL
)
GO
ALTER TABLE "dbo"."pm_dashboard_gadget"
ADD CONSTRAINT fk_pm_dashboard_gadget_pm_dashboard
FOREIGN KEY (dashboard_id)
REFERENCES "dbo"."pm_dashboard"(id)
GO

CREATE TABLE "dbo"."pm_dashboard_gadgetprop"
(
   "id" numeric(19,0) IDENTITY PRIMARY KEY NOT NULL,
   "name" varchar(100),
   "value" varchar(4000),
   "gadget_id" numeric(19,0) NOT NULL
)
GO
ALTER TABLE "dbo"."pm_dashboard_gadgetprop"
ADD CONSTRAINT fk_pm_dashboard_gadgetprop_pm_dashboard_gadget
FOREIGN KEY (gadget_id)
REFERENCES "dbo"."pm_dashboard_gadget"(id)
GO
CREATE UNIQUE INDEX uk_pm_dashboard_gadgetprop_gadget_id_name ON "dbo"."pm_dashboard_gadgetprop"
(
  "gadget_id",
  "name"
)
GO

CREATE TABLE "dbo"."pm_dashboard_share"
(
   "type" varchar(31) NOT NULL,
   "id" numeric(19,0) IDENTITY PRIMARY KEY NOT NULL,
   "dashboard_id" numeric(19,0) NOT NULL,
   "group_id" decimal(19,0),
   "user_id" decimal(19,0)
)
GO
ALTER TABLE "dbo"."pm_dashboard_share"
ADD CONSTRAINT fk_pm_dashboard_share_usertable
FOREIGN KEY (user_id)
REFERENCES "dbo"."UserTable"(oid) ON DELETE CASCADE
GO
ALTER TABLE "dbo"."pm_dashboard_share"
ADD CONSTRAINT fk_pm_dashboard_share_grouptable
FOREIGN KEY (group_id)
REFERENCES "dbo"."GroupTable"(oid) ON DELETE CASCADE
GO
ALTER TABLE "dbo"."pm_dashboard_share"
ADD CONSTRAINT fk_pm_dashboard_share_pm_dashboard
FOREIGN KEY (dashboard_id)
REFERENCES "dbo"."pm_dashboard"(id)
GO