/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade;

import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalConfiguration;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.upgrade.UpgraderLockService;
import com.suncode.pwfl.upgrade.UpgraderLockServiceImpl;
import com.suncode.upgrader.Upgrader;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SystemUpgrader {
    private final String PRE_INITIALIZE_CHANGE_FILE = "changes/pre_initialize/pre_initialize_changes.xml";
    private final String POST_INITIALIZE_CHANGE_FILE = "changes/post_initialize/post_initialize_changes.xml";
    private Logger log = LoggerFactory.getLogger(SystemUpgrader.class);
    private static Properties sharkConf;
    @Nullable
    private UpgraderLockService upgraderLockService;

    public SystemUpgrader() {
        Experimental experimental = ExperimentalConfiguration.getExperimentalInstance();
        if (experimental.hasFeature(ExperimentalFeature.DISTRIBUTED_UPGRADER_LOCK)) {
            this.upgraderLockService = new UpgraderLockServiceImpl(DataSourceFactory.getDataSource());
        }
    }

    public void upgradePreInitialize() {
        this.upgrade("changes/pre_initialize/pre_initialize_changes.xml");
    }

    public void upgradePostInitialize() {
        this.upgrade("changes/post_initialize/post_initialize_changes.xml");
    }

    private void upgrade(String changeFilePath) {
        if (this.upgraderLockService != null) {
            this.upgraderLockService.doWithinUpgraderLock(() -> this.doUpgrade(changeFilePath));
        } else {
            this.doUpgrade(changeFilePath);
        }
    }

    private void doUpgrade(String changeFilePath) {
        this.log.info("Starting upgrade from file " + changeFilePath);
        DefaultResourceLoader rl = new DefaultResourceLoader(this.getClass().getClassLoader());
        Upgrader upgrader = Upgrader.create().dataSource(DataSourceFactory.getDataSource()).project("plusworkflow").changeFile(changeFilePath).resourceLoader((ResourceLoader)rl).build();
        upgrader.setRequiredDbVersion(false);
        upgrader.upgrade();
        this.log.info("System upgrade from file " + changeFilePath + " finished.");
    }

    public static Properties getSharkConf() {
        return sharkConf;
    }

    public static void setSharkConf(Properties sharkConf) {
        SystemUpgrader.sharkConf = sharkConf;
    }
}

