/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.gadget.Layout;
import com.suncode.pwfl.dashboard.persistence.DashboardDao;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class ResizeDashboardGadgets
implements CustomTaskChange {
    private final DashboardDao dashboardDao = (DashboardDao)SpringContext.getBean(DashboardDao.class);
    private final DashboardService dashboardService = (DashboardService)SpringContext.getBean(DashboardService.class);

    public void execute(Database database) {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            List userDashboards = this.dashboardDao.getAll(new String[]{"dashboardGadgets"});
            userDashboards.stream().flatMap(dashboard -> dashboard.getDashboardGadgets().stream()).forEach(gadget -> {
                Integer width;
                Layout layout = gadget.getLayout();
                Integer positionX = layout.getPositionX();
                if (positionX != null) {
                    layout.setPositionX(Integer.valueOf(positionX * 2));
                }
                if ((width = layout.getWidth()) != null) {
                    layout.setWidth(Integer.valueOf(width * 2));
                }
            });
            userDashboards.forEach(dashboard -> this.dashboardService.updateDashboard((Dashboard)dashboard, Boolean.valueOf(false)));
        });
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

