/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.enhydra.shark.utilities.MiscUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulatePasswordDictionary
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(PopulatePasswordDictionary.class);
    private static final String PASSWORD_DICTIONARY_PATH = "password_dictionary.txt";
    private static final int BATCH_SIZE = 10000;

    public void execute(Database database) throws CustomChangeException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        String databaseProductName = database.getDatabaseProductName();
        String query = "INSERT INTO pm_policy_password_dictionary (dictionary_password) VALUES (?)";
        if ("Oracle".equalsIgnoreCase(databaseProductName)) {
            query = "INSERT INTO pm_policy_password_dictionary (\"DICTIONARY_PASSWORD\") VALUES (?)";
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(PASSWORD_DICTIONARY_PATH);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            String password;
            int count = 0;
            while ((password = reader.readLine()) != null) {
                preparedStatement.setString(1, MiscUtilities.passwordDigest((String)password));
                preparedStatement.addBatch();
                if (++count % 10000 != 0) continue;
                preparedStatement.executeBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

