/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.archive;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class DeleteUniqueConstraintsFromClassesAssociations
implements CustomSqlChange {
    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        String selectUniqueConstraints = "select tc.constraint_name from information_schema.table_constraints tc where tc.constraint_type  = 'UNIQUE' and tc.table_name = 'pm_classesassociation';";
        PreparedStatement uniqueConstraintsStatement = connection.prepareStatement(selectUniqueConstraints);
        ResultSet uniqueConstraints = uniqueConstraintsStatement.executeQuery();
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        while (uniqueConstraints.next()) {
            String constraintName = uniqueConstraints.getString("constraint_name");
            statements.add(new RawSqlStatement(String.format("ALTER TABLE pm_classesassociation DROP CONSTRAINT %s", constraintName)));
        }
        return (SqlStatement[])statements.toArray(RawSqlStatement[]::new);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

