/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.pwfl.SystemContext;
import com.suncode.pwfl.distinction.DistinctionEntityRepository;
import com.suncode.pwfl.distinction.VariableDistinguishTable;
import com.suncode.pwfl.util.GraphicUtils;
import com.suncode.pwfl.util.SpringContext;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Optional;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertDistinctionIconToBlob
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(ConvertDistinctionIconToBlob.class);
    private final DistinctionEntityRepository variableDistinguishService = (DistinctionEntityRepository)SpringContext.getBean(DistinctionEntityRepository.class);

    public void execute(Database database) throws CustomChangeException {
        block26: {
            log.info("***Converting distinction icons to blob***");
            JdbcConnection connection = (JdbcConnection)database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("SELECT variable_distinguish_id, imagePath, icon FROM pm_variable_distinguish");){
                ResultSet fetchedPaths = statement.executeQuery();
                block19: while (true) {
                    while (fetchedPaths.next()) {
                        String imagePath = fetchedPaths.getString("imagePath");
                        if (StringUtils.isBlank((CharSequence)imagePath) || fetchedPaths.getBlob("icon") != null) continue;
                        Optional<String> realPath = Optional.ofNullable(SystemContext.get().getServletContext().getRealPath(imagePath));
                        if (realPath.isEmpty()) {
                            log.info("File with given path does not exist: " + imagePath);
                            continue;
                        }
                        Path path = Paths.get(realPath.get().replace("\\", "/"), new String[0]);
                        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
                            log.info("File with given path does not exist: " + path);
                            continue;
                        }
                        try {
                            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                            try {
                                VariableDistinguishTable distinction = this.variableDistinguishService.get(Long.valueOf(fetchedPaths.getLong("variable_distinguish_id")));
                                distinction.setIcon(GraphicUtils.resizeImage((byte[])inputStream.readAllBytes(), (int)36));
                                this.variableDistinguishService.update(distinction);
                                continue block19;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                continue block19;
                            }
                        }
                        catch (Exception e) {
                            log.info("Couldn't save icon from path: {}. Message: {}", (Object)path, (Object)e.getMessage());
                        }
                    }
                    break block26;
                    {
                        continue block19;
                        break;
                    }
                    break;
                }
                finally {
                    if (fetchedPaths != null) {
                        fetchedPaths.close();
                    }
                }
            }
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

