/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateDocClassesTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateDocClassesTranslations.class);
    private Map<Long, String> docClassesNames = new HashMap<Long, String>();
    private Map<Long, String> docClassesDescriptions = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_docclasses_translations";
        this.sequenceName = "pm_docclasses_tr_id_seq";
        this.entityTableName = "pm_docclasses";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, docclassname as name, docclassdescription as description FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.docClassesNames.put(resultSet.getLong("id"), resultSet.getString("name"));
                this.docClassesDescriptions.put(resultSet.getLong("id"), resultSet.getString("description"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        InsertStatement insertStatement;
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.docClassesNames, (String)translation.getKey());
        List<Long> translatedDescEntityIds = this.getTranslatedEntityId(this.docClassesDescriptions, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        for (Long id : translatedDescEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"DESCRIPTION");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getDocClassesNames() {
        return this.docClassesNames;
    }

    public Map<Long, String> getDocClassesDescriptions() {
        return this.docClassesDescriptions;
    }

    public void setDocClassesNames(Map<Long, String> docClassesNames) {
        this.docClassesNames = docClassesNames;
    }

    public void setDocClassesDescriptions(Map<Long, String> docClassesDescriptions) {
        this.docClassesDescriptions = docClassesDescriptions;
    }
}

