/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.parameters;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import com.suncode.pwfl.core.type.TypeException;
import com.suncode.pwfl.upgrade.SystemUpgrader;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.UpdateStatement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemParamUpgradeChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(SystemParamUpgradeChange.class);
    private String parameterKey;
    private String parameterType;
    private String defaultValue;
    private String category;
    private String removable;
    private String hidden;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        if (this.checkIfExists(database)) {
            log.info("Parameter {} already exists in database", (Object)this.parameterKey);
            LinkedList<SqlStatement> statementsList = new LinkedList<SqlStatement>();
            this.updateRemovable(statementsList);
            this.updateHidden(statementsList);
            this.updateType(statementsList);
            this.updateCategory(database, statementsList);
            this.updateParameterValue(database, statementsList);
            return statementsList.toArray(new SqlStatement[statementsList.size()]);
        }
        log.info("Parameter {} does not exist in database", (Object)this.parameterKey);
        return this.createNew(database);
    }

    private void updateRemovable(List<SqlStatement> statementsList) {
        if (StringUtils.isNotBlank((CharSequence)this.removable)) {
            UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
            statement.addNewColumnValue("removable", (Object)Boolean.parseBoolean(this.removable));
            statement.setWhereClause("parameterkey = '" + this.parameterKey + "'");
            statementsList.add((SqlStatement)statement);
        }
    }

    private void updateHidden(List<SqlStatement> statementsList) {
        if (StringUtils.isNotBlank((CharSequence)this.hidden)) {
            UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
            statement.addNewColumnValue("hidden", (Object)Boolean.parseBoolean(this.hidden));
            statement.setWhereClause("parameterkey = '" + this.parameterKey + "'");
            statementsList.add((SqlStatement)statement);
        }
    }

    private void updateType(List<SqlStatement> statementsList) {
        if (StringUtils.isNotBlank((CharSequence)this.parameterType)) {
            UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
            statement.addNewColumnValue("parametertype", (Object)this.parameterType);
            statement.setWhereClause("parameterkey = '" + this.parameterKey + "'");
            statementsList.add((SqlStatement)statement);
        }
    }

    private void updateCategory(Database database, List<SqlStatement> statementsList) throws CustomChangeException {
        if (StringUtils.isNotBlank((CharSequence)this.category)) {
            try {
                UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
                statement.addNewColumnValue("categoryid", (Object)SystemParamUpgradeChange.getCategoryId(database, this.category));
                statement.setWhereClause("parameterkey = '" + this.parameterKey + "'");
                statementsList.add((SqlStatement)statement);
            }
            catch (Exception ex) {
                throw new CustomChangeException((Throwable)ex);
            }
        }
    }

    private void updateParameterValue(Database database, List<SqlStatement> statementsList) throws CustomChangeException {
        if (this.defaultValue != null) {
            try {
                ParameterValue parameterValue = this.buildParameterValue(this.defaultValue, this.getParameterType(database));
                if (parameterValue != null) {
                    UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
                    statement.addNewColumnValue(parameterValue.getColumnName(), parameterValue.getValue());
                    statement.setWhereClause("parameterkey = '" + this.parameterKey + "'");
                    statementsList.add((SqlStatement)statement);
                }
            }
            catch (Exception ex) {
                throw new CustomChangeException((Throwable)ex);
            }
        }
    }

    private String getParameterType(Database database) throws CustomChangeException {
        if (StringUtils.isNotBlank((CharSequence)this.parameterType)) {
            return this.parameterType;
        }
        try {
            JdbcConnection conn = (JdbcConnection)database.getConnection();
            PreparedStatement statement = conn.prepareStatement("SELECT parametertype FROM pm_systemparameter WHERE parameterkey = ?");
            statement.setString(1, this.parameterKey);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            throw new CustomChangeException("Parameter [" + this.parameterKey + "] does not exist. You should specify parameter type while creating new parameter.");
        }
        catch (Exception ex) {
            throw new CustomChangeException((Throwable)ex);
        }
    }

    private SqlStatement[] createNew(Database database) throws CustomChangeException {
        InsertStatement statement = new InsertStatement("", "", "pm_systemparameter");
        if (!(database instanceof MSSQLDatabase)) {
            statement.addColumn(this.createSequence());
        }
        statement.addColumnValue("parameterkey", (Object)this.parameterKey);
        statement.addColumnValue("parametertype", (Object)this.parameterType);
        statement.addColumnValue("removable", (Object)Boolean.parseBoolean(this.removable));
        if (StringUtils.isNotEmpty((CharSequence)this.hidden)) {
            statement.addColumnValue("hidden", (Object)Boolean.parseBoolean(this.hidden));
        }
        try {
            this.buildParameterValue(statement);
            Integer categoryId = SystemParamUpgradeChange.getCategoryId(database, this.category);
            statement.addColumnValue("categoryid", (Object)categoryId);
        }
        catch (Exception ex) {
            throw new CustomChangeException((Throwable)ex);
        }
        return new SqlStatement[]{statement};
    }

    private void buildParameterValue(InsertStatement statement) throws Exception {
        try {
            ParameterValue parameterValue;
            if (this.isPropertyInShark(this.parameterKey)) {
                String sharkValue = this.getSharkValue(this.parameterKey);
                try {
                    parameterValue = this.buildParameterValue(sharkValue, this.parameterType);
                }
                catch (TypeException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("Value [{}] in configuration file isn't compatible with parameter [{}] of type [{}]. Saving parameter with default value [{}]", new Object[]{sharkValue, this.parameterKey, this.parameterType, this.defaultValue, e});
                    parameterValue = this.buildParameterValue(this.defaultValue, this.parameterType);
                }
            } else {
                parameterValue = this.buildParameterValue(this.defaultValue, this.parameterType);
            }
            if (parameterValue != null) {
                statement.addColumnValue(parameterValue.getColumnName(), parameterValue.getValue());
            }
        }
        catch (TypeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Cannot save default value [{}] of parameter [{}] with type [{}].", new Object[]{this.defaultValue, this.parameterKey, this.parameterType});
            throw e;
        }
    }

    private ParameterValue buildParameterValue(String value, String parameterType) throws ParseException, Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ParameterType type = ParameterType.valueOf((String)parameterType);
            switch (type) {
                case BOOLEAN: {
                    return new ParameterValue("valuebool", Boolean.parseBoolean(value));
                }
                case DATE: {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    return new ParameterValue("valuedate", format.parse(value));
                }
                case LONG: {
                    return new ParameterValue("valuelong", Long.parseLong(value));
                }
                case DOUBLE: {
                    return new ParameterValue("valueDouble", Double.parseDouble(value));
                }
                case TEXT: {
                    return new ParameterValue("valuestring", value);
                }
                case COMBOBOX: {
                    return new ParameterValue("valuestring", value);
                }
                case PASSWORD: {
                    String encryptedPassword = this.encryptText(value);
                    return new ParameterValue("valuestring", encryptedPassword);
                }
            }
            throw new TypeException("Unknown type [" + parameterType + "] of parameter [" + this.parameterKey + "]");
        }
        return null;
    }

    private Properties getConf() {
        return SystemUpgrader.getSharkConf();
    }

    public String getSharkValue(String key) {
        Properties properties = this.getConf();
        if (this.isPropertyInShark(key)) {
            String sharkValue = properties.getProperty(key);
            if (this.parameterType.equalsIgnoreCase("password")) {
                log.info("Parameter {} exists in configuration file", (Object)key);
            } else {
                log.info("Parameter {} exists in configuration file: {}", (Object)key, (Object)sharkValue);
            }
            return sharkValue;
        }
        log.info("Parameter {} doesn't exist in configuration file", (Object)key);
        return null;
    }

    public boolean isPropertyInShark(String key) {
        Properties properties = this.getConf();
        return properties.containsKey(key);
    }

    private String encryptText(String value) {
        try {
            return TextCipher.encrypt((String)value);
        }
        catch (Exception e) {
            log.error("Cannot encrypt value " + value, (Throwable)e);
            throw new EncryptingException((Throwable)e);
        }
    }

    private static Integer getCategoryId(Database database, String category) throws DatabaseException, SQLException {
        JdbcConnection conn = (JdbcConnection)database.getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT * FROM pm_systemparametercategory WHERE categorykey = ?");
        statement.setString(1, category);
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt("id");
        }
        return null;
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_systemparameter_seq"));
        return config;
    }

    private boolean checkIfExists(Database database) throws CustomChangeException {
        try {
            JdbcConnection conn = (JdbcConnection)database.getConnection();
            PreparedStatement statement = conn.prepareStatement("SELECT categoryid FROM pm_systemparameter WHERE parameterkey = ?");
            statement.setString(1, this.parameterKey);
            ResultSet resultSet = statement.executeQuery();
            return resultSet.next();
        }
        catch (Exception ex) {
            throw new CustomChangeException((Throwable)ex);
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getCategory() {
        return this.category;
    }

    public String getRemovable() {
        return this.removable;
    }

    public String getHidden() {
        return this.hidden;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setRemovable(String removable) {
        this.removable = removable;
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    class ParameterValue {
        private String columnName;
        private Object value;

        public String getColumnName() {
            return this.columnName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterValue)) {
                return false;
            }
            ParameterValue other = (ParameterValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParameterValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "SystemParamUpgradeChange.ParameterValue(columnName=" + this.getColumnName() + ", value=" + this.getValue() + ")";
        }

        @ConstructorProperties(value={"columnName", "value"})
        public ParameterValue(String columnName, Object value) {
            this.columnName = columnName;
            this.value = value;
        }
    }
}

