/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.plugin.dashboard.gadget.GadgetDefinition;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.dashboard.internal.DashboardGadget;
import com.suncode.pwfl.dashboard.internal.DashboardGadgetProperty;
import com.suncode.pwfl.dashboard.internal.UserDashboard;
import com.suncode.pwfl.dashboard.internal.gadget.SystemGadgetDefinition;
import com.suncode.pwfl.dashboard.internal.gadget.favourites.FavouritesGadgetGenerator;
import com.suncode.pwfl.dashboard.persistence.DashboardDao;
import com.suncode.pwfl.dashboard.persistence.DefaultDashboardDao;
import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.FavouritesService;
import com.suncode.pwfl.favourites.FavouritesSet;
import com.suncode.pwfl.favourites.support.model.DisplayNameMode;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.DivanteColor;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;

public class RewriteUserPanelToFavouritesChange
implements CustomTaskChange {
    private final FavouritesService favouritesService = (FavouritesService)SpringContext.getBean(FavouritesService.class);
    private final DashboardDao dashboardDao = (DashboardDao)SpringContext.getBean(DashboardDao.class);
    private final DefaultDashboardDao defaultDashboardDao = (DefaultDashboardDao)SpringContext.getBean(DefaultDashboardDao.class);
    private final UserFinder userFinder = (UserFinder)SpringContext.getBean(UserFinder.class);
    private final FavouritesGadgetGenerator favouritesGadgetGenerator = (FavouritesGadgetGenerator)SpringContext.getBean(FavouritesGadgetGenerator.class);
    private final MessageHelperBean messageHelperBean = (MessageHelperBean)SpringContext.getBean(MessageHelperBean.class);
    private final UserSettingsService userSettingsService = (UserSettingsService)SpringContext.getBean(UserSettingsService.class);
    private PreparedStatement parametersQuery;

    public void execute(Database database) {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        this.parametersQuery = connection.prepareStatement("SELECT * from pm_operation_panel_parameters WHERE operation_panel_id = ? ORDER BY position");
        List<OperationPanel> panels = this.getPanels(connection);
        for (OperationPanel panel : panels) {
            List<OperationPanelParameter> parameters = this.getParameters(panel);
            if (parameters.isEmpty()) continue;
            TransactionWrapper.get().doInHibernateTransaction(session -> {
                User user = this.userFinder.findByUserName(panel.getUserId(), new String[0]);
                if (user == null) {
                    return;
                }
                Locale locale = this.userSettingsService.getUserLocale(user.getUserName());
                FavouritesSet favouritesSet = this.createFavouritesSet(panel, parameters, locale);
                UserDashboard userDashboard = this.createDashboard(user, favouritesSet, locale);
                String defaultView = this.userSettingsService.getSetting(user.getUserName(), UserSettingsService.UserSetting.DEFAULT_VIEW);
                if (defaultView != null && defaultView.equals("operationPanel")) {
                    this.userSettingsService.setUserSetting(user, UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), "dashboard");
                    this.defaultDashboardDao.setDefaultUserDashboardForUser(user, userDashboard);
                }
            });
        }
        this.deleteRemainingDefaultViews(connection);
    }

    private List<OperationPanel> getPanels(JdbcConnection connection) throws SQLException, DatabaseException {
        PreparedStatement panelsQuery = connection.prepareStatement("SELECT * from pm_operation_panel");
        ArrayList<OperationPanel> panels = new ArrayList<OperationPanel>();
        try (ResultSet resultSet = panelsQuery.executeQuery();){
            while (resultSet.next()) {
                OperationPanel panel = OperationPanel.builder().operation_panel_id(resultSet.getLong("operation_panel_id")).name(resultSet.getString("name")).description(resultSet.getString("description")).userId(resultSet.getString("userId")).build();
                panels.add(panel);
            }
        }
        return panels;
    }

    private List<OperationPanelParameter> getParameters(OperationPanel panel) throws SQLException {
        this.parametersQuery.setLong(1, panel.getOperation_panel_id());
        ArrayList<OperationPanelParameter> parameters = new ArrayList<OperationPanelParameter>();
        try (ResultSet resultSet = this.parametersQuery.executeQuery();){
            while (resultSet.next()) {
                OperationPanelParameter parameter = OperationPanelParameter.builder().operation_panel_parameter_id(resultSet.getLong("operation_panel_parameter_id")).name(resultSet.getString("name")).type(resultSet.getString("type")).params(resultSet.getString("params")).is_count(resultSet.getBoolean("is_count")).position(resultSet.getLong("position")).operation_panel_id(resultSet.getLong("operation_panel_id")).build();
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    private FavouritesSet createFavouritesSet(OperationPanel panel, List<OperationPanelParameter> parameters, Locale locale) {
        String panelName = StringUtils.isNotBlank((CharSequence)panel.name) ? panel.name : this.messageHelperBean.getMessage("Panel_uzytkownika", locale, new Object[0]);
        String favouritesSetName = String.format("%s - %s", panelName, panel.userId);
        FavouritesSet favouritesSet = this.favouritesService.createFavouritesSet(panel.getUserId(), favouritesSetName, panel.getDescription());
        HashSet<FavouriteElement> favouriteElements = new HashSet<FavouriteElement>();
        for (int i = 0; i < parameters.size(); ++i) {
            OperationPanelParameter parameter = parameters.get(i);
            FavouriteElement element = FavouriteElement.builder().id(null).name(parameter.getName()).type(this.convertType(parameter.getType())).counted(parameter.getIs_count().booleanValue()).parameter(parameter.getParams()).position(Integer.valueOf(i)).displayNameMode(DisplayNameMode.CUSTOM).set(favouritesSet).build();
            favouriteElements.add(element);
        }
        favouritesSet.setElements(favouriteElements);
        this.favouritesService.updateFavourites(favouritesSet);
        return favouritesSet;
    }

    private String convertType(String type) {
        return type.equals("createprocess") ? "processes" : type;
    }

    private UserDashboard createDashboard(User user, FavouritesSet favouritesSet, Locale locale) {
        String dashboardName = this.messageHelperBean.getMessage("Panel_uzytkownika", locale, new Object[0]);
        if (this.dashboardDao.findDashboardByUserAndName(user, dashboardName).isPresent()) {
            String originalName = dashboardName;
            int counter = 2;
            while (this.dashboardDao.findDashboardByUserAndName(user, dashboardName = String.format("%s (%d)", originalName, counter++)).isPresent()) {
            }
        }
        UserDashboard dashboard = new UserDashboard();
        dashboard.setName(dashboardName);
        dashboard.setDescription(null);
        dashboard.setOwner(user);
        dashboard.setCreationDate(new Date());
        dashboard.setAbbreviation(null);
        dashboard.setColor(DivanteColor.BLUE.getCode());
        SystemGadgetDefinition definition = this.favouritesGadgetGenerator.generate();
        DashboardGadget dashboardGadget = new DashboardGadget((GadgetDefinition)definition);
        dashboardGadget.setDashboard(dashboard);
        dashboardGadget.getLayout().setWidth(Integer.valueOf(24));
        DashboardGadgetProperty dashboardGadgetProperty = new DashboardGadgetProperty("set", favouritesSet.getId().toString(), dashboardGadget);
        dashboardGadget.getPersistedProperties().put(dashboardGadgetProperty.getName(), dashboardGadgetProperty);
        dashboard.getDashboardGadgets().add(dashboardGadget);
        this.dashboardDao.save((Object)dashboard);
        return dashboard;
    }

    private void deleteRemainingDefaultViews(JdbcConnection connection) throws DatabaseException, SQLException {
        PreparedStatement deleteRemainingDefaultViewsQuery = connection.prepareStatement("DELETE FROM pm_userdata WHERE userfieldname = 'defaultView' AND userfieldvalue = 'operationPanel'");
        deleteRemainingDefaultViewsQuery.executeUpdate();
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    private static class OperationPanel {
        private Long operation_panel_id;
        private String name;
        private String description;
        private String userId;

        public static OperationPanelBuilder builder() {
            return new OperationPanelBuilder();
        }

        public Long getOperation_panel_id() {
            return this.operation_panel_id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setOperation_panel_id(Long operation_panel_id) {
            this.operation_panel_id = operation_panel_id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public OperationPanel() {
        }

        @ConstructorProperties(value={"operation_panel_id", "name", "description", "userId"})
        public OperationPanel(Long operation_panel_id, String name, String description, String userId) {
            this.operation_panel_id = operation_panel_id;
            this.name = name;
            this.description = description;
            this.userId = userId;
        }

        public static class OperationPanelBuilder {
            private Long operation_panel_id;
            private String name;
            private String description;
            private String userId;

            OperationPanelBuilder() {
            }

            public OperationPanelBuilder operation_panel_id(Long operation_panel_id) {
                this.operation_panel_id = operation_panel_id;
                return this;
            }

            public OperationPanelBuilder name(String name) {
                this.name = name;
                return this;
            }

            public OperationPanelBuilder description(String description) {
                this.description = description;
                return this;
            }

            public OperationPanelBuilder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public OperationPanel build() {
                return new OperationPanel(this.operation_panel_id, this.name, this.description, this.userId);
            }

            public String toString() {
                return "RewriteUserPanelToFavouritesChange.OperationPanel.OperationPanelBuilder(operation_panel_id=" + this.operation_panel_id + ", name=" + this.name + ", description=" + this.description + ", userId=" + this.userId + ")";
            }
        }
    }

    private static class OperationPanelParameter {
        private Long operation_panel_parameter_id;
        private String name;
        private String type;
        private String params;
        private Boolean is_count;
        private Long position;
        private Long operation_panel_id;

        public static OperationPanelParameterBuilder builder() {
            return new OperationPanelParameterBuilder();
        }

        public Long getOperation_panel_parameter_id() {
            return this.operation_panel_parameter_id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getParams() {
            return this.params;
        }

        public Boolean getIs_count() {
            return this.is_count;
        }

        public Long getPosition() {
            return this.position;
        }

        public Long getOperation_panel_id() {
            return this.operation_panel_id;
        }

        public void setOperation_panel_parameter_id(Long operation_panel_parameter_id) {
            this.operation_panel_parameter_id = operation_panel_parameter_id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public void setIs_count(Boolean is_count) {
            this.is_count = is_count;
        }

        public void setPosition(Long position) {
            this.position = position;
        }

        public void setOperation_panel_id(Long operation_panel_id) {
            this.operation_panel_id = operation_panel_id;
        }

        public OperationPanelParameter() {
        }

        @ConstructorProperties(value={"operation_panel_parameter_id", "name", "type", "params", "is_count", "position", "operation_panel_id"})
        public OperationPanelParameter(Long operation_panel_parameter_id, String name, String type, String params, Boolean is_count, Long position, Long operation_panel_id) {
            this.operation_panel_parameter_id = operation_panel_parameter_id;
            this.name = name;
            this.type = type;
            this.params = params;
            this.is_count = is_count;
            this.position = position;
            this.operation_panel_id = operation_panel_id;
        }

        public static class OperationPanelParameterBuilder {
            private Long operation_panel_parameter_id;
            private String name;
            private String type;
            private String params;
            private Boolean is_count;
            private Long position;
            private Long operation_panel_id;

            OperationPanelParameterBuilder() {
            }

            public OperationPanelParameterBuilder operation_panel_parameter_id(Long operation_panel_parameter_id) {
                this.operation_panel_parameter_id = operation_panel_parameter_id;
                return this;
            }

            public OperationPanelParameterBuilder name(String name) {
                this.name = name;
                return this;
            }

            public OperationPanelParameterBuilder type(String type) {
                this.type = type;
                return this;
            }

            public OperationPanelParameterBuilder params(String params) {
                this.params = params;
                return this;
            }

            public OperationPanelParameterBuilder is_count(Boolean is_count) {
                this.is_count = is_count;
                return this;
            }

            public OperationPanelParameterBuilder position(Long position) {
                this.position = position;
                return this;
            }

            public OperationPanelParameterBuilder operation_panel_id(Long operation_panel_id) {
                this.operation_panel_id = operation_panel_id;
                return this;
            }

            public OperationPanelParameter build() {
                return new OperationPanelParameter(this.operation_panel_parameter_id, this.name, this.type, this.params, this.is_count, this.position, this.operation_panel_id);
            }

            public String toString() {
                return "RewriteUserPanelToFavouritesChange.OperationPanelParameter.OperationPanelParameterBuilder(operation_panel_parameter_id=" + this.operation_panel_parameter_id + ", name=" + this.name + ", type=" + this.type + ", params=" + this.params + ", is_count=" + this.is_count + ", position=" + this.position + ", operation_panel_id=" + this.operation_panel_id + ")";
            }
        }
    }
}

