/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.views.change;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.suncode.pwfl.changes.views.builder.SearchFormModelBuilder;
import com.suncode.pwfl.changes.views.model.ExtrasSearchModelDto;
import com.suncode.pwfl.changes.views.model.SearchFormModelDto;
import com.suncode.pwfl.changes.views.variables.AdvanceVariableForm;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertViewsVariablesToSearchFormModelChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(ConvertViewsVariablesToSearchFormModelChange.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        String getViewIdsQuery = "SELECT id FROM pm_usersearchviews WHERE source != 'SQLQuery'";
        PreparedStatement viewIds = connection.prepareStatement(getViewIdsQuery);
        ResultSet fetchedViewIds = viewIds.executeQuery();
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        while (fetchedViewIds.next()) {
            int viewId = fetchedViewIds.getInt("id");
            try {
                RawSqlStatement statement = this.generateUpdateStatement(connection, viewId);
                statements.add(statement);
            }
            catch (Exception e) {
                log.warn(String.format("Exception occurred on converting view [id=%d] to search form model", viewId), (Throwable)e);
            }
        }
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateUpdateStatement(JdbcConnection connection, int viewId) throws SQLException, DatabaseException, JsonProcessingException {
        String getViewQuery = String.format("SELECT * FROM pm_advancesearchvariables WHERE viewid = '%s' ORDER BY id", viewId);
        PreparedStatement view = connection.prepareStatement(getViewQuery);
        ResultSet fetchedView = view.executeQuery();
        ArrayList<AdvanceVariableForm> viewVariables = new ArrayList<AdvanceVariableForm>();
        AdvanceVariableForm[] viewExtras = new AdvanceVariableForm[2];
        int extrasIndex = 0;
        while (fetchedView.next()) {
            AdvanceVariableForm advanceVariableForm = this.buildAdvanceSearchForm(fetchedView);
            if (advanceVariableForm.getName() != null && advanceVariableForm.getName().startsWith("extra-")) {
                viewExtras[extrasIndex] = advanceVariableForm;
                ++extrasIndex;
                continue;
            }
            viewVariables.add(advanceVariableForm);
        }
        SearchFormModelBuilder searchFormModelBuilder = new SearchFormModelBuilder();
        SearchFormModelDto searchFormModelDto = searchFormModelBuilder.buildSearchFormModel((AdvanceVariableForm[])viewVariables.toArray(AdvanceVariableForm[]::new));
        ExtrasSearchModelDto extrasSearchModelDto = searchFormModelBuilder.buildExtrasSearchModelDto(viewExtras);
        searchFormModelDto.setExtrasSearchModel(extrasSearchModelDto);
        String searchFormModel = new ObjectMapper().writer().writeValueAsString((Object)searchFormModelDto);
        return new RawSqlStatement(this.getStatement(connection, searchFormModel, viewId));
    }

    private String getStatement(JdbcConnection connection, String searchFormModel, int viewId) throws DatabaseException {
        return connection.getDatabaseProductName().equalsIgnoreCase("Oracle") ? this.getOracleUpdateStatement(searchFormModel, viewId) : this.getUpdateStatement(searchFormModel, viewId);
    }

    private String getUpdateStatement(String searchFormModel, int viewId) {
        return "UPDATE pm_usersearchviews SET searchformmodel = '" + searchFormModel + "' where id = " + viewId;
    }

    private String getOracleUpdateStatement(String searchFormModel, int viewId) {
        byte[] searchFormModelBytes = searchFormModel.getBytes(StandardCharsets.UTF_8);
        List<Byte> list = IntStream.range(0, searchFormModelBytes.length).mapToObj(i -> searchFormModelBytes[i]).toList();
        int chunkSize = 4000;
        List searchFormModelChunks = Lists.partition(list, (int)chunkSize);
        StringBuilder updateQuery = new StringBuilder("UPDATE pm_usersearchviews SET searchformmodel = ( ");
        for (int i2 = 0; i2 < searchFormModelChunks.size(); ++i2) {
            Object chunkPart = "";
            if (i2 != 0) {
                chunkPart = (String)chunkPart + " || ";
            }
            chunkPart = (String)chunkPart + " to_clob( '" + new String(Bytes.toArray((Collection)((Collection)searchFormModelChunks.get(i2))), StandardCharsets.UTF_8) + "') ";
            updateQuery.append((String)chunkPart);
        }
        updateQuery.append(") where id = ").append(viewId);
        return updateQuery.toString();
    }

    private AdvanceVariableForm buildAdvanceSearchForm(ResultSet fetchedView) {
        AdvanceVariableForm advanceVariableForm = new AdvanceVariableForm();
        advanceVariableForm.setActive(fetchedView.getString("active"));
        advanceVariableForm.setName(fetchedView.getString("name"));
        advanceVariableForm.setSearchMode(fetchedView.getString("searchmode"));
        advanceVariableForm.setPosition(fetchedView.getString("position"));
        advanceVariableForm.setValue(fetchedView.getString("value"));
        advanceVariableForm.setValue2(fetchedView.getString("value2"));
        advanceVariableForm.setDisableFilter(fetchedView.getString("disablefilter"));
        advanceVariableForm.setShowFilter(fetchedView.getString("showfilter"));
        advanceVariableForm.setSortType(fetchedView.getString("sorttype"));
        advanceVariableForm.setUpperCase(fetchedView.getString("uppercase"));
        return advanceVariableForm;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

