/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.processRights;

import com.plusmpm.database.UserSearchViewProtectionTable;
import com.plusmpm.database.authorization.Right;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.authorization.RightsManager;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.changes.processRights.SharedViewResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.dao.advanceSearchVariable.AdvanceSearchVariableDao;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class AddProcessDashboardAccessRights
implements CustomTaskChange {
    private final SessionFactory sessionFactory = (SessionFactory)SpringContext.getBean(SessionFactory.class);
    private final UserService userService = (UserService)SpringContext.getBean(UserService.class);

    public void execute(Database database) throws CustomChangeException {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            Map<Long, Set<Resource>> sharedViews = this.findSharedViews();
            this.findCreateOrViewProcessRightsForGroups().forEach(right -> this.addProcessDashboardAccessRightForGroup(session, (Right)right));
            sharedViews.entrySet().stream().forEach(entry -> {
                Set<String> processDefIdsUsedInView = this.getProcessDefIdsUsedInView((Long)entry.getKey());
                processDefIdsUsedInView.forEach(processDefId -> ((Set)entry.getValue()).forEach(resource -> this.addProcessDashboardAccessRightForGroup(session, (String)processDefId, (Resource)resource)));
            });
            Set groupIdsWithProcessDashboardAccessRight = this.findProcessDashboardAccessRightsForGroups().stream().map(Right::getResourceId).collect(Collectors.toSet());
            this.findCreateOrViewProcessRightsForUsers().forEach(right -> this.addProcessDashboardAccessRightForUser(session, (Right)right, groupIdsWithProcessDashboardAccessRight));
            sharedViews.entrySet().stream().forEach(entry -> {
                Set<String> processDefIdsUsedInView = this.getProcessDefIdsUsedInView((Long)entry.getKey());
                processDefIdsUsedInView.forEach(processDefId -> ((Set)entry.getValue()).forEach(resource -> this.addProcessDashboardAccessRightForUser(session, (String)processDefId, (Resource)resource, groupIdsWithProcessDashboardAccessRight)));
            });
        });
    }

    private List<Right> findCreateOrViewProcessRightsForGroups() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)true));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        SimpleExpression createCondition = Restrictions.like((String)"level", (String)"system.workflow.processes.create.", (MatchMode)MatchMode.ANYWHERE);
        SimpleExpression viewCondition = Restrictions.like((String)"level", (String)"system.workflow.processes.view.", (MatchMode)MatchMode.ANYWHERE);
        detachedCriteria.add((Criterion)Restrictions.or((Criterion)createCondition, (Criterion)viewCondition));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private List<Right> findCreateOrViewProcessRightsForUsers() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)false));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        SimpleExpression createCondition = Restrictions.like((String)"level", (String)"system.workflow.processes.create.", (MatchMode)MatchMode.ANYWHERE);
        SimpleExpression viewCondition = Restrictions.like((String)"level", (String)"system.workflow.processes.view.", (MatchMode)MatchMode.ANYWHERE);
        detachedCriteria.add((Criterion)Restrictions.or((Criterion)createCondition, (Criterion)viewCondition));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private Map<Long, Set<Resource>> findSharedViews() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(UserSearchViewProtectionTable.class, (String)"share");
        detachedCriteria.createAlias("share.userSearchViewTable", "userSearchViewTable", JoinType.INNER_JOIN).setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"share.userSearchViewTable.id"), "viewId").add((Projection)Projections.property((String)"share.shareUserId"), "resourceId").add((Projection)Projections.property((String)"share.isGroup"), "isGroup")).add((Criterion)Restrictions.eq((String)"userSearchViewTable.source", (Object)"advanceSearch")).setResultTransformer(Transformers.aliasToBean(SharedViewResult.class));
        List sharedViewResults = detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
        HashMap<Long, Set<Resource>> sharedViewsMap = new HashMap<Long, Set<Resource>>();
        sharedViewResults.forEach(sharedViewResult -> {
            Resource resourceToAdd = new Resource(sharedViewResult.getResourceId(), Boolean.parseBoolean(sharedViewResult.getIsGroup()));
            sharedViewsMap.computeIfAbsent(sharedViewResult.getViewId(), k -> new HashSet()).add(resourceToAdd);
        });
        return sharedViewsMap;
    }

    private Set<String> getProcessDefIdsUsedInView(Long viewId) {
        AdvanceSearchVariableDao advanceSearchVariableDao = (AdvanceSearchVariableDao)SpringContext.getBean(AdvanceSearchVariableDao.class);
        String processDefinitionIdForView = advanceSearchVariableDao.getProcessDefinitionIdForView(viewId);
        if (StringUtils.isNotBlank((CharSequence)processDefinitionIdForView)) {
            return Set.of(processDefinitionIdForView);
        }
        String processTypesForView = advanceSearchVariableDao.getProcessTypeForView(viewId);
        if (StringUtils.isNotBlank((CharSequence)processTypesForView)) {
            return Arrays.stream(processTypesForView.split(";")).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private void addProcessDashboardAccessRightForGroup(Session session, Right right) {
        boolean rightAlreadyExists;
        String processVisibilityLevel = right.getLevel().replace("processes.view.", "processes.processdashboard.").replace("processes.create.", "processes.processdashboard.");
        boolean bl = rightAlreadyExists = RightsManager.getRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel) != null;
        if (!rightAlreadyExists) {
            RightsManager.addRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel, (Byte)right.getType());
        }
    }

    private void addProcessDashboardAccessRightForUser(Session session, Right right, Set<String> groupIdsWithProcessDashboardAccessRight) {
        String processVisibilityLevel = right.getLevel().replace("processes.view.", "processes.processdashboard.").replace("processes.create.", "processes.processdashboard.");
        boolean rightAlreadyExists = RightsManager.getRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel) != null;
        boolean rightAlreadyExistsForAnyUserGroup = this.doesRightAlreadyExistForAnyUserGroup(right.getResourceId(), groupIdsWithProcessDashboardAccessRight);
        if (!rightAlreadyExists && !rightAlreadyExistsForAnyUserGroup) {
            RightsManager.addRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel, (Byte)right.getType());
        }
    }

    private void addProcessDashboardAccessRightForGroup(Session session, String processDefId, Resource resource) {
        boolean rightAlreadyExists;
        if (!resource.isGroup) {
            return;
        }
        String rightLevel = RightTreeBuilder.builder().system().workflow().processes().processDashboard().custom((Object)processDefId).build();
        boolean bl = rightAlreadyExists = RightsManager.getRight((Session)session, (String)resource.resourceId(), (boolean)resource.isGroup(), (String)rightLevel) != null;
        if (!rightAlreadyExists) {
            RightsManager.addRight((Session)session, (String)resource.resourceId(), (boolean)resource.isGroup(), (String)rightLevel, (Byte)0);
        }
    }

    private List<Right> findProcessDashboardAccessRightsForGroups() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)true));
        detachedCriteria.add((Criterion)Restrictions.like((String)"level", (String)".processdashboard.", (MatchMode)MatchMode.ANYWHERE));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private void addProcessDashboardAccessRightForUser(Session session, String processDefId, Resource resource, Set<String> groupIdsWithProcessDashboardAccessRight) {
        if (resource.isGroup) {
            return;
        }
        String rightLevel = RightTreeBuilder.builder().system().workflow().processes().processDashboard().custom((Object)processDefId).build();
        boolean rightAlreadyExists = RightsManager.getRight((Session)session, (String)resource.resourceId(), (boolean)resource.isGroup(), (String)rightLevel) != null;
        boolean rightAlreadyExistsForAnyUserGroup = this.doesRightAlreadyExistForAnyUserGroup(resource.resourceId, groupIdsWithProcessDashboardAccessRight);
        if (!rightAlreadyExists && !rightAlreadyExistsForAnyUserGroup) {
            RightsManager.addRight((Session)session, (String)resource.resourceId(), (boolean)resource.isGroup(), (String)rightLevel, (Byte)0);
        }
    }

    private boolean doesRightAlreadyExistForAnyUserGroup(String userId, Set<String> groupIdsWithProcessDashboardAccessRight) {
        User user = this.userService.getUser(userId, new String[]{"groups"});
        if (user == null) {
            return false;
        }
        return user.getGroups().stream().map(UserGroup::getName).anyMatch(groupIdsWithProcessDashboardAccessRight::contains);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    private record Resource(String resourceId, boolean isGroup) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            return this.isGroup == resource.isGroup && Objects.equals(this.resourceId, resource.resourceId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.resourceId, this.isGroup);
        }
    }
}

