/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade.lock;

import com.suncode.pwfl.upgrade.SystemUpgraderType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Locale;
import javax.sql.DataSource;

public class SimpleUpgradeLock {
    private static final String TABLE_NAME = "db_upgrade_lock";
    private static final long POLL_INTERVAL_MS = Duration.ofSeconds(5L).toMillis();
    private final DataSource dataSource;

    public SimpleUpgradeLock(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireOrWaitThenSkip(SystemUpgraderType upgraderType) {
        try (Connection connection = this.dataSource.getConnection();){
            this.ensureTableAndRow(connection, upgraderType);
            if (this.tryAcquire(connection, upgraderType)) {
                boolean bl2 = true;
                return bl2;
            }
            while (this.isLocked(connection, upgraderType)) {
                try {
                    Thread.sleep(POLL_INTERVAL_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to acquire or wait for db_upgrade_lock", e);
        }
    }

    public void release(SystemUpgraderType upgraderType) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement("UPDATE db_upgrade_lock SET lock_flag=0 WHERE upgrader_type=?");){
            ps.setString(1, upgraderType.name());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to release db_upgrade_lock", e);
        }
    }

    private boolean tryAcquire(Connection connection, SystemUpgraderType upgraderType) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("UPDATE db_upgrade_lock SET lock_flag=1 WHERE upgrader_type=? AND lock_flag=0");){
            ps.setString(1, upgraderType.name());
            boolean bl = ps.executeUpdate() == 1;
            return bl;
        }
    }

    private boolean isLocked(Connection connection, SystemUpgraderType upgraderType) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("SELECT lock_flag FROM db_upgrade_lock WHERE upgrader_type=?");){
            boolean bl;
            block16: {
                ResultSet rs;
                block14: {
                    boolean bl2;
                    block15: {
                        ps.setString(1, upgraderType.name());
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            boolean bl3 = bl2 = rs.getInt(1) != 0;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block16;
                rs.close();
            }
            return bl;
        }
    }

    private void ensureTableAndRow(Connection connection, SystemUpgraderType upgraderType) throws SQLException {
        if (!this.tableExists(connection)) {
            this.createTable(connection);
        }
        this.ensureRowExists(connection, upgraderType);
    }

    private boolean tableExists(Connection connection) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        String upper = TABLE_NAME.toUpperCase(Locale.ROOT);
        try (ResultSet rs = meta.getTables(null, null, upper, null);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        rs = meta.getTables(null, null, TABLE_NAME, null);
        try {
            boolean bl = rs.next();
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void createTable(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            st.execute("CREATE TABLE db_upgrade_lock (upgrader_type VARCHAR(64) PRIMARY KEY, lock_flag INTEGER NOT NULL)");
        }
    }

    private void ensureRowExists(Connection connection, SystemUpgraderType upgraderType) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("SELECT upgrader_type FROM db_upgrade_lock WHERE upgrader_type=?");){
            ps.setString(1, upgraderType.name());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    return;
                }
            }
        }
        try (PreparedStatement ins = connection.prepareStatement("INSERT INTO db_upgrade_lock (upgrader_type, lock_flag) VALUES (?, 0)");){
            ins.setString(1, upgraderType.name());
            ins.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

