/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade;

import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.pwfl.upgrade.SystemUpgraderType;
import com.suncode.pwfl.upgrade.lock.SimpleUpgradeLock;
import com.suncode.upgrader.Upgrader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SystemUpgrader {
    private static final Logger log = LoggerFactory.getLogger(SystemUpgrader.class);
    private static Properties sharkConf;

    public void upgradePreInitialize() {
        this.upgrade(SystemUpgraderType.PRE_INITIALIZE);
    }

    public void upgradePostInitialize() {
        this.upgrade(SystemUpgraderType.POST_INITIALIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade(SystemUpgraderType upgraderType) {
        String changeFilePath = upgraderType.getChangeFilePath();
        log.info("Starting upgrade from file " + changeFilePath);
        SimpleUpgradeLock lock = new SimpleUpgradeLock(DataSourceFactory.getDataSource());
        boolean acquired = lock.acquireOrWaitThenSkip(upgraderType);
        if (!acquired) {
            log.info("Another node performed upgrade. Skipping '{}' and continuing startup.", (Object)changeFilePath);
            return;
        }
        try {
            DefaultResourceLoader rl = new DefaultResourceLoader(this.getClass().getClassLoader());
            Upgrader upgrader = Upgrader.create().dataSource(DataSourceFactory.getDataSource()).project("plusworkflow").changeFile(changeFilePath).resourceLoader((ResourceLoader)rl).build();
            upgrader.setRequiredDbVersion(false);
            upgrader.upgrade();
            log.info("System upgrade from file " + changeFilePath + " finished.");
        }
        finally {
            lock.release(upgraderType);
        }
    }

    public static Properties getSharkConf() {
        return sharkConf;
    }

    public static void setSharkConf(Properties sharkConf) {
        SystemUpgrader.sharkConf = sharkConf;
    }
}

