/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusableIndexesChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(UnusableIndexesChange.class);
    private String tableName;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        List<String> unusableIndexes = this.getOracleUnusableIndexesNames(this.tableName, (JdbcConnection)database.getConnection());
        log.info("Rebuilding indexes");
        Stream<RawSqlStatement> statements = unusableIndexes.stream().map(indexName -> new RawSqlStatement("ALTER INDEX " + indexName + " REBUILD"));
        return (SqlStatement[])statements.toArray(RawSqlStatement[]::new);
    }

    private List<String> getOracleUnusableIndexesNames(String tableName, JdbcConnection connection) throws SQLException, DatabaseException {
        String oracleQuery = "SELECT index_name FROM user_indexes WHERE table_name = '" + tableName + "' and status = 'UNUSABLE'";
        PreparedStatement statement = connection.prepareStatement(oracleQuery);
        ResultSet resultSet = statement.executeQuery();
        ArrayList<String> result = new ArrayList<String>();
        while (resultSet.next()) {
            result.add(resultSet.getString("index_name"));
        }
        return result;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

