/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.views.change;

import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.SearchMode;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.dao.advanceSearchVariable.AdvanceSearchVariableDao;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class RestoreViewVariablesChange
implements CustomTaskChange {
    private static final String viewsQuery = "select distinct advt.viewid from AdvanceSearchVariableTable advt WHERE advt.viewid NOT IN (SELECT advt1.viewid FROM AdvanceSearchVariableTable advt1 WHERE advt1.name = 'procDefId')";

    public void execute(Database database) throws CustomChangeException {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            List viewIds = session.createQuery(viewsQuery).list();
            AdvanceSearchVariableDao advanceSearchVariableDao = (AdvanceSearchVariableDao)SpringContext.getBean(AdvanceSearchVariableDao.class);
            for (String viewId : viewIds) {
                AdvanceSearchVariableTable variable = AdvanceSearchVariableTable.builder().viewid(viewId).name("procDefId").searchMode(SearchMode.SINGLE).build();
                advanceSearchVariableDao.save((Object)variable);
            }
        });
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

