/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateNotificationDefsTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateNotificationDefsTranslations.class);
    private Map<Long, String> notificationDefsNames = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_notificationdef_tr";
        this.sequenceName = "pm_notificationdef_tr_id_seq";
        this.entityTableName = "pm_notificationdef";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, subject as name FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.notificationDefsNames.put(resultSet.getLong("id"), resultSet.getString("name"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.notificationDefsNames, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            InsertStatement insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"SUBJECT");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getNotificationDefsNames() {
        return this.notificationDefsNames;
    }

    public void setNotificationDefsNames(Map<Long, String> notificationDefsNames) {
        this.notificationDefsNames = notificationDefsNames;
    }
}

