/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.processRights;

import com.plusmpm.database.authorization.Right;
import com.plusmpm.database.authorization.RightsManager;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class CopyProcessDashboardAccessRightToProcessVisibilityRight
implements CustomTaskChange {
    private final SessionFactory sessionFactory = (SessionFactory)SpringContext.getBean(SessionFactory.class);
    private final UserService userService = (UserService)SpringContext.getBean(UserService.class);

    public void execute(Database database) throws CustomChangeException {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            this.findProcessDashboardsRightsForGroups().forEach(right -> {
                boolean rightAlreadyExists;
                String processVisibilityLevel = right.getLevel().replace("processes.processdashboard.", "processes.processvisibility.");
                boolean bl = rightAlreadyExists = RightsManager.getRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel) != null;
                if (!rightAlreadyExists) {
                    RightsManager.addRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel, (Byte)right.getType());
                }
            });
            Set groupIdsWithProcessVisibilityRight = this.findProcessVisibilityRightsForGroups().stream().map(right -> right.getResourceId()).collect(Collectors.toSet());
            this.findProcessDashboardsRightsForUsers().forEach(right -> {
                String processVisibilityLevel = right.getLevel().replace("processes.processdashboard.", "processes.processvisibility.");
                boolean rightAlreadyExists = RightsManager.getRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel) != null;
                boolean rightAlreadyExistsForAnyUserGroup = this.doesRightAlreadyExistForAnyUserGroup(right.getResourceId(), groupIdsWithProcessVisibilityRight);
                if (!rightAlreadyExists && !rightAlreadyExistsForAnyUserGroup) {
                    RightsManager.addRight((Session)session, (String)right.getResourceId(), (boolean)right.getGroup(), (String)processVisibilityLevel, (Byte)right.getType());
                }
            });
        });
    }

    private List<Right> findProcessDashboardsRightsForGroups() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)true));
        detachedCriteria.add((Criterion)Restrictions.like((String)"level", (String)".processdashboard.", (MatchMode)MatchMode.ANYWHERE));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private List<Right> findProcessVisibilityRightsForGroups() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)true));
        detachedCriteria.add((Criterion)Restrictions.like((String)"level", (String)".processvisibility.", (MatchMode)MatchMode.ANYWHERE));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private List<Right> findProcessDashboardsRightsForUsers() {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Right.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        detachedCriteria.add((Criterion)Restrictions.eq((String)"group", (Object)false));
        detachedCriteria.add((Criterion)Restrictions.like((String)"level", (String)".processdashboard.", (MatchMode)MatchMode.ANYWHERE));
        return detachedCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private boolean doesRightAlreadyExistForAnyUserGroup(String userId, Set<String> groupIdsWithProcessDashboardRight) {
        User user = this.userService.getUser(userId, new String[]{"groups"});
        if (user == null) {
            return false;
        }
        return user.getGroups().stream().map(UserGroup::getName).anyMatch(groupIdsWithProcessDashboardRight::contains);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

