/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.parameters.extended;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.MssqlImportedDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;

public class HideParametersUpgradeChange
implements CustomSqlChange {
    private static List<DefinedSystemParameter> parametersToIgnore = new LinkedList<DefinedSystemParameter>();

    public void setUp() throws SetupException {
        parametersToIgnore = Arrays.asList(DefinedSystemParameter.SYSTEM_TYPE, DefinedSystemParameter.CAPTCHA_LOGIN_ATTEMPTS, DefinedSystemParameter.CUSTOM_HOLIDAYS);
    }

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        return (SqlStatement[])Stream.of(DefinedSystemParameter.values()).filter(parameter -> !parametersToIgnore.contains(parameter)).map(DefinedSystemParameter::getKey).map(key -> this.createStatement(database, (String)key)).toArray(UpdateStatement[]::new);
    }

    private UpdateStatement createStatement(Database database, String parameterKey) {
        UpdateStatement statement = new UpdateStatement("", "", "pm_systemparameter");
        if (database instanceof MSSQLDatabase || database instanceof MssqlImportedDatabase || database instanceof OracleDatabase || database instanceof DB2Database) {
            statement.addNewColumnValue("hidden", (Object)1);
            statement.setWhereClause("parameterkey = '" + parameterKey + "' AND removable = 0");
        } else {
            statement.addNewColumnValue("hidden", (Object)true);
            statement.setWhereClause("parameterkey = '" + parameterKey + "' AND removable = false");
        }
        return statement;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

