/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.indexes.rename;

import com.suncode.pwfl.changes.indexes.rename.RenameOrCreateIndex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenameMSSQLIndexes
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(RenameMSSQLIndexes.class);
    private final String fileName = System.getProperty("plusworkflow.home") + "/rename-indexes-log.txt";
    private final String findOneColumnIndexNameQuery = "SELECT sys.indexes.name FROM sys.indexes JOIN sys.index_columns ON sys.indexes.object_id = sys.index_columns.object_id AND sys.indexes.index_id = sys.index_columns.index_id JOIN sys.columns ON sys.index_columns.object_id = sys.columns.object_id AND sys.index_columns.column_id = sys.columns.column_id JOIN sys.tables ON sys.indexes.object_id = sys.tables.object_id WHERE sys.tables.name = '%s' AND sys.indexes.is_hypothetical = 0 GROUP BY sys.indexes.name HAVING COUNT(*) = 1 AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.key_ordinal ELSE 0 END) = 1";
    private final String findMultiColumnIndexNameQuery = "SELECT sys.indexes.name FROM sys.indexes JOIN sys.index_columns ON sys.indexes.object_id = sys.index_columns.object_id AND sys.indexes.index_id = sys.index_columns.index_id JOIN sys.columns ON sys.index_columns.object_id = sys.columns.object_id AND sys.index_columns.column_id = sys.columns.column_id JOIN sys.tables ON sys.indexes.object_id = sys.tables.object_id WHERE sys.tables.name = '%s' AND sys.indexes.is_hypothetical = 0 GROUP BY sys.indexes.name HAVING COUNT(*) = %d ";
    private final String checkIndexColumnQueryPart = "AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.key_ordinal ELSE 0 END) = 1 ";
    private final String checkIndexColumnOrderQueryPart = "AND MAX(CASE WHEN sys.columns.name = '%1$s' THEN sys.index_columns.key_ordinal ELSE -1 END) <> -1 AND MAX(CASE WHEN sys.columns.name = '%1$s' THEN sys.index_columns.key_ordinal ELSE 0 END) < MAX(CASE WHEN sys.columns.name = '%2$s' THEN sys.index_columns.key_ordinal ELSE 0 END) AND MAX(CASE WHEN sys.columns.name = '%2$s' THEN sys.index_columns.key_ordinal ELSE -1 END) <> -1 ";
    private final String checkIndexIncludeColumnQueryPart = "AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.is_included_column ELSE 0 END) = 1 ";
    protected String tableName;
    protected List<RenameOrCreateIndex> indexes;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        if (StringUtils.isBlank((CharSequence)this.tableName) || CollectionUtils.isEmpty(this.indexes)) {
            return new SqlStatement[0];
        }
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName, true));){
            writer.write(String.format("Checking indexes for table %s", this.tableName));
            writer.newLine();
            int i = 0;
            for (RenameOrCreateIndex index : this.indexes) {
                String query = index.getColumns().size() == 1 && CollectionUtils.isEmpty(index.getIncludeColumns()) ? String.format("SELECT sys.indexes.name FROM sys.indexes JOIN sys.index_columns ON sys.indexes.object_id = sys.index_columns.object_id AND sys.indexes.index_id = sys.index_columns.index_id JOIN sys.columns ON sys.index_columns.object_id = sys.columns.object_id AND sys.index_columns.column_id = sys.columns.column_id JOIN sys.tables ON sys.indexes.object_id = sys.tables.object_id WHERE sys.tables.name = '%s' AND sys.indexes.is_hypothetical = 0 GROUP BY sys.indexes.name HAVING COUNT(*) = 1 AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.key_ordinal ELSE 0 END) = 1", this.tableName, index.getColumns().get(0)) : this.generateFindMultiColumnIndexQuery(index);
                try {
                    ResultSet resultSet = connection.prepareStatement(query).executeQuery();
                    try {
                        if (resultSet.next()) {
                            String currentIndexName = resultSet.getString("name");
                            if (!currentIndexName.equals(index.getNewName())) {
                                writer.write(String.format("Renaming index %s to %s", currentIndexName, index.getNewName()));
                                writer.newLine();
                                statements.add(this.generateRenameStatement(currentIndexName, index.getNewName()));
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)index.getCreateIndexStatement())) {
                            writer.write(String.format("Creating index %s with query: %s", index.getNewName(), index.getCreateIndexStatement()));
                            writer.newLine();
                            statements.add(new RawSqlStatement(index.getCreateIndexStatement()));
                        }
                        ++i;
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                catch (Exception e) {
                    log.error("Error fetching index {} for {} table", new Object[]{index.getNewName(), this.tableName, e});
                }
            }
            writer.write(String.format("%d/%d indexes processed", i, this.indexes.size()));
            writer.newLine();
            writer.newLine();
        }
        catch (IOException e) {
            log.error(String.format("Error on writing data to file: %s", this.fileName), (Throwable)e);
        }
        return statements.toArray(new SqlStatement[0]);
    }

    private String generateFindMultiColumnIndexQuery(RenameOrCreateIndex index) {
        List<String> columns = index.getColumns();
        List<String> includeColumns = index.getIncludeColumns();
        StringBuilder stringBuilder = new StringBuilder(String.format("SELECT sys.indexes.name FROM sys.indexes JOIN sys.index_columns ON sys.indexes.object_id = sys.index_columns.object_id AND sys.indexes.index_id = sys.index_columns.index_id JOIN sys.columns ON sys.index_columns.object_id = sys.columns.object_id AND sys.index_columns.column_id = sys.columns.column_id JOIN sys.tables ON sys.indexes.object_id = sys.tables.object_id WHERE sys.tables.name = '%s' AND sys.indexes.is_hypothetical = 0 GROUP BY sys.indexes.name HAVING COUNT(*) = %d ", this.tableName, columns.size() + includeColumns.size()));
        if (columns.size() > 1) {
            for (int i = 0; i < columns.size() - 1; ++i) {
                stringBuilder.append(String.format("AND MAX(CASE WHEN sys.columns.name = '%1$s' THEN sys.index_columns.key_ordinal ELSE -1 END) <> -1 AND MAX(CASE WHEN sys.columns.name = '%1$s' THEN sys.index_columns.key_ordinal ELSE 0 END) < MAX(CASE WHEN sys.columns.name = '%2$s' THEN sys.index_columns.key_ordinal ELSE 0 END) AND MAX(CASE WHEN sys.columns.name = '%2$s' THEN sys.index_columns.key_ordinal ELSE -1 END) <> -1 ", columns.get(i), columns.get(i + 1)));
            }
        } else {
            stringBuilder.append(String.format("AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.key_ordinal ELSE 0 END) = 1 ", columns.get(0)));
        }
        for (String includeColumn : includeColumns) {
            stringBuilder.append(String.format("AND MAX(CASE WHEN sys.columns.name = '%s' THEN sys.index_columns.is_included_column ELSE 0 END) = 1 ", includeColumn));
        }
        return stringBuilder.toString();
    }

    private RawSqlStatement generateRenameStatement(String oldName, String newName) {
        String query = String.format("EXEC sp_rename '%s.%s', '%s', 'INDEX';", this.tableName, oldName, newName);
        return new RawSqlStatement(query);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

