/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.parameters;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertStatement;
import org.apache.commons.lang3.StringUtils;

public class SystemParamComboUpgradeChange
implements CustomSqlChange {
    private static final String SEPARATOR = ";";
    private String parameterKey;
    private String deleteCurrent;
    private List<String> values;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        LinkedList<Object> statements = new LinkedList<Object>();
        try {
            Integer parameterId = SystemParamComboUpgradeChange.getParameterId(database, this.parameterKey);
            if (Boolean.valueOf(this.deleteCurrent).booleanValue()) {
                statements.add(this.deleteCurrentCombosStatement(parameterId));
            }
            List insertStatements = this.values.stream().map(comboValue -> {
                InsertStatement statement = new InsertStatement("", "", "pm_systemparametercombovalues");
                if (!(database instanceof MSSQLDatabase)) {
                    statement.addColumn(this.createSequence());
                }
                statement.addColumnValue("ownerid", (Object)parameterId);
                statement.addColumnValue("value", comboValue);
                return statement;
            }).collect(Collectors.toList());
            statements.addAll(insertStatements);
            return statements.toArray(new SqlStatement[statements.size()]);
        }
        catch (Exception ex) {
            throw new CustomChangeException((Throwable)ex);
        }
    }

    private static Integer getParameterId(Database database, String paramKey) throws DatabaseException, SQLException, CustomChangeException {
        JdbcConnection conn = (JdbcConnection)database.getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT id FROM pm_systemparameter WHERE parameterkey = ?");
        statement.setString(1, paramKey);
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt("id");
        }
        throw new CustomChangeException("No parameter with key " + paramKey);
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_combovalues_seq"));
        return config;
    }

    private SqlStatement deleteCurrentCombosStatement(Integer parameterId) {
        DeleteStatement statement = new DeleteStatement("", "", "pm_systemparametercombovalues");
        statement.setWhere("ownerid = " + parameterId);
        return statement;
    }

    public String getValues() {
        return StringUtils.join(this.values, (String)SEPARATOR);
    }

    public void setValues(String values) {
        this.values = Arrays.asList(values.split(SEPARATOR));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }

    public String getDeleteCurrent() {
        return this.deleteCurrent;
    }

    public void setDeleteCurrent(String deleteCurrent) {
        this.deleteCurrent = deleteCurrent;
    }
}

