/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.indexes;

import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.changes.indexes.dao.IndexUpgraderDao;
import com.suncode.pwfl.changes.indexes.domain.IndexUpgraderDomain;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixBooleanIndexesUpgradeChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(FixBooleanIndexesUpgradeChange.class);

    public SqlStatement[] generateStatements(Database database) {
        IndexUpgraderDao indexUpgraderDao = new IndexUpgraderDao(database, (JdbcConnection)database.getConnection());
        List booleanIndexes = indexUpgraderDao.getAll().stream().filter(index -> index.getType() == IndexType.BOOLEAN).peek(index -> log.info("Updating values for index [id={}], [name={}]", (Object)index.getId(), (Object)index.getName())).collect(Collectors.toList());
        Stream<UpdateStatement> statementStream = Stream.concat(booleanIndexes.stream().map(index -> indexUpgraderDao.generateStringValueUpdateStatement((IndexUpgraderDomain)index, Boolean.TRUE.toString(), "1")), booleanIndexes.stream().map(index -> indexUpgraderDao.generateStringValueUpdateStatement((IndexUpgraderDomain)index, Boolean.FALSE.toString(), "0")));
        return (SqlStatement[])statementStream.toArray(UpdateStatement[]::new);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

