/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade;

import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.upgrader.Upgrader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SystemUpgrader {
    private final String PRE_INITIALIZE_CHANGE_FILE = "changes/pre_initialize/pre_initialize_changes.xml";
    private final String POST_INITIALIZE_CHANGE_FILE = "changes/post_initialize/post_initialize_changes.xml";
    private Logger log = LoggerFactory.getLogger(SystemUpgrader.class);
    private static Properties sharkConf;

    public void upgradePreInitialize() {
        this.upgrade("changes/pre_initialize/pre_initialize_changes.xml");
    }

    public void upgradePostInitialize() {
        this.upgrade("changes/post_initialize/post_initialize_changes.xml");
    }

    private void upgrade(String changeFilePath) {
        this.log.info("Starting upgrade from file " + changeFilePath);
        DefaultResourceLoader rl = new DefaultResourceLoader(this.getClass().getClassLoader());
        Upgrader upgrader = Upgrader.create().dataSource(DataSourceFactory.getDataSource()).project("plusworkflow").changeFile(changeFilePath).resourceLoader((ResourceLoader)rl).build();
        upgrader.setRequiredDbVersion(false);
        upgrader.upgrade();
        this.log.info("System upgrade from file " + changeFilePath + " finished.");
    }

    public static Properties getSharkConf() {
        return sharkConf;
    }

    public static void setSharkConf(Properties sharkConf) {
        SystemUpgrader.sharkConf = sharkConf;
    }
}

