/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.changes.indexes.dao.IndexUpgraderDao;
import com.suncode.pwfl.changes.indexes.domain.IndexUpgraderDomain;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeIndexTypeConverterChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(DateTimeIndexTypeConverterChange.class);

    public void execute(Database database) {
        IndexUpgraderDao indexUpgraderDao = new IndexUpgraderDao(database, (JdbcConnection)database.getConnection());
        List<IndexUpgraderDomain> dateTimeIndexes = indexUpgraderDao.getByType(IndexType.DATETIME);
        if (CollectionUtils.isNotEmpty(dateTimeIndexes)) {
            dateTimeIndexes.forEach(index -> {
                String documentClassTable = indexUpgraderDao.getDocumentClassTableName(index.getDocumentClassId());
                String indexColumnName = indexUpgraderDao.getIndexColumnName(index.getId());
                try {
                    indexUpgraderDao.changeDatetimeToTimestampIfNecessary(indexColumnName, documentClassTable);
                }
                catch (Exception e) {
                    log.error("Error while converting datetime index {} from table {}", new Object[]{indexColumnName, documentClassTable, e});
                }
            });
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

