/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.TranslationUpgradeHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PopulateTranslations
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(PopulateTranslations.class);
    protected String tableName;
    protected String sequenceName;
    protected String entityTableName;
    protected Boolean isMSSQL = false;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        this.setVariables();
        if (this.tableName.isEmpty() || this.sequenceName.isEmpty() || this.entityTableName.isEmpty()) {
            return new SqlStatement[0];
        }
        this.isMSSQL = database instanceof MSSQLDatabase;
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        TranslationUpgradeHelper translationUpgradeHelper = TranslationUpgradeHelper.getInstance(connection);
        Map<String, Properties> localeTranslations = translationUpgradeHelper.getLocaleTranslations();
        if (localeTranslations == null || localeTranslations.isEmpty()) {
            return new SqlStatement[0];
        }
        this.loadTranslatableEntities(connection);
        InsertSetStatement insertSetStatement = new InsertSetStatement("", "", this.tableName);
        for (String locale : localeTranslations.keySet()) {
            this.generateInsertStatements(insertSetStatement, locale, localeTranslations.get(locale));
        }
        return insertSetStatement.getStatementsArray();
    }

    protected abstract void setVariables();

    protected abstract void loadTranslatableEntities(JdbcConnection var1);

    private void generateInsertStatements(InsertSetStatement insertSetStatement, String locale, Properties translations) {
        for (Map.Entry<Object, Object> translation : translations.entrySet()) {
            List<InsertStatement> insertStatements = this.getInsertStatements(locale, translation);
            for (InsertStatement statement : insertStatements) {
                insertSetStatement.addInsertStatement(statement);
            }
        }
    }

    protected abstract List<InsertStatement> getInsertStatements(String var1, Map.Entry<Object, Object> var2);

    protected List<Long> getTranslatedEntityId(Map<Long, String> map, String translatedEntityName) {
        String[] words = translatedEntityName.split("[\\s_]");
        String transformedTranslatedEntityName = Arrays.stream(words).map(word -> "\\Q" + word + "\\E").collect(Collectors.joining("_"));
        String regex = "^" + transformedTranslatedEntityName.replace("_", "[\\s_]") + "$";
        return map.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> ((String)entry.getValue()).matches(regex)).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
    }

    protected ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction(this.sequenceName));
        return config;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getEntityTableName() {
        return this.entityTableName;
    }

    public Boolean getIsMSSQL() {
        return this.isMSSQL;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setEntityTableName(String entityTableName) {
        this.entityTableName = entityTableName;
    }

    public void setIsMSSQL(Boolean isMSSQL) {
        this.isMSSQL = isMSSQL;
    }
}

