/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateDocClassIndicesTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateDocClassIndicesTranslations.class);
    private Map<Long, String> docClassIndicesNames = new HashMap<Long, String>();
    private Map<Long, String> docClassIndicesDescriptions = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_indecies_translations";
        this.sequenceName = "pm_indecies_tr_id_seq";
        this.entityTableName = "pm_indecies";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, indexname as name, indexdescription as description FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.docClassIndicesNames.put(resultSet.getLong("id"), resultSet.getString("name"));
                this.docClassIndicesDescriptions.put(resultSet.getLong("id"), resultSet.getString("description"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        InsertStatement insertStatement;
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.docClassIndicesNames, (String)translation.getKey());
        List<Long> translatedDescEntityIds = this.getTranslatedEntityId(this.docClassIndicesDescriptions, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        for (Long id : translatedDescEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"DESCRIPTION");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getDocClassIndicesNames() {
        return this.docClassIndicesNames;
    }

    public Map<Long, String> getDocClassIndicesDescriptions() {
        return this.docClassIndicesDescriptions;
    }

    public void setDocClassIndicesNames(Map<Long, String> docClassIndicesNames) {
        this.docClassIndicesNames = docClassIndicesNames;
    }

    public void setDocClassIndicesDescriptions(Map<Long, String> docClassIndicesDescriptions) {
        this.docClassIndicesDescriptions = docClassIndicesDescriptions;
    }
}

