CREATE TABLE ACTIVITIES
(
   ID varchar(100) NOT NULL,
   ACTIVITYSETDEFINITIONID varchar(90),
   ACTIVITYDEFINITIONID varchar(90) NOT NULL,
   PROCESS decimal(19,0) NOT NULL,
   THERESOURCE decimal(19,0),
   PDEFNAME varchar(200) NOT NULL,
   PROCESSID varchar(200) NOT NULL,
   RESOURCEID varchar(100),
   STATE decimal(19,0) NOT NULL,
   BLOCKACTIVITYID varchar(100),
   PERFORMER varchar(100),
   ISPERFORMERASYNCHRONOUS smallint,
   PRIORITY int,
   NAME varchar(254),
   ACTIVATED bigint NOT NULL,
   ACCEPTED bigint,
   LASTSTATETIME bigint NOT NULL,
   LIMITTIME bigint NOT NULL,
   DESCRIPTION varchar(254),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ACTIVITYDATA
(
   ACTIVITY decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUE blob(1048576),
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   ISRESULT smallint NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ACTIVITYDATABLOBS
(
   ACTIVITYDATAWOB decimal(19,0) NOT NULL,
   VARIABLEVALUE blob(1048576),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ACTIVITYDATAWOB
(
   ACTIVITY decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   ISRESULT smallint NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ACTIVITYSTATEEVENTAUDITS
(
   KEYVALUE varchar(30) NOT NULL,
   NAME varchar(50) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ACTIVITYSTATES
(
   KEYVALUE varchar(30) NOT NULL,
   NAME varchar(50) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ANDJOINTABLE
(
   PROCESS decimal(19,0) NOT NULL,
   ACTIVITYSETDEFINITIONID varchar(90),
   ACTIVITYDEFINITIONID varchar(90) NOT NULL,
   ACTIVITY decimal(19,0) NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ASSIGNMENTEVENTAUDITS
(
   UTCTIME varchar(254) NOT NULL,
   THETYPE decimal(19,0) NOT NULL,
   ACTIVITYID varchar(100) NOT NULL,
   ACTIVITYNAME varchar(254),
   PROCESSID varchar(100) NOT NULL,
   PROCESSNAME varchar(254),
   PROCESSDEFINITIONNAME varchar(200) NOT NULL,
   PROCESSDEFINITIONVERSION varchar(20) NOT NULL,
   ACTIVITYDEFINITIONID varchar(90) NOT NULL,
   ACTIVITYSETDEFINITIONID varchar(90),
   PROCESSDEFINITIONID varchar(90) NOT NULL,
   PACKAGEID varchar(90) NOT NULL,
   OLDRESOURCEUSERNAME varchar(100),
   OLDRESOURCENAME varchar(100),
   NEWRESOURCEUSERNAME varchar(100) NOT NULL,
   NEWRESOURCENAME varchar(100),
   ISACCEPTED smallint NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE ASSIGNMENTSTABLE
(
   ACTIVITY decimal(19,0) NOT NULL,
   THERESOURCE decimal(19,0) NOT NULL,
   ACTIVITYID varchar(100) NOT NULL,
   ACTIVITYPROCESSID varchar(100) NOT NULL,
   ACTIVITYPROCESSDEFNAME varchar(200) NOT NULL,
   RESOURCEID varchar(100) NOT NULL,
   ISACCEPTED smallint NOT NULL,
   ISVALID smallint NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE COUNTERS
(
   NAME varchar(100) NOT NULL,
   THE_NUMBER decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE CREATEPROCESSEVENTAUDITS
(
   UTCTIME varchar(254) NOT NULL,
   THETYPE decimal(19,0) NOT NULL,
   PROCESSID varchar(100) NOT NULL,
   PROCESSNAME varchar(254),
   PROCESSDEFINITIONNAME varchar(200) NOT NULL,
   PROCESSDEFINITIONVERSION varchar(20) NOT NULL,
   PROCESSDEFINITIONID varchar(90) NOT NULL,
   PACKAGEID varchar(90) NOT NULL,
   PACTIVITYID varchar(100),
   PPROCESSID varchar(100),
   PPROCESSNAME varchar(254),
   PPROCESSDEFINITIONNAME varchar(200),
   PPROCESSDEFINITIONVERSION varchar(20),
   PACTIVITYDEFINITIONID varchar(90),
   PACTIVITYSETDEFINITIONID varchar(90),
   PPROCESSDEFINITIONID varchar(90),
   PPACKAGEID varchar(90),
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE DATAEVENTAUDITS
(
   UTCTIME varchar(254) NOT NULL,
   THETYPE decimal(19,0) NOT NULL,
   ACTIVITYID varchar(100),
   ACTIVITYNAME varchar(254),
   PROCESSID varchar(100) NOT NULL,
   PROCESSNAME varchar(254),
   PROCESSDEFINITIONNAME varchar(200) NOT NULL,
   PROCESSDEFINITIONVERSION varchar(20) NOT NULL,
   ACTIVITYDEFINITIONID varchar(90),
   ACTIVITYSETDEFINITIONID varchar(90),
   PROCESSDEFINITIONID varchar(90) NOT NULL,
   PACKAGEID varchar(90) NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE DEADLINES
(
   PROCESS decimal(19,0) NOT NULL,
   ACTIVITY decimal(19,0) NOT NULL,
   CNT decimal(19,0) NOT NULL,
   TIMELIMIT bigint NOT NULL,
   EXCEPTIONNAME varchar(100) NOT NULL,
   ISSYNCHRONOUS smallint NOT NULL,
   ISEXECUTED smallint NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE EVENTTYPES
(
   KEYVALUE varchar(30) NOT NULL,
   NAME varchar(50) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE GROUPGROUPTABLE
(
   SUB_GID decimal(19,0) NOT NULL,
   GROUPID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE GROUPTABLE
(
   GROUPID varchar(100) NOT NULL,
   DESCRIPTION varchar(254),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE GROUPUSER
(
   USERNAME varchar(100) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE GROUPUSERPACKLEVELPARTICIPANT
(
   PARTICIPANTOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE GROUPUSERPROCLEVELPARTICIPANT
(
   PARTICIPANTOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE LOCKTABLE
(
   ENGINENAME varchar(100) NOT NULL,
   ID varchar(100) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE NEWEVENTAUDITDATA
(
   DATAEVENTAUDIT decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUE blob(1048576),
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE NEWEVENTAUDITDATABLOBS
(
   NEWEVENTAUDITDATAWOB decimal(19,0) NOT NULL,
   VARIABLEVALUE blob(1048576),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE NEWEVENTAUDITDATAWOB
(
   DATAEVENTAUDIT decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE NEXTXPDLVERSIONS
(
   XPDLID varchar(90) NOT NULL,
   NEXTVERSION varchar(20) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE NORMALUSER
(
   USERNAME varchar(100) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE OBJECTID
(
   NEXT decimal(19,0) PRIMARY KEY NOT NULL
)
;
CREATE TABLE OLDEVENTAUDITDATA
(
   DATAEVENTAUDIT decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUE blob(1048576),
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE OLDEVENTAUDITDATABLOBS
(
   OLDEVENTAUDITDATAWOB decimal(19,0) NOT NULL,
   VARIABLEVALUE blob(1048576),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE OLDEVENTAUDITDATAWOB
(
   DATAEVENTAUDIT decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELPARTICIPANT
(
   PARTICIPANT_ID varchar(90) NOT NULL,
   PACKAGEOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELXPDLAPP
(
   APPLICATION_ID varchar(90) NOT NULL,
   PACKAGEOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELXPDLAPPTAAPPDETAIL
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELXPDLAPPTAAPPDETAILUSR
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELXPDLAPPTAAPPUSER
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PACKLEVELXPDLAPPTOOLAGENTAPP
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSDATA
(
   PROCESS decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUE blob(1048576),
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSDATABLOBS
(
   PROCESSDATAWOB decimal(19,0) NOT NULL,
   VARIABLEVALUE blob(1048576),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSDATAWOB
(
   PROCESS decimal(19,0) NOT NULL,
   VARIABLEDEFINITIONID varchar(100) NOT NULL,
   VARIABLETYPE int NOT NULL,
   VARIABLEVALUEVCHAR long varchar,
   VARIABLEVALUEDBL float(53),
   VARIABLEVALUELONG bigint,
   VARIABLEVALUEDATE timestamp,
   VARIABLEVALUEBOOL smallint,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSDEFINITIONS
(
   NAME varchar(200) NOT NULL,
   PACKAGEID varchar(90) NOT NULL,
   PROCESSDEFINITIONID varchar(90) NOT NULL,
   PROCESSDEFINITIONCREATED bigint NOT NULL,
   PROCESSDEFINITIONVERSION varchar(20) NOT NULL,
   STATE int NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSES
(
   ID varchar(100) NOT NULL,
   PROCESSDEFINITION decimal(19,0) NOT NULL,
   PDEFNAME varchar(200) NOT NULL,
   ACTIVITYREQUESTERID varchar(100),
   ACTIVITYREQUESTERPROCESSID varchar(100),
   RESOURCEREQUESTERID varchar(100) NOT NULL,
   EXTERNALREQUESTERCLASSNAME varchar(254),
   STATE decimal(19,0) NOT NULL,
   PRIORITY int,
   NAME varchar(254),
   CREATED bigint NOT NULL,
   STARTED bigint,
   LASTSTATETIME bigint NOT NULL,
   LIMITTIME bigint NOT NULL,
   DESCRIPTION varchar(254),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSREQUESTERS
(
   ID varchar(100) NOT NULL,
   ACTIVITYREQUESTER decimal(19,0),
   RESOURCEREQUESTER decimal(19,0),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSSTATEEVENTAUDITS
(
   KEYVALUE varchar(30) NOT NULL,
   NAME varchar(50) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCESSSTATES
(
   KEYVALUE varchar(30) NOT NULL,
   NAME varchar(50) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELPARTICIPANT
(
   PARTICIPANT_ID varchar(90) NOT NULL,
   PROCESSOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELXPDLAPP
(
   APPLICATION_ID varchar(90) NOT NULL,
   PROCESSOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELXPDLAPPTAAPPDETAIL
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELXPDLAPPTAAPPDETAILUSR
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELXPDLAPPTAAPPUSER
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PROCLEVELXPDLAPPTOOLAGENTAPP
(
   XPDL_APPOID decimal(19,0) NOT NULL,
   TOOLAGENTOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE RESOURCESTABLE
(
   USERNAME varchar(100) NOT NULL,
   NAME varchar(100),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE STATEEVENTAUDITS
(
   UTCTIME varchar(254) NOT NULL,
   THETYPE decimal(19,0) NOT NULL,
   ACTIVITYID varchar(100),
   ACTIVITYNAME varchar(254),
   PROCESSID varchar(100) NOT NULL,
   PROCESSNAME varchar(254),
   PROCESSDEFINITIONNAME varchar(200) NOT NULL,
   PROCESSDEFINITIONVERSION varchar(20) NOT NULL,
   ACTIVITYDEFINITIONID varchar(90),
   ACTIVITYSETDEFINITIONID varchar(90),
   PROCESSDEFINITIONID varchar(90) NOT NULL,
   PACKAGEID varchar(90) NOT NULL,
   OLDPROCESSSTATE decimal(19,0),
   NEWPROCESSSTATE decimal(19,0),
   OLDACTIVITYSTATE decimal(19,0),
   NEWACTIVITYSTATE decimal(19,0),
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE TOOLAGENTAPP
(
   TOOL_AGENT_NAME varchar(250) NOT NULL,
   APP_NAME varchar(90) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE TOOLAGENTAPPDETAIL
(
   APP_MODE decimal(10,0) NOT NULL,
   TOOLAGENT_APPOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE TOOLAGENTAPPDETAILUSER
(
   TOOLAGENT_APPOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE TOOLAGENTAPPUSER
(
   TOOLAGENT_APPOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE TOOLAGENTUSER
(
   USERNAME varchar(100) NOT NULL,
   PWD varchar(100),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE USERGROUPTABLE
(
   USERID decimal(19,0) NOT NULL,
   GROUPID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE USERPACKLEVELPARTICIPANT
(
   PARTICIPANTOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE USERPROCLEVELPARTICIPANT
(
   PARTICIPANTOID decimal(19,0) NOT NULL,
   USEROID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE USERTABLE
(
   USERID varchar(100) NOT NULL,
   FIRSTNAME varchar(50),
   LASTNAME varchar(50),
   PASSWD varchar(50) NOT NULL,
   EMAIL varchar(254),
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL,
   ACTIVE smallint DEFAULT 1,
   "number" varchar(255)
)
;
CREATE TABLE XPDLAPPLICATIONPACKAGE
(
   PACKAGE_ID varchar(90) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLAPPLICATIONPROCESS
(
   PROCESS_ID varchar(90) NOT NULL,
   PACKAGEOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLDATA
(
   XPDLCONTENT blob(1048576) NOT NULL,
   XPDLCLASSCONTENT blob(1048576) NOT NULL,
   XPDL decimal(19,0) NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLHISTORY
(
   XPDLID varchar(90) NOT NULL,
   XPDLVERSION varchar(20) NOT NULL,
   XPDLCLASSVERSION bigint NOT NULL,
   XPDLUPLOADTIME timestamp NOT NULL,
   XPDLHISTORYUPLOADTIME timestamp NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLHISTORYDATA
(
   XPDLCONTENT blob(1048576) NOT NULL,
   XPDLCLASSCONTENT blob(1048576) NOT NULL,
   XPDLHISTORY decimal(19,0) NOT NULL,
   CNT decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLPARTICIPANTPACKAGE
(
   PACKAGE_ID varchar(90) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLPARTICIPANTPROCESS
(
   PROCESS_ID varchar(90) NOT NULL,
   PACKAGEOID decimal(19,0) NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE XPDLREFERENCES
(
   REFERREDXPDLID varchar(90) NOT NULL,
   REFERRINGXPDL decimal(19,0) NOT NULL,
   REFERREDXPDLNUMBER int NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
CREATE TABLE PM_SYSTEMPARAMETER (
    ID bigint PRIMARY KEY NOT NULL,
    PARAMETERKEY varchar(512) NOT NULL,
    CATEGORYID bigint NOT NULL,
    PARAMETERTYPE varchar(256) NOT NULL,
    REMOVABLE smallint NOT NULL,
    VALUESTRING varchar(4096),
    VALUELONG bigint,
    VALUEBOOL smallint,
    VALUEDATE date,
    VALUEDOUBLE float(53)
)
;
CREATE SEQUENCE PM_SYSTEMPARAMETER_SEQ
    START WITH 1
;
CREATE TABLE PM_SYSTEMPARAMETERCATEGORY (
    ID bigint PRIMARY KEY NOT NULL,
    CATEGORYKEY varchar(1024) NOT NULL
)
;
CREATE SEQUENCE PM_SYSTEMPARAMETERCATEGORY_SEQ
    START WITH 1
;
CREATE TABLE PM_SYSTEMPARAMETERCOMBOVALUES (
    ID bigint PRIMARY KEY NOT NULL,
    OWNERID bigint NOT NULL,
    VALUE varchar(4096) NOT NULL
);
CREATE SEQUENCE PM_COMBOVALUES_SEQ
    START WITH 1
;

INSERT INTO pm_systemparametercategory(id, categorykey) VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'Rights.Optional');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETER_SEQ, 'Rights.UserAccount.Enabled', PREVIOUS VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'BOOLEAN', 0, 0);

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETER_SEQ, 'Rights.Views.Enabled', PREVIOUS VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'BOOLEAN', 0, 0);

INSERT INTO pm_systemparametercategory(id, categorykey) VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'General');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuestring)
VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETER_SEQ, 'UniversalPassword', PREVIOUS VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'PASSWORD', 0, 'WbqyS8mRTdyybVuPdF1SEM3cIGmM1MP02OBTjG5GrsY');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETER_SEQ, 'ShowCalendarCart', PREVIOUS VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'BOOLEAN', 0, 0);

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (NEXT VALUE FOR PM_SYSTEMPARAMETER_SEQ, 'ShowStatistics', PREVIOUS VALUE FOR PM_SYSTEMPARAMETERCATEGORY_SEQ, 'BOOLEAN', 0, 0);

CREATE TABLE PM_EXTERNALDB_CONF (
    ID bigint PRIMARY KEY NOT NULL,
    EXTERNALDBCONFNAME varchar(1024),
    URL varchar(1024),
    DRIVER varchar(512),
    LOGIN varchar(256),
    PASSWORD varchar(256)
);
CREATE SEQUENCE EXTERNALDBCONF_ID_SEQ
    START WITH 1
;
CREATE TABLE PM_QUERYDATACHOOSER (
    ID bigint PRIMARY KEY NOT NULL,
    NAME varchar(1024),
    QUERY varchar(4000),
    PARAMETERS varchar(1024),
    COUNTQUERY varchar(4000),
    EXTERNALDB varchar(256),
    EXTERNALDBCONFNAME varchar(1024),
    FULLCLASSNAME varchar(512)
);
CREATE SEQUENCE QUERYDATACHOOSER_ID_SEQ
    START WITH 1
;

CREATE TABLE XPDLS
(
   XPDLID varchar(90) NOT NULL,
   XPDLVERSION varchar(20) NOT NULL,
   XPDLCLASSVERSION bigint NOT NULL,
   XPDLUPLOADTIME timestamp NOT NULL,
   OBJECTID decimal(19,0) PRIMARY KEY NOT NULL,
   VERSION int NOT NULL
)
;
ALTER TABLE ACTIVITIES
ADD CONSTRAINT ACTIVITIES_STATE
FOREIGN KEY (STATE)
REFERENCES ACTIVITYSTATES(OBJECTID)
;
ALTER TABLE ACTIVITIES
ADD CONSTRAINT ACTIVITIES_PROCESS
FOREIGN KEY (PROCESS)
REFERENCES PROCESSES(OBJECTID)
;
ALTER TABLE ACTIVITIES
ADD CONSTRAINT ACTIVITIES_THERES9
FOREIGN KEY (THERESOURCE)
REFERENCES RESOURCESTABLE(OBJECTID)
;
CREATE INDEX I2_ACTIVITIES ON ACTIVITIES
(
  PROCESS,
  ACTIVITYSETDEFINITIONID,
  ACTIVITYDEFINITIONID
)
;
CREATE INDEX I3_ACTIVITIES ON ACTIVITIES
(
  PROCESS,
  STATE
)
;
CREATE UNIQUE INDEX I1_ACTIVITIES ON ACTIVITIES(ID)
;
ALTER TABLE ACTIVITYDATA
ADD CONSTRAINT ACTIVITYDATA_ACT23
FOREIGN KEY (ACTIVITY)
REFERENCES ACTIVITIES(OBJECTID)
;
CREATE UNIQUE INDEX I1_ACTIVITYDATA ON ACTIVITYDATA
(
  ACTIVITY,
  VARIABLEDEFINITIONID
)
;
ALTER TABLE ACTIVITYDATABLOBS
ADD CONSTRAINT ACTIVITYDATABLOB27
FOREIGN KEY (ACTIVITYDATAWOB)
REFERENCES ACTIVITYDATAWOB(OBJECTID)
;
CREATE UNIQUE INDEX I1_ACTIVITYDATAB26 ON ACTIVITYDATABLOBS(ACTIVITYDATAWOB)
;
ALTER TABLE ACTIVITYDATAWOB
ADD CONSTRAINT ACTIVITYDATAWOB_24
FOREIGN KEY (ACTIVITY)
REFERENCES ACTIVITIES(OBJECTID)
;
CREATE UNIQUE INDEX I1_ACTIVITYDATAWOB ON ACTIVITYDATAWOB
(
  ACTIVITY,
  VARIABLEDEFINITIONID
)
;
CREATE UNIQUE INDEX I2_ACTIVITYSTATEE4 ON ACTIVITYSTATEEVENTAUDITS(NAME)
;
CREATE UNIQUE INDEX I1_ACTIVITYSTATEE3 ON ACTIVITYSTATEEVENTAUDITS(KEYVALUE)
;
CREATE UNIQUE INDEX I2_ACTIVITYSTATES ON ACTIVITYSTATES(NAME)
;
CREATE UNIQUE INDEX I1_ACTIVITYSTATES ON ACTIVITYSTATES(KEYVALUE)
;
ALTER TABLE ANDJOINTABLE
ADD CONSTRAINT ANDJOINTABLE_PRO29
FOREIGN KEY (PROCESS)
REFERENCES PROCESSES(OBJECTID)
;
ALTER TABLE ANDJOINTABLE
ADD CONSTRAINT ANDJOINTABLE_ACT30
FOREIGN KEY (ACTIVITY)
REFERENCES ACTIVITIES(OBJECTID)
;
CREATE INDEX I3_ANDJOINTABLE ON ANDJOINTABLE(ACTIVITY)
;
CREATE INDEX I2_ANDJOINTABLE ON ANDJOINTABLE
(
  PROCESS,
  ACTIVITYSETDEFINITIONID,
  ACTIVITYDEFINITIONID
)
;
CREATE UNIQUE INDEX I1_ANDJOINTABLE ON ANDJOINTABLE(CNT)
;
ALTER TABLE ASSIGNMENTEVENTAUDITS
ADD CONSTRAINT ASSIGNMENTEVENTA19
FOREIGN KEY (THETYPE)
REFERENCES EVENTTYPES(OBJECTID)
;
CREATE UNIQUE INDEX I1_ASSIGNMENTEVE18 ON ASSIGNMENTEVENTAUDITS(CNT)
;
ALTER TABLE ASSIGNMENTSTABLE
ADD CONSTRAINT ASSIGNMENTSTABLE16
FOREIGN KEY (THERESOURCE)
REFERENCES RESOURCESTABLE(OBJECTID)
;
ALTER TABLE ASSIGNMENTSTABLE
ADD CONSTRAINT ASSIGNMENTSTABLE15
FOREIGN KEY (ACTIVITY)
REFERENCES ACTIVITIES(OBJECTID)
;
CREATE INDEX I4_ASSIGNMENTSTA13 ON ASSIGNMENTSTABLE(ACTIVITYID)
;
CREATE INDEX I3_ASSIGNMENTSTA12 ON ASSIGNMENTSTABLE
(
  THERESOURCE,
  ISVALID
)
;
CREATE UNIQUE INDEX I2_ASSIGNMENTSTA11 ON ASSIGNMENTSTABLE
(
  ACTIVITY,
  THERESOURCE
)
;
CREATE UNIQUE INDEX I1_ASSIGNMENTSTA10 ON ASSIGNMENTSTABLE(CNT)
;
CREATE INDEX I5_ASSIGNMENTSTA14 ON ASSIGNMENTSTABLE(RESOURCEID)
;
CREATE UNIQUE INDEX I1_COUNTERS ON COUNTERS(NAME)
;
ALTER TABLE CREATEPROCESSEVENTAUDITS
ADD CONSTRAINT CREATEPROCESSEVEN7
FOREIGN KEY (THETYPE)
REFERENCES EVENTTYPES(OBJECTID)
;
CREATE UNIQUE INDEX I1_CREATEPROCESSE6 ON CREATEPROCESSEVENTAUDITS(CNT)
;
ALTER TABLE DATAEVENTAUDITS
ADD CONSTRAINT DATAEVENTAUDITS_16
FOREIGN KEY (THETYPE)
REFERENCES EVENTTYPES(OBJECTID)
;
CREATE UNIQUE INDEX I1_DATAEVENTAUDITS ON DATAEVENTAUDITS(CNT)
;
ALTER TABLE DEADLINES
ADD CONSTRAINT DEADLINES_ACTIVITY
FOREIGN KEY (ACTIVITY)
REFERENCES ACTIVITIES(OBJECTID)
;
ALTER TABLE DEADLINES
ADD CONSTRAINT DEADLINES_PROCESS
FOREIGN KEY (PROCESS)
REFERENCES PROCESSES(OBJECTID)
;
CREATE UNIQUE INDEX I1_DEADLINES ON DEADLINES(CNT)
;
CREATE INDEX I2_DEADLINES ON DEADLINES
(
  PROCESS,
  TIMELIMIT
)
;
CREATE INDEX I3_DEADLINES ON DEADLINES
(
  ACTIVITY,
  TIMELIMIT
)
;
CREATE UNIQUE INDEX I1_EVENTTYPES ON EVENTTYPES(KEYVALUE)
;
CREATE UNIQUE INDEX I2_EVENTTYPES ON EVENTTYPES(NAME)
;
ALTER TABLE GROUPGROUPTABLE
ADD CONSTRAINT GROUPGROUPTABLE_S2
FOREIGN KEY (SUB_GID)
REFERENCES GROUPTABLE(OBJECTID)
;
ALTER TABLE GROUPGROUPTABLE
ADD CONSTRAINT GROUPGROUPTABLE_G3
FOREIGN KEY (GROUPID)
REFERENCES GROUPTABLE(OBJECTID)
;
CREATE UNIQUE INDEX I1_GROUPGROUPTABLE ON GROUPGROUPTABLE
(
  SUB_GID,
  GROUPID
)
;
CREATE INDEX I2_GROUPGROUPTABLE ON GROUPGROUPTABLE(GROUPID)
;
CREATE UNIQUE INDEX I1_GROUPTABLE ON GROUPTABLE(GROUPID)
;
CREATE UNIQUE INDEX I1_GROUPUSER ON GROUPUSER(USERNAME)
;
ALTER TABLE GROUPUSERPACKLEVELPARTICIPANT
ADD CONSTRAINT GROUPUSERPACKLEV21
FOREIGN KEY (USEROID)
REFERENCES GROUPUSER(OBJECTID)
;
ALTER TABLE GROUPUSERPACKLEVELPARTICIPANT
ADD CONSTRAINT GROUPUSERPACKLEV20
FOREIGN KEY (PARTICIPANTOID)
REFERENCES PACKLEVELPARTICIPANT(OBJECTID)
;
CREATE UNIQUE INDEX I1_GROUPUSERPACK19 ON GROUPUSERPACKLEVELPARTICIPANT
(
  PARTICIPANTOID,
  USEROID
)
;
ALTER TABLE GROUPUSERPROCLEVELPARTICIPANT
ADD CONSTRAINT GROUPUSERPROCLEV25
FOREIGN KEY (USEROID)
REFERENCES GROUPUSER(OBJECTID)
;
ALTER TABLE GROUPUSERPROCLEVELPARTICIPANT
ADD CONSTRAINT GROUPUSERPROCLEV24
FOREIGN KEY (PARTICIPANTOID)
REFERENCES PROCLEVELPARTICIPANT(OBJECTID)
;
CREATE UNIQUE INDEX I1_GROUPUSERPROC23 ON GROUPUSERPROCLEVELPARTICIPANT
(
  PARTICIPANTOID,
  USEROID
)
;
CREATE UNIQUE INDEX I2_LOCKTABLE ON LOCKTABLE
(
  ID,
  ENGINENAME
)
;
CREATE UNIQUE INDEX I1_LOCKTABLE ON LOCKTABLE(ID)
;
ALTER TABLE NEWEVENTAUDITDATA
ADD CONSTRAINT NEWEVENTAUDITDAT31
FOREIGN KEY (DATAEVENTAUDIT)
REFERENCES DATAEVENTAUDITS(OBJECTID)
;
CREATE UNIQUE INDEX I1_NEWEVENTAUDIT30 ON NEWEVENTAUDITDATA
(
  DATAEVENTAUDIT,
  VARIABLEDEFINITIONID
)
;
ALTER TABLE NEWEVENTAUDITDATABLOBS
ADD CONSTRAINT NEWEVENTAUDITDAT37
FOREIGN KEY (NEWEVENTAUDITDATAWOB)
REFERENCES NEWEVENTAUDITDATAWOB(OBJECTID)
;
CREATE UNIQUE INDEX I1_NEWEVENTAUDIT36 ON NEWEVENTAUDITDATABLOBS(NEWEVENTAUDITDATAWOB)
;
ALTER TABLE NEWEVENTAUDITDATAWOB
ADD CONSTRAINT NEWEVENTAUDITDAT34
FOREIGN KEY (DATAEVENTAUDIT)
REFERENCES DATAEVENTAUDITS(OBJECTID)
;
CREATE UNIQUE INDEX I1_NEWEVENTAUDIT33 ON NEWEVENTAUDITDATAWOB
(
  DATAEVENTAUDIT,
  VARIABLEDEFINITIONID
)
;
CREATE UNIQUE INDEX I1_NEXTXPDLVERSIO3 ON NEXTXPDLVERSIONS
(
  XPDLID,
  NEXTVERSION
)
;
CREATE UNIQUE INDEX I1_NORMALUSER ON NORMALUSER(USERNAME)
;
ALTER TABLE OLDEVENTAUDITDATA
ADD CONSTRAINT OLDEVENTAUDITDAT22
FOREIGN KEY (DATAEVENTAUDIT)
REFERENCES DATAEVENTAUDITS(OBJECTID)
;
CREATE UNIQUE INDEX I1_OLDEVENTAUDIT21 ON OLDEVENTAUDITDATA
(
  DATAEVENTAUDIT,
  VARIABLEDEFINITIONID
)
;
ALTER TABLE OLDEVENTAUDITDATABLOBS
ADD CONSTRAINT OLDEVENTAUDITDAT28
FOREIGN KEY (OLDEVENTAUDITDATAWOB)
REFERENCES OLDEVENTAUDITDATAWOB(OBJECTID)
;
CREATE UNIQUE INDEX I1_OLDEVENTAUDIT27 ON OLDEVENTAUDITDATABLOBS(OLDEVENTAUDITDATAWOB)
;
ALTER TABLE OLDEVENTAUDITDATAWOB
ADD CONSTRAINT OLDEVENTAUDITDAT25
FOREIGN KEY (DATAEVENTAUDIT)
REFERENCES DATAEVENTAUDITS(OBJECTID)
;
CREATE UNIQUE INDEX I1_OLDEVENTAUDIT24 ON OLDEVENTAUDITDATAWOB
(
  DATAEVENTAUDIT,
  VARIABLEDEFINITIONID
)
;
ALTER TABLE PACKLEVELPARTICIPANT
ADD CONSTRAINT PACKLEVELPARTICIP6
FOREIGN KEY (PACKAGEOID)
REFERENCES XPDLPARTICIPANTPACKAGE(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELPARTI5 ON PACKLEVELPARTICIPANT
(
  PARTICIPANT_ID,
  PACKAGEOID
)
;
ALTER TABLE PACKLEVELXPDLAPP
ADD CONSTRAINT PACKLEVELXPDLAPP_6
FOREIGN KEY (PACKAGEOID)
REFERENCES XPDLAPPLICATIONPACKAGE(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELXPDLA5 ON PACKLEVELXPDLAPP
(
  APPLICATION_ID,
  PACKAGEOID
)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPDETAIL
ADD CONSTRAINT PACKLEVELXPDLAPP28
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPDETAIL(OBJECTID)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPDETAIL
ADD CONSTRAINT PACKLEVELXPDLAPP27
FOREIGN KEY (XPDL_APPOID)
REFERENCES PACKLEVELXPDLAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELXPDL26 ON PACKLEVELXPDLAPPTAAPPDETAIL
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPDETAILUSR
ADD CONSTRAINT PACKLEVELXPDLAPP36
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPDETAILUSER(OBJECTID)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPDETAILUSR
ADD CONSTRAINT PACKLEVELXPDLAPP35
FOREIGN KEY (XPDL_APPOID)
REFERENCES PACKLEVELXPDLAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELXPDL34 ON PACKLEVELXPDLAPPTAAPPDETAILUSR
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPUSER
ADD CONSTRAINT PACKLEVELXPDLAPP32
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPUSER(OBJECTID)
;
ALTER TABLE PACKLEVELXPDLAPPTAAPPUSER
ADD CONSTRAINT PACKLEVELXPDLAPP31
FOREIGN KEY (XPDL_APPOID)
REFERENCES PACKLEVELXPDLAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELXPDL30 ON PACKLEVELXPDLAPPTAAPPUSER
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PACKLEVELXPDLAPPTOOLAGENTAPP
ADD CONSTRAINT PACKLEVELXPDLAPP23
FOREIGN KEY (XPDL_APPOID)
REFERENCES PACKLEVELXPDLAPP(OBJECTID)
;
ALTER TABLE PACKLEVELXPDLAPPTOOLAGENTAPP
ADD CONSTRAINT PACKLEVELXPDLAPP24
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PACKLEVELXPDL22 ON PACKLEVELXPDLAPPTOOLAGENTAPP
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PROCESSDATA
ADD CONSTRAINT PROCESSDATA_PROC18
FOREIGN KEY (PROCESS)
REFERENCES PROCESSES(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCESSDATA ON PROCESSDATA
(
  PROCESS,
  VARIABLEDEFINITIONID
)
;
ALTER TABLE PROCESSDATABLOBS
ADD CONSTRAINT PROCESSDATABLOBS21
FOREIGN KEY (PROCESSDATAWOB)
REFERENCES PROCESSDATAWOB(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCESSDATABL20 ON PROCESSDATABLOBS(PROCESSDATAWOB)
;
ALTER TABLE PROCESSDATAWOB
ADD CONSTRAINT PROCESSDATAWOB_P19
FOREIGN KEY (PROCESS)
REFERENCES PROCESSES(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCESSDATAWOB ON PROCESSDATAWOB
(
  PROCESS,
  VARIABLEDEFINITIONID
)
;
CREATE UNIQUE INDEX I1_PROCESSDEFINIT0 ON PROCESSDEFINITIONS(NAME)
;
ALTER TABLE PROCESSES
ADD CONSTRAINT PROCESSES_PROCESS2
FOREIGN KEY (PROCESSDEFINITION)
REFERENCES PROCESSDEFINITIONS(OBJECTID)
;
ALTER TABLE PROCESSES
ADD CONSTRAINT PROCESSES_STATE
FOREIGN KEY (STATE)
REFERENCES PROCESSSTATES(OBJECTID)
;
CREATE INDEX I3_PROCESSES ON PROCESSES(STATE)
;
CREATE INDEX I4_PROCESSES ON PROCESSES(ACTIVITYREQUESTERID)
;
CREATE UNIQUE INDEX I1_PROCESSES ON PROCESSES(ID)
;
CREATE INDEX I5_PROCESSES ON PROCESSES(RESOURCEREQUESTERID)
;
CREATE INDEX I2_PROCESSES ON PROCESSES(PROCESSDEFINITION)
;
ALTER TABLE PROCESSREQUESTERS
ADD CONSTRAINT PROCESSREQUESTERS6
FOREIGN KEY (ACTIVITYREQUESTER)
REFERENCES ACTIVITIES(OBJECTID)
;
ALTER TABLE PROCESSREQUESTERS
ADD CONSTRAINT PROCESSREQUESTERS7
FOREIGN KEY (RESOURCEREQUESTER)
REFERENCES RESOURCESTABLE(OBJECTID)
;
CREATE INDEX I3_PROCESSREQUEST5 ON PROCESSREQUESTERS(RESOURCEREQUESTER)
;
CREATE INDEX I2_PROCESSREQUEST4 ON PROCESSREQUESTERS(ACTIVITYREQUESTER)
;
CREATE UNIQUE INDEX I1_PROCESSREQUEST3 ON PROCESSREQUESTERS(ID)
;
CREATE UNIQUE INDEX I1_PROCESSSTATEEV0 ON PROCESSSTATEEVENTAUDITS(KEYVALUE)
;
CREATE UNIQUE INDEX I2_PROCESSSTATEEV1 ON PROCESSSTATEEVENTAUDITS(NAME)
;
CREATE UNIQUE INDEX I2_PROCESSSTATES ON PROCESSSTATES(NAME)
;
CREATE UNIQUE INDEX I1_PROCESSSTATES ON PROCESSSTATES(KEYVALUE)
;
ALTER TABLE PROCLEVELPARTICIPANT
ADD CONSTRAINT PROCLEVELPARTICIP3
FOREIGN KEY (PROCESSOID)
REFERENCES XPDLPARTICIPANTPROCESS(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELPARTI2 ON PROCLEVELPARTICIPANT
(
  PARTICIPANT_ID,
  PROCESSOID
)
;
ALTER TABLE PROCLEVELXPDLAPP
ADD CONSTRAINT PROCLEVELXPDLAPP_9
FOREIGN KEY (PROCESSOID)
REFERENCES XPDLAPPLICATIONPROCESS(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELXPDLA8 ON PROCLEVELXPDLAPP
(
  APPLICATION_ID,
  PROCESSOID
)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPDETAIL
ADD CONSTRAINT PROCLEVELXPDLAPP43
FOREIGN KEY (XPDL_APPOID)
REFERENCES PROCLEVELXPDLAPP(OBJECTID)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPDETAIL
ADD CONSTRAINT PROCLEVELXPDLAPP44
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPDETAIL(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELXPDL42 ON PROCLEVELXPDLAPPTAAPPDETAIL
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPDETAILUSR
ADD CONSTRAINT PROCLEVELXPDLAPP52
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPDETAILUSER(OBJECTID)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPDETAILUSR
ADD CONSTRAINT PROCLEVELXPDLAPP51
FOREIGN KEY (XPDL_APPOID)
REFERENCES PROCLEVELXPDLAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELXPDL50 ON PROCLEVELXPDLAPPTAAPPDETAILUSR
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPUSER
ADD CONSTRAINT PROCLEVELXPDLAPP47
FOREIGN KEY (XPDL_APPOID)
REFERENCES PROCLEVELXPDLAPP(OBJECTID)
;
ALTER TABLE PROCLEVELXPDLAPPTAAPPUSER
ADD CONSTRAINT PROCLEVELXPDLAPP48
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPPUSER(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELXPDL46 ON PROCLEVELXPDLAPPTAAPPUSER
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
ALTER TABLE PROCLEVELXPDLAPPTOOLAGENTAPP
ADD CONSTRAINT PROCLEVELXPDLAPP40
FOREIGN KEY (TOOLAGENTOID)
REFERENCES TOOLAGENTAPP(OBJECTID)
;
ALTER TABLE PROCLEVELXPDLAPPTOOLAGENTAPP
ADD CONSTRAINT PROCLEVELXPDLAPP39
FOREIGN KEY (XPDL_APPOID)
REFERENCES PROCLEVELXPDLAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_PROCLEVELXPDL38 ON PROCLEVELXPDLAPPTOOLAGENTAPP
(
  XPDL_APPOID,
  TOOLAGENTOID
)
;
CREATE UNIQUE INDEX I1_RESOURCESTABLE ON RESOURCESTABLE(USERNAME)
;
ALTER TABLE STATEEVENTAUDITS
ADD CONSTRAINT STATEEVENTAUDITS12
FOREIGN KEY (NEWPROCESSSTATE)
REFERENCES PROCESSSTATEEVENTAUDITS(OBJECTID)
;
ALTER TABLE STATEEVENTAUDITS
ADD CONSTRAINT STATEEVENTAUDITS14
FOREIGN KEY (NEWACTIVITYSTATE)
REFERENCES ACTIVITYSTATEEVENTAUDITS(OBJECTID)
;
ALTER TABLE STATEEVENTAUDITS
ADD CONSTRAINT STATEEVENTAUDITS11
FOREIGN KEY (OLDPROCESSSTATE)
REFERENCES PROCESSSTATEEVENTAUDITS(OBJECTID)
;
ALTER TABLE STATEEVENTAUDITS
ADD CONSTRAINT STATEEVENTAUDITS13
FOREIGN KEY (OLDACTIVITYSTATE)
REFERENCES ACTIVITYSTATEEVENTAUDITS(OBJECTID)
;
ALTER TABLE STATEEVENTAUDITS
ADD CONSTRAINT STATEEVENTAUDITS10
FOREIGN KEY (THETYPE)
REFERENCES EVENTTYPES(OBJECTID)
;
CREATE UNIQUE INDEX I1_STATEEVENTAUDI9 ON STATEEVENTAUDITS(CNT)
;
CREATE UNIQUE INDEX I1_TOOLAGENTAPP ON TOOLAGENTAPP
(
  TOOL_AGENT_NAME,
  APP_NAME
)
;
ALTER TABLE TOOLAGENTAPPDETAIL
ADD CONSTRAINT TOOLAGENTAPPDETA12
FOREIGN KEY (TOOLAGENT_APPOID)
REFERENCES TOOLAGENTAPP(OBJECTID)
;
CREATE UNIQUE INDEX I1_TOOLAGENTAPPD11 ON TOOLAGENTAPPDETAIL
(
  APP_MODE,
  TOOLAGENT_APPOID
)
;
ALTER TABLE TOOLAGENTAPPDETAILUSER
ADD CONSTRAINT TOOLAGENTAPPDETA20
FOREIGN KEY (USEROID)
REFERENCES TOOLAGENTUSER(OBJECTID)
;
ALTER TABLE TOOLAGENTAPPDETAILUSER
ADD CONSTRAINT TOOLAGENTAPPDETA19
FOREIGN KEY (TOOLAGENT_APPOID)
REFERENCES TOOLAGENTAPPDETAIL(OBJECTID)
;
CREATE UNIQUE INDEX I1_TOOLAGENTAPPD18 ON TOOLAGENTAPPDETAILUSER
(
  TOOLAGENT_APPOID,
  USEROID
)
;
ALTER TABLE TOOLAGENTAPPUSER
ADD CONSTRAINT TOOLAGENTAPPUSER15
FOREIGN KEY (TOOLAGENT_APPOID)
REFERENCES TOOLAGENTAPP(OBJECTID)
;
ALTER TABLE TOOLAGENTAPPUSER
ADD CONSTRAINT TOOLAGENTAPPUSER16
FOREIGN KEY (USEROID)
REFERENCES TOOLAGENTUSER(OBJECTID)
;
CREATE UNIQUE INDEX I1_TOOLAGENTAPPU14 ON TOOLAGENTAPPUSER
(
  TOOLAGENT_APPOID,
  USEROID
)
;
CREATE UNIQUE INDEX I1_TOOLAGENTUSER ON TOOLAGENTUSER(USERNAME)
;
ALTER TABLE USERGROUPTABLE
ADD CONSTRAINT USERGROUPTABLE_US0
FOREIGN KEY (USERID)
REFERENCES USERTABLE(OBJECTID)
;
ALTER TABLE USERGROUPTABLE
ADD CONSTRAINT USERGROUPTABLE_GR1
FOREIGN KEY (GROUPID)
REFERENCES GROUPTABLE(OBJECTID)
;
CREATE UNIQUE INDEX I1_USERGROUPTABLE ON USERGROUPTABLE
(
  USERID,
  GROUPID
)
;
ALTER TABLE USERPACKLEVELPARTICIPANT
ADD CONSTRAINT USERPACKLEVELPAR17
FOREIGN KEY (USEROID)
REFERENCES NORMALUSER(OBJECTID)
;
ALTER TABLE USERPACKLEVELPARTICIPANT
ADD CONSTRAINT USERPACKLEVELPAR16
FOREIGN KEY (PARTICIPANTOID)
REFERENCES PACKLEVELPARTICIPANT(OBJECTID)
;
CREATE UNIQUE INDEX I1_USERPACKLEVEL15 ON USERPACKLEVELPARTICIPANT
(
  PARTICIPANTOID,
  USEROID
)
;
ALTER TABLE USERPROCLEVELPARTICIPANT
ADD CONSTRAINT USERPROCLEVELPAR12
FOREIGN KEY (PARTICIPANTOID)
REFERENCES PROCLEVELPARTICIPANT(OBJECTID)
;
ALTER TABLE USERPROCLEVELPARTICIPANT
ADD CONSTRAINT USERPROCLEVELPAR13
FOREIGN KEY (USEROID)
REFERENCES NORMALUSER(OBJECTID)
;
CREATE UNIQUE INDEX I1_USERPROCLEVEL11 ON USERPROCLEVELPARTICIPANT
(
  PARTICIPANTOID,
  USEROID
)
;
CREATE UNIQUE INDEX I1_USERTABLE ON USERTABLE(USERID)
;
CREATE UNIQUE INDEX I1_XPDLAPPLICATIO0 ON XPDLAPPLICATIONPACKAGE(PACKAGE_ID)
;
ALTER TABLE XPDLAPPLICATIONPROCESS
ADD CONSTRAINT XPDLAPPLICATIONPR3
FOREIGN KEY (PACKAGEOID)
REFERENCES XPDLAPPLICATIONPACKAGE(OBJECTID)
;
CREATE UNIQUE INDEX I1_XPDLAPPLICATIO2 ON XPDLAPPLICATIONPROCESS
(
  PROCESS_ID,
  PACKAGEOID
)
;
ALTER TABLE XPDLDATA
ADD CONSTRAINT XPDLDATA_XPDL
FOREIGN KEY (XPDL)
REFERENCES XPDLS(OBJECTID)
;
CREATE UNIQUE INDEX I1_XPDLDATA ON XPDLDATA(CNT)
;
CREATE UNIQUE INDEX I2_XPDLDATA ON XPDLDATA(XPDL)
;
CREATE UNIQUE INDEX I1_XPDLHISTORY ON XPDLHISTORY
(
  XPDLID,
  XPDLVERSION
)
;
ALTER TABLE XPDLHISTORYDATA
ADD CONSTRAINT XPDLHISTORYDATA_X0
FOREIGN KEY (XPDLHISTORY)
REFERENCES XPDLHISTORY(OBJECTID)
;
CREATE UNIQUE INDEX I1_XPDLHISTORYDATA ON XPDLHISTORYDATA(CNT)
;
CREATE UNIQUE INDEX I1_XPDLPARTICIPAN0 ON XPDLPARTICIPANTPACKAGE(PACKAGE_ID)
;
ALTER TABLE XPDLPARTICIPANTPROCESS
ADD CONSTRAINT XPDLPARTICIPANTPR9
FOREIGN KEY (PACKAGEOID)
REFERENCES XPDLPARTICIPANTPACKAGE(OBJECTID)
;
CREATE UNIQUE INDEX I1_XPDLPARTICIPAN8 ON XPDLPARTICIPANTPROCESS
(
  PROCESS_ID,
  PACKAGEOID
)
;
ALTER TABLE XPDLREFERENCES
ADD CONSTRAINT XPDLREFERENCES_RE2
FOREIGN KEY (REFERRINGXPDL)
REFERENCES XPDLS(OBJECTID)
;
CREATE UNIQUE INDEX I1_XPDLREFERENCES ON XPDLREFERENCES
(
  REFERREDXPDLID,
  REFERRINGXPDL
)
;
CREATE UNIQUE INDEX I1_XPDLS ON XPDLS
(
  XPDLID,
  XPDLVERSION
)
;

INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.running','open.running','1000001','0');
INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.not_running.not_started','open.not_running.not_started','1000003','0');
INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.not_running.suspended','open.not_running.suspended','1000005','0');
INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.completed','closed.completed','1000007','0');
INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.terminated','closed.terminated','1000009','0');
INSERT INTO ACTIVITYSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.aborted','closed.aborted','1000011','0');

INSERT INTO GROUPTABLE (GROUPID,DESCRIPTION,OBJECTID,VERSION) values ('Administrators',null,'1000012','0');

INSERT INTO OBJECTID (NEXT) values ('1000200');

INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.running','open.running','1000000','0');
INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.not_running.not_started','open.not_running.not_started','1000002','0');
INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('open.not_running.suspended','open.not_running.suspended','1000004','0');
INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.completed','closed.completed','1000006','0');
INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.terminated','closed.terminated','1000008','0');
INSERT INTO PROCESSSTATES (KEYVALUE,NAME,OBJECTID,VERSION) values ('closed.aborted','closed.aborted','1000010','0');
INSERT INTO RESOURCESTABLE (USERNAME,NAME,OBJECTID,VERSION) values ('admin',null,'1000015','0');

INSERT INTO USERTABLE (USERID,FIRSTNAME,LASTNAME,PASSWD,EMAIL,OBJECTID,VERSION,ACTIVE) values ('admin','Administrator','PlusWorkflow','73d7665487f88c55adb98e90a84f579728032f46',null,'1000013','0',1);

INSERT INTO USERGROUPTABLE (USERID,GROUPID,OBJECTID,VERSION) values ('1000013','1000012','1000014','0');

CREATE TABLE PM_ACTIONS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DOCCLASSID BIGINT,
		ACTIONNAME VARCHAR(255),
		ACTIONSOURCE VARCHAR(255),
		ACTIONTYPE VARCHAR(255),
		ACTIONVALUE VARCHAR(255),
		ACTIONVALUE2 VARCHAR(4000)
	);

CREATE TABLE PM_ACTIVATEDTIMES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		ACTIVITYID VARCHAR(255),
		ACTIVATEDTIME BIGINT,
		ACTIVATED BIGINT
	);

CREATE TABLE PM_ACTIVITYCOMMENTS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		PROCESSID VARCHAR(255),
		ACTIVITYID VARCHAR(255),
		USERID VARCHAR(255),
		ACTIVITY_COMMENT VARCHAR(4000),
		TIMESTAMP BIGINT
	);

CREATE TABLE PM_ACTIVITYREDIRECTION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		ACTIVITYDEFID VARCHAR(255),
		PROCESSDEFID VARCHAR(255),
		SOURCEUSER DECIMAL(19 , 0)
	);

CREATE TABLE PM_ACTIVITYREDIRECTION_GROUPS (
		REDIRECTION BIGINT NOT NULL,
		TARGETGROUP DECIMAL(19 , 0) NOT NULL
	);

CREATE TABLE PM_ACTIVITYREDIRECTION_USERS (
		REDIRECTION BIGINT NOT NULL,
		TARGETUSER DECIMAL(19 , 0) NOT NULL
	);

CREATE TABLE PM_ACTIVITY_DOCUMENT (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		ADDEDHERE SMALLINT NOT NULL,
		"date" TIMESTAMP NOT NULL,
		ACTIVITY DECIMAL(19 , 0),
		FILEID BIGINT NOT NULL,
		PROCESS DECIMAL(19 , 0) NOT NULL,
		USERID DECIMAL(19 , 0) NOT NULL,
		VERSION BIGINT NOT NULL
	);

CREATE TABLE PM_ACTIVITY_STATUS (
		STATUS_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		PROCESS_ID VARCHAR(100) NOT NULL,
		ACTIVITY_ID VARCHAR(100) NOT NULL,
		ACTIVITY_ACCEPTANCE_TIME BIGINT,
		STATUS_TYPE INTEGER NOT NULL,
		STATUS_IS_NEWEST SMALLINT NOT NULL,
		STATUS_DATE TIMESTAMP NOT NULL,
		STATUS_AUTHOR VARCHAR(100) NOT NULL,
		STATUS_MESSAGE LONG VARCHAR,
		CHECK_FORM_ACCEPT SMALLINT
	);

CREATE TABLE PM_ACTIVITY_TRANSLATION (
		PACKAGEID VARCHAR(254) NOT NULL,
		PROCESSDEFID VARCHAR(254) NOT NULL,
		ACTIVITYDEFID VARCHAR(254) NOT NULL,
		LANGUAGE VARCHAR(254) NOT NULL,
		NAME VARCHAR(254),
		DESCRIPTION LONG VARCHAR
	);

CREATE TABLE PM_ADVANCESEARCHVARIABLES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VIEWID VARCHAR(255),
		NAME VARCHAR(255),
		VALUE VARCHAR(1024),
		VALUE2 VARCHAR(1024),
		SORTTYPE VARCHAR(255),
		POSITION VARCHAR(255),
		ACTIVE VARCHAR(255),
		UPPERCASE VARCHAR(255)
	);

CREATE TABLE PM_AUDITS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		USERID VARCHAR(128),
		IPADDRESS VARCHAR(255),
		THREADID VARCHAR(255),
		AUDITTYPE VARCHAR(255),
		AUDITSTARTED BIGINT,
		AUDITSTOPPED BIGINT,
		AUDITDURATION BIGINT,
		AUDITSUCCESS SMALLINT,
		AUDITPARAMS LONG VARCHAR
	);

CREATE TABLE PM_DELEGATEDACTIVITIES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		ACTIVITYID VARCHAR(255),
		USERID VARCHAR(255),
		DELEGATEDUSER VARCHAR(255),
		TRANSFERTYPE VARCHAR(20) NOT NULL
	);

CREATE TABLE PM_DEVICES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DEVICEFREESPACE BIGINT,
		DEVICENAME VARCHAR(255),
		DEVICEPATH VARCHAR(255),
		DEVICESIZE BIGINT
	);

CREATE TABLE PM_DIRECTORIES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DIRECTORYFREESPACE BIGINT,
		DIRECTORYNAME VARCHAR(255),
		DIRECTORYSIZE BIGINT,
		DIRECTORYTHRESHOLD BIGINT,
		DEVICEID BIGINT,
		ROOTDIRECTORYID BIGINT
	);

CREATE TABLE PM_DOCCLASSCONDITIONPROTECTION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		CONDITION VARCHAR(255),
		CONDITIONTYPE VARCHAR(255),
		ISGROUP SMALLINT NOT NULL,
		PROTECTOR VARCHAR(255),
		USERID VARCHAR(255),
		DOCCLASSID BIGINT
	);

CREATE TABLE PM_DOCCLASSES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DOCCLASSNAME VARCHAR(255) NOT NULL,
		DOCCLASSDESCRIPTION VARCHAR(255),
		DOCCLASSEXPIRETIONDATE VARCHAR(255),
		DOCCLASSEXPIRETIONTYPE VARCHAR(255),
		DOCCLASSDIRECTORYID BIGINT,
		DOCCLASSENCODING VARCHAR(255),
		DOCCLASSCOMPRESSING VARCHAR(255),
		DOCCLASSFTSSERVERID BIGINT,
		CIPHERALGORITHM VARCHAR(255),
		KEYLENGTH BIGINT,
		DOCCLASSORDERID BIGINT,
		DOCCLASSINDEXPATH VARCHAR(255),
		DOCCLASSINDEX VARCHAR(255),
		MAXFILESIZE BIGINT,
		LOGICALCONN VARCHAR(255) DEFAULT 'AND'
	);

CREATE TABLE PM_DOCCLASSPROTECTION (
		DOCCLASSID BIGINT NOT NULL,
	    ISGROUP smallint NOT NULL,
	    RESOURCEID VARCHAR(255) NOT NULL,
	    LOGICALCONNECTION VARCHAR(50),
	    CONSTRAINT PM_DOCCLASSPROTECTION_PKEY PRIMARY KEY (DOCCLASSID, ISGROUP, RESOURCEID)
);

CREATE TABLE PM_DOCUMENTTEMPLATE (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		TEMPLATENAME VARCHAR(255),
		TEMPLATEPATH VARCHAR(255),
		PROCESSID VARCHAR(255)
	);

CREATE TABLE PM_DOCUMENT_VIEWS (
		DOCUMENT_VIEW_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DOCUMENT_VIEW_NAME VARCHAR(255),
		DOCUMENT_VIEW_DESC VARCHAR(255),
		PROC_DEF_ID VARCHAR(255),
		TASK_DEF_ID VARCHAR(255),
		USER_ID VARCHAR(255),
		DOC_CLASS_ID BIGINT,
		IS_DESCENDING SMALLINT NOT NULL,
		AMOUNT INTEGER NOT NULL,
		REGEX VARCHAR(255)
	);

CREATE TABLE PM_DOMAINSERVERS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DOMAINNAME VARCHAR(255),
		DOMAINSERVERADRES VARCHAR(255),
		DOMAINSERVERPORT BIGINT,
		DOMAINUSER VARCHAR(255),
		DOMAINUSERPASSWORD VARCHAR(255),
		DOMAINBASESEARCH VARCHAR(255),
		USERNAMETEMPLATE VARCHAR(255),
		DOMAINSPNEGO VARCHAR(255),
		usernamemapping VARCHAR(255),
		firstnamemapping VARCHAR(255),
		lastnamemapping VARCHAR(255),
		emailmapping VARCHAR(255),
		membermapping VARCHAR(255),
		memberofmapping VARCHAR(255),
		numbermapping VARCHAR(255)
	);

CREATE TABLE PM_EMAILNOTIFICATION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		SPROCESSTYPENAME VARCHAR(255),
		STASKNAME VARCHAR(255),
		SUSERNAME VARCHAR(255),
		SISGROUP VARCHAR(255),
		SNOTIFICATIONTYPE VARCHAR(255)
	);

CREATE TABLE PM_FILES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		FILE_DATE TIMESTAMP,
		NAME VARCHAR(255),
		ORG_NAME VARCHAR(255),
		PATH VARCHAR(255),
		UPLOADER VARCHAR(255),
		DESCRIPTION VARCHAR(255),
		FILE_SIZE BIGINT,
		COMPRESSED VARCHAR(255),
		ENCRYPTED VARCHAR(255),
		CIPHERALGORITHM VARCHAR(255),
		CIPHERKEY VARCHAR(255),
		DOCCLASSID BIGINT NOT NULL
	);

CREATE TABLE PM_FILE_VERSIONS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		FILEID BIGINT NOT NULL,
		PARENT_FILEID BIGINT,
		CHECKOUT_DATE DATE,
		CHECKIN_DATE DATE,
		CHECKOUT_USER VARCHAR(255),
		STATE VARCHAR(255),
		FILE_COMMENT VARCHAR(255),
		REPLACE_DATE DATE,
		VERSION BIGINT,
		NEWEST_FILEID BIGINT
	);

CREATE TABLE PM_INDECIES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DOCCLASSID BIGINT,
		INDEXNAME VARCHAR(255),
		INDEXDESCRIPTION VARCHAR(255),
		INDEXTYPE VARCHAR(255),
		INDEXVALUES VARCHAR(4000),
		INDEXORDERID BIGINT
	);

CREATE TABLE PM_LICENSE (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		DATES BLOB(102400) INLINE LENGTH 140,
		LICENSEDATA BLOB(1048576) INLINE LENGTH 164,
		PUBLICKEY BLOB(102400) INLINE LENGTH 140
	);

CREATE TABLE PM_TRIAL (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		TRIAL_DATA BLOB(1048576) INLINE LENGTH 164
	);

CREATE TABLE PM_LINKCONNECTION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		LINKID BIGINT,
		LINKINDEXID BIGINT,
		DOCCLASSID BIGINT,
		INDEXID BIGINT
	);

CREATE TABLE PM_LINKINDECIES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		LINKID BIGINT,
		INDEXNAME VARCHAR(255),
		INDEXDESCRIPTION VARCHAR(255),
		INDEXTYPE VARCHAR(255),
		INDEXVALUES VARCHAR(4000),
		INDEXORDER BIGINT
	);

CREATE TABLE PM_LINKS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		LINKNAME VARCHAR(255),
		LINKDESCRIPTION VARCHAR(255)
	);

CREATE TABLE PM_NOTIFICATIONDEF (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NAME VARCHAR(255) NOT NULL,
		SUBJECT VARCHAR(255) NOT NULL,
		TEMPLATEPATH VARCHAR(4000) NOT NULL,
		CONDITIONTYPE VARCHAR(255) NOT NULL,
		CONDITIONVARNAME VARCHAR(255),
		CONDITIONVAL VARCHAR(255),
		RECIPIENTPERFORMER SMALLINT
	);

CREATE TABLE PM_NOTIFICATIONPROCACT (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NOTIFICATIONDEFID VARCHAR(255) NOT NULL,
		PROCESSDEFID VARCHAR(255) NOT NULL,
		ACTIVITYDEFID VARCHAR(255)
	);

CREATE TABLE PM_NOTIFICATIONRECIPIENT (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NOTIFICATIONDEFID VARCHAR(255) NOT NULL,
		RECIPIENTTYPE VARCHAR(255) NOT NULL,
		RECIPIENTVAL VARCHAR(255),
		RECIPIENTEXCLUDED VARCHAR(255)
	);

CREATE TABLE PM_NOTIFICATIONS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NOTIFICATIONDEFID VARCHAR(255) NOT NULL,
		PROCESSID VARCHAR(255) NOT NULL,
		ACTIVITYID VARCHAR(255),
		RECIPIENTUSERIDS LONG VARCHAR
	);

CREATE TABLE PM_OPENED_FILES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		FILEID BIGINT,
		USERNAME VARCHAR(255),
		FILENAME VARCHAR(255),
		SESSIONID VARCHAR(255),
		DATEOFOPEN TIMESTAMP
	);

CREATE TABLE PM_OPERATION_PANEL (
		OPERATION_PANEL_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		USERID VARCHAR(255),
		NAME VARCHAR(255),
		DESCRIPTION VARCHAR(255)
	);

CREATE TABLE PM_OPERATION_PANEL_PARAMETERS (
		OPERATION_PANEL_PARAMETER_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NAME VARCHAR(255) NOT NULL,
		TYPE VARCHAR(255) NOT NULL,
		PARAMS VARCHAR(255),
		IS_COUNT SMALLINT,
		POSITION BIGINT,
		OPERATION_PANEL_ID BIGINT NOT NULL
	);

CREATE TABLE PM_ORGANIZATIONALUNITS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		ORGANIZATIONALUNITNAME VARCHAR(255),
		ORGANIZATIONALUNITSYMBOL VARCHAR(255) NOT NULL,
		DIRECTORPOSITIONID BIGINT,
		HIGHERORGANIZATIONALUNITID BIGINT
	);

CREATE TABLE PM_PLUGINS_CONFIGURATION (
		ID VARCHAR(255) NOT NULL,
		PLUGIN_NAME VARCHAR(255) NOT NULL,
		ENTRY_FILE_NAME VARCHAR(255) NOT NULL,
		PLUGIN_FILE_NAME VARCHAR(255) NOT NULL,
		PLUGIN_FILE_MD5 VARCHAR(255) NOT NULL
	);

CREATE TABLE PM_POSITIONS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		POSITIONNAME VARCHAR(255),
		POSITIONSYMBOL VARCHAR(255) NOT NULL,
		HIGHERPOSITIONID BIGINT,
		ORGANIZATIONALUNITID BIGINT,
		USERID DECIMAL(19 , 0)
	);

CREATE TABLE PM_POSITION_ROLE (
		POSITIONID BIGINT NOT NULL,
		ROLEID BIGINT NOT NULL
	);

CREATE TABLE PM_PROCESSDATA (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		SPROCESSFIELDNAME VARCHAR(255),
		SPROCESSFIELDVALUE VARCHAR(255),
		SPROCESSTYPENAME VARCHAR(255),
		STASKTYPENAME VARCHAR(255)
	);

CREATE SEQUENCE PM_PROCESSDATA_ID_SEQ
  START WITH 1;

CREATE TABLE PM_PROCESSTYPES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		SPROCESSTYPENAME VARCHAR(255),
		SPROCESSINDECESTABLE VARCHAR(255)
	);

CREATE TABLE PM_PROCESS_TRANSLATION (
		PROCESSID VARCHAR(255) NOT NULL,
		LANGUAGE VARCHAR(255) NOT NULL,
		NAME VARCHAR(255),
		DESCRIPTION VARCHAR(255)
	);

CREATE TABLE PM_REPORTLISTVARIABLEVALUE (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VARIABLEID BIGINT NOT NULL,
		LISTVALUEID VARCHAR(255),
		LISTVALUEDISPLAY VARCHAR(255)
	);

CREATE TABLE PM_REPORTS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VIEWID BIGINT,
		REPORTNAME VARCHAR(255),
		REPORTDESCR VARCHAR(255),
		ACCESSLEVEL VARCHAR(255),
		USERNAME VARCHAR(255),
		SHOWFORMONRESULT VARCHAR(255),
		CANFILTERRESULT VARCHAR(255),
		REPORTTYPE VARCHAR(255),
		REPORTDEFINITIONPATH VARCHAR(255)
	);

CREATE TABLE PM_REPORTSPROTECTION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		REPORTID VARCHAR(255),
		SHAREUSERID VARCHAR(255),
		ISGROUP VARCHAR(255)
	);

CREATE TABLE PM_REPORTVARIABLE (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		REPORTID VARCHAR(255),
		NAME VARCHAR(255),
		VIEWNAME VARCHAR(255),
		SORTTYPE VARCHAR(255),
		POSITION VARCHAR(255),
		ACTIVE VARCHAR(255),
		GROUPED VARCHAR(255),
		SUM VARCHAR(255),
		AVG VARCHAR(255),
		MIN VARCHAR(255),
		MAX VARCHAR(255),
		COUNT VARCHAR(255)
	);

CREATE TABLE PM_RIGHTS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		RIGHT_TYPE SMALLINT NOT NULL,
		RESOURCE_ID VARCHAR(100) NOT NULL,
		IS_RESOURCE_A_GROUP SMALLINT NOT NULL,
		RIGHT_LEVEL VARCHAR(768) NOT NULL
	);

INSERT INTO PM_RIGHTS (RIGHT_TYPE, RESOURCE_ID, IS_RESOURCE_A_GROUP, RIGHT_LEVEL) VALUES (0,'admin',0,'system');

CREATE TABLE PM_ROLES (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		PACKAGEID VARCHAR(255),
		PROCESSDEFID VARCHAR(255),
		ROLEID VARCHAR(255)
	);

CREATE TABLE PM_SCHEDULED_TASKS (
		SCHEDULED_TASK_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NAME VARCHAR(255),
		DESCRIPTION VARCHAR(255),
		IS_ACTIVE SMALLINT NOT NULL,
		IS_PROCESSING SMALLINT NOT NULL,
		SAVEHISTORY SMALLINT,
		CLASS_NAME VARCHAR(255) NOT NULL,
		METHOD_NAME VARCHAR(255) NOT NULL,
		FIRST_RUN TIMESTAMP NOT NULL,
		NEXT_RUN TIMESTAMP,
		LAST_RUN TIMESTAMP,
		PERIOD_MILISECONDS BIGINT,
		CATEGORY_ID BIGINT
	);

CREATE TABLE PM_SCHEDULED_TASKS_COMPONENT (
    ID bigint PRIMARY KEY NOT NULL,
    PLUGINID VARCHAR(255) NOT NULL,
    SCHEDULEDTASKID bigint NOT NULL
  );

CREATE SEQUENCE PM_SCHEDULEDTASKSCOMP_SEQ
  START WITH 1;

CREATE TABLE PM_SCHEDULED_TASKS_CATEGORY (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		NAME VARCHAR(255) NOT NULL
	);

CREATE TABLE PM_SCHEDULED_TASKS_HISTORY (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		STARTDATE TIMESTAMP NOT NULL,
		FINISHDATE TIMESTAMP,
		SUCCESS SMALLINT NOT NULL,
		RESULT VARCHAR(1000),
		TASKID BIGINT NOT NULL
	);

CREATE TABLE PM_SCHEDULED_TASKS_PARAMETERS (
		SCHEDULED_TASK_PARAMETER_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		PARAMETER_TYPE VARCHAR(255) NOT NULL,
		PARAMETER_VALUE VARCHAR(255) NOT NULL,
		PARAMETER_POSITION INTEGER NOT NULL,
		SCHEDULED_TASK_ID BIGINT NOT NULL
	);

CREATE TABLE pm_substitutions (
	id bigint NOT NULL GENERATED ALWAYS AS IDENTITY(START WITH 1, INCREMENT BY 1),
  	processdefid varchar(255),
  	role bigint ,
  	substituted decimal(19,0) NOT NULL,
  	substitute decimal(19,0) NOT NULL,
  	startdate bigint,
  	finishdate bigint
);

CREATE TABLE PM_SYSVERSION (
	ver varchar(255),
	version decimal(19,2),
	status varchar(255),
	versionorder integer
);

INSERT INTO PM_SYSVERSION (ver,version,status,versionorder) values ('3.1.8',3.1,'COMPLETE',4);

CREATE TABLE PM_UPGRADE_STATUS (
	VERSION VARCHAR(255),
	STATUS VARCHAR(255),
	NAME VARCHAR(255),
	TYPE VARCHAR(255)
);

CREATE TABLE PM_USERCALENDARSHARE (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		OWNERID VARCHAR(255),
		SHAREUSERID VARCHAR(255),
		ISGROUP VARCHAR(255)
	);

CREATE TABLE PM_USERDATA (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		USERID BIGINT NOT NULL,
		USERFIELDNAME VARCHAR(255) NOT NULL,
		USERFIELDVALUE VARCHAR(255)
	);

CREATE TABLE PM_USERSEARCHVIEWS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VAL VARCHAR(4000),
		VIEWNAME VARCHAR(255),
		VIEWDESCR VARCHAR(255),
		ACCESSLEVEL VARCHAR(255),
		SOURCE VARCHAR(255),
		USERNAME VARCHAR(255),
		SHOWFORMONRESULT VARCHAR(255),
		ACCEPTMANYTASKS VARCHAR(255),
		SHOWSEARCHRESULTONRESULT VARCHAR(255)
	);

CREATE TABLE PM_USERSEARCHVIEWSPROTECTION (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VIEWID VARCHAR(255) NOT NULL,
		SHAREUSERID VARCHAR(255),
		ISGROUP VARCHAR(255)
	);

CREATE TABLE PM_USER_NOTIFICATIONS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		SENDER VARCHAR(255) NOT NULL,
		NOTIFDATE TIMESTAMP NOT NULL,
		MESSAGE VARCHAR(4000) NOT NULL,
		RECEIVER VARCHAR(255) NOT NULL,
		CONFIRMED SMALLINT,
		FAILURE SMALLINT
	);

CREATE TABLE PM_USER_NOTIFICATION_CONFIGS (
		ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		PROCESSDEFID VARCHAR(255) NOT NULL,
		LANG VARCHAR(255),
		PROCESSEND VARCHAR(2500),
		ACTIVITYEND VARCHAR(2500),
		ACTIVITYDELIVER VARCHAR(2500),
		ENABLED SMALLINT
	);

CREATE TABLE PM_VARIABLE_DISTINGUISH (
		VARIABLE_DISTINGUISH_ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1 INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE CACHE 20 NO ORDER ),
		VARIABLEID VARCHAR(255),
		VARIABLENAME VARCHAR(255),
		VARIABLEVALUE VARCHAR(1900),
		VARIABLEVALUE2 VARCHAR(255),
		VIEWID VARCHAR(255),
		IMAGEPATH VARCHAR(255),
		VARIABLEVIEWTYPE VARCHAR(255),
		VARIABLEFORMAT VARCHAR(255),
		COLOR VARCHAR(255)
	);

CREATE TABLE PM_VARIABLE_SET_TEMP (
		PROCESS_ID VARCHAR(100) NOT NULL,
		ACTIVITY_ID VARCHAR(100) NOT NULL,
		VARIABLE_ID VARCHAR(100) NOT NULL,
		VARIABLE_VALUE LONG VARCHAR
	);

CREATE TABLE PM_VCOLUMNS (
		TABLEID VARCHAR(255) NOT NULL,
		ID VARCHAR(255) NOT NULL,
		MODIFIED TIMESTAMP NOT NULL,
		NAME VARCHAR(255),
		DESCRIPTION VARCHAR(1024),
		TYPEID VARCHAR(256)
	);

CREATE TABLE PM_VTABLES (
		ID VARCHAR(255) NOT NULL,
		NAME VARCHAR(255),
		DESCRIPTION VARCHAR(1024),
		USERID VARCHAR(255) NOT NULL,
		VTABLE_ROWS INTEGER NOT NULL
	);

CREATE TABLE PM_VTYPES (
		ID VARCHAR(256) NOT NULL,
		NAME VARCHAR(512),
		DESCRIPTION VARCHAR(1024)
	);
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.String', 'napis', 'typ napisowy');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.Float', 'liczba rzeczywista', 'liczba rzeczywista');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.Boolean', 'wartość logiczna', 'wartość logiczna');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.util.Date', 'data', 'data');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.Integer', 'liczba całkowita', 'liczba całkowita');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.Long', 'duża liczba całkowita', 'duża liczba całkowita');
INSERT INTO PM_VTYPES (ID, NAME, DESCRIPTION) VALUES ('java.lang.Double', 'duża liczba rzeczywista', 'duża liczba rzeczywista');

CREATE TABLE PM_VVALUES (
		TABLEID VARCHAR(255) NOT NULL,
		COLUMNID VARCHAR(255) NOT NULL,
		VVALUE_ROWID INTEGER NOT NULL,
		MODIFIED TIMESTAMP NOT NULL,
		CELLVALUE VARCHAR(1024),
		USERID VARCHAR(255) NOT NULL
	);

ALTER TABLE PM_ACTIONS ADD CONSTRAINT SQL140805104037320 PRIMARY KEY
	(ID);

ALTER TABLE PM_ACTIVATEDTIMES ADD CONSTRAINT SQL140805104037450 PRIMARY KEY
	(ID);

ALTER TABLE PM_ACTIVITYCOMMENTS ADD CONSTRAINT SQL140805104041090 PRIMARY KEY
	(ID);

ALTER TABLE PM_ACTIVITYREDIRECTION ADD CONSTRAINT SQL140805104041820 PRIMARY KEY
	(ID);

ALTER TABLE PM_ACTIVITYREDIRECTION_GROUPS ADD CONSTRAINT SQL140805104042290 PRIMARY KEY
	(REDIRECTION,
	 TARGETGROUP);

ALTER TABLE PM_ACTIVITYREDIRECTION_USERS ADD CONSTRAINT SQL140805104042830 PRIMARY KEY
	(REDIRECTION,
	 TARGETUSER);

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT SQL140805104039160 PRIMARY KEY
	(ID);

ALTER TABLE PM_ACTIVITY_STATUS ADD CONSTRAINT SQL140805104039810 PRIMARY KEY
	(STATUS_ID);

ALTER TABLE PM_ACTIVITY_TRANSLATION ADD CONSTRAINT SQL140805104040480 PRIMARY KEY
	(PACKAGEID,
	 PROCESSDEFID,
	 ACTIVITYDEFID,
	 LANGUAGE);

ALTER TABLE PM_ADVANCESEARCHVARIABLES ADD CONSTRAINT SQL140805104043350 PRIMARY KEY
	(ID);

ALTER TABLE PM_AUDITS ADD CONSTRAINT SQL140805104044150 PRIMARY KEY
	(ID);

ALTER TABLE PM_DELEGATEDACTIVITIES ADD CONSTRAINT SQL140805104044660 PRIMARY KEY
	(ID);

ALTER TABLE PM_DEVICES ADD CONSTRAINT SQL140805104045250 PRIMARY KEY
	(ID);

ALTER TABLE PM_DIRECTORIES ADD CONSTRAINT SQL140805104045950 PRIMARY KEY
	(ID);

ALTER TABLE PM_DOCCLASSCONDITIONPROTECTION ADD CONSTRAINT SQL140805104046530 PRIMARY KEY
	(ID);

ALTER TABLE PM_DOCCLASSES ADD CONSTRAINT SQL140805104046780 PRIMARY KEY
	(ID);

ALTER TABLE PM_DOCCLASSES ADD CONSTRAINT UK_CN0LF0L2YUH5UWVPI86BL1DSR UNIQUE
	(DOCCLASSNAME);

ALTER TABLE PM_DOCUMENTTEMPLATE ADD CONSTRAINT SQL140805104046830 PRIMARY KEY
	(ID);

ALTER TABLE PM_DOCUMENT_VIEWS ADD CONSTRAINT SQL140805104036000 PRIMARY KEY
	(DOCUMENT_VIEW_ID);

ALTER TABLE PM_DOMAINSERVERS ADD CONSTRAINT SQL140805104046860 PRIMARY KEY
	(ID);

ALTER TABLE PM_EMAILNOTIFICATION ADD CONSTRAINT SQL140805104046900 PRIMARY KEY
	(ID);

ALTER TABLE PM_FILES ADD CONSTRAINT SQL140805104047100 PRIMARY KEY
	(ID);

ALTER TABLE PM_FILE_VERSIONS ADD CONSTRAINT SQL140805104046960 PRIMARY KEY
	(ID);

ALTER TABLE PM_FILE_VERSIONS ADD CONSTRAINT UK_5G95E5RTEV82DSY4EI5QTNDE2 UNIQUE
	(FILEID);

ALTER TABLE PM_INDECIES ADD CONSTRAINT SQL140805104047290 PRIMARY KEY
	(ID);

ALTER TABLE PM_LICENSE ADD CONSTRAINT SQL140805104047390 PRIMARY KEY
	(ID);

ALTER TABLE PM_TRIAL ADD CONSTRAINT SQL140805104047390 PRIMARY KEY
	(ID);

ALTER TABLE PM_LINKCONNECTION ADD CONSTRAINT SQL140805104047430 PRIMARY KEY
	(ID);

ALTER TABLE PM_LINKINDECIES ADD CONSTRAINT SQL140805104047490 PRIMARY KEY
	(ID);

ALTER TABLE PM_LINKS ADD CONSTRAINT SQL140805104047530 PRIMARY KEY
	(ID);

ALTER TABLE PM_NOTIFICATIONDEF ADD CONSTRAINT SQL140805104047580 PRIMARY KEY
	(ID);

ALTER TABLE PM_NOTIFICATIONPROCACT ADD CONSTRAINT SQL140805104047620 PRIMARY KEY
	(ID);

ALTER TABLE PM_NOTIFICATIONRECIPIENT ADD CONSTRAINT SQL140805104047790 PRIMARY KEY
	(ID);

ALTER TABLE PM_NOTIFICATIONS ADD CONSTRAINT SQL140805104047840 PRIMARY KEY
	(ID);

ALTER TABLE PM_OPENED_FILES ADD CONSTRAINT SQL140805104047900 PRIMARY KEY
	(ID);

ALTER TABLE PM_OPERATION_PANEL ADD CONSTRAINT SQL140805104047940 PRIMARY KEY
	(OPERATION_PANEL_ID);

ALTER TABLE PM_OPERATION_PANEL_PARAMETERS ADD CONSTRAINT SQL140805104048110 PRIMARY KEY
	(OPERATION_PANEL_PARAMETER_ID);

ALTER TABLE PM_ORGANIZATIONALUNITS ADD CONSTRAINT SQL140805104048150 PRIMARY KEY
	(ID);

ALTER TABLE PM_ORGANIZATIONALUNITS ADD CONSTRAINT UK_8TQMIYI7S0FLXYIP7JAGN783L UNIQUE
	(ORGANIZATIONALUNITSYMBOL);

ALTER TABLE PM_PLUGINS_CONFIGURATION ADD CONSTRAINT SQL140805104048190 PRIMARY KEY
	(ID);

ALTER TABLE PM_PLUGINS_CONFIGURATION ADD CONSTRAINT UK_3C75UP0LI4G2D0WAMLDNXW1KR UNIQUE
	(PLUGIN_FILE_MD5);

ALTER TABLE PM_POSITIONS ADD CONSTRAINT SQL140805104048380 PRIMARY KEY
	(ID);

ALTER TABLE PM_POSITIONS ADD CONSTRAINT UK_QYKK3S5TQ5JOIXVFK2DB40F08 UNIQUE
	(POSITIONSYMBOL);

ALTER TABLE PM_POSITION_ROLE ADD CONSTRAINT SQL140805104048310 PRIMARY KEY
	(POSITIONID,
	 ROLEID);

ALTER TABLE PM_PROCESSDATA ADD CONSTRAINT SQL140805104048420 PRIMARY KEY
	(ID);

ALTER TABLE PM_PROCESSTYPES ADD CONSTRAINT SQL140805104048580 PRIMARY KEY
	(ID);

ALTER TABLE PM_PROCESS_TRANSLATION ADD CONSTRAINT SQL140805104048450 PRIMARY KEY
	(PROCESSID,
	 LANGUAGE);

ALTER TABLE PM_REPORTLISTVARIABLEVALUE ADD CONSTRAINT SQL140805104048650 PRIMARY KEY
	(ID);

ALTER TABLE PM_REPORTS ADD CONSTRAINT SQL140805104048740 PRIMARY KEY
	(ID);

ALTER TABLE PM_REPORTSPROTECTION ADD CONSTRAINT SQL140805104048830 PRIMARY KEY
	(ID);

ALTER TABLE PM_REPORTVARIABLE ADD CONSTRAINT SQL140805104048990 PRIMARY KEY
	(ID);

ALTER TABLE PM_RIGHTS ADD CONSTRAINT SQL140805104049080 PRIMARY KEY
	(ID);

ALTER TABLE PM_RIGHTS ADD CONSTRAINT UK_MW4QT93VFVL3ELXFANT6J6M9X UNIQUE
	(RESOURCE_ID,
	 IS_RESOURCE_A_GROUP,
	 RIGHT_LEVEL);

ALTER TABLE PM_ROLES ADD CONSTRAINT SQL140805104049120 PRIMARY KEY
	(ID);

ALTER TABLE PM_SCHEDULED_TASKS ADD CONSTRAINT SQL140805104036130 PRIMARY KEY
	(SCHEDULED_TASK_ID);

ALTER TABLE PM_SCHEDULED_TASKS_CATEGORY ADD CONSTRAINT SQL140805104049190 PRIMARY KEY
	(ID);

ALTER TABLE PM_SCHEDULED_TASKS_CATEGORY ADD CONSTRAINT UK_QT2QKW71TES14FVISAW2IPK0D UNIQUE
	(NAME);

ALTER TABLE PM_SCHEDULED_TASKS_HISTORY ADD CONSTRAINT SQL140805104049230 PRIMARY KEY
	(ID);

ALTER TABLE PM_SCHEDULED_TASKS_PARAMETERS ADD CONSTRAINT SQL140805104036380 PRIMARY KEY
	(SCHEDULED_TASK_PARAMETER_ID);

ALTER TABLE PM_USERCALENDARSHARE ADD CONSTRAINT SQL140805104049280 PRIMARY KEY
	(ID);

ALTER TABLE PM_USERDATA ADD CONSTRAINT SQL140805104049600 PRIMARY KEY
	(ID);

ALTER TABLE PM_USERSEARCHVIEWS ADD CONSTRAINT SQL140805104049630 PRIMARY KEY
	(ID);

ALTER TABLE PM_USERSEARCHVIEWSPROTECTION ADD CONSTRAINT SQL140805104049720 PRIMARY KEY
	(ID);

ALTER TABLE PM_USER_NOTIFICATIONS ADD CONSTRAINT SQL140805104049510 PRIMARY KEY
	(ID);

ALTER TABLE PM_USER_NOTIFICATION_CONFIGS ADD CONSTRAINT SQL140805104049470 PRIMARY KEY
	(ID);

ALTER TABLE PM_VARIABLE_DISTINGUISH ADD CONSTRAINT SQL140805104049760 PRIMARY KEY
	(VARIABLE_DISTINGUISH_ID);

ALTER TABLE PM_VARIABLE_SET_TEMP ADD CONSTRAINT SQL140805104036980 PRIMARY KEY
	(PROCESS_ID,
	 ACTIVITY_ID,
	 VARIABLE_ID);

ALTER TABLE PM_VCOLUMNS ADD CONSTRAINT SQL140805104049880 PRIMARY KEY
	(TABLEID,
	 ID);

ALTER TABLE PM_VTABLES ADD CONSTRAINT SQL140805104049910 PRIMARY KEY
	(ID);

ALTER TABLE PM_VTYPES ADD CONSTRAINT SQL140805104049950 PRIMARY KEY
	(ID);

ALTER TABLE PM_VVALUES ADD CONSTRAINT SQL140805104050030 PRIMARY KEY
	(TABLEID,
	 COLUMNID,
	 VVALUE_ROWID);

INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_usertable', 'plusworkflow', 1482230592284, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_usertable', 'plusworkflow', 1482230592300, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_file_versions', 'plusworkflow', 1482230592315, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_substitutions', 'plusworkflow', 1482230592329, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_notificationprocact', 'plusworkflow', 1482230592343, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usersearchviewsprotection', 'plusworkflow', 1482230592357, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usersearchviews', 'plusworkflow', 1482230592372, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_advancesearchvariables', 'plusworkflow', 1482230592386, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_reportvariable', 'plusworkflow', 1482230592399, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_reports', 'plusworkflow', 1482230592413, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_rights', 'plusworkflow', 1482230592427, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_rights', 'plusworkflow', 1482230592441, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_indecies', 'plusworkflow', 1482230592453, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_notifications', 'plusworkflow', 1482230592465, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_deadlines', 'plusworkflow', 1482230592478, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_deadlines', 'plusworkflow', 1482230592491, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_usergrouptable', 'plusworkflow', 1482230592503, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activity_document', 'plusworkflow', 1482230592515, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_activity_document', 'plusworkflow', 1482230592526, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i03_pm_activity_document', 'plusworkflow', 1482230592538, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i04_pm_activity_document', 'plusworkflow', 1482230592551, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activitycomments', 'plusworkflow', 1482230592562, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_delegatedactivities', 'plusworkflow', 1482230592574, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_delegatedactivities', 'plusworkflow', 1482230592586, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_docclassconditionprotection', 'plusworkflow', 1482230592597, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_docclassconditionprotection', 'plusworkflow', 1482230592609, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_activity_status', 'plusworkflow', 1482230592620, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_document_views', 'plusworkflow', 1482230592632, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_user_notifications', 'plusworkflow', 1482230592643, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i02_pm_user_notifications', 'plusworkflow', 1482230592655, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_i01_pm_usercalendarshare', 'plusworkflow', 1482230592667, 'EXECUTED', '', '3.1.32');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_max_file_size', 'plusworkflow', 1482230592672, 'EXECUTED', '', '3.1.39');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_docclass_protection', 'plusworkflow', 1482230592673, 'EXECUTED', '', '3.1.67');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparameter', 'plusworkflow', 1482230592674, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparametercategory', 'plusworkflow', 1482230592675, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_systemparametercombovalues', 'plusworkflow', 1482230592676, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparameter', 'plusworkflow', 1482230592677, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparametercategory', 'plusworkflow', 1482230592678, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_systemparametercombovalues', 'plusworkflow', 1482230592679, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.Optional_category', 'plusworkflow', 1482230592680, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.Views.Enabled_param', 'plusworkflow', 1482230592681, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_Rights.UserAccount.Enabled_param', 'plusworkflow', 1482230592682, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_General_category', 'plusworkflow', 1482230592683, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_UniversalPassword_param', 'plusworkflow', 1482230592684, 'EXECUTED', '', '3.2.0');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_domain_server_mapping_columns', 'plusworkflow', 1482230592685, 'EXECUTED', '', '3.2.2');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_number_to_long_parameters', 'plusworkflow', 1482230592686, 'EXECUTED', '', '3.2.6');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_valuedouble_column', 'plusworkflow', 1482230592686, 'EXECUTED', '', '3.2.6');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_pm_scheduled_tasks_component', 'plusworkflow', 1482230592687, 'EXECUTED', '', '3.2.12');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_sequence_pm_scheduledtaskscomp_seq', 'plusworkflow', 1482230592688, 'EXECUTED', '', '3.2.12');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_trial', 'plusworkflow', 1482230592689, 'EXECUTED', '', '3.2.15');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_trial_id_seq', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.15');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_externaldb_conf', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_externaldbconf_id_seq', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_pm_querydatachooser_query', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('change_pm_querydatachooser_countquery', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_pm_querydatachooser', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('create_querydatachooser_id_seq', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.20');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_ShowCalendarCart_param', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.31');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('add_cascadeOnDelete_pm_failedloggingregister', 'plusworkflow', 1482230592690, 'EXECUTED', '', '3.2.45');
INSERT INTO DB_CHANGELOG (ID,PROJECT,CHANGE_DATE,CHANGE_RESULT,MESSAGE,VERSION) values ('insert_ShowStatistics_param', 'plusworkflow', 1482230592690, 'EXECUTED', '', '4.0.0');

ALTER TABLE PM_ACTIONS ADD CONSTRAINT FK_J8BPHK6D8HQC438JVBPGLLVK6 FOREIGN KEY
	(DOCCLASSID)
	REFERENCES PM_DOCCLASSES
	(ID);

ALTER TABLE PM_ACTIVITYREDIRECTION ADD CONSTRAINT FK_O6U7QNMFF1AU8ND9PSBQ0S6WS FOREIGN KEY
	(SOURCEUSER)
	REFERENCES USERTABLE
	(OBJECTID);

ALTER TABLE PM_ACTIVITYREDIRECTION_GROUPS ADD CONSTRAINT FK_6VWLTOFSQ2485GHW20XFCLD9M FOREIGN KEY
	(TARGETGROUP)
	REFERENCES GROUPTABLE
	(OBJECTID);

ALTER TABLE PM_ACTIVITYREDIRECTION_GROUPS ADD CONSTRAINT FK_EFYSD6MGPS4UHJ882Y2WJV6CB FOREIGN KEY
	(REDIRECTION)
	REFERENCES PM_ACTIVITYREDIRECTION
	(ID);

ALTER TABLE PM_ACTIVITYREDIRECTION_USERS ADD CONSTRAINT FK_7R86W89TL7E93V6M6X0ATSA56 FOREIGN KEY
	(TARGETUSER)
	REFERENCES USERTABLE
	(OBJECTID);

ALTER TABLE PM_ACTIVITYREDIRECTION_USERS ADD CONSTRAINT FK_JGO839LT6W4NI79G6VJELK6Q8 FOREIGN KEY
	(REDIRECTION)
	REFERENCES PM_ACTIVITYREDIRECTION
	(ID);

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT FK_42WVRBSW0YF0J8HPSKCQ3096W FOREIGN KEY
	(PROCESS)
	REFERENCES PROCESSES
	(OBJECTID);

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT FK_6FBX8827LMFVDPB1G0JCWMNNV FOREIGN KEY
	(FILEID)
	REFERENCES PM_FILES
	(ID);

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT FK_7O8AEHFV9SN3SLVT92LT9QTKM FOREIGN KEY
	(VERSION)
	REFERENCES PM_FILE_VERSIONS
	(ID);

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT FK_92ASSDYL6QAJMNGOSUJR2XHNH FOREIGN KEY
	(ACTIVITY)
	REFERENCES ACTIVITIES
	(OBJECTID)
	ON DELETE CASCADE;

ALTER TABLE PM_ACTIVITY_DOCUMENT ADD CONSTRAINT FK_JDWG9TBE9XDWXC3BHFFDAPS86 FOREIGN KEY
	(USERID)
	REFERENCES USERTABLE
	(OBJECTID);

ALTER TABLE PM_DIRECTORIES ADD CONSTRAINT FK_18U81P51NS1C6MCJVKI6PJ13C FOREIGN KEY
	(ROOTDIRECTORYID)
	REFERENCES PM_DIRECTORIES
	(ID);

ALTER TABLE PM_DIRECTORIES ADD CONSTRAINT FK_85OXBEWNWAUQ6F84AYC8YU26H FOREIGN KEY
	(DEVICEID)
	REFERENCES PM_DEVICES
	(ID);

ALTER TABLE PM_DOCCLASSCONDITIONPROTECTION ADD CONSTRAINT FK_I5CCQELQAXR6IHGG61GCX0UCT FOREIGN KEY
	(DOCCLASSID)
	REFERENCES PM_DOCCLASSES
	(ID);

ALTER TABLE PM_DOCCLASSES ADD CONSTRAINT FK_6LGIBE4CJ428MAHVPATN5SXOM FOREIGN KEY
	(DOCCLASSDIRECTORYID)
	REFERENCES PM_DIRECTORIES
	(ID);

ALTER TABLE PM_FILES ADD CONSTRAINT FK_IYBHE442I7RMBMSH9SAI36AKJ FOREIGN KEY
	(DOCCLASSID)
	REFERENCES PM_DOCCLASSES
	(ID);

ALTER TABLE PM_FILE_VERSIONS ADD CONSTRAINT FK_5G95E5RTEV82DSY4EI5QTNDE2 FOREIGN KEY
	(FILEID)
	REFERENCES PM_FILES
	(ID);

ALTER TABLE PM_FILE_VERSIONS ADD CONSTRAINT FK_72TLBY59E4NYQ7N67L22CD1JV FOREIGN KEY
	(NEWEST_FILEID)
	REFERENCES PM_FILES
	(ID);

ALTER TABLE PM_FILE_VERSIONS ADD CONSTRAINT FK_SOTKPBHYTPGXQCME4613OR9EL FOREIGN KEY
	(PARENT_FILEID)
	REFERENCES PM_FILES
	(ID);

ALTER TABLE PM_INDECIES ADD CONSTRAINT FK_L71M7JDUOKEQBP05NOTE87LK9 FOREIGN KEY
	(DOCCLASSID)
	REFERENCES PM_DOCCLASSES
	(ID);

ALTER TABLE PM_LINKCONNECTION ADD CONSTRAINT FK_3AFP7Q3TABN0CLET0OHTEHJE1 FOREIGN KEY
	(DOCCLASSID)
	REFERENCES PM_DOCCLASSES
	(ID);

ALTER TABLE PM_LINKCONNECTION ADD CONSTRAINT FK_AHQO7IH2HAG0YC9TQY0AVJ8Q5 FOREIGN KEY
	(LINKID)
	REFERENCES PM_LINKS
	(ID);

ALTER TABLE PM_LINKCONNECTION ADD CONSTRAINT FK_D5XSFYMB2EA989YOSRR7K9TCM FOREIGN KEY
	(INDEXID)
	REFERENCES PM_INDECIES
	(ID);

ALTER TABLE PM_LINKCONNECTION ADD CONSTRAINT FK_FCPRTPGA9KXI2VK1P1F9W9TGU FOREIGN KEY
	(LINKINDEXID)
	REFERENCES PM_LINKINDECIES
	(ID);

ALTER TABLE PM_LINKINDECIES ADD CONSTRAINT FK_NU4AJAVO7G1UGNAVUIRSO0O0C FOREIGN KEY
	(LINKID)
	REFERENCES PM_LINKS
	(ID);

ALTER TABLE PM_OPERATION_PANEL_PARAMETERS ADD CONSTRAINT FK_1AGA3412YHJ9JU42EIJRG5V90 FOREIGN KEY
	(OPERATION_PANEL_ID)
	REFERENCES PM_OPERATION_PANEL
	(OPERATION_PANEL_ID);

ALTER TABLE PM_ORGANIZATIONALUNITS ADD CONSTRAINT FK_9AMGDAP6GHG0JPNLT2F3YNOVB FOREIGN KEY
	(HIGHERORGANIZATIONALUNITID)
	REFERENCES PM_ORGANIZATIONALUNITS
	(ID);

ALTER TABLE PM_ORGANIZATIONALUNITS ADD CONSTRAINT FK_OJ19EYKQYP025V0IU7T56KIFO FOREIGN KEY
	(DIRECTORPOSITIONID)
	REFERENCES PM_POSITIONS
	(ID);

ALTER TABLE PM_POSITIONS ADD CONSTRAINT FK_3U1I14XG7C20GXV5T0Q81RILT FOREIGN KEY
	(HIGHERPOSITIONID)
	REFERENCES PM_POSITIONS
	(ID);

ALTER TABLE PM_POSITIONS ADD CONSTRAINT FK_9TA5VW7G06HEAW17JAVV38MNQ FOREIGN KEY
	(USERID)
	REFERENCES USERTABLE
	(OBJECTID);

ALTER TABLE PM_POSITIONS ADD CONSTRAINT FK_L5DL4JFNE63RYTSX0UA7A851E FOREIGN KEY
	(ORGANIZATIONALUNITID)
	REFERENCES PM_ORGANIZATIONALUNITS
	(ID);

ALTER TABLE PM_POSITION_ROLE ADD CONSTRAINT FK_1IPTJPWGFMO8WSVS95SB9UQ0 FOREIGN KEY
	(ROLEID)
	REFERENCES PM_ROLES
	(ID);

ALTER TABLE PM_POSITION_ROLE ADD CONSTRAINT FK_PX59CJC90BSCBJBUIJD2G6E6U FOREIGN KEY
	(POSITIONID)
	REFERENCES PM_POSITIONS
	(ID);

ALTER TABLE PM_SCHEDULED_TASKS ADD CONSTRAINT FK_B29CPXIJG24TEBQPD7LSXLJVM FOREIGN KEY
	(CATEGORY_ID)
	REFERENCES PM_SCHEDULED_TASKS_CATEGORY
	(ID);

ALTER TABLE PM_SCHEDULED_TASKS_HISTORY ADD CONSTRAINT FK_7RHYTF8LRQHL8345F35E3W76E FOREIGN KEY
	(TASKID)
	REFERENCES PM_SCHEDULED_TASKS
	(SCHEDULED_TASK_ID);

ALTER TABLE PM_SCHEDULED_TASKS_PARAMETERS ADD CONSTRAINT FK_G1XSEBBFRUF71FHTVV5THFR3E FOREIGN KEY
	(SCHEDULED_TASK_ID)
	REFERENCES PM_SCHEDULED_TASKS
	(SCHEDULED_TASK_ID);

ALTER TABLE PM_USERDATA ADD CONSTRAINT FK_21DCY78O0PADSBBHB9I3DVOKL FOREIGN KEY
	(USERID)
	REFERENCES USERTABLE
	(OBJECTID);

ALTER TABLE PM_VCOLUMNS ADD CONSTRAINT FK_8SDY1K5RJ0HRRJBTFPLGF4JPL FOREIGN KEY
	(TYPEID)
	REFERENCES PM_VTYPES
	(ID);

ALTER TABLE PM_VCOLUMNS ADD CONSTRAINT FK_LX10IP15RM7V0F0T886PJDM19 FOREIGN KEY
	(TABLEID)
	REFERENCES PM_VTABLES
	(ID);

ALTER TABLE PM_VVALUES ADD CONSTRAINT FK_PS2IW5FJ2HAVS4R2H3AE96OUP FOREIGN KEY
	(TABLEID,
	 COLUMNID)
	REFERENCES PM_VCOLUMNS
	(TABLEID,
	 ID)
	ON DELETE CASCADE;

ALTER TABLE pm_substitutions ADD CONSTRAINT pm_substitutions_pkey PRIMARY KEY (id);
ALTER TABLE pm_substitutions ADD CONSTRAINT pm_s_fk_role FOREIGN KEY (role) REFERENCES pm_roles (id);
ALTER TABLE pm_substitutions ADD CONSTRAINT pm_s_fk_substituted FOREIGN KEY (substituted) REFERENCES usertable (objectid);
ALTER TABLE pm_substitutions ADD CONSTRAINT pm_s_fk_substitute FOREIGN KEY (substitute) REFERENCES usertable (objectid);

CREATE INDEX I01_USERTABLE ON USERTABLE(FIRSTNAME);

CREATE INDEX I02_USERTABLE ON USERTABLE(LASTNAME);

CREATE INDEX I01_PM_FILE_VERSIONS ON PM_FILE_VERSIONS(NEWEST_FILEID);

CREATE INDEX I01_PM_SUBSTITUTIONS ON PM_SUBSTITUTIONS(SUBSTITUTED);

CREATE INDEX I01_PM_NOTIFICATIONPROCACT ON PM_NOTIFICATIONPROCACT(NOTIFICATIONDEFID);

CREATE INDEX I01_PM_USERSEARCHVIEWSPROT ON PM_USERSEARCHVIEWSPROTECTION(SHAREUSERID);

CREATE INDEX I01_PM_USERSEARCHVIEWS ON PM_USERSEARCHVIEWS(USERNAME);

CREATE INDEX I01_PM_ADVANCESEARCHVARIABLES ON PM_ADVANCESEARCHVARIABLES(VIEWID);

CREATE INDEX I01_PM_REPORTVARIABLE ON PM_REPORTVARIABLE(REPORTID);

CREATE INDEX I01_PM_REPORTS ON PM_REPORTS(USERNAME);

CREATE INDEX I01_PM_RIGHTS ON PM_RIGHTS(RIGHT_LEVEL);

CREATE INDEX I02_PM_RIGHTS ON PM_RIGHTS(RESOURCE_ID);

CREATE INDEX I01_PM_INDECIES ON PM_INDECIES(DOCCLASSID);

CREATE INDEX I01_PM_NOTIFICATIONS ON PM_NOTIFICATIONS(PROCESSID);

CREATE INDEX I01_DEADLINES ON DEADLINES(PROCESS);

CREATE INDEX I02_DEADLINES ON DEADLINES(ACTIVITY);

CREATE INDEX I01_USERGROUPTABLE ON USERGROUPTABLE(GROUPID);

CREATE INDEX I01_PM_ACTIVITY_DOCUMENT ON PM_ACTIVITY_DOCUMENT(PROCESS);

CREATE INDEX I02_PM_ACTIVITY_DOCUMENT ON PM_ACTIVITY_DOCUMENT(ACTIVITY);

CREATE INDEX I03_PM_ACTIVITY_DOCUMENT ON PM_ACTIVITY_DOCUMENT(FILEID);

CREATE INDEX I04_PM_ACTIVITY_DOCUMENT ON PM_ACTIVITY_DOCUMENT(USERID);

CREATE INDEX I01_PM_ACTIVITYCOMMENTS ON PM_ACTIVITYCOMMENTS(PROCESSID);

CREATE INDEX I01_PM_DELEGATEDACTIVITIES ON PM_DELEGATEDACTIVITIES(ACTIVITYID);

CREATE INDEX I02_PM_DELEGATEDACTIVITIES ON PM_DELEGATEDACTIVITIES(DELEGATEDUSER);

CREATE INDEX I01_PM_DOCCLASSCONDITIONPROT ON PM_DOCCLASSCONDITIONPROTECTION(DOCCLASSID);

CREATE INDEX I02_PM_DOCCLASSCONDITIONPROT ON PM_DOCCLASSCONDITIONPROTECTION(USERID);

CREATE INDEX I01_PM_ACTIVITY_STATUS ON PM_ACTIVITY_STATUS(PROCESS_ID,STATUS_TYPE,STATUS_IS_NEWEST,STATUS_ID,ACTIVITY_ID);

CREATE INDEX I01_PM_DOCUMENT_VIEWS ON PM_DOCUMENT_VIEWS(PROC_DEF_ID);

CREATE INDEX I01_PM_USER_NOTIFICATIONS ON PM_USER_NOTIFICATIONS(RECEIVER,CONFIRMED);

CREATE INDEX I02_PM_USER_NOTIFICATIONS ON PM_USER_NOTIFICATIONS(RECEIVER,FAILURE);

CREATE INDEX I01_PM_USERCALENDARSHARE ON PM_USERCALENDARSHARE(SHAREUSERID);

CREATE INDEX I4_ACTIVITIES ON ACTIVITIES( PROCESSID );

CREATE INDEX I1_PM_AUDITS ON PM_AUDITS
(
  USERID,
  AUDITTYPE,
  AUDITSTARTED,
  AUDITSTOPPED
);
