/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.plusmpm.security.TextCipher;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Objects;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailParameterMigrationChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(EmailParameterMigrationChange.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        SqlStatement[] sqlStatementArray;
        block22: {
            JdbcConnection connection = (JdbcConnection)database.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * from pm_systemparameter WHERE parameterkey LIKE('DefaultMailMessageHandler.%')");
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                while (resultSet.next()) {
                    String key = resultSet.getString("parameterkey");
                    SqlStatement[] type = resultSet.getString("parametertype");
                    Object value = null;
                    switch (type) {
                        case "LONG": {
                            value = resultSet.getLong("valuelong");
                            break;
                        }
                        case "BOOLEAN": {
                            value = resultSet.getBoolean("valuebool");
                            break;
                        }
                        case "TEXT": {
                            value = resultSet.getString("valuestring");
                            break;
                        }
                        case "PASSWORD": {
                            String password = resultSet.getString("valuestring");
                            if (!Objects.nonNull(password)) break;
                            value = TextCipher.decrypt((String)password);
                        }
                    }
                    parameters.put(key, (String)value);
                }
                Boolean smtpAuth = (Boolean)parameters.get("DefaultMailMessageHandler.SMTPAuth");
                String emailAuthenticationMethod = smtpAuth != false ? "PASSWORD" : "NONE";
                InsertStatement insertStatement = new InsertStatement("", "", "pm_email_config");
                if (!(database instanceof MSSQLDatabase)) {
                    insertStatement.addColumn(this.createSequence());
                }
                insertStatement.addColumnValue("name", (Object)"System").addColumnValue("email", parameters.get("DefaultMailMessageHandler.Email")).addColumnValue("defaultconfiguration", (Object)true).addColumnValue("mailserver", parameters.get("DefaultMailMessageHandler.MailServer")).addColumnValue("smtpmailserver", parameters.get("DefaultMailMessageHandler.SMTPMailServer")).addColumnValue("smtpportnumber", parameters.get("DefaultMailMessageHandler.SMTPPortNo")).addColumnValue("sourceaddress", parameters.get("DefaultMailMessageHandler.SourceAddress")).addColumnValue("timeout", parameters.get("DefaultMailMessageHandler.Timeout")).addColumnValue("mailuser", parameters.get("DefaultMailMessageHandler.User")).addColumnValue("usessl", parameters.get("DefaultMailMessageHandler.UseSSL")).addColumnValue("usestarttls", parameters.get("DefaultMailMessageHandler.UseSTARTTLS")).addColumnValue("smtpuser", parameters.get("DefaultMailMessageHandler.SMTPUser")).addColumnValue("userpassword", parameters.get("DefaultMailMessageHandler.UserPassword")).addColumnValue("debug", parameters.get("DefaultMailMessageHandler.Debug")).addColumnValue("emailauthenticationmethod", (Object)emailAuthenticationMethod).addColumnValue("oauthconnection", null);
                sqlStatementArray = new SqlStatement[]{insertStatement};
                if (resultSet == null) break block22;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resultSet.close();
        }
        return sqlStatementArray;
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_email_config_id_seq"));
        return config;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

