/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Objects;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailParameterMigrationChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(EmailParameterMigrationChange.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * from pm_systemparameter WHERE parameterkey LIKE('DefaultMailMessageHandler.%')");
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (resultSet.next()) {
                String key = resultSet.getString("parameterkey");
                SqlStatement[] type = resultSet.getString("parametertype");
                Object value = null;
                switch (type) {
                    case "LONG": {
                        value = resultSet.getLong("valuelong");
                        break;
                    }
                    case "BOOLEAN": {
                        value = resultSet.getBoolean("valuebool");
                        break;
                    }
                    case "TEXT": {
                        value = resultSet.getString("valuestring");
                        break;
                    }
                    case "PASSWORD": {
                        String password = resultSet.getString("valuestring");
                        if (!Objects.nonNull(password)) break;
                        value = TextCipher.decrypt((String)password);
                        break;
                    }
                }
                parameters.put(key, (String)value);
            }
            Boolean smtpAuth = (Boolean)parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPAUTH.getKey());
            String emailAuthenticationMethod = smtpAuth != false ? "PASSWORD" : "NONE";
            InsertStatement insertStatement = new InsertStatement("", "", "pm_email_config");
            if (!(database instanceof MSSQLDatabase)) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("name", (Object)"System").addColumnValue("email", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_EMAIL.getKey())).addColumnValue("defaultconfiguration", (Object)true).addColumnValue("mailserver", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_MAILSERVER.getKey())).addColumnValue("smtpmailserver", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPMAILSERVER.getKey())).addColumnValue("smtpportnumber", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPPORTNO.getKey())).addColumnValue("sourceaddress", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SOURCEADDRESS.getKey())).addColumnValue("timeout", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_TIMEOUT.getKey())).addColumnValue("mailuser", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USER.getKey())).addColumnValue("usessl", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESSL.getKey())).addColumnValue("usestarttls", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESTARTTLS.getKey())).addColumnValue("smtpuser", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPUSER.getKey())).addColumnValue("userpassword", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USERPASSWORD.getKey())).addColumnValue("debug", parameters.get(DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_DEBUG.getKey())).addColumnValue("emailauthenticationmethod", (Object)emailAuthenticationMethod).addColumnValue("oauthconnection", null);
            SqlStatement[] sqlStatementArray = new SqlStatement[]{insertStatement};
            return sqlStatementArray;
        }
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_email_config_id_seq"));
        return config;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

