/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.apache.commons.lang3.StringUtils;

public class AddHolidaysToCustomHolidaysSystemParameter
implements CustomSqlChange {
    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        return this.generateUpdateStatements((JdbcConnection)database.getConnection());
    }

    private SqlStatement[] generateUpdateStatements(JdbcConnection connection) throws DatabaseException, SQLException {
        String customHolidaysQuery = "SELECT valuestring FROM pm_systemparameter WHERE parameterkey = 'CustomHolidays'";
        PreparedStatement customHolidaysPreparedStatement = connection.prepareStatement(customHolidaysQuery);
        ResultSet customHolidaysResultSet = customHolidaysPreparedStatement.executeQuery();
        HashSet<String> customHolidays = new HashSet<String>();
        List<String> systemHolidays = Arrays.asList("01-01", "05-01", "05-03", "08-15", "11-01", "11-11", "12-25", "12-26");
        customHolidays.addAll(systemHolidays);
        while (customHolidaysResultSet.next()) {
            String existedCustomHolidays = customHolidaysResultSet.getString("valuestring");
            if (!StringUtils.isNotBlank((CharSequence)existedCustomHolidays)) continue;
            customHolidays.addAll(Arrays.asList(existedCustomHolidays.split(";")).stream().collect(Collectors.toList()));
        }
        String updateValue = customHolidays.stream().collect(Collectors.joining(";"));
        String updateCustomHolidaysParameterStatement = "UPDATE pm_systemparameter SET valuestring = '" + updateValue + "' WHERE parameterkey = 'CustomHolidays'";
        return new SqlStatement[]{new RawSqlStatement(updateCustomHolidaysParameterStatement)};
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

