/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.indexes.dao;

import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.changes.indexes.domain.IndexUpgraderDomain;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.statement.core.UpdateStatement;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUpgraderDao {
    private static final Logger log = LoggerFactory.getLogger(IndexUpgraderDao.class);
    private static String SELECT_INDEXES_QUERY = "SELECT pm_indecies.id as id, pm_indecies.indexname as name, pm_indecies.indextype as type, pm_docclasses.id as documentClassId\nFROM pm_indecies\nJOIN pm_docclasses ON pm_indecies.docclassid = pm_docclasses.id";
    @NonNull
    private Database database;
    @NonNull
    private JdbcConnection connection;

    public List<IndexUpgraderDomain> getAll() throws DatabaseException, SQLException {
        return this.getByType(null);
    }

    public List<IndexUpgraderDomain> getByType(IndexType type) throws DatabaseException, SQLException {
        if (type != null) {
            SELECT_INDEXES_QUERY = String.format(SELECT_INDEXES_QUERY + " where indextype = '%s'", type.toString());
        }
        PreparedStatement statement = this.connection.prepareStatement(SELECT_INDEXES_QUERY);
        return this.toList(statement.executeQuery());
    }

    private List<IndexUpgraderDomain> toList(ResultSet resultSet) throws SQLException {
        LinkedList<IndexUpgraderDomain> list = new LinkedList<IndexUpgraderDomain>();
        while (resultSet.next()) {
            list.add(this.toDomain(resultSet));
        }
        return list;
    }

    private IndexUpgraderDomain toDomain(ResultSet resultSet) throws SQLException {
        return IndexUpgraderDomain.builder().id(resultSet.getLong("id")).name(resultSet.getString("name")).type(IndexType.getType((String)resultSet.getString("type"))).documentClassId(resultSet.getLong("documentClassId")).build();
    }

    public UpdateStatement generateStringValueUpdateStatement(IndexUpgraderDomain index, String value, String whereValueEquals) {
        UpdateStatement statement = new UpdateStatement("", "", this.getDocumentClassTableName(index.getDocumentClassId()));
        String columnName = this.getIndexColumnName(index.getId());
        statement.addNewColumnValue(columnName, (Object)value);
        statement.setWhereClause(columnName + " = '" + whereValueEquals + "'");
        return statement;
    }

    public String getDocumentClassTableName(Long documentClassId) {
        return "pm_idx000" + documentClassId;
    }

    public String getIndexColumnName(Long indexId) {
        return "idx000" + indexId;
    }

    private boolean isIndexOfGivenType(String indexColumn, String documentClassTable, Class<?> type) throws SQLException, DatabaseException {
        String query = String.format("SELECT %s FROM %s where id = 1", indexColumn, documentClassTable);
        PreparedStatement statement = this.connection.prepareStatement(query);
        ResultSetMetaData metaData = statement.executeQuery().getMetaData();
        return type.getName().equals(metaData.getColumnClassName(1));
    }

    public void changeDatetimeToTimestampIfNecessary(String indexColumn, String documentClassTable) throws DatabaseException, SQLException {
        if (this.isIndexOfGivenType(indexColumn, documentClassTable, String.class)) {
            switch (this.database.getShortName()) {
                case "mssql": {
                    String tempColumnName = indexColumn + "t";
                    this.executeUpdateStatement(String.format("ALTER TABLE %s ADD %s datetime", documentClassTable, tempColumnName));
                    this.executeUpdateStatement(String.format("UPDATE %s SET %s = CAST(SUBSTRING(%s, 1, 19) as datetime)", documentClassTable, tempColumnName, indexColumn));
                    this.executeUpdateStatement(String.format("ALTER TABLE %s DROP COLUMN %s", documentClassTable, indexColumn));
                    this.executeUpdateStatement(String.format("EXEC sp_rename '%s', '%s', 'COLUMN'", documentClassTable + "." + tempColumnName, indexColumn));
                    break;
                }
                case "postgresql": {
                    this.executeUpdateStatement(String.format("ALTER TABLE %s ALTER COLUMN %s TYPE timestamp using to_timestamp(%s,'YYYY-MM-DD HH24:MI:SS')", documentClassTable, indexColumn, indexColumn));
                    break;
                }
                case "oracle": {
                    this.executeUpdateStatement(String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", documentClassTable, indexColumn, indexColumn + "old"));
                    this.executeUpdateStatement(String.format("ALTER TABLE %s ADD %s timestamp NULL", documentClassTable, indexColumn));
                    break;
                }
                case "db2": {
                    break;
                }
            }
        }
    }

    private void executeUpdateStatement(String statement) throws DatabaseException, SQLException {
        this.connection.prepareStatement(statement).executeUpdate();
    }

    @ConstructorProperties(value={"database", "connection"})
    public IndexUpgraderDao(@NonNull Database database, @NonNull JdbcConnection connection) {
        if (database == null) {
            throw new NullPointerException("database");
        }
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.database = database;
        this.connection = connection;
    }
}

