/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterColumnDefinitionChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(AlterColumnDefinitionChange.class);
    private static final String GET_COLUMN_TYPE_MSSQL_QUERY = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
    private static final String GET_COLUMN_TYPE_DB2_QUERY = "SELECT TYPENAME, LENGTH FROM SYSCAT.COLUMNS WHERE TABNAME = ? AND COLNAME = ?";
    private String tableName;
    private String columnName;
    private String sourceTableName;
    private String sourceColumnName;
    private String nullable;

    public void setUp() {
        assert (StringUtils.isNotBlank((CharSequence)this.tableName));
        assert (StringUtils.isNotBlank((CharSequence)this.columnName));
        assert (StringUtils.isNotBlank((CharSequence)this.sourceTableName));
        assert (StringUtils.isNotBlank((CharSequence)this.sourceColumnName));
        this.nullable = (String)StringUtils.defaultIfBlank((CharSequence)this.nullable, (CharSequence)Boolean.TRUE.toString());
    }

    public SqlStatement[] generateStatements(Database database) {
        if (this.isMssql(database).booleanValue()) {
            String columnType = this.getColumnDefinitionForMSSQL(database, this.sourceTableName, this.sourceColumnName);
            ModifyDataTypeStatement statement = new ModifyDataTypeStatement("", "", this.tableName, this.columnName, columnType);
            return new ModifyDataTypeStatement[]{statement};
        }
        if (this.isDB2(database).booleanValue()) {
            String columnType = this.getColumnDefinitionForDB2(database, this.sourceTableName, this.sourceColumnName);
            ModifyDataTypeStatement statement = new ModifyDataTypeStatement("", "", this.tableName, this.columnName, columnType);
            ReorganizeTableStatement statementReog = new ReorganizeTableStatement("", "", this.tableName);
            return new AbstractSqlStatement[]{statement, statementReog};
        }
        log.info("Database is not type of MSSQL or DB2. Ignoring change " + this.getClass().getName() + ": " + this.toString());
        return new ModifyDataTypeStatement[0];
    }

    private Boolean isMssql(Database database) {
        return database instanceof MSSQLDatabase;
    }

    private Boolean isDB2(Database database) {
        return database instanceof DB2Database;
    }

    private String getColumnDefinitionForMSSQL(Database database, String tableName, String columnName) throws DatabaseException, SQLException {
        ResultSet resultSet = this.getColumnDefinitionResultSet(database, tableName, columnName, GET_COLUMN_TYPE_MSSQL_QUERY);
        if (resultSet.next()) {
            return this.resolveMSSQLColumnDefinition(resultSet);
        }
        throw new IllegalArgumentException("Table " + tableName + " with column " + columnName + " does not exist");
    }

    private String getColumnDefinitionForDB2(Database database, String tableName, String columnName) throws DatabaseException, SQLException {
        ResultSet resultSet = this.getColumnDefinitionResultSet(database, tableName.toUpperCase(), columnName.toUpperCase(), GET_COLUMN_TYPE_DB2_QUERY);
        if (resultSet.next()) {
            return this.resolveDB2ColumnDefinition(resultSet);
        }
        throw new IllegalArgumentException("Table " + tableName + " with column " + columnName + " does not exist");
    }

    private ResultSet getColumnDefinitionResultSet(Database database, String tableName, String columnName, String getColumnTypeQuery) throws SQLException, DatabaseException {
        JdbcConnection conn = (JdbcConnection)database.getConnection();
        PreparedStatement statement = conn.prepareStatement(getColumnTypeQuery);
        statement.setString(1, tableName);
        statement.setString(2, columnName);
        return statement.executeQuery();
    }

    private String resolveMSSQLColumnDefinition(ResultSet resultSet) throws SQLException {
        String rawDataType;
        String columnDefinition = rawDataType = resultSet.getString("DATA_TYPE");
        if (rawDataType.equals("numeric") || rawDataType.equals("decimal")) {
            columnDefinition = columnDefinition + String.format("(%d,%d)", resultSet.getInt("NUMERIC_PRECISION"), resultSet.getInt("NUMERIC_SCALE"));
        } else if (rawDataType.equals("varchar")) {
            columnDefinition = columnDefinition + String.format("(%d)", resultSet.getInt("CHARACTER_MAXIMUM_LENGTH"));
        }
        Boolean isNullable = Boolean.valueOf(this.nullable);
        if (!isNullable.booleanValue()) {
            columnDefinition = columnDefinition + " NOT NULL";
        }
        return columnDefinition;
    }

    private String resolveDB2ColumnDefinition(ResultSet resultSet) throws SQLException {
        String rawDataType;
        String columnDefinition = rawDataType = resultSet.getString("TYPENAME");
        if (rawDataType.equals("DECIMAL")) {
            columnDefinition = columnDefinition + String.format("(%d)", resultSet.getInt("LENGTH"));
        }
        return columnDefinition;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getSourceColumnName() {
        return this.sourceColumnName;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public void setSourceColumnName(String sourceColumnName) {
        this.sourceColumnName = sourceColumnName;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return "AlterColumnDefinitionChange(tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ", sourceTableName=" + this.getSourceTableName() + ", sourceColumnName=" + this.getSourceColumnName() + ", nullable=" + this.getNullable() + ")";
    }
}

