﻿--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner:
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner:
--


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: activities; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activities (
    id character varying(100) NOT NULL,
    activitysetdefinitionid character varying(90),
    activitydefinitionid character varying(90) NOT NULL,
    process numeric(19,0) NOT NULL,
    theresource numeric(19,0),
    pdefname character varying(200) NOT NULL,
    processid character varying(200) NOT NULL,
    resourceid character varying(100),
    state numeric(19,0) NOT NULL,
    blockactivityid character varying(100),
    performer character varying(100),
    isperformerasynchronous character varying(100),
    priority integer,
    name character varying(254),
    activated bigint NOT NULL,
    accepted bigint,
    laststatetime bigint NOT NULL,
    limittime bigint NOT NULL,
    description character varying(254),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activities OWNER TO CURRENT_USER;

--
-- Name: activitydata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activitydata (
    activity numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevalue bytea,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    isresult character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activitydata OWNER TO CURRENT_USER;

--
-- Name: activitydatablobs; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activitydatablobs (
    activitydatawob numeric(19,0) NOT NULL,
    variablevalue bytea,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activitydatablobs OWNER TO CURRENT_USER;

--
-- Name: activitydatawob; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activitydatawob (
    activity numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    isresult character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activitydatawob OWNER TO CURRENT_USER;

--
-- Name: activitystateeventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activitystateeventaudits (
    keyvalue character varying(30) NOT NULL,
    name character varying(50) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activitystateeventaudits OWNER TO CURRENT_USER;

--
-- Name: activitystates; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE activitystates (
    keyvalue character varying(30) NOT NULL,
    name character varying(50) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.activitystates OWNER TO CURRENT_USER;

--
-- Name: andjointable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE andjointable (
    process numeric(19,0) NOT NULL,
    activitysetdefinitionid character varying(90),
    activitydefinitionid character varying(90) NOT NULL,
    activity numeric(19,0) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.andjointable OWNER TO CURRENT_USER;

--
-- Name: assignmenteventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE assignmenteventaudits (
    utctime character varying(254) NOT NULL,
    thetype numeric(19,0) NOT NULL,
    activityid character varying(100) NOT NULL,
    activityname character varying(254),
    processid character varying(100) NOT NULL,
    processname character varying(254),
    processdefinitionname character varying(200) NOT NULL,
    processdefinitionversion character varying(20) NOT NULL,
    activitydefinitionid character varying(90) NOT NULL,
    activitysetdefinitionid character varying(90),
    processdefinitionid character varying(90) NOT NULL,
    packageid character varying(90) NOT NULL,
    oldresourceusername character varying(100),
    oldresourcename character varying(100),
    newresourceusername character varying(100) NOT NULL,
    newresourcename character varying(100),
    isaccepted character varying(100) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.assignmenteventaudits OWNER TO CURRENT_USER;

--
-- Name: assignmentstable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE assignmentstable (
    activity numeric(19,0) NOT NULL,
    theresource numeric(19,0) NOT NULL,
    activityid character varying(100) NOT NULL,
    activityprocessid character varying(100) NOT NULL,
    activityprocessdefname character varying(200) NOT NULL,
    resourceid character varying(100) NOT NULL,
    isaccepted character varying(100) NOT NULL,
    isvalid character varying(100) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.assignmentstable OWNER TO CURRENT_USER;

--
-- Name: counters; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE counters (
    name character varying(100) NOT NULL,
    the_number numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.counters OWNER TO CURRENT_USER;

--
-- Name: createprocesseventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE createprocesseventaudits (
    utctime character varying(254) NOT NULL,
    thetype numeric(19,0) NOT NULL,
    processid character varying(100) NOT NULL,
    processname character varying(254),
    processdefinitionname character varying(200) NOT NULL,
    processdefinitionversion character varying(20) NOT NULL,
    processdefinitionid character varying(90) NOT NULL,
    packageid character varying(90) NOT NULL,
    pactivityid character varying(100),
    pprocessid character varying(100),
    pprocessname character varying(254),
    pprocessdefinitionname character varying(200),
    pprocessdefinitionversion character varying(20),
    pactivitydefinitionid character varying(90),
    pactivitysetdefinitionid character varying(90),
    pprocessdefinitionid character varying(90),
    ppackageid character varying(90),
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.createprocesseventaudits OWNER TO CURRENT_USER;

--
-- Name: dataeventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE dataeventaudits (
    utctime character varying(254) NOT NULL,
    thetype numeric(19,0) NOT NULL,
    activityid character varying(100),
    activityname character varying(254),
    processid character varying(100) NOT NULL,
    processname character varying(254),
    processdefinitionname character varying(200) NOT NULL,
    processdefinitionversion character varying(20) NOT NULL,
    activitydefinitionid character varying(90),
    activitysetdefinitionid character varying(90),
    processdefinitionid character varying(90) NOT NULL,
    packageid character varying(90) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.dataeventaudits OWNER TO CURRENT_USER;

--
-- Name: deadlines; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE deadlines (
    process numeric(19,0) NOT NULL,
    activity numeric(19,0) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    timelimit bigint NOT NULL,
    exceptionname character varying(100) NOT NULL,
    issynchronous character varying(100) NOT NULL,
    isexecuted character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.deadlines OWNER TO CURRENT_USER;

--
-- Name: eventtypes; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE eventtypes (
    keyvalue character varying(30) NOT NULL,
    name character varying(50) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.eventtypes OWNER TO CURRENT_USER;

--
-- Name: file_versions_file_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE file_versions_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.file_versions_file_id_seq OWNER TO CURRENT_USER;

--
-- Name: files_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.files_id_seq OWNER TO CURRENT_USER;

--
-- Name: groupgrouptable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE groupgrouptable (
    sub_gid numeric(19,0) NOT NULL,
    groupid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.groupgrouptable OWNER TO CURRENT_USER;

--
-- Name: grouptable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE grouptable (
    groupid character varying(100) NOT NULL,
    description character varying(254),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.grouptable OWNER TO CURRENT_USER;

--
-- Name: groupuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE groupuser (
    username character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.groupuser OWNER TO CURRENT_USER;

--
-- Name: groupuserpacklevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE groupuserpacklevelparticipant (
    participantoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.groupuserpacklevelparticipant OWNER TO CURRENT_USER;

--
-- Name: groupuserproclevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE groupuserproclevelparticipant (
    participantoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.groupuserproclevelparticipant OWNER TO CURRENT_USER;

--
-- Name: locktable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE locktable (
    enginename character varying(100) NOT NULL,
    id character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.locktable OWNER TO CURRENT_USER;

--
-- Name: neweventauditdata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE neweventauditdata (
    dataeventaudit numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevalue bytea,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.neweventauditdata OWNER TO CURRENT_USER;

--
-- Name: neweventauditdatablobs; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE neweventauditdatablobs (
    neweventauditdatawob numeric(19,0) NOT NULL,
    variablevalue bytea,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.neweventauditdatablobs OWNER TO CURRENT_USER;

--
-- Name: neweventauditdatawob; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE neweventauditdatawob (
    dataeventaudit numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.neweventauditdatawob OWNER TO CURRENT_USER;

--
-- Name: nextxpdlversions; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE nextxpdlversions (
    xpdlid character varying(90) NOT NULL,
    nextversion character varying(20) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.nextxpdlversions OWNER TO CURRENT_USER;

--
-- Name: normaluser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE normaluser (
    username character varying(100) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.normaluser OWNER TO CURRENT_USER;

--
-- Name: objectid; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE objectid (
    next numeric(19,0) NOT NULL
);


ALTER TABLE public.objectid OWNER TO CURRENT_USER;

--
-- Name: oldeventauditdata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE oldeventauditdata (
    dataeventaudit numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevalue bytea,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.oldeventauditdata OWNER TO CURRENT_USER;

--
-- Name: oldeventauditdatablobs; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE oldeventauditdatablobs (
    oldeventauditdatawob numeric(19,0) NOT NULL,
    variablevalue bytea,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.oldeventauditdatablobs OWNER TO CURRENT_USER;

--
-- Name: oldeventauditdatawob; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE oldeventauditdatawob (
    dataeventaudit numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.oldeventauditdatawob OWNER TO CURRENT_USER;

--
-- Name: opened_files_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE opened_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opened_files_id_seq OWNER TO CURRENT_USER;

--
-- Name: packlevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelparticipant (
    participant_id character varying(90) NOT NULL,
    packageoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelparticipant OWNER TO CURRENT_USER;

--
-- Name: packlevelxpdlapp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelxpdlapp (
    application_id character varying(90) NOT NULL,
    packageoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelxpdlapp OWNER TO CURRENT_USER;

--
-- Name: packlevelxpdlapptaappdetail; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelxpdlapptaappdetail (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelxpdlapptaappdetail OWNER TO CURRENT_USER;

--
-- Name: packlevelxpdlapptaappdetailusr; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelxpdlapptaappdetailusr (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelxpdlapptaappdetailusr OWNER TO CURRENT_USER;

--
-- Name: packlevelxpdlapptaappuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelxpdlapptaappuser (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelxpdlapptaappuser OWNER TO CURRENT_USER;

--
-- Name: packlevelxpdlapptoolagentapp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE packlevelxpdlapptoolagentapp (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.packlevelxpdlapptoolagentapp OWNER TO CURRENT_USER;

--
-- Name: pm_actions; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_actions (
    id bigint NOT NULL,
    docclassid bigint,
    actionname character varying(255),
    actionsource character varying(255),
    actiontype character varying(255),
    actionvalue character varying(255),
    actionvalue2 character varying(4000)
);


ALTER TABLE public.pm_actions OWNER TO CURRENT_USER;

--
-- Name: pm_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_actions_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_activatedtimes; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activatedtimes (
    id bigint NOT NULL,
    activityid character varying(255),
    activatedtime bigint,
    activated bigint
);


ALTER TABLE public.pm_activatedtimes OWNER TO CURRENT_USER;

--
-- Name: pm_activatedtimes_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_activatedtimes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_activatedtimes_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_activity_document; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activity_document (
    id bigint NOT NULL,
    date timestamp without time zone NOT NULL,
    activity numeric(19,0),
    process numeric(19,0) NOT NULL,
    userid numeric(19,0) NOT NULL,
    fileid bigint NOT NULL,
    version bigint NOT NULL,
    addedhere boolean NOT NULL
);


ALTER TABLE public.pm_activity_document OWNER TO CURRENT_USER;

--
-- Name: pm_activity_document_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_activity_document_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_activity_document_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_activity_status; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activity_status (
    status_id bigint NOT NULL,
    process_id character varying(100) NOT NULL,
    activity_id character varying(100) NOT NULL,
    activity_acceptance_time bigint,
    status_type integer NOT NULL,
    status_is_newest boolean NOT NULL,
    status_date timestamp without time zone NOT NULL,
    status_author character varying(100) NOT NULL,
    status_message text,
    check_form_accept boolean
);


ALTER TABLE public.pm_activity_status OWNER TO CURRENT_USER;

--
-- Name: pm_activity_translation; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activity_translation (
    packageid character varying(254) NOT NULL,
    processdefid character varying(254) NOT NULL,
    activitydefid character varying(254) NOT NULL,
    language character varying(254) NOT NULL,
    name character varying(254),
    description text
);


ALTER TABLE public.pm_activity_translation OWNER TO CURRENT_USER;

--
-- Name: pm_activitycomments; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activitycomments (
    id bigint NOT NULL,
    processid character varying(255),
    activityid character varying(255),
    userid character varying(255),
    activity_comment character varying(4000),
    "timestamp" bigint
);


ALTER TABLE public.pm_activitycomments OWNER TO CURRENT_USER;

--
-- Name: pm_activitycomments_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_activitycomments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_activitycomments_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_activityredirection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activityredirection (
    id bigint NOT NULL,
    activitydefid character varying(255),
    processdefid character varying(255),
    sourceuser numeric(19,0)
);


ALTER TABLE public.pm_activityredirection OWNER TO CURRENT_USER;

--
-- Name: pm_activityredirection_groups; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activityredirection_groups (
    redirection bigint NOT NULL,
    targetgroup numeric(19,0) NOT NULL
);


ALTER TABLE public.pm_activityredirection_groups OWNER TO CURRENT_USER;

--
-- Name: pm_activityredirection_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_activityredirection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_activityredirection_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_activityredirection_users; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_activityredirection_users (
    redirection bigint NOT NULL,
    targetuser numeric(19,0) NOT NULL
);


ALTER TABLE public.pm_activityredirection_users OWNER TO CURRENT_USER;

--
-- Name: pm_advancesearchvariables; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_advancesearchvariables (
    id bigint NOT NULL,
    viewid character varying(255),
    name character varying(255),
    value character varying(1024),
    value2 character varying(1024),
    sorttype character varying(255),
    "position" character varying(255),
    active character varying(255),
    uppercase character varying(255)
);


ALTER TABLE public.pm_advancesearchvariables OWNER TO CURRENT_USER;

--
-- Name: pm_as_status_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_as_status_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_as_status_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_asv_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_asv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_asv_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_audits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_audits (
    id bigint NOT NULL,
    userid character varying(128),
    ipaddress character varying(255),
    threadid character varying(255),
    audittype character varying(255),
    auditstarted bigint,
    auditstopped bigint,
    auditduration bigint,
    auditsuccess boolean,
    auditparams text
);


ALTER TABLE public.pm_audits OWNER TO CURRENT_USER;

--
-- Name: pm_audits_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_audits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_audits_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_dccp_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_dccp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_dccp_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_delegatedactivities; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_delegatedactivities (
    id bigint NOT NULL,
    activityid character varying(255),
    userid character varying(255),
    delegateduser character varying(255),
    transfertype character varying(20) NOT NULL,
    inactive boolean
);


ALTER TABLE public.pm_delegatedactivities OWNER TO CURRENT_USER;

--
-- Name: pm_delegatedactivities_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_delegatedactivities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_delegatedactivities_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_devices; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_devices (
    id bigint NOT NULL,
    devicefreespace bigint,
    devicename character varying(255),
    devicepath character varying(255),
    devicesize bigint
);


ALTER TABLE public.pm_devices OWNER TO CURRENT_USER;

--
-- Name: pm_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_devices_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_directories; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_directories (
    id bigint NOT NULL,
    directoryfreespace bigint,
    directoryname character varying(255),
    directorysize bigint,
    directorythreshold bigint,
    deviceid bigint,
    rootdirectoryid bigint
);


ALTER TABLE public.pm_directories OWNER TO CURRENT_USER;

--
-- Name: pm_directories_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_directories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_directories_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_docclassconditionprotection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_docclassconditionprotection (
    id bigint NOT NULL,
    condition character varying(255),
    conditiontype character varying(255),
    isgroup boolean NOT NULL,
    protector character varying(255),
    userid character varying(255),
    docclassid bigint
);


ALTER TABLE public.pm_docclassconditionprotection OWNER TO CURRENT_USER;

--
-- Name: pm_docclasses; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_docclasses (
    id bigint NOT NULL,
    docclassname character varying(255) NOT NULL,
    docclassdescription character varying(255),
    docclassexpiretiondate character varying(255),
    docclassexpiretiontype character varying(255),
    docclassdirectoryid bigint,
    docclassencoding character varying(255),
    docclasscompressing character varying(255),
    docclassftsserverid bigint,
    cipheralgorithm character varying(255),
    keylength bigint,
    docclassorderid bigint,
    docclassindexpath character varying(255),
    docclassindex character varying(255),
    maxfilesize bigint,
    logicalconn character varying(255) DEFAULT 'AND'
);

ALTER TABLE public.pm_docclasses OWNER TO CURRENT_USER;

--
-- Name: pm_docclassprotection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_docclassprotection (
	docclassid bigint NOT NULL,
    isgroup boolean NOT NULL,
    resourceid character varying(255) NOT NULL,
    logicalconnection character varying(50),
    CONSTRAINT pm_docclassprotection_pkey PRIMARY KEY (docclassid, isgroup, resourceid)
);

--
-- Name: pm_docclasses_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_docclasses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_docclasses_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_document_view_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_document_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_document_view_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_document_views; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_document_views (
    document_view_id bigint NOT NULL,
    document_view_name character varying(255),
    document_view_desc character varying(255),
    proc_def_id character varying(255),
    task_def_id character varying(255),
    user_id character varying(255),
    doc_class_id bigint,
    is_descending boolean NOT NULL,
    amount integer NOT NULL,
    regex character varying(255)
);


ALTER TABLE public.pm_document_views OWNER TO CURRENT_USER;

--
-- Name: pm_documenttemplate; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_documenttemplate (
    id bigint NOT NULL,
    templatename character varying(255),
    templatepath character varying(255),
    processid character varying(255)
);


ALTER TABLE public.pm_documenttemplate OWNER TO CURRENT_USER;

--
-- Name: pm_documenttemplate_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_documenttemplate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_documenttemplate_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_domainservers; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_domainservers (
    id bigint NOT NULL,
    domainname character varying(255),
    domainserveradres character varying(255),
    domainserverport bigint,
    domainuser character varying(255),
    domainuserpassword character varying(255),
    domainbasesearch character varying(255),
    usernametemplate character varying(255),
    domainspnego character varying(255),
    usernamemapping character varying(255),
    firstnamemapping character varying(255),
    lastnamemapping character varying(255),
    emailmapping character varying(255),
    membermapping character varying(255),
    memberofmapping character varying(255),
    numbermapping character varying(255)
);


ALTER TABLE public.pm_domainservers OWNER TO CURRENT_USER;

--
-- Name: pm_domainservers_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_domainservers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_domainservers_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_emailnotification; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_emailnotification (
    id bigint NOT NULL,
    sprocesstypename character varying(255),
    staskname character varying(255),
    susername character varying(255),
    sisgroup character varying(255),
    snotificationtype character varying(255)
);


ALTER TABLE public.pm_emailnotification OWNER TO CURRENT_USER;

--
-- Name: pm_emailnotification_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_emailnotification_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_emailnotification_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_file_versions; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_file_versions (
    id bigint NOT NULL,
    fileid bigint NOT NULL,
    parent_fileid bigint,
    checkout_date date,
    checkin_date date,
    checkout_user character varying(255),
    state character varying(255),
    file_comment character varying(255),
    replace_date date,
    version bigint,
    newest_fileid bigint
);


ALTER TABLE public.pm_file_versions OWNER TO CURRENT_USER;

--
-- Name: pm_files; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_files (
    id bigint NOT NULL,
    file_date timestamp without time zone,
    name character varying(255),
    org_name character varying(255),
    path character varying(255),
    uploader character varying(255),
    description character varying(255),
    file_size bigint,
    compressed character varying(255),
    encrypted character varying(255),
    cipheralgorithm character varying(255),
    cipherkey character varying(255),
    docclassid bigint NOT NULL
);


ALTER TABLE public.pm_files OWNER TO CURRENT_USER;

--
-- Name: pm_indecies; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_indecies (
    id bigint NOT NULL,
    docclassid bigint,
    indexname character varying(255),
    indexdescription character varying(255),
    indextype character varying(255),
    indexvalues character varying(4000),
    indexorderid bigint
);


ALTER TABLE public.pm_indecies OWNER TO CURRENT_USER;

--
-- Name: pm_indecies_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_indecies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_indecies_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_license; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_license (
    id bigint NOT NULL,
    dates oid,
    licensedata oid,
    publickey oid
);


ALTER TABLE public.pm_license OWNER TO CURRENT_USER;

--
-- Name: pm_license_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_license_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_license_id_seq OWNER TO CURRENT_USER;


--
-- Name: pm_trial; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_trial
(
  id bigint NOT NULL,
  data bytea,
  CONSTRAINT pm_trial_pkey PRIMARY KEY (id)
);

ALTER TABLE public.pm_trial OWNER TO CURRENT_USER;

--
-- Name: pm_trial_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_trial_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

--
-- Name: pm_linkconnection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_linkconnection (
    id bigint NOT NULL,
    linkid bigint,
    linkindexid bigint,
    docclassid bigint,
    indexid bigint
);


ALTER TABLE public.pm_linkconnection OWNER TO CURRENT_USER;

--
-- Name: pm_linkconnection_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_linkconnection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_linkconnection_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_linkindecies; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_linkindecies (
    id bigint NOT NULL,
    linkid bigint,
    indexname character varying(255),
    indexdescription character varying(255),
    indextype character varying(255),
    indexvalues character varying(4000),
    indexorder bigint
);


ALTER TABLE public.pm_linkindecies OWNER TO CURRENT_USER;

--
-- Name: pm_linkindecies_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_linkindecies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_linkindecies_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_links; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_links (
    id bigint NOT NULL,
    linkname character varying(255),
    linkdescription character varying(255)
);


ALTER TABLE public.pm_links OWNER TO CURRENT_USER;

--
-- Name: pm_links_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_links_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_links_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_notificationdef; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_notificationdef (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    subject character varying(255) NOT NULL,
    templatepath character varying(4000) NOT NULL,
    conditiontype character varying(255) NOT NULL,
    conditionvarname character varying(255),
    conditionval character varying(255),
    recipientperformer boolean
);


ALTER TABLE public.pm_notificationdef OWNER TO CURRENT_USER;

--
-- Name: pm_notificationdef_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_notificationdef_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_notificationdef_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_notificationprocact; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_notificationprocact (
    id bigint NOT NULL,
    notificationdefid character varying(255) NOT NULL,
    processdefid character varying(255) NOT NULL,
    activitydefid character varying(255)
);


ALTER TABLE public.pm_notificationprocact OWNER TO CURRENT_USER;

--
-- Name: pm_notificationprocact_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_notificationprocact_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_notificationprocact_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_notificationrecipient; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_notificationrecipient (
    id bigint NOT NULL,
    notificationdefid character varying(255) NOT NULL,
    recipienttype character varying(255) NOT NULL,
    recipientval character varying(255),
    recipientexcluded character varying(255)
);


ALTER TABLE public.pm_notificationrecipient OWNER TO CURRENT_USER;

--
-- Name: pm_notifications; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_notifications (
    id bigint NOT NULL,
    notificationdefid character varying(255) NOT NULL,
    processid character varying(255) NOT NULL,
    activityid character varying(255),
    recipientuserids text
);


ALTER TABLE public.pm_notifications OWNER TO CURRENT_USER;

--
-- Name: pm_notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_notifications_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_nr_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_nr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_nr_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_op_opid_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_op_opid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_op_opid_seq OWNER TO CURRENT_USER;

--
-- Name: pm_opened_files; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_opened_files (
    id bigint NOT NULL,
    fileid bigint,
    username character varying(255),
    filename character varying(255),
    sessionid character varying(255),
    dateofopen timestamp without time zone
);


ALTER TABLE public.pm_opened_files OWNER TO CURRENT_USER;

--
-- Name: pm_operation_panel; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_operation_panel (
    operation_panel_id bigint NOT NULL,
    userid character varying(255),
    name character varying(255),
    description character varying(255)
);


ALTER TABLE public.pm_operation_panel OWNER TO CURRENT_USER;

--
-- Name: pm_operation_panel_parameters; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_operation_panel_parameters (
    operation_panel_parameter_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    params character varying(255),
    is_count boolean,
    "position" bigint,
    operation_panel_id bigint NOT NULL
);


ALTER TABLE public.pm_operation_panel_parameters OWNER TO CURRENT_USER;

--
-- Name: pm_opp_oppid_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_opp_oppid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_opp_oppid_seq OWNER TO CURRENT_USER;

--
-- Name: pm_organizationalunits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_organizationalunits (
    id bigint NOT NULL,
    organizationalunitname character varying(255),
    organizationalunitsymbol character varying(255) NOT NULL,
    directorpositionid bigint,
    higherorganizationalunitid bigint
);


ALTER TABLE public.pm_organizationalunits OWNER TO CURRENT_USER;

--
-- Name: pm_organizationalunits_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_organizationalunits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_organizationalunits_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_plugins_configuration; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_plugins_configuration (
    id character varying(255) NOT NULL,
    plugin_name character varying(255) NOT NULL,
    entry_file_name character varying(255) NOT NULL,
    plugin_file_name character varying(255) NOT NULL,
    plugin_file_md5 character varying(255) NOT NULL
);


ALTER TABLE public.pm_plugins_configuration OWNER TO CURRENT_USER;

--
-- Name: pm_position_role; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_position_role (
    positionid bigint NOT NULL,
    roleid bigint NOT NULL
);


ALTER TABLE public.pm_position_role OWNER TO CURRENT_USER;

--
-- Name: pm_positions; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_positions (
    id bigint NOT NULL,
    positionname character varying(255),
    positionsymbol character varying(255) NOT NULL,
    higherpositionid bigint,
    organizationalunitid bigint,
    userid numeric(19,0)
);


ALTER TABLE public.pm_positions OWNER TO CURRENT_USER;

--
-- Name: pm_positions_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_positions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_positions_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_process_translation; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_process_translation (
    processid character varying(255) NOT NULL,
    language character varying(255) NOT NULL,
    name character varying(255),
    description character varying(255)
);


ALTER TABLE public.pm_process_translation OWNER TO CURRENT_USER;

--
-- Name: pm_processdata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_processdata (
    id bigint NOT NULL,
    sprocessfieldname character varying(255),
    sprocessfieldvalue character varying(255),
    sprocesstypename character varying(255),
    stasktypename character varying(255)
);


ALTER TABLE public.pm_processdata OWNER TO CURRENT_USER;

--
-- Name: pm_processdata_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_processdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_processdata_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_processtypes; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_processtypes (
    id bigint NOT NULL,
    sprocesstypename character varying(255),
    sprocessindecestable character varying(255)
);


ALTER TABLE public.pm_processtypes OWNER TO CURRENT_USER;

--
-- Name: pm_reportlistvariablevalue; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_reportlistvariablevalue (
    id bigint NOT NULL,
    variableid bigint NOT NULL,
    listvalueid character varying(255),
    listvaluedisplay character varying(255)
);


ALTER TABLE public.pm_reportlistvariablevalue OWNER TO CURRENT_USER;

--
-- Name: pm_reports; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_reports (
    id bigint NOT NULL,
    viewid bigint,
    reportname character varying(255),
    reportdescr character varying(255),
    accesslevel character varying(255),
    username character varying(255),
    showformonresult character varying(255),
    canfilterresult character varying(255),
    reporttype character varying(255),
    reportdefinitionpath character varying(255)
);


ALTER TABLE public.pm_reports OWNER TO CURRENT_USER;

--
-- Name: pm_reports_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_reports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_reports_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_reportsprotection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_reportsprotection (
    id bigint NOT NULL,
    reportid character varying(255),
    shareuserid character varying(255),
    isgroup character varying(255)
);


ALTER TABLE public.pm_reportsprotection OWNER TO CURRENT_USER;

--
-- Name: pm_reportsprotection_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_reportsprotection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_reportsprotection_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_reportvariable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_reportvariable (
    id bigint NOT NULL,
    reportid character varying(255),
    name character varying(255),
    viewname character varying(255),
    sorttype character varying(255),
    "position" character varying(255),
    active character varying(255),
    grouped character varying(255),
    sum character varying(255),
    avg character varying(255),
    min character varying(255),
    max character varying(255),
    count character varying(255)
);


ALTER TABLE public.pm_reportvariable OWNER TO CURRENT_USER;

--
-- Name: pm_reportvariable_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_reportvariable_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_reportvariable_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_rights; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_rights (
    id bigint NOT NULL,
    right_type smallint NOT NULL,
    resource_id character varying(100) NOT NULL,
    is_resource_a_group boolean NOT NULL,
    right_level character varying(768) NOT NULL
);


ALTER TABLE public.pm_rights OWNER TO CURRENT_USER;

--
-- Name: pm_rights_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_rights_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_rights_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_rlvv_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_rlvv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_rlvv_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_roles; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_roles (
    id bigint NOT NULL,
    packageid character varying(255),
    processdefid character varying(255),
    roleid character varying(255)
);


ALTER TABLE public.pm_roles OWNER TO CURRENT_USER;

--
-- Name: pm_roles_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_roles_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_scheduled_task_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_scheduled_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_scheduled_task_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_scheduled_tasks; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_scheduled_tasks (
    scheduled_task_id bigint NOT NULL,
    name character varying(255),
    description character varying(255),
    is_active boolean NOT NULL,
    is_processing boolean NOT NULL,
    savehistory boolean,
    class_name character varying(255) NOT NULL,
    method_name character varying(255) NOT NULL,
    first_run timestamp without time zone NOT NULL,
    next_run timestamp without time zone,
    last_run timestamp without time zone,
    period_miliseconds bigint,
    category_id bigint
);


ALTER TABLE public.pm_scheduled_tasks OWNER TO CURRENT_USER;

--
-- Name: pm_scheduled_tasks_component; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_scheduled_tasks_component (
    id bigint NOT NULL PRIMARY KEY,
    pluginid character varying(255) NOT NULL,
    scheduledtaskid bigint NOT NULL
);


ALTER TABLE public.pm_scheduled_tasks_component OWNER TO CURRENT_USER;

CREATE SEQUENCE pm_scheduledtaskscomp_seq
	START WITH 1
	INCREMENT BY 1
	NO MAXVALUE
	NO CYCLE;

--
-- Name: pm_scheduled_tasks_category; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_scheduled_tasks_category (
    id bigint NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.pm_scheduled_tasks_category OWNER TO CURRENT_USER;

--
-- Name: pm_scheduled_tasks_history; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_scheduled_tasks_history (
    id bigint NOT NULL,
    startdate timestamp without time zone NOT NULL,
    finishdate timestamp without time zone,
    success boolean NOT NULL,
    result character varying(1000),
    taskid bigint NOT NULL
);


ALTER TABLE public.pm_scheduled_tasks_history OWNER TO CURRENT_USER;

--
-- Name: pm_scheduled_tasks_parameters; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_scheduled_tasks_parameters (
    scheduled_task_parameter_id bigint NOT NULL,
    parameter_type character varying(255) NOT NULL,
    parameter_value character varying(255) NOT NULL,
    parameter_position integer NOT NULL,
    scheduled_task_id bigint NOT NULL
);


ALTER TABLE public.pm_scheduled_tasks_parameters OWNER TO CURRENT_USER;

--
-- Name: pm_stc_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_stc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_stc_id_seq OWNER TO CURRENT_USER;


--
-- Name: pm_sth_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_sth_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_sth_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_stp_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_stp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_stp_id_seq OWNER TO CURRENT_USER;

CREATE TABLE pm_substitutions
(
  id bigint NOT NULL,
  processdefid character varying(255),
  role bigint,
  substituted numeric(19,0) NOT NULL,
  substitute numeric(19,0) NOT NULL,
  startdate bigint,
  finishdate bigint
);

ALTER TABLE pm_substitutions OWNER TO CURRENT_USER;

CREATE SEQUENCE pm_substitutions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE public.pm_substitutions_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_user_notification_configs; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_user_notification_configs (
    id bigint NOT NULL,
    processdefid character varying(255) NOT NULL,
    lang character varying(255),
    processend character varying(2500),
    activityend character varying(2500),
    activitydeliver character varying(2500),
    enabled boolean
);


ALTER TABLE public.pm_user_notification_configs OWNER TO CURRENT_USER;

--
-- Name: pm_user_notifications; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_user_notifications (
    id bigint NOT NULL,
    sender character varying(255) NOT NULL,
    notifdate timestamp without time zone NOT NULL,
    message character varying(4000) NOT NULL,
    receiver character varying(255) NOT NULL,
    confirmed boolean,
    failure boolean
);


ALTER TABLE public.pm_user_notifications OWNER TO CURRENT_USER;

--
-- Name: pm_usercalendarshare; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_usercalendarshare (
    id bigint NOT NULL,
    ownerid character varying(255),
    shareuserid character varying(255),
    isgroup character varying(255)
);


ALTER TABLE public.pm_usercalendarshare OWNER TO CURRENT_USER;

--
-- Name: pm_usercalendarshare_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_usercalendarshare_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_usercalendarshare_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_userdata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_userdata (
    id bigint NOT NULL,
    userid bigint NOT NULL,
    userfieldname character varying(255) NOT NULL,
    userfieldvalue character varying(255)
);


ALTER TABLE public.pm_userdata OWNER TO CURRENT_USER;

--
-- Name: pm_userdata_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_userdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_userdata_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_sysversion; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_sysversion
(
  ver character varying(255),
  version numeric(19,2),
  status character varying(255),
  versionorder integer
);

ALTER TABLE public.pm_sysversion OWNER TO CURRENT_USER;

insert into pm_sysversion (ver,version,status, versionorder) values ('3.1.8',3.1,'COMPLETE',4);

--
-- Name: pm_upgrade_status; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_upgrade_status
(
  version character varying(255),
  name character varying(255),
  status character varying(255),
  type character varying(255)
);

ALTER TABLE public.pm_upgrade_status OWNER TO CURRENT_USER;

--
-- Name: pm_usersearchviews; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_usersearchviews (
    id bigint NOT NULL,
    val character varying(4000),
    viewname character varying(255),
    viewdescr character varying(255),
    accesslevel character varying(255),
    source character varying(255),
    username character varying(255),
    showformonresult character varying(255),
    acceptmanytasks character varying(255),
    showsearchresultonresult character varying(255)
);


ALTER TABLE public.pm_usersearchviews OWNER TO CURRENT_USER;

--
-- Name: pm_usersearchviews_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_usersearchviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_usersearchviews_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_usersearchviewsprotection; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_usersearchviewsprotection (
    id bigint NOT NULL,
    viewid character varying(255) NOT NULL,
    shareuserid character varying(255),
    isgroup character varying(255)
);


ALTER TABLE public.pm_usersearchviewsprotection OWNER TO CURRENT_USER;

--
-- Name: pm_usvp_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_usvp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_usvp_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_variable_distinguish; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_variable_distinguish (
    variable_distinguish_id bigint NOT NULL,
    variableid character varying(255),
    variablename character varying(255),
    variablevalue text,
    variablevalue2 character varying(255),
    viewid character varying(255),
    imagepath character varying(255),
    variableviewtype character varying(255),
    variableformat character varying(255),
    color character varying(255)
);


ALTER TABLE public.pm_variable_distinguish OWNER TO CURRENT_USER;

--
-- Name: pm_variable_distinguish_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE pm_variable_distinguish_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pm_variable_distinguish_id_seq OWNER TO CURRENT_USER;

--
-- Name: pm_variable_set_temp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_variable_set_temp (
    process_id character varying(100) NOT NULL,
    activity_id character varying(100) NOT NULL,
    variable_id character varying(100) NOT NULL,
    variable_value text
);


ALTER TABLE public.pm_variable_set_temp OWNER TO CURRENT_USER;

--
-- Name: pm_vcolumns; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_vcolumns (
    tableid character varying(255) NOT NULL,
    id character varying(255) NOT NULL,
    modified timestamp without time zone NOT NULL,
    name character varying(255),
    description character varying(1024),
    typeid character varying(256)
);


ALTER TABLE public.pm_vcolumns OWNER TO CURRENT_USER;

--
-- Name: pm_vtables; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_vtables (
    id character varying(255) NOT NULL,
    name character varying(255),
    description character varying(1024),
    userid character varying(255) NOT NULL,
    vtable_rows integer NOT NULL
);


ALTER TABLE public.pm_vtables OWNER TO CURRENT_USER;

--
-- Name: pm_vtypes; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_vtypes (
    id character varying(256) NOT NULL,
    name character varying(512),
    description character varying(1024)
);


ALTER TABLE public.pm_vtypes OWNER TO CURRENT_USER;

--
-- Name: pm_vvalues; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_vvalues (
    tableid character varying(255) NOT NULL,
    columnid character varying(255) NOT NULL,
    vvalue_rowid integer NOT NULL,
    modified timestamp without time zone NOT NULL,
    cellvalue character varying(1024),
    userid character varying(255) NOT NULL
);


ALTER TABLE public.pm_vvalues OWNER TO CURRENT_USER;

--
-- Name: processdata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processdata (
    process numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevalue bytea,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processdata OWNER TO CURRENT_USER;

--
-- Name: processdatablobs; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processdatablobs (
    processdatawob numeric(19,0) NOT NULL,
    variablevalue bytea,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processdatablobs OWNER TO CURRENT_USER;

--
-- Name: processdatawob; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processdatawob (
    process numeric(19,0) NOT NULL,
    variabledefinitionid character varying(100) NOT NULL,
    variabletype integer NOT NULL,
    variablevaluevchar character varying(4000),
    variablevaluedbl double precision,
    variablevaluelong bigint,
    variablevaluedate timestamp without time zone,
    variablevaluebool character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processdatawob OWNER TO CURRENT_USER;

--
-- Name: processdefinitions; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processdefinitions (
    name character varying(200) NOT NULL,
    packageid character varying(90) NOT NULL,
    processdefinitionid character varying(90) NOT NULL,
    processdefinitioncreated bigint NOT NULL,
    processdefinitionversion character varying(20) NOT NULL,
    state integer NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processdefinitions OWNER TO CURRENT_USER;

--
-- Name: processes; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processes (
    id character varying(100) NOT NULL,
    processdefinition numeric(19,0) NOT NULL,
    pdefname character varying(200) NOT NULL,
    activityrequesterid character varying(100),
    activityrequesterprocessid character varying(100),
    resourcerequesterid character varying(100) NOT NULL,
    externalrequesterclassname character varying(254),
    state numeric(19,0) NOT NULL,
    priority integer,
    name character varying(254),
    created bigint NOT NULL,
    started bigint,
    laststatetime bigint NOT NULL,
    limittime bigint NOT NULL,
    description character varying(254),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processes OWNER TO CURRENT_USER;

--
-- Name: processrequesters; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processrequesters (
    id character varying(100) NOT NULL,
    activityrequester numeric(19,0),
    resourcerequester numeric(19,0),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processrequesters OWNER TO CURRENT_USER;

--
-- Name: processstateeventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processstateeventaudits (
    keyvalue character varying(30) NOT NULL,
    name character varying(50) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processstateeventaudits OWNER TO CURRENT_USER;

--
-- Name: processstates; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE processstates (
    keyvalue character varying(30) NOT NULL,
    name character varying(50) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.processstates OWNER TO CURRENT_USER;

--
-- Name: proclevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelparticipant (
    participant_id character varying(90) NOT NULL,
    processoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelparticipant OWNER TO CURRENT_USER;

--
-- Name: proclevelxpdlapp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelxpdlapp (
    application_id character varying(90) NOT NULL,
    processoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelxpdlapp OWNER TO CURRENT_USER;

--
-- Name: proclevelxpdlapptaappdetail; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelxpdlapptaappdetail (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelxpdlapptaappdetail OWNER TO CURRENT_USER;

--
-- Name: proclevelxpdlapptaappdetailusr; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelxpdlapptaappdetailusr (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelxpdlapptaappdetailusr OWNER TO CURRENT_USER;

--
-- Name: proclevelxpdlapptaappuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelxpdlapptaappuser (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelxpdlapptaappuser OWNER TO CURRENT_USER;

--
-- Name: proclevelxpdlapptoolagentapp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE proclevelxpdlapptoolagentapp (
    xpdl_appoid numeric(19,0) NOT NULL,
    toolagentoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.proclevelxpdlapptoolagentapp OWNER TO CURRENT_USER;

--
-- Name: proctypes_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE proctypes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.proctypes_id_seq OWNER TO CURRENT_USER;

--
-- Name: resourcestable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE resourcestable (
    username character varying(100) NOT NULL,
    name character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.resourcestable OWNER TO CURRENT_USER;

--
-- Name: stateeventaudits; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE stateeventaudits (
    utctime character varying(254) NOT NULL,
    thetype numeric(19,0) NOT NULL,
    activityid character varying(100),
    activityname character varying(254),
    processid character varying(100) NOT NULL,
    processname character varying(254),
    processdefinitionname character varying(200) NOT NULL,
    processdefinitionversion character varying(20) NOT NULL,
    activitydefinitionid character varying(90),
    activitysetdefinitionid character varying(90),
    processdefinitionid character varying(90) NOT NULL,
    packageid character varying(90) NOT NULL,
    oldprocessstate numeric(19,0),
    newprocessstate numeric(19,0),
    oldactivitystate numeric(19,0),
    newactivitystate numeric(19,0),
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.stateeventaudits OWNER TO CURRENT_USER;

--
-- Name: toolagentapp; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE toolagentapp (
    tool_agent_name character varying(250) NOT NULL,
    app_name character varying(90) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.toolagentapp OWNER TO CURRENT_USER;

--
-- Name: toolagentappdetail; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE toolagentappdetail (
    app_mode numeric(10,0) NOT NULL,
    toolagent_appoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.toolagentappdetail OWNER TO CURRENT_USER;

--
-- Name: toolagentappdetailuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE toolagentappdetailuser (
    toolagent_appoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.toolagentappdetailuser OWNER TO CURRENT_USER;

--
-- Name: toolagentappuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE toolagentappuser (
    toolagent_appoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.toolagentappuser OWNER TO CURRENT_USER;

--
-- Name: toolagentuser; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE toolagentuser (
    username character varying(100) NOT NULL,
    pwd character varying(100),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.toolagentuser OWNER TO CURRENT_USER;

--
-- Name: user_notif_config_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE user_notif_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_notif_config_id_seq OWNER TO CURRENT_USER;

--
-- Name: user_notifs_id_seq; Type: SEQUENCE; Schema: public; Owner: CURRENT_USER
--

CREATE SEQUENCE user_notifs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_notifs_id_seq OWNER TO CURRENT_USER;

--
-- Name: usergrouptable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE usergrouptable (
    userid numeric(19,0) NOT NULL,
    groupid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.usergrouptable OWNER TO CURRENT_USER;

--
-- Name: userpacklevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE userpacklevelparticipant (
    participantoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.userpacklevelparticipant OWNER TO CURRENT_USER;

--
-- Name: userproclevelparticipant; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE userproclevelparticipant (
    participantoid numeric(19,0) NOT NULL,
    useroid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.userproclevelparticipant OWNER TO CURRENT_USER;

--
-- Name: usertable; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE usertable (
    userid character varying(100) NOT NULL,
    firstname character varying(50),
    lastname character varying(50),
    passwd character varying(50) NOT NULL,
    email character varying(254),
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL,
    active boolean DEFAULT true,
    number character varying(255)
);


ALTER TABLE public.usertable OWNER TO CURRENT_USER;

--
-- Name: xpdlapplicationpackage; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlapplicationpackage (
    package_id character varying(90) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlapplicationpackage OWNER TO CURRENT_USER;

--
-- Name: xpdlapplicationprocess; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlapplicationprocess (
    process_id character varying(90) NOT NULL,
    packageoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlapplicationprocess OWNER TO CURRENT_USER;

--
-- Name: xpdldata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdldata (
    xpdlcontent bytea NOT NULL,
    xpdlclasscontent bytea NOT NULL,
    xpdl numeric(19,0) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdldata OWNER TO CURRENT_USER;

--
-- Name: xpdlhistory; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlhistory (
    xpdlid character varying(90) NOT NULL,
    xpdlversion character varying(20) NOT NULL,
    xpdlclassversion bigint NOT NULL,
    xpdluploadtime timestamp without time zone NOT NULL,
    xpdlhistoryuploadtime timestamp without time zone NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlhistory OWNER TO CURRENT_USER;

--
-- Name: xpdlhistorydata; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlhistorydata (
    xpdlcontent bytea NOT NULL,
    xpdlclasscontent bytea NOT NULL,
    xpdlhistory numeric(19,0) NOT NULL,
    cnt numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlhistorydata OWNER TO CURRENT_USER;

--
-- Name: xpdlparticipantpackage; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlparticipantpackage (
    package_id character varying(90) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlparticipantpackage OWNER TO CURRENT_USER;

--
-- Name: xpdlparticipantprocess; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlparticipantprocess (
    process_id character varying(90) NOT NULL,
    packageoid numeric(19,0) NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlparticipantprocess OWNER TO CURRENT_USER;

--
-- Name: xpdlreferences; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdlreferences (
    referredxpdlid character varying(90) NOT NULL,
    referringxpdl numeric(19,0) NOT NULL,
    referredxpdlnumber integer NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdlreferences OWNER TO CURRENT_USER;

--
-- Name: pm_systemparameter; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_systemparameter (
    id bigint NOT NULL PRIMARY KEY,
    parameterkey character varying(512) NOT NULL,
    categoryid bigint NOT NULL,
    parametertype character varying(256) NOT NULL,
    removable boolean NOT NULL,
    valuestring character varying(4000),
    valuelong bigint,
    valuebool boolean,
    valuedate date,
    valuedouble double precision
);

ALTER TABLE public.pm_systemparameter OWNER TO CURRENT_USER;

CREATE SEQUENCE pm_systemparameter_seq
	START WITH 1
	INCREMENT BY 1
	NO MAXVALUE
	NO CYCLE;
--
-- Name: pm_systemparametercategory; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE pm_systemparametercategory (
    id bigint NOT NULL PRIMARY KEY,
    categorykey character varying(1024) NOT NULL
);


ALTER TABLE public.pm_systemparametercategory OWNER TO CURRENT_USER;

CREATE SEQUENCE pm_systemparametercategory_seq
	START WITH 1
	INCREMENT BY 1
	NO MAXVALUE
	NO CYCLE;

--
-- Name: pm_systemparametercategory; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

INSERT INTO pm_systemparametercategory(id, categorykey) VALUES (nextval('pm_systemparametercategory_seq'), 'Rights.Optional');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (nextval('pm_systemparameter_seq'), 'Rights.UserAccount.Enabled', currval('pm_systemparametercategory_seq'), 'BOOLEAN', FALSE, FALSE);

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (nextval('pm_systemparameter_seq'), 'Rights.Views.Enabled', currval('pm_systemparametercategory_seq'), 'BOOLEAN', FALSE, FALSE);

INSERT INTO pm_systemparametercategory(id, categorykey) VALUES (nextval('pm_systemparametercategory_seq'), 'General');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuestring)
VALUES (nextval('pm_systemparameter_seq'), 'UniversalPassword', currval('pm_systemparametercategory_seq'), 'PASSWORD', FALSE, 'WbqyS8mRTdyybVuPdF1SEM3cIGmM1MP02OBTjG5GrsY');

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (nextval('pm_systemparameter_seq'), 'ShowCalendarCart', currval('pm_systemparametercategory_seq'), 'BOOLEAN', FALSE, FALSE);

INSERT INTO pm_systemparameter(id, parameterkey, categoryid, parametertype, removable, valuebool)
VALUES (nextval('pm_systemparameter_seq'), 'ShowStatistics', currval('pm_systemparametercategory_seq'), 'BOOLEAN', FALSE, FALSE);

CREATE TABLE pm_systemparametercombovalues (
    id bigint NOT NULL PRIMARY KEY,
    ownerid bigint NOT NULL,
    value character varying(4000) NOT NULL
);


ALTER TABLE public.pm_systemparametercombovalues OWNER TO CURRENT_USER;

CREATE SEQUENCE pm_combovalues_seq
	START WITH 1
	INCREMENT BY 1
	NO MAXVALUE
	NO CYCLE;
--
-- Name: xpdls; Type: TABLE; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE TABLE xpdls (
    xpdlid character varying(90) NOT NULL,
    xpdlversion character varying(20) NOT NULL,
    xpdlclassversion bigint NOT NULL,
    xpdluploadtime timestamp without time zone NOT NULL,
    objectid numeric(19,0) NOT NULL,
    objectversion integer NOT NULL
);


ALTER TABLE public.xpdls OWNER TO CURRENT_USER;

CREATE TABLE pm_externaldb_conf
(
  id bigint NOT NULL PRIMARY KEY,
  externalDBConfName character varying(1024),
  url character varying(1024),
  driver character varying(512),
  login character varying(256),
  password character varying(256)
);


ALTER TABLE pm_externaldb_conf OWNER TO CURRENT_USER;


CREATE SEQUENCE externaldbconf_id_seq
	START WITH 1
	INCREMENT BY 1
	NO MAXVALUE
	NO CYCLE;


CREATE TABLE pm_querydatachooser
(
  id bigint NOT NULL PRIMARY KEY,
  name character varying(1024),
  query character varying(4000),
  parameters character varying(1024),
  countQuery character varying(4000),
  externalDB character varying(256),
  externalDBConfName character varying(1024),
  fullClassName character varying(512)
);


ALTER TABLE pm_querydatachooser OWNER TO CURRENT_USER;


CREATE SEQUENCE querydatachooser_id_seq
  START WITH 1
  INCREMENT BY 1
  NO MAXVALUE
  NO CYCLE;


--
-- Data for Name: activities; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: activitydata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: activitydatablobs; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: activitydatawob; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: activitystateeventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: activitystates; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO activitystates VALUES ('open.running', 'open.running', 1000001, 0);
INSERT INTO activitystates VALUES ('open.not_running.not_started', 'open.not_running.not_started', 1000003, 0);
INSERT INTO activitystates VALUES ('open.not_running.suspended', 'open.not_running.suspended', 1000005, 0);
INSERT INTO activitystates VALUES ('closed.completed', 'closed.completed', 1000007, 0);
INSERT INTO activitystates VALUES ('closed.terminated', 'closed.terminated', 1000009, 0);
INSERT INTO activitystates VALUES ('closed.aborted', 'closed.aborted', 1000011, 0);


--
-- Data for Name: andjointable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: assignmenteventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: assignmentstable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: counters; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: createprocesseventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: dataeventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: deadlines; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: eventtypes; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: file_versions_file_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('file_versions_file_id_seq', 1, false);


--
-- Name: files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('files_id_seq', 1, false);


--
-- Data for Name: groupgrouptable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: grouptable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO grouptable VALUES ('Administrators', '', 1000012, 0);


--
-- Data for Name: groupuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: groupuserpacklevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: groupuserproclevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: locktable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: neweventauditdata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: neweventauditdatablobs; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: neweventauditdatawob; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: nextxpdlversions; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: normaluser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: objectid; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO objectid VALUES (1000600);


--
-- Data for Name: oldeventauditdata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: oldeventauditdatablobs; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: oldeventauditdatawob; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: opened_files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('opened_files_id_seq', 1, false);


--
-- Data for Name: packlevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: packlevelxpdlapp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: packlevelxpdlapptaappdetail; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: packlevelxpdlapptaappdetailusr; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: packlevelxpdlapptaappuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: packlevelxpdlapptoolagentapp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_actions; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_actions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_actions_id_seq', 1, false);


--
-- Data for Name: pm_activatedtimes; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_activatedtimes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_activatedtimes_id_seq', 1, false);


--
-- Data for Name: pm_activity_document; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_activity_document_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_activity_document_id_seq', 1, false);


--
-- Data for Name: pm_activity_status; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_activity_translation; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_activitycomments; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_activitycomments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_activitycomments_id_seq', 1, false);


--
-- Data for Name: pm_activityredirection; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_activityredirection_groups; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_activityredirection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_activityredirection_id_seq', 1, false);


--
-- Data for Name: pm_activityredirection_users; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_advancesearchvariables; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_as_status_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_as_status_id_seq', 1, false);


--
-- Name: pm_asv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_asv_id_seq', 1, false);


--
-- Data for Name: pm_audits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_audits_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_audits_id_seq', 1, false);


--
-- Name: pm_dccp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_dccp_id_seq', 1, false);


--
-- Data for Name: pm_delegatedactivities; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_delegatedactivities_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_delegatedactivities_id_seq', 1, false);


--
-- Data for Name: pm_devices; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_devices_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_devices_id_seq', 1, false);


--
-- Data for Name: pm_directories; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_directories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_directories_id_seq', 1, false);


--
-- Data for Name: pm_docclassconditionprotection; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_docclasses; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_docclasses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_docclasses_id_seq', 1, false);


--
-- Name: pm_document_view_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_document_view_id_seq', 1, false);


--
-- Data for Name: pm_document_views; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_documenttemplate; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_documenttemplate_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_documenttemplate_id_seq', 1, false);


--
-- Data for Name: pm_domainservers; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_domainservers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_domainservers_id_seq', 1, false);


--
-- Data for Name: pm_emailnotification; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_emailnotification_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_emailnotification_id_seq', 1, false);


--
-- Data for Name: pm_file_versions; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_files; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_indecies; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_indecies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_indecies_id_seq', 1, false);


--
-- Data for Name: pm_license; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_license_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_license_id_seq', 1, false);


--
-- Data for Name: pm_linkconnection; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_linkconnection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_linkconnection_id_seq', 1, false);


--
-- Data for Name: pm_linkindecies; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_linkindecies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_linkindecies_id_seq', 1, false);


--
-- Data for Name: pm_links; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_links_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_links_id_seq', 1, false);


--
-- Data for Name: pm_notificationdef; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_notificationdef_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_notificationdef_id_seq', 1, false);


--
-- Data for Name: pm_notificationprocact; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_notificationprocact_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_notificationprocact_id_seq', 1, false);


--
-- Data for Name: pm_notificationrecipient; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_notifications; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_notifications_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_notifications_id_seq', 1, false);


--
-- Name: pm_nr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_nr_id_seq', 1, false);


--
-- Name: pm_op_opid_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_op_opid_seq', 1, false);


--
-- Data for Name: pm_opened_files; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_operation_panel; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_operation_panel_parameters; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_opp_oppid_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_opp_oppid_seq', 1, false);


--
-- Data for Name: pm_organizationalunits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_organizationalunits_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_organizationalunits_id_seq', 1, false);


--
-- Data for Name: pm_plugins_configuration; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_position_role; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_positions; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_positions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_positions_id_seq', 1, false);


--
-- Data for Name: pm_process_translation; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_processdata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_processdata_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_processdata_id_seq', 1, false);


--
-- Data for Name: pm_processtypes; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_reportlistvariablevalue; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_reports; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_reports_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_reports_id_seq', 1, false);


--
-- Data for Name: pm_reportsprotection; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_reportsprotection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_reportsprotection_id_seq', 1, false);


--
-- Data for Name: pm_reportvariable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_reportvariable_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_reportvariable_id_seq', 1, false);


--
-- Data for Name: pm_rights; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_rights_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_rights_id_seq', 1, false);


--
-- Name: pm_rlvv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_rlvv_id_seq', 1, false);


--
-- Data for Name: pm_roles; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_roles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_roles_id_seq', 1, false);


--
-- Name: pm_scheduled_task_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_scheduled_task_id_seq', 1, false);

SELECT pg_catalog.setval('pm_substitutions_id_seq', 1, false);

--
-- Data for Name: pm_scheduled_tasks; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_scheduled_tasks_category; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO pm_scheduled_tasks_category VALUES (1, 'Wdrożenie');
INSERT INTO pm_scheduled_tasks_category VALUES (2, 'System');


--
-- Data for Name: pm_scheduled_tasks_history; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_scheduled_tasks_parameters; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_stc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_stc_id_seq', 2, true);


--
-- Name: pm_sth_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_sth_id_seq', 1, false);


--
-- Name: pm_stp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_stp_id_seq', 1, false);


--
-- Data for Name: pm_user_notification_configs; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_user_notifications; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_usercalendarshare; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_usercalendarshare_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_usercalendarshare_id_seq', 1, false);


--
-- Data for Name: pm_userdata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_userdata_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_userdata_id_seq', 1, false);

--
-- Data for Name: pm_usersearchviews; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_usersearchviews_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_usersearchviews_id_seq', 1, false);


--
-- Data for Name: pm_usersearchviewsprotection; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_usvp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_usvp_id_seq', 1, false);


--
-- Data for Name: pm_variable_distinguish; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: pm_variable_distinguish_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('pm_variable_distinguish_id_seq', 1, false);


--
-- Data for Name: pm_variable_set_temp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_vcolumns; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_vtables; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: pm_vtypes; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO pm_vtypes VALUES ('java.lang.String', 'napis', 'typ napisowy');
INSERT INTO pm_vtypes VALUES ('java.lang.Float', 'liczba rzeczywista', 'liczba rzeczywista');
INSERT INTO pm_vtypes VALUES ('java.lang.Boolean', 'wartość logiczna', 'wartość logiczna');
INSERT INTO pm_vtypes VALUES ('java.util.Date', 'data', 'data');
INSERT INTO pm_vtypes VALUES ('java.lang.Integer', 'liczba całkowita', 'liczba całkowita');
INSERT INTO pm_vtypes VALUES ('java.lang.Long', 'duża liczba całkowita', 'duża liczba całkowita');
INSERT INTO pm_vtypes VALUES ('java.lang.Double', 'duża liczba rzeczywista', 'duża liczba rzeczywista');

--
-- Data for Name: pm_vvalues; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processdata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processdatablobs; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processdatawob; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processdefinitions; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processes; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processrequesters; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processstateeventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: processstates; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO processstates VALUES ('open.running', 'open.running', 1000000, 0);
INSERT INTO processstates VALUES ('open.not_running.not_started', 'open.not_running.not_started', 1000002, 0);
INSERT INTO processstates VALUES ('open.not_running.suspended', 'open.not_running.suspended', 1000004, 0);
INSERT INTO processstates VALUES ('closed.completed', 'closed.completed', 1000006, 0);
INSERT INTO processstates VALUES ('closed.terminated', 'closed.terminated', 1000008, 0);
INSERT INTO processstates VALUES ('closed.aborted', 'closed.aborted', 1000010, 0);


--
-- Data for Name: proclevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: proclevelxpdlapp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: proclevelxpdlapptaappdetail; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: proclevelxpdlapptaappdetailusr; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: proclevelxpdlapptaappuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: proclevelxpdlapptoolagentapp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: proctypes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('proctypes_id_seq', 1, false);


--
-- Data for Name: resourcestable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO resourcestable VALUES ('admin', NULL, 1000015, 0);


--
-- Data for Name: stateeventaudits; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: toolagentapp; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: toolagentappdetail; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: toolagentappdetailuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: toolagentappuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: toolagentuser; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Name: user_notif_config_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('user_notif_config_id_seq', 1, false);


--
-- Name: user_notifs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: CURRENT_USER
--

SELECT pg_catalog.setval('user_notifs_id_seq', 1, false);


--
-- Data for Name: usergrouptable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO usergrouptable VALUES (1000013, 1000012, 1000014, 0);


--
-- Data for Name: userpacklevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: userproclevelparticipant; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: usertable; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO usertable VALUES ('admin', 'Administrator', 'PlusWorkflow', '73d7665487f88c55adb98e90a84f579728032f46', '', 1000013, 0, true, NULL);

INSERT INTO pm_rights VALUES (NEXTVAL('pm_rights_id_seq'),0,'admin',false,'system');
--
-- Data for Name: xpdlapplicationpackage; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlapplicationprocess; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdldata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlhistory; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlhistorydata; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlparticipantpackage; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlparticipantprocess; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdlreferences; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: xpdls; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--



--
-- Data for Name: db_changelog; Type: TABLE DATA; Schema: public; Owner: CURRENT_USER
--

INSERT INTO db_changelog VALUES ('add_i01_usertable', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_usertable', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_file_versions', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_substitutions', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_notificationprocact', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_usersearchviewsprotection', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_usersearchviews', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_advancesearchvariables', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_reportvariable', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_reports', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_rights', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_pm_rights', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_indecies', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_notifications', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_deadlines', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_deadlines', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_usergrouptable', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_activity_document', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_pm_activity_document', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i03_pm_activity_document', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i04_pm_activity_document', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_activitycomments', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_delegatedactivities', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_pm_delegatedactivities', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_docclassconditionprotection', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_pm_docclassconditionprotection', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_activity_status', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_document_views', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_user_notifications', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i02_pm_user_notifications', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_i01_pm_usercalendarshare', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.32');
INSERT INTO db_changelog VALUES ('add_max_file_size', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.39');
INSERT INTO db_changelog VALUES ('add_docclass_protection', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.1.67');
INSERT INTO db_changelog VALUES ('add_pm_systemparameter', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('add_pm_systemparametercategory', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('create_sequence_pm_systemparameter', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('create_sequence_pm_systemparametercategory', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('create_sequence_pm_systemparametercombovalues', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('add_pm_systemparametercombovalues', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('insert_Rights.Optional_category', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('insert_Rights.Views.Enabled_param', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('insert_Rights.UserAccount.Enabled_param', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('insert_General_category', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('insert_UniversalPassword_param', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.0');
INSERT INTO db_changelog VALUES ('add_domain_server_mapping_columns', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.2');
INSERT INTO db_changelog VALUES ('change_number_to_long_parameters', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.6');
INSERT INTO db_changelog VALUES ('add_valuedouble_column', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.6');
INSERT INTO db_changelog VALUES ('add_pm_scheduled_tasks_component', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.12');
INSERT INTO db_changelog VALUES ('create_sequence_pm_scheduledtaskscomp_seq', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.12');
INSERT INTO db_changelog VALUES ('create_pm_trial', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.15');
INSERT INTO db_changelog VALUES ('create_pm_trial_id_seq', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.15');
INSERT INTO db_changelog VALUES ('create_pm_externaldb_conf', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('create_externaldbconf_id_seq', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('change_pm_querydatachooser_query', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('change_pm_querydatachooser_countquery', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('create_pm_querydatachooser', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('create_querydatachooser_id_seq', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.20');
INSERT INTO db_changelog VALUES ('insert_ShowCalendarCart_param', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.31');
INSERT INTO db_changelog VALUES ('add_cascadeOnDelete_pm_failedloggingregister', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '3.2.45');
INSERT INTO db_changelog VALUES ('insert_ShowStatistics_param', 'plusworkflow', extract(epoch from now())*1000, 'EXECUTED', '', '4.0.0');


--
-- Name: activities_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activities
    ADD CONSTRAINT activities_objectid PRIMARY KEY (objectid);


--
-- Name: activitydata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activitydata
    ADD CONSTRAINT activitydata_objectid PRIMARY KEY (objectid);


--
-- Name: activitydatablobs_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activitydatablobs
    ADD CONSTRAINT activitydatablobs_objectid PRIMARY KEY (objectid);


--
-- Name: activitydatawob_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activitydatawob
    ADD CONSTRAINT activitydatawob_objectid PRIMARY KEY (objectid);


--
-- Name: activitystateeventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activitystateeventaudits
    ADD CONSTRAINT activitystateeventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: activitystates_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY activitystates
    ADD CONSTRAINT activitystates_objectid PRIMARY KEY (objectid);


--
-- Name: andjointable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY andjointable
    ADD CONSTRAINT andjointable_objectid PRIMARY KEY (objectid);


--
-- Name: assignmenteventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY assignmenteventaudits
    ADD CONSTRAINT assignmenteventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: assignmentstable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY assignmentstable
    ADD CONSTRAINT assignmentstable_objectid PRIMARY KEY (objectid);


--
-- Name: counters_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY counters
    ADD CONSTRAINT counters_objectid PRIMARY KEY (objectid);


--
-- Name: createprocesseventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY createprocesseventaudits
    ADD CONSTRAINT createprocesseventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: dataeventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY dataeventaudits
    ADD CONSTRAINT dataeventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: deadlines_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY deadlines
    ADD CONSTRAINT deadlines_objectid PRIMARY KEY (objectid);


--
-- Name: eventtypes_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY eventtypes
    ADD CONSTRAINT eventtypes_objectid PRIMARY KEY (objectid);


--
-- Name: groupgrouptable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY groupgrouptable
    ADD CONSTRAINT groupgrouptable_objectid PRIMARY KEY (objectid);


--
-- Name: grouptable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY grouptable
    ADD CONSTRAINT grouptable_objectid PRIMARY KEY (objectid);


--
-- Name: groupuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY groupuser
    ADD CONSTRAINT groupuser_objectid PRIMARY KEY (objectid);


--
-- Name: groupuserpacklevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY groupuserpacklevelparticipant
    ADD CONSTRAINT groupuserpacklevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: groupuserproclevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY groupuserproclevelparticipant
    ADD CONSTRAINT groupuserproclevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: locktable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY locktable
    ADD CONSTRAINT locktable_objectid PRIMARY KEY (objectid);


--
-- Name: neweventauditdata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY neweventauditdata
    ADD CONSTRAINT neweventauditdata_objectid PRIMARY KEY (objectid);


--
-- Name: neweventauditdatablobs_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY neweventauditdatablobs
    ADD CONSTRAINT neweventauditdatablobs_objectid PRIMARY KEY (objectid);


--
-- Name: neweventauditdatawob_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY neweventauditdatawob
    ADD CONSTRAINT neweventauditdatawob_objectid PRIMARY KEY (objectid);


--
-- Name: nextxpdlversions_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY nextxpdlversions
    ADD CONSTRAINT nextxpdlversions_objectid PRIMARY KEY (objectid);


--
-- Name: normaluser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY normaluser
    ADD CONSTRAINT normaluser_objectid PRIMARY KEY (objectid);


--
-- Name: objectid_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY objectid
    ADD CONSTRAINT objectid_pkey PRIMARY KEY (next);


--
-- Name: oldeventauditdata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY oldeventauditdata
    ADD CONSTRAINT oldeventauditdata_objectid PRIMARY KEY (objectid);


--
-- Name: oldeventauditdatablobs_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY oldeventauditdatablobs
    ADD CONSTRAINT oldeventauditdatablobs_objectid PRIMARY KEY (objectid);


--
-- Name: oldeventauditdatawob_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY oldeventauditdatawob
    ADD CONSTRAINT oldeventauditdatawob_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelparticipant
    ADD CONSTRAINT packlevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelxpdlapp_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelxpdlapp
    ADD CONSTRAINT packlevelxpdlapp_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelxpdlapptaappdetail_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelxpdlapptaappdetail
    ADD CONSTRAINT packlevelxpdlapptaappdetail_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelxpdlapptaappdetailusr_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelxpdlapptaappdetailusr
    ADD CONSTRAINT packlevelxpdlapptaappdetailusr_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelxpdlapptaappuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelxpdlapptaappuser
    ADD CONSTRAINT packlevelxpdlapptaappuser_objectid PRIMARY KEY (objectid);


--
-- Name: packlevelxpdlapptoolagentapp_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY packlevelxpdlapptoolagentapp
    ADD CONSTRAINT packlevelxpdlapptoolagentapp_objectid PRIMARY KEY (objectid);


--
-- Name: pm_actions_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_actions
    ADD CONSTRAINT pm_actions_pkey PRIMARY KEY (id);


--
-- Name: pm_activatedtimes_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activatedtimes
    ADD CONSTRAINT pm_activatedtimes_pkey PRIMARY KEY (id);


--
-- Name: pm_activity_document_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT pm_activity_document_pkey PRIMARY KEY (id);


--
-- Name: pm_activity_status_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activity_status
    ADD CONSTRAINT pm_activity_status_pkey PRIMARY KEY (status_id);


--
-- Name: pm_activity_translation_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activity_translation
    ADD CONSTRAINT pm_activity_translation_pkey PRIMARY KEY (packageid, processdefid, activitydefid, language);


--
-- Name: pm_activitycomments_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activitycomments
    ADD CONSTRAINT pm_activitycomments_pkey PRIMARY KEY (id);


--
-- Name: pm_activityredirection_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activityredirection_groups
    ADD CONSTRAINT pm_activityredirection_groups_pkey PRIMARY KEY (redirection, targetgroup);


--
-- Name: pm_activityredirection_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activityredirection
    ADD CONSTRAINT pm_activityredirection_pkey PRIMARY KEY (id);


--
-- Name: pm_activityredirection_users_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_activityredirection_users
    ADD CONSTRAINT pm_activityredirection_users_pkey PRIMARY KEY (redirection, targetuser);


--
-- Name: pm_advancesearchvariables_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_advancesearchvariables
    ADD CONSTRAINT pm_advancesearchvariables_pkey PRIMARY KEY (id);


--
-- Name: pm_audits_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_audits
    ADD CONSTRAINT pm_audits_pkey PRIMARY KEY (id);


--
-- Name: pm_delegatedactivities_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_delegatedactivities
    ADD CONSTRAINT pm_delegatedactivities_pkey PRIMARY KEY (id);


--
-- Name: pm_devices_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_devices
    ADD CONSTRAINT pm_devices_pkey PRIMARY KEY (id);


--
-- Name: pm_directories_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_directories
    ADD CONSTRAINT pm_directories_pkey PRIMARY KEY (id);


--
-- Name: pm_docclassconditionprotection_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_docclassconditionprotection
    ADD CONSTRAINT pm_docclassconditionprotection_pkey PRIMARY KEY (id);


--
-- Name: pm_docclasses_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_docclasses
    ADD CONSTRAINT pm_docclasses_pkey PRIMARY KEY (id);


--
-- Name: pm_document_views_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_document_views
    ADD CONSTRAINT pm_document_views_pkey PRIMARY KEY (document_view_id);


--
-- Name: pm_documenttemplate_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_documenttemplate
    ADD CONSTRAINT pm_documenttemplate_pkey PRIMARY KEY (id);


--
-- Name: pm_domainservers_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_domainservers
    ADD CONSTRAINT pm_domainservers_pkey PRIMARY KEY (id);


--
-- Name: pm_emailnotification_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_emailnotification
    ADD CONSTRAINT pm_emailnotification_pkey PRIMARY KEY (id);


--
-- Name: pm_file_versions_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_file_versions
    ADD CONSTRAINT pm_file_versions_pkey PRIMARY KEY (id);


--
-- Name: pm_files_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_files
    ADD CONSTRAINT pm_files_pkey PRIMARY KEY (id);


--
-- Name: pm_indecies_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_indecies
    ADD CONSTRAINT pm_indecies_pkey PRIMARY KEY (id);


--
-- Name: pm_license_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_license
    ADD CONSTRAINT pm_license_pkey PRIMARY KEY (id);


--
-- Name: pm_linkconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_linkconnection
    ADD CONSTRAINT pm_linkconnection_pkey PRIMARY KEY (id);


--
-- Name: pm_linkindecies_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_linkindecies
    ADD CONSTRAINT pm_linkindecies_pkey PRIMARY KEY (id);


--
-- Name: pm_links_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_links
    ADD CONSTRAINT pm_links_pkey PRIMARY KEY (id);


--
-- Name: pm_notificationdef_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_notificationdef
    ADD CONSTRAINT pm_notificationdef_pkey PRIMARY KEY (id);


--
-- Name: pm_notificationprocact_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_notificationprocact
    ADD CONSTRAINT pm_notificationprocact_pkey PRIMARY KEY (id);


--
-- Name: pm_notificationrecipient_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_notificationrecipient
    ADD CONSTRAINT pm_notificationrecipient_pkey PRIMARY KEY (id);


--
-- Name: pm_notifications_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_notifications
    ADD CONSTRAINT pm_notifications_pkey PRIMARY KEY (id);


--
-- Name: pm_opened_files_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_opened_files
    ADD CONSTRAINT pm_opened_files_pkey PRIMARY KEY (id);


--
-- Name: pm_operation_panel_parameters_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_operation_panel_parameters
    ADD CONSTRAINT pm_operation_panel_parameters_pkey PRIMARY KEY (operation_panel_parameter_id);


--
-- Name: pm_operation_panel_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_operation_panel
    ADD CONSTRAINT pm_operation_panel_pkey PRIMARY KEY (operation_panel_id);


--
-- Name: pm_organizationalunits_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_organizationalunits
    ADD CONSTRAINT pm_organizationalunits_pkey PRIMARY KEY (id);


--
-- Name: pm_plugins_configuration_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_plugins_configuration
    ADD CONSTRAINT pm_plugins_configuration_pkey PRIMARY KEY (id);


--
-- Name: pm_position_role_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_position_role
    ADD CONSTRAINT pm_position_role_pkey PRIMARY KEY (positionid, roleid);


--
-- Name: pm_positions_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_positions
    ADD CONSTRAINT pm_positions_pkey PRIMARY KEY (id);


--
-- Name: pm_process_translation_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_process_translation
    ADD CONSTRAINT pm_process_translation_pkey PRIMARY KEY (processid, language);


--
-- Name: pm_processdata_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_processdata
    ADD CONSTRAINT pm_processdata_pkey PRIMARY KEY (id);


--
-- Name: pm_processtypes_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_processtypes
    ADD CONSTRAINT pm_processtypes_pkey PRIMARY KEY (id);


--
-- Name: pm_reportlistvariablevalue_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_reportlistvariablevalue
    ADD CONSTRAINT pm_reportlistvariablevalue_pkey PRIMARY KEY (id);


--
-- Name: pm_reports_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_reports
    ADD CONSTRAINT pm_reports_pkey PRIMARY KEY (id);


--
-- Name: pm_reportsprotection_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_reportsprotection
    ADD CONSTRAINT pm_reportsprotection_pkey PRIMARY KEY (id);


--
-- Name: pm_reportvariable_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_reportvariable
    ADD CONSTRAINT pm_reportvariable_pkey PRIMARY KEY (id);


--
-- Name: pm_rights_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_rights
    ADD CONSTRAINT pm_rights_pkey PRIMARY KEY (id);


--
-- Name: pm_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_roles
    ADD CONSTRAINT pm_roles_pkey PRIMARY KEY (id);


--
-- Name: pm_scheduled_tasks_category_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_scheduled_tasks_category
    ADD CONSTRAINT pm_scheduled_tasks_category_pkey PRIMARY KEY (id);


--
-- Name: pm_scheduled_tasks_history_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_scheduled_tasks_history
    ADD CONSTRAINT pm_scheduled_tasks_history_pkey PRIMARY KEY (id);


--
-- Name: pm_scheduled_tasks_parameters_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_scheduled_tasks_parameters
    ADD CONSTRAINT pm_scheduled_tasks_parameters_pkey PRIMARY KEY (scheduled_task_parameter_id);


--
-- Name: pm_scheduled_tasks_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_scheduled_tasks
    ADD CONSTRAINT pm_scheduled_tasks_pkey PRIMARY KEY (scheduled_task_id);


--
-- Name: pm_user_notification_configs_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_user_notification_configs
    ADD CONSTRAINT pm_user_notification_configs_pkey PRIMARY KEY (id);


--
-- Name: pm_user_notifications_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_user_notifications
    ADD CONSTRAINT pm_user_notifications_pkey PRIMARY KEY (id);


--
-- Name: pm_usercalendarshare_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_usercalendarshare
    ADD CONSTRAINT pm_usercalendarshare_pkey PRIMARY KEY (id);


--
-- Name: pm_userdata_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_userdata
    ADD CONSTRAINT pm_userdata_pkey PRIMARY KEY (id);


--
-- Name: pm_usersearchviews_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_usersearchviews
    ADD CONSTRAINT pm_usersearchviews_pkey PRIMARY KEY (id);


--
-- Name: pm_usersearchviewsprotection_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_usersearchviewsprotection
    ADD CONSTRAINT pm_usersearchviewsprotection_pkey PRIMARY KEY (id);


--
-- Name: pm_variable_distinguish_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_variable_distinguish
    ADD CONSTRAINT pm_variable_distinguish_pkey PRIMARY KEY (variable_distinguish_id);


--
-- Name: pm_variable_set_temp_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_variable_set_temp
    ADD CONSTRAINT pm_variable_set_temp_pkey PRIMARY KEY (process_id, activity_id, variable_id);


--
-- Name: pm_vcolumns_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_vcolumns
    ADD CONSTRAINT pm_vcolumns_pkey PRIMARY KEY (tableid, id);


--
-- Name: pm_vtables_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_vtables
    ADD CONSTRAINT pm_vtables_pkey PRIMARY KEY (id);


--
-- Name: pm_vtypes_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_vtypes
    ADD CONSTRAINT pm_vtypes_pkey PRIMARY KEY (id);


--
-- Name: pm_vvalues_pkey; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_vvalues
    ADD CONSTRAINT pm_vvalues_pkey PRIMARY KEY (tableid, columnid, vvalue_rowid);


--
-- Name: processdata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processdata
    ADD CONSTRAINT processdata_objectid PRIMARY KEY (objectid);


--
-- Name: processdatablobs_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processdatablobs
    ADD CONSTRAINT processdatablobs_objectid PRIMARY KEY (objectid);


--
-- Name: processdatawob_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processdatawob
    ADD CONSTRAINT processdatawob_objectid PRIMARY KEY (objectid);


--
-- Name: processdefinitions_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processdefinitions
    ADD CONSTRAINT processdefinitions_objectid PRIMARY KEY (objectid);


--
-- Name: processes_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processes
    ADD CONSTRAINT processes_objectid PRIMARY KEY (objectid);


--
-- Name: processrequesters_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processrequesters
    ADD CONSTRAINT processrequesters_objectid PRIMARY KEY (objectid);


--
-- Name: processstateeventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processstateeventaudits
    ADD CONSTRAINT processstateeventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: processstates_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY processstates
    ADD CONSTRAINT processstates_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelparticipant
    ADD CONSTRAINT proclevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelxpdlapp_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelxpdlapp
    ADD CONSTRAINT proclevelxpdlapp_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelxpdlapptaappdetail_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelxpdlapptaappdetail
    ADD CONSTRAINT proclevelxpdlapptaappdetail_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelxpdlapptaappdetailusr_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelxpdlapptaappdetailusr
    ADD CONSTRAINT proclevelxpdlapptaappdetailusr_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelxpdlapptaappuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelxpdlapptaappuser
    ADD CONSTRAINT proclevelxpdlapptaappuser_objectid PRIMARY KEY (objectid);


--
-- Name: proclevelxpdlapptoolagentapp_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY proclevelxpdlapptoolagentapp
    ADD CONSTRAINT proclevelxpdlapptoolagentapp_objectid PRIMARY KEY (objectid);


--
-- Name: resourcestable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY resourcestable
    ADD CONSTRAINT resourcestable_objectid PRIMARY KEY (objectid);


--
-- Name: stateeventaudits_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_objectid PRIMARY KEY (objectid);


--
-- Name: toolagentapp_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY toolagentapp
    ADD CONSTRAINT toolagentapp_objectid PRIMARY KEY (objectid);


--
-- Name: toolagentappdetail_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY toolagentappdetail
    ADD CONSTRAINT toolagentappdetail_objectid PRIMARY KEY (objectid);


--
-- Name: toolagentappdetailuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY toolagentappdetailuser
    ADD CONSTRAINT toolagentappdetailuser_objectid PRIMARY KEY (objectid);


--
-- Name: toolagentappuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY toolagentappuser
    ADD CONSTRAINT toolagentappuser_objectid PRIMARY KEY (objectid);


--
-- Name: toolagentuser_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY toolagentuser
    ADD CONSTRAINT toolagentuser_objectid PRIMARY KEY (objectid);


--
-- Name: uk_3c75up0li4g2d0wamldnxw1kr; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_plugins_configuration
    ADD CONSTRAINT uk_3c75up0li4g2d0wamldnxw1kr UNIQUE (plugin_file_md5);


--
-- Name: uk_5g95e5rtev82dsy4ei5qtnde2; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_file_versions
    ADD CONSTRAINT uk_5g95e5rtev82dsy4ei5qtnde2 UNIQUE (fileid);


--
-- Name: uk_8tqmiyi7s0flxyip7jagn783l; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_organizationalunits
    ADD CONSTRAINT uk_8tqmiyi7s0flxyip7jagn783l UNIQUE (organizationalunitsymbol);


--
-- Name: uk_cn0lf0l2yuh5uwvpi86bl1dsr; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_docclasses
    ADD CONSTRAINT uk_cn0lf0l2yuh5uwvpi86bl1dsr UNIQUE (docclassname);


--
-- Name: uk_mw4qt93vfvl3elxfant6j6m9x; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_rights
    ADD CONSTRAINT uk_mw4qt93vfvl3elxfant6j6m9x UNIQUE (resource_id, is_resource_a_group, right_level);


--
-- Name: uk_qt2qkw71tes14fvisaw2ipk0d; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_scheduled_tasks_category
    ADD CONSTRAINT uk_qt2qkw71tes14fvisaw2ipk0d UNIQUE (name);


--
-- Name: uk_qykk3s5tq5joixvfk2db40f08; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY pm_positions
    ADD CONSTRAINT uk_qykk3s5tq5joixvfk2db40f08 UNIQUE (positionsymbol);


--
-- Name: usergrouptable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY usergrouptable
    ADD CONSTRAINT usergrouptable_objectid PRIMARY KEY (objectid);


--
-- Name: userpacklevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY userpacklevelparticipant
    ADD CONSTRAINT userpacklevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: userproclevelparticipant_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY userproclevelparticipant
    ADD CONSTRAINT userproclevelparticipant_objectid PRIMARY KEY (objectid);


--
-- Name: usertable_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY usertable
    ADD CONSTRAINT usertable_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlapplicationpackage_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlapplicationpackage
    ADD CONSTRAINT xpdlapplicationpackage_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlapplicationprocess_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlapplicationprocess
    ADD CONSTRAINT xpdlapplicationprocess_objectid PRIMARY KEY (objectid);


--
-- Name: xpdldata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdldata
    ADD CONSTRAINT xpdldata_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlhistory_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlhistory
    ADD CONSTRAINT xpdlhistory_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlhistorydata_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlhistorydata
    ADD CONSTRAINT xpdlhistorydata_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlparticipantpackage_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlparticipantpackage
    ADD CONSTRAINT xpdlparticipantpackage_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlparticipantprocess_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlparticipantprocess
    ADD CONSTRAINT xpdlparticipantprocess_objectid PRIMARY KEY (objectid);


--
-- Name: xpdlreferences_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdlreferences
    ADD CONSTRAINT xpdlreferences_objectid PRIMARY KEY (objectid);


--
-- Name: xpdls_objectid; Type: CONSTRAINT; Schema: public; Owner: CURRENT_USER; Tablespace:
--

ALTER TABLE ONLY xpdls
    ADD CONSTRAINT xpdls_objectid PRIMARY KEY (objectid);


--
-- Name: i1_activities; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activities ON activities USING btree (id);


--
-- Name: i1_activitydata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activitydata ON activitydata USING btree (activity, variabledefinitionid);


--
-- Name: i1_activitydatablobs; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activitydatablobs ON activitydatablobs USING btree (activitydatawob);


--
-- Name: i1_activitydatawob; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activitydatawob ON activitydatawob USING btree (activity, variabledefinitionid);


--
-- Name: i1_activitystateeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activitystateeventaudits ON activitystateeventaudits USING btree (keyvalue);


--
-- Name: i1_activitystates; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_activitystates ON activitystates USING btree (keyvalue);


--
-- Name: i1_andjointable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_andjointable ON andjointable USING btree (cnt);


--
-- Name: i1_assignmenteventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_assignmenteventaudits ON assignmenteventaudits USING btree (cnt);


--
-- Name: i1_assignmentstable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_assignmentstable ON assignmentstable USING btree (cnt);


--
-- Name: i1_counters; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_counters ON counters USING btree (name);


--
-- Name: i1_createprocesseventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_createprocesseventaudits ON createprocesseventaudits USING btree (cnt);


--
-- Name: i1_dataeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_dataeventaudits ON dataeventaudits USING btree (cnt);


--
-- Name: i1_deadlines; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_deadlines ON deadlines USING btree (cnt);


--
-- Name: i1_eventtypes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_eventtypes ON eventtypes USING btree (keyvalue);


--
-- Name: i1_groupgrouptable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_groupgrouptable ON groupgrouptable USING btree (sub_gid, groupid);


--
-- Name: i1_grouptable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_grouptable ON grouptable USING btree (groupid);


--
-- Name: i1_groupuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_groupuser ON groupuser USING btree (username);


--
-- Name: i1_groupuserpacklevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_groupuserpacklevelparticipant ON groupuserpacklevelparticipant USING btree (participantoid, useroid);


--
-- Name: i1_groupuserproclevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_groupuserproclevelparticipant ON groupuserproclevelparticipant USING btree (participantoid, useroid);


--
-- Name: i1_locktable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_locktable ON locktable USING btree (id);


--
-- Name: i1_neweventauditdata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_neweventauditdata ON neweventauditdata USING btree (dataeventaudit, variabledefinitionid);


--
-- Name: i1_neweventauditdatablobs; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_neweventauditdatablobs ON neweventauditdatablobs USING btree (neweventauditdatawob);


--
-- Name: i1_neweventauditdatawob; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_neweventauditdatawob ON neweventauditdatawob USING btree (dataeventaudit, variabledefinitionid);


--
-- Name: i1_nextxpdlversions; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_nextxpdlversions ON nextxpdlversions USING btree (xpdlid, nextversion);


--
-- Name: i1_normaluser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_normaluser ON normaluser USING btree (username);


--
-- Name: i1_oldeventauditdata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_oldeventauditdata ON oldeventauditdata USING btree (dataeventaudit, variabledefinitionid);


--
-- Name: i1_oldeventauditdatablobs; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_oldeventauditdatablobs ON oldeventauditdatablobs USING btree (oldeventauditdatawob);


--
-- Name: i1_oldeventauditdatawob; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_oldeventauditdatawob ON oldeventauditdatawob USING btree (dataeventaudit, variabledefinitionid);


--
-- Name: i1_packlevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelparticipant ON packlevelparticipant USING btree (participant_id, packageoid);


--
-- Name: i1_packlevelxpdlapp; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelxpdlapp ON packlevelxpdlapp USING btree (application_id, packageoid);


--
-- Name: i1_packlevelxpdlapptaappdetail; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelxpdlapptaappdetail ON packlevelxpdlapptaappdetail USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_packlevelxpdlapptaappdetailusr; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelxpdlapptaappdetailusr ON packlevelxpdlapptaappdetailusr USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_packlevelxpdlapptaappuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelxpdlapptaappuser ON packlevelxpdlapptaappuser USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_packlevelxpdlapptoolagentapp; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_packlevelxpdlapptoolagentapp ON packlevelxpdlapptoolagentapp USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_processdata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processdata ON processdata USING btree (process, variabledefinitionid);


--
-- Name: i1_processdatablobs; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processdatablobs ON processdatablobs USING btree (processdatawob);


--
-- Name: i1_processdatawob; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processdatawob ON processdatawob USING btree (process, variabledefinitionid);


--
-- Name: i1_processdefinitions; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processdefinitions ON processdefinitions USING btree (name);


--
-- Name: i1_processes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processes ON processes USING btree (id);


--
-- Name: i1_processrequesters; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processrequesters ON processrequesters USING btree (id);


--
-- Name: i1_processstateeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processstateeventaudits ON processstateeventaudits USING btree (keyvalue);


--
-- Name: i1_processstates; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_processstates ON processstates USING btree (keyvalue);


--
-- Name: i1_proclevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelparticipant ON proclevelparticipant USING btree (participant_id, processoid);


--
-- Name: i1_proclevelxpdlapp; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelxpdlapp ON proclevelxpdlapp USING btree (application_id, processoid);


--
-- Name: i1_proclevelxpdlapptaappdetail; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelxpdlapptaappdetail ON proclevelxpdlapptaappdetail USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_proclevelxpdlapptaappdetailusr; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelxpdlapptaappdetailusr ON proclevelxpdlapptaappdetailusr USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_proclevelxpdlapptaappuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelxpdlapptaappuser ON proclevelxpdlapptaappuser USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_proclevelxpdlapptoolagentapp; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_proclevelxpdlapptoolagentapp ON proclevelxpdlapptoolagentapp USING btree (xpdl_appoid, toolagentoid);


--
-- Name: i1_resourcestable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_resourcestable ON resourcestable USING btree (username);


--
-- Name: i1_stateeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_stateeventaudits ON stateeventaudits USING btree (cnt);


--
-- Name: i1_toolagentapp; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_toolagentapp ON toolagentapp USING btree (tool_agent_name, app_name);


--
-- Name: i1_toolagentappdetail; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_toolagentappdetail ON toolagentappdetail USING btree (app_mode, toolagent_appoid);


--
-- Name: i1_toolagentappdetailuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_toolagentappdetailuser ON toolagentappdetailuser USING btree (toolagent_appoid, useroid);


--
-- Name: i1_toolagentappuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_toolagentappuser ON toolagentappuser USING btree (toolagent_appoid, useroid);


--
-- Name: i1_toolagentuser; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_toolagentuser ON toolagentuser USING btree (username);


--
-- Name: i1_usergrouptable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_usergrouptable ON usergrouptable USING btree (userid, groupid);


--
-- Name: i1_userpacklevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_userpacklevelparticipant ON userpacklevelparticipant USING btree (participantoid, useroid);


--
-- Name: i1_userproclevelparticipant; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_userproclevelparticipant ON userproclevelparticipant USING btree (participantoid, useroid);


--
-- Name: i1_usertable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_usertable ON usertable USING btree (userid);


--
-- Name: i1_xpdlapplicationpackage; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlapplicationpackage ON xpdlapplicationpackage USING btree (package_id);


--
-- Name: i1_xpdlapplicationprocess; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlapplicationprocess ON xpdlapplicationprocess USING btree (process_id, packageoid);


--
-- Name: i1_xpdldata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdldata ON xpdldata USING btree (cnt);


--
-- Name: i1_xpdlhistory; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlhistory ON xpdlhistory USING btree (xpdlid, xpdlversion);


--
-- Name: i1_xpdlhistorydata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlhistorydata ON xpdlhistorydata USING btree (cnt);


--
-- Name: i1_xpdlparticipantpackage; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlparticipantpackage ON xpdlparticipantpackage USING btree (package_id);


--
-- Name: i1_xpdlparticipantprocess; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlparticipantprocess ON xpdlparticipantprocess USING btree (process_id, packageoid);


--
-- Name: i1_xpdlreferences; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdlreferences ON xpdlreferences USING btree (referredxpdlid, referringxpdl);


--
-- Name: i1_xpdls; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i1_xpdls ON xpdls USING btree (xpdlid, xpdlversion);


--
-- Name: i2_activities; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_activities ON activities USING btree (process, activitysetdefinitionid, activitydefinitionid);


--
-- Name: i2_activitystateeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_activitystateeventaudits ON activitystateeventaudits USING btree (name);


--
-- Name: i2_activitystates; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_activitystates ON activitystates USING btree (name);


--
-- Name: i2_andjointable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_andjointable ON andjointable USING btree (process, activitysetdefinitionid, activitydefinitionid);


--
-- Name: i2_assignmentstable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_assignmentstable ON assignmentstable USING btree (activity, theresource);


--
-- Name: i2_deadlines; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_deadlines ON deadlines USING btree (process, timelimit);


--
-- Name: i2_eventtypes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_eventtypes ON eventtypes USING btree (name);


--
-- Name: i2_groupgrouptable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_groupgrouptable ON groupgrouptable USING btree (groupid);


--
-- Name: i2_locktable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_locktable ON locktable USING btree (id, enginename);


--
-- Name: i2_processes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_processes ON processes USING btree (processdefinition);


--
-- Name: i2_processrequesters; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i2_processrequesters ON processrequesters USING btree (activityrequester);


--
-- Name: i2_processstateeventaudits; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_processstateeventaudits ON processstateeventaudits USING btree (name);


--
-- Name: i2_processstates; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_processstates ON processstates USING btree (name);


--
-- Name: i2_xpdldata; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE UNIQUE INDEX i2_xpdldata ON xpdldata USING btree (xpdl);


--
-- Name: i3_activities; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_activities ON activities USING btree (process, state);


--
-- Name: i3_andjointable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_andjointable ON andjointable USING btree (activity);


--
-- Name: i3_assignmentstable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_assignmentstable ON assignmentstable USING btree (theresource, isvalid);


--
-- Name: i3_deadlines; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_deadlines ON deadlines USING btree (activity, timelimit);


--
-- Name: i3_processes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_processes ON processes USING btree (state);


--
-- Name: i3_processrequesters; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i3_processrequesters ON processrequesters USING btree (resourcerequester);


--
-- Name: i4_assignmentstable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i4_assignmentstable ON assignmentstable USING btree (activityid);


--
-- Name: i4_processes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i4_processes ON processes USING btree (activityrequesterid);


--
-- Name: i5_assignmentstable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i5_assignmentstable ON assignmentstable USING btree (resourceid);


--
-- Name: i5_processes; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i5_processes ON processes USING btree (resourcerequesterid);


--
-- Name: i01_usertable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_usertable ON usertable USING btree (firstname);


--
-- Name: i02_usertable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_usertable ON usertable USING btree (lastname);


--
-- Name: i01_pm_file_versions; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_file_versions ON pm_file_versions USING btree (newest_fileid);


--
-- Name: i01_pm_substitutions; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_substitutions ON pm_substitutions USING btree (substituted);


--
-- Name: i01_pm_notificationprocact; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_notificationprocact ON pm_notificationprocact USING btree (notificationdefid);


--
-- Name: i01_pm_usersearchviewsprot; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_usersearchviewsprot ON pm_usersearchviewsprotection USING btree (shareuserid);


--
-- Name: i01_pm_usersearchviews; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_usersearchviews ON pm_usersearchviews USING btree (username);


--
-- Name: i01_pm_advancesearchvariables; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_advancesearchvariables ON pm_advancesearchvariables USING btree (viewid);


--
-- Name: i01_pm_reportvariable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_reportvariable ON pm_reportvariable USING btree (reportid);


--
-- Name: i01_pm_reports; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_reports ON pm_reports USING btree (username);


--
-- Name: i01_pm_rights; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_rights ON pm_rights USING btree (right_level);


--
-- Name: i02_pm_rights; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_pm_rights ON pm_rights USING btree (resource_id);


--
-- Name: i01_pm_indecies; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_indecies ON pm_indecies USING btree (docclassid);


--
-- Name: i01_pm_notifications; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_notifications ON pm_notifications USING btree (processid);


--
-- Name: i01_deadlines; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_deadlines ON deadlines USING btree (process);


--
-- Name: i02_deadlines; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_deadlines ON deadlines USING btree (activity);


--
-- Name: i01_usergrouptable; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_usergrouptable ON usergrouptable USING btree (groupid);


--
-- Name: i01_pm_activity_document; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_activity_document ON pm_activity_document USING btree (process);


--
-- Name: i02_pm_activity_document; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_pm_activity_document ON pm_activity_document USING btree (activity);


--
-- Name: i03_pm_activity_document; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i03_pm_activity_document ON pm_activity_document USING btree (fileid);


--
-- Name: i04_pm_activity_document; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i04_pm_activity_document ON pm_activity_document USING btree (userid);


--
-- Name: i01_pm_activitycomments; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_activitycomments ON pm_activitycomments USING btree (processid);


--
-- Name: i01_pm_delegatedactivities; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_delegatedactivities ON pm_delegatedactivities USING btree (activityid);


--
-- Name: i02_pm_delegatedactivities; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_pm_delegatedactivities ON pm_delegatedactivities USING btree (delegateduser);


--
-- Name: i01_pm_docclassconditionprot; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_docclassconditionprot ON pm_docclassconditionprotection USING btree (docclassid);


--
-- Name: i02_pm_docclassconditionprot; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_pm_docclassconditionprot ON pm_docclassconditionprotection USING btree (userid);


--
-- Name: i01_pm_activity_status; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_activity_status ON pm_activity_status USING btree (process_id,status_type,status_is_newest,status_id,activity_id);


--
-- Name: i01_pm_document_views; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_document_views ON pm_document_views USING btree (proc_def_id);


--
-- Name: i01_pm_user_notifications; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_user_notifications ON pm_user_notifications USING btree (receiver,confirmed);


--
-- Name: i02_pm_user_notifications; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i02_pm_user_notifications ON pm_user_notifications USING btree (receiver,failure);


--
-- Name: i01_pm_usercalendarshare; Type: INDEX; Schema: public; Owner: CURRENT_USER; Tablespace:
--

CREATE INDEX i01_pm_usercalendarshare ON pm_usercalendarshare USING btree (shareuserid);


--
-- Name: activities_process; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activities
    ADD CONSTRAINT activities_process FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: activities_state; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activities
    ADD CONSTRAINT activities_state FOREIGN KEY (state) REFERENCES activitystates(objectid);


--
-- Name: activities_theresource; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activities
    ADD CONSTRAINT activities_theresource FOREIGN KEY (theresource) REFERENCES resourcestable(objectid);


--
-- Name: activitydata_activity; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activitydata
    ADD CONSTRAINT activitydata_activity FOREIGN KEY (activity) REFERENCES activities(objectid);


--
-- Name: activitydatablobs_activitydatawob; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activitydatablobs
    ADD CONSTRAINT activitydatablobs_activitydatawob FOREIGN KEY (activitydatawob) REFERENCES activitydatawob(objectid);


--
-- Name: activitydatawob_activity; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY activitydatawob
    ADD CONSTRAINT activitydatawob_activity FOREIGN KEY (activity) REFERENCES activities(objectid);


--
-- Name: andjointable_activity; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY andjointable
    ADD CONSTRAINT andjointable_activity FOREIGN KEY (activity) REFERENCES activities(objectid);


--
-- Name: andjointable_process; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY andjointable
    ADD CONSTRAINT andjointable_process FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: assignmenteventaudits_thetype; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY assignmenteventaudits
    ADD CONSTRAINT assignmenteventaudits_thetype FOREIGN KEY (thetype) REFERENCES eventtypes(objectid);


--
-- Name: assignmentstable_activity; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY assignmentstable
    ADD CONSTRAINT assignmentstable_activity FOREIGN KEY (activity) REFERENCES activities(objectid);


--
-- Name: assignmentstable_theresource; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY assignmentstable
    ADD CONSTRAINT assignmentstable_theresource FOREIGN KEY (theresource) REFERENCES resourcestable(objectid);


--
-- Name: createprocesseventaudits_thetype; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY createprocesseventaudits
    ADD CONSTRAINT createprocesseventaudits_thetype FOREIGN KEY (thetype) REFERENCES eventtypes(objectid);


--
-- Name: dataeventaudits_thetype; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY dataeventaudits
    ADD CONSTRAINT dataeventaudits_thetype FOREIGN KEY (thetype) REFERENCES eventtypes(objectid);


--
-- Name: deadlines_activity; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY deadlines
    ADD CONSTRAINT deadlines_activity FOREIGN KEY (activity) REFERENCES activities(objectid);


--
-- Name: deadlines_process; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY deadlines
    ADD CONSTRAINT deadlines_process FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: fk_18u81p51ns1c6mcjvki6pj13c; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_directories
    ADD CONSTRAINT fk_18u81p51ns1c6mcjvki6pj13c FOREIGN KEY (rootdirectoryid) REFERENCES pm_directories(id);


--
-- Name: fk_1aga3412yhj9ju42eijrg5v90; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_operation_panel_parameters
    ADD CONSTRAINT fk_1aga3412yhj9ju42eijrg5v90 FOREIGN KEY (operation_panel_id) REFERENCES pm_operation_panel(operation_panel_id);


--
-- Name: fk_1iptjpwgfmo8wsvs95sb9uq0; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_position_role
    ADD CONSTRAINT fk_1iptjpwgfmo8wsvs95sb9uq0 FOREIGN KEY (roleid) REFERENCES pm_roles(id);


--
-- Name: fk_21dcy78o0padsbbhb9i3dvokl; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_userdata
    ADD CONSTRAINT fk_21dcy78o0padsbbhb9i3dvokl FOREIGN KEY (userid) REFERENCES usertable(objectid);


--
-- Name: fk_3afp7q3tabn0clet0ohtehje1; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_linkconnection
    ADD CONSTRAINT fk_3afp7q3tabn0clet0ohtehje1 FOREIGN KEY (docclassid) REFERENCES pm_docclasses(id);


--
-- Name: fk_3u1i14xg7c20gxv5t0q81rilt; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_positions
    ADD CONSTRAINT fk_3u1i14xg7c20gxv5t0q81rilt FOREIGN KEY (higherpositionid) REFERENCES pm_positions(id);


--
-- Name: fk_42wvrbsw0yf0j8hpskcq3096w; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT fk_42wvrbsw0yf0j8hpskcq3096w FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: fk_5g95e5rtev82dsy4ei5qtnde2; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_file_versions
    ADD CONSTRAINT fk_5g95e5rtev82dsy4ei5qtnde2 FOREIGN KEY (fileid) REFERENCES pm_files(id);


--
-- Name: fk_6fbx8827lmfvdpb1g0jcwmnnv; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT fk_6fbx8827lmfvdpb1g0jcwmnnv FOREIGN KEY (fileid) REFERENCES pm_files(id);


--
-- Name: fk_6lgibe4cj428mahvpatn5sxom; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_docclasses
    ADD CONSTRAINT fk_6lgibe4cj428mahvpatn5sxom FOREIGN KEY (docclassdirectoryid) REFERENCES pm_directories(id);


--
-- Name: fk_6vwltofsq2485ghw20xfcld9m; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activityredirection_groups
    ADD CONSTRAINT fk_6vwltofsq2485ghw20xfcld9m FOREIGN KEY (targetgroup) REFERENCES grouptable(objectid);


--
-- Name: fk_72tlby59e4nyq7n67l22cd1jv; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_file_versions
    ADD CONSTRAINT fk_72tlby59e4nyq7n67l22cd1jv FOREIGN KEY (newest_fileid) REFERENCES pm_files(id);


--
-- Name: fk_7o8aehfv9sn3slvt92lt9qtkm; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT fk_7o8aehfv9sn3slvt92lt9qtkm FOREIGN KEY (version) REFERENCES pm_file_versions(id);


--
-- Name: fk_7r86w89tl7e93v6m6x0atsa56; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activityredirection_users
    ADD CONSTRAINT fk_7r86w89tl7e93v6m6x0atsa56 FOREIGN KEY (targetuser) REFERENCES usertable(objectid);


--
-- Name: fk_7rhytf8lrqhl8345f35e3w76e; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_scheduled_tasks_history
    ADD CONSTRAINT fk_7rhytf8lrqhl8345f35e3w76e FOREIGN KEY (taskid) REFERENCES pm_scheduled_tasks(scheduled_task_id);


--
-- Name: fk_85oxbewnwauq6f84ayc8yu26h; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_directories
    ADD CONSTRAINT fk_85oxbewnwauq6f84ayc8yu26h FOREIGN KEY (deviceid) REFERENCES pm_devices(id);


--
-- Name: fk_8sdy1k5rj0hrrjbtfplgf4jpl; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_vcolumns
    ADD CONSTRAINT fk_8sdy1k5rj0hrrjbtfplgf4jpl FOREIGN KEY (typeid) REFERENCES pm_vtypes(id);


--
-- Name: fk_92assdyl6qajmngosujr2xhnh; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT fk_92assdyl6qajmngosujr2xhnh FOREIGN KEY (activity) REFERENCES activities(objectid) ON DELETE CASCADE;


--
-- Name: fk_9amgdap6ghg0jpnlt2f3ynovb; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_organizationalunits
    ADD CONSTRAINT fk_9amgdap6ghg0jpnlt2f3ynovb FOREIGN KEY (higherorganizationalunitid) REFERENCES pm_organizationalunits(id);


--
-- Name: fk_9ta5vw7g06heaw17javv38mnq; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_positions
    ADD CONSTRAINT fk_9ta5vw7g06heaw17javv38mnq FOREIGN KEY (userid) REFERENCES usertable(objectid);


--
-- Name: fk_ahqo7ih2hag0yc9tqy0avj8q5; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_linkconnection
    ADD CONSTRAINT fk_ahqo7ih2hag0yc9tqy0avj8q5 FOREIGN KEY (linkid) REFERENCES pm_links(id);


--
-- Name: fk_b29cpxijg24tebqpd7lsxljvm; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_scheduled_tasks
    ADD CONSTRAINT fk_b29cpxijg24tebqpd7lsxljvm FOREIGN KEY (category_id) REFERENCES pm_scheduled_tasks_category(id);


--
-- Name: fk_d5xsfymb2ea989yosrr7k9tcm; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_linkconnection
    ADD CONSTRAINT fk_d5xsfymb2ea989yosrr7k9tcm FOREIGN KEY (indexid) REFERENCES pm_indecies(id);


--
-- Name: fk_efysd6mgps4uhj882y2wjv6cb; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activityredirection_groups
    ADD CONSTRAINT fk_efysd6mgps4uhj882y2wjv6cb FOREIGN KEY (redirection) REFERENCES pm_activityredirection(id);


--
-- Name: fk_fcprtpga9kxi2vk1p1f9w9tgu; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_linkconnection
    ADD CONSTRAINT fk_fcprtpga9kxi2vk1p1f9w9tgu FOREIGN KEY (linkindexid) REFERENCES pm_linkindecies(id);


--
-- Name: fk_g1xsebbfruf71fhtvv5thfr3e; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_scheduled_tasks_parameters
    ADD CONSTRAINT fk_g1xsebbfruf71fhtvv5thfr3e FOREIGN KEY (scheduled_task_id) REFERENCES pm_scheduled_tasks(scheduled_task_id);


--
-- Name: fk_i5ccqelqaxr6ihgg61gcx0uct; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_docclassconditionprotection
    ADD CONSTRAINT fk_i5ccqelqaxr6ihgg61gcx0uct FOREIGN KEY (docclassid) REFERENCES pm_docclasses(id);


--
-- Name: fk_iybhe442i7rmbmsh9sai36akj; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_files
    ADD CONSTRAINT fk_iybhe442i7rmbmsh9sai36akj FOREIGN KEY (docclassid) REFERENCES pm_docclasses(id);


--
-- Name: fk_j8bphk6d8hqc438jvbpgllvk6; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_actions
    ADD CONSTRAINT fk_j8bphk6d8hqc438jvbpgllvk6 FOREIGN KEY (docclassid) REFERENCES pm_docclasses(id);


--
-- Name: fk_jdwg9tbe9xdwxc3bhffdaps86; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activity_document
    ADD CONSTRAINT fk_jdwg9tbe9xdwxc3bhffdaps86 FOREIGN KEY (userid) REFERENCES usertable(objectid);


--
-- Name: fk_jgo839lt6w4ni79g6vjelk6q8; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activityredirection_users
    ADD CONSTRAINT fk_jgo839lt6w4ni79g6vjelk6q8 FOREIGN KEY (redirection) REFERENCES pm_activityredirection(id);


--
-- Name: fk_l5dl4jfne63rytsx0ua7a851e; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_positions
    ADD CONSTRAINT fk_l5dl4jfne63rytsx0ua7a851e FOREIGN KEY (organizationalunitid) REFERENCES pm_organizationalunits(id);


--
-- Name: fk_l71m7jduokeqbp05note87lk9; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_indecies
    ADD CONSTRAINT fk_l71m7jduokeqbp05note87lk9 FOREIGN KEY (docclassid) REFERENCES pm_docclasses(id);


--
-- Name: fk_lx10ip15rm7v0f0t886pjdm19; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_vcolumns
    ADD CONSTRAINT fk_lx10ip15rm7v0f0t886pjdm19 FOREIGN KEY (tableid) REFERENCES pm_vtables(id);


--
-- Name: fk_nu4ajavo7g1ugnavuirso0o0c; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_linkindecies
    ADD CONSTRAINT fk_nu4ajavo7g1ugnavuirso0o0c FOREIGN KEY (linkid) REFERENCES pm_links(id);


--
-- Name: fk_o6u7qnmff1au8nd9psbq0s6ws; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_activityredirection
    ADD CONSTRAINT fk_o6u7qnmff1au8nd9psbq0s6ws FOREIGN KEY (sourceuser) REFERENCES usertable(objectid);


--
-- Name: fk_oj19eykqyp025v0iu7t56kifo; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_organizationalunits
    ADD CONSTRAINT fk_oj19eykqyp025v0iu7t56kifo FOREIGN KEY (directorpositionid) REFERENCES pm_positions(id);


--
-- Name: fk_ps2iw5fj2havs4r2h3ae96oup; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_vvalues
    ADD CONSTRAINT fk_ps2iw5fj2havs4r2h3ae96oup FOREIGN KEY (tableid, columnid) REFERENCES pm_vcolumns(tableid, id) ON DELETE CASCADE;


--
-- Name: fk_px59cjc90bscbjbuijd2g6e6u; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_position_role
    ADD CONSTRAINT fk_px59cjc90bscbjbuijd2g6e6u FOREIGN KEY (positionid) REFERENCES pm_positions(id);


--
-- Name: fk_sotkpbhytpgxqcme4613or9el; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY pm_file_versions
    ADD CONSTRAINT fk_sotkpbhytpgxqcme4613or9el FOREIGN KEY (parent_fileid) REFERENCES pm_files(id);


--
-- Name: groupgrouptable_groupid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupgrouptable
    ADD CONSTRAINT groupgrouptable_groupid FOREIGN KEY (groupid) REFERENCES grouptable(objectid);


--
-- Name: groupgrouptable_sub_gid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupgrouptable
    ADD CONSTRAINT groupgrouptable_sub_gid FOREIGN KEY (sub_gid) REFERENCES grouptable(objectid);


--
-- Name: groupuserpacklevelparticipant_participantoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupuserpacklevelparticipant
    ADD CONSTRAINT groupuserpacklevelparticipant_participantoid FOREIGN KEY (participantoid) REFERENCES packlevelparticipant(objectid);


--
-- Name: groupuserpacklevelparticipant_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupuserpacklevelparticipant
    ADD CONSTRAINT groupuserpacklevelparticipant_useroid FOREIGN KEY (useroid) REFERENCES groupuser(objectid);


--
-- Name: groupuserproclevelparticipant_participantoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupuserproclevelparticipant
    ADD CONSTRAINT groupuserproclevelparticipant_participantoid FOREIGN KEY (participantoid) REFERENCES proclevelparticipant(objectid);


--
-- Name: groupuserproclevelparticipant_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY groupuserproclevelparticipant
    ADD CONSTRAINT groupuserproclevelparticipant_useroid FOREIGN KEY (useroid) REFERENCES groupuser(objectid);


--
-- Name: neweventauditdata_dataeventaudit; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY neweventauditdata
    ADD CONSTRAINT neweventauditdata_dataeventaudit FOREIGN KEY (dataeventaudit) REFERENCES dataeventaudits(objectid);


--
-- Name: neweventauditdatablobs_neweventauditdatawob; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY neweventauditdatablobs
    ADD CONSTRAINT neweventauditdatablobs_neweventauditdatawob FOREIGN KEY (neweventauditdatawob) REFERENCES neweventauditdatawob(objectid);


--
-- Name: neweventauditdatawob_dataeventaudit; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY neweventauditdatawob
    ADD CONSTRAINT neweventauditdatawob_dataeventaudit FOREIGN KEY (dataeventaudit) REFERENCES dataeventaudits(objectid);


--
-- Name: oldeventauditdata_dataeventaudit; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY oldeventauditdata
    ADD CONSTRAINT oldeventauditdata_dataeventaudit FOREIGN KEY (dataeventaudit) REFERENCES dataeventaudits(objectid);


--
-- Name: oldeventauditdatablobs_oldeventauditdatawob; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY oldeventauditdatablobs
    ADD CONSTRAINT oldeventauditdatablobs_oldeventauditdatawob FOREIGN KEY (oldeventauditdatawob) REFERENCES oldeventauditdatawob(objectid);


--
-- Name: oldeventauditdatawob_dataeventaudit; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY oldeventauditdatawob
    ADD CONSTRAINT oldeventauditdatawob_dataeventaudit FOREIGN KEY (dataeventaudit) REFERENCES dataeventaudits(objectid);


--
-- Name: packlevelparticipant_packageoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelparticipant
    ADD CONSTRAINT packlevelparticipant_packageoid FOREIGN KEY (packageoid) REFERENCES xpdlparticipantpackage(objectid);


--
-- Name: packlevelxpdlapp_packageoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapp
    ADD CONSTRAINT packlevelxpdlapp_packageoid FOREIGN KEY (packageoid) REFERENCES xpdlapplicationpackage(objectid);


--
-- Name: packlevelxpdlapptaappdetail_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappdetail
    ADD CONSTRAINT packlevelxpdlapptaappdetail_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappdetail(objectid);


--
-- Name: packlevelxpdlapptaappdetail_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappdetail
    ADD CONSTRAINT packlevelxpdlapptaappdetail_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES packlevelxpdlapp(objectid);


--
-- Name: packlevelxpdlapptaappdetailusr_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappdetailusr
    ADD CONSTRAINT packlevelxpdlapptaappdetailusr_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappdetailuser(objectid);


--
-- Name: packlevelxpdlapptaappdetailusr_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappdetailusr
    ADD CONSTRAINT packlevelxpdlapptaappdetailusr_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES packlevelxpdlapp(objectid);


--
-- Name: packlevelxpdlapptaappuser_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappuser
    ADD CONSTRAINT packlevelxpdlapptaappuser_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappuser(objectid);


--
-- Name: packlevelxpdlapptaappuser_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptaappuser
    ADD CONSTRAINT packlevelxpdlapptaappuser_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES packlevelxpdlapp(objectid);


--
-- Name: packlevelxpdlapptoolagentapp_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptoolagentapp
    ADD CONSTRAINT packlevelxpdlapptoolagentapp_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentapp(objectid);


--
-- Name: packlevelxpdlapptoolagentapp_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY packlevelxpdlapptoolagentapp
    ADD CONSTRAINT packlevelxpdlapptoolagentapp_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES packlevelxpdlapp(objectid);


--
-- Name: processdata_process; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processdata
    ADD CONSTRAINT processdata_process FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: processdatablobs_processdatawob; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processdatablobs
    ADD CONSTRAINT processdatablobs_processdatawob FOREIGN KEY (processdatawob) REFERENCES processdatawob(objectid);


--
-- Name: processdatawob_process; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processdatawob
    ADD CONSTRAINT processdatawob_process FOREIGN KEY (process) REFERENCES processes(objectid);


--
-- Name: processes_processdefinition; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processes
    ADD CONSTRAINT processes_processdefinition FOREIGN KEY (processdefinition) REFERENCES processdefinitions(objectid);


--
-- Name: processes_state; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processes
    ADD CONSTRAINT processes_state FOREIGN KEY (state) REFERENCES processstates(objectid);


--
-- Name: processrequesters_activityrequester; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processrequesters
    ADD CONSTRAINT processrequesters_activityrequester FOREIGN KEY (activityrequester) REFERENCES activities(objectid);


--
-- Name: processrequesters_resourcerequester; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY processrequesters
    ADD CONSTRAINT processrequesters_resourcerequester FOREIGN KEY (resourcerequester) REFERENCES resourcestable(objectid);


--
-- Name: proclevelparticipant_processoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelparticipant
    ADD CONSTRAINT proclevelparticipant_processoid FOREIGN KEY (processoid) REFERENCES xpdlparticipantprocess(objectid);


--
-- Name: proclevelxpdlapp_processoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapp
    ADD CONSTRAINT proclevelxpdlapp_processoid FOREIGN KEY (processoid) REFERENCES xpdlapplicationprocess(objectid);


--
-- Name: proclevelxpdlapptaappdetail_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappdetail
    ADD CONSTRAINT proclevelxpdlapptaappdetail_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappdetail(objectid);


--
-- Name: proclevelxpdlapptaappdetail_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappdetail
    ADD CONSTRAINT proclevelxpdlapptaappdetail_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES proclevelxpdlapp(objectid);


--
-- Name: proclevelxpdlapptaappdetailusr_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappdetailusr
    ADD CONSTRAINT proclevelxpdlapptaappdetailusr_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappdetailuser(objectid);


--
-- Name: proclevelxpdlapptaappdetailusr_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappdetailusr
    ADD CONSTRAINT proclevelxpdlapptaappdetailusr_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES proclevelxpdlapp(objectid);


--
-- Name: proclevelxpdlapptaappuser_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappuser
    ADD CONSTRAINT proclevelxpdlapptaappuser_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentappuser(objectid);


--
-- Name: proclevelxpdlapptaappuser_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptaappuser
    ADD CONSTRAINT proclevelxpdlapptaappuser_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES proclevelxpdlapp(objectid);


--
-- Name: proclevelxpdlapptoolagentapp_toolagentoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptoolagentapp
    ADD CONSTRAINT proclevelxpdlapptoolagentapp_toolagentoid FOREIGN KEY (toolagentoid) REFERENCES toolagentapp(objectid);


--
-- Name: proclevelxpdlapptoolagentapp_xpdl_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY proclevelxpdlapptoolagentapp
    ADD CONSTRAINT proclevelxpdlapptoolagentapp_xpdl_appoid FOREIGN KEY (xpdl_appoid) REFERENCES proclevelxpdlapp(objectid);


--
-- Name: stateeventaudits_newactivitystate; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_newactivitystate FOREIGN KEY (newactivitystate) REFERENCES activitystateeventaudits(objectid);


--
-- Name: stateeventaudits_newprocessstate; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_newprocessstate FOREIGN KEY (newprocessstate) REFERENCES processstateeventaudits(objectid);


--
-- Name: stateeventaudits_oldactivitystate; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_oldactivitystate FOREIGN KEY (oldactivitystate) REFERENCES activitystateeventaudits(objectid);


--
-- Name: stateeventaudits_oldprocessstate; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_oldprocessstate FOREIGN KEY (oldprocessstate) REFERENCES processstateeventaudits(objectid);


--
-- Name: stateeventaudits_thetype; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY stateeventaudits
    ADD CONSTRAINT stateeventaudits_thetype FOREIGN KEY (thetype) REFERENCES eventtypes(objectid);


--
-- Name: toolagentappdetail_toolagent_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY toolagentappdetail
    ADD CONSTRAINT toolagentappdetail_toolagent_appoid FOREIGN KEY (toolagent_appoid) REFERENCES toolagentapp(objectid);


--
-- Name: toolagentappdetailuser_toolagent_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY toolagentappdetailuser
    ADD CONSTRAINT toolagentappdetailuser_toolagent_appoid FOREIGN KEY (toolagent_appoid) REFERENCES toolagentappdetail(objectid);


--
-- Name: toolagentappdetailuser_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY toolagentappdetailuser
    ADD CONSTRAINT toolagentappdetailuser_useroid FOREIGN KEY (useroid) REFERENCES toolagentuser(objectid);


--
-- Name: toolagentappuser_toolagent_appoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY toolagentappuser
    ADD CONSTRAINT toolagentappuser_toolagent_appoid FOREIGN KEY (toolagent_appoid) REFERENCES toolagentapp(objectid);


--
-- Name: toolagentappuser_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY toolagentappuser
    ADD CONSTRAINT toolagentappuser_useroid FOREIGN KEY (useroid) REFERENCES toolagentuser(objectid);


--
-- Name: usergrouptable_groupid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY usergrouptable
    ADD CONSTRAINT usergrouptable_groupid FOREIGN KEY (groupid) REFERENCES grouptable(objectid);


--
-- Name: usergrouptable_userid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY usergrouptable
    ADD CONSTRAINT usergrouptable_userid FOREIGN KEY (userid) REFERENCES usertable(objectid);


--
-- Name: userpacklevelparticipant_participantoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY userpacklevelparticipant
    ADD CONSTRAINT userpacklevelparticipant_participantoid FOREIGN KEY (participantoid) REFERENCES packlevelparticipant(objectid);


--
-- Name: userpacklevelparticipant_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY userpacklevelparticipant
    ADD CONSTRAINT userpacklevelparticipant_useroid FOREIGN KEY (useroid) REFERENCES normaluser(objectid);


--
-- Name: userproclevelparticipant_participantoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY userproclevelparticipant
    ADD CONSTRAINT userproclevelparticipant_participantoid FOREIGN KEY (participantoid) REFERENCES proclevelparticipant(objectid);


--
-- Name: userproclevelparticipant_useroid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY userproclevelparticipant
    ADD CONSTRAINT userproclevelparticipant_useroid FOREIGN KEY (useroid) REFERENCES normaluser(objectid);


--
-- Name: xpdlapplicationprocess_packageoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY xpdlapplicationprocess
    ADD CONSTRAINT xpdlapplicationprocess_packageoid FOREIGN KEY (packageoid) REFERENCES xpdlapplicationpackage(objectid);


--
-- Name: xpdldata_xpdl; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY xpdldata
    ADD CONSTRAINT xpdldata_xpdl FOREIGN KEY (xpdl) REFERENCES xpdls(objectid);


--
-- Name: xpdlhistorydata_xpdlhistory; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY xpdlhistorydata
    ADD CONSTRAINT xpdlhistorydata_xpdlhistory FOREIGN KEY (xpdlhistory) REFERENCES xpdlhistory(objectid);


--
-- Name: xpdlparticipantprocess_packageoid; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY xpdlparticipantprocess
    ADD CONSTRAINT xpdlparticipantprocess_packageoid FOREIGN KEY (packageoid) REFERENCES xpdlparticipantpackage(objectid);


--
-- Name: xpdlreferences_referringxpdl; Type: FK CONSTRAINT; Schema: public; Owner: CURRENT_USER
--

ALTER TABLE ONLY xpdlreferences
    ADD CONSTRAINT xpdlreferences_referringxpdl FOREIGN KEY (referringxpdl) REFERENCES xpdls(objectid);

ALTER TABLE ONLY pm_substitutions
    ADD CONSTRAINT pm_substitutions_pkey PRIMARY KEY (id);
ALTER TABLE ONLY pm_substitutions
    ADD CONSTRAINT fk_6w6rrt4yfkr0ffe8tpxlkbive FOREIGN KEY (role) REFERENCES pm_roles (id);
ALTER TABLE ONLY pm_substitutions
    ADD CONSTRAINT fk_kx0wni8xswincetlnruakv9fg FOREIGN KEY (substituted) REFERENCES usertable (objectid);
ALTER TABLE ONLY pm_substitutions
    ADD CONSTRAINT fk_qqucqfsnbgfmedk1rh7hosr01 FOREIGN KEY (substitute) REFERENCES usertable (objectid);


--
-- Name: public; Type: ACL; Schema: -; Owner: CURRENT_USER
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM CURRENT_USER;
GRANT ALL ON SCHEMA public TO CURRENT_USER;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

CREATE INDEX i4_activities ON activities USING btree (processid);

CREATE INDEX i1_pm_audits ON pm_audits USING btree (userid, audittype, auditstarted, auditstopped);
