/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateReportsTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateReportsTranslations.class);
    private Map<Long, String> reportsNames = new HashMap<Long, String>();
    private Map<Long, String> reportsDescriptions = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_reports_translations";
        this.sequenceName = "pm_reports_translations_id_seq";
        this.entityTableName = "pm_reports";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, reportname as name, reportdescr as description FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.reportsNames.put(resultSet.getLong("id"), resultSet.getString("name"));
                this.reportsDescriptions.put(resultSet.getLong("id"), resultSet.getString("description"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        InsertStatement insertStatement;
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.reportsNames, (String)translation.getKey());
        List<Long> translatedDescEntityIds = this.getTranslatedEntityId(this.reportsDescriptions, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        for (Long id : translatedDescEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"DESCRIPTION");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getReportsNames() {
        return this.reportsNames;
    }

    public Map<Long, String> getReportsDescriptions() {
        return this.reportsDescriptions;
    }

    public void setReportsNames(Map<Long, String> reportsNames) {
        this.reportsNames = reportsNames;
    }

    public void setReportsDescriptions(Map<Long, String> reportsDescriptions) {
        this.reportsDescriptions = reportsDescriptions;
    }
}

