/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.indexes.rename;

import com.suncode.pwfl.changes.indexes.rename.RenameOrCreateIndex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenamePostgresIndexes
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(RenamePostgresIndexes.class);
    private final String fileName = System.getProperty("plusworkflow.home") + "/rename-indexes-log.txt";
    private final String findIndexNameQuery = "SELECT indexname FROM pg_indexes WHERE tablename = '%1$s' AND indexdef ~* 'CREATE.*INDEX .* ON .*%1$s USING .* [(]%2$s[)]'";
    private final String findIndexNameWithIncludeColumnsQuery = "SELECT indexname FROM pg_indexes WHERE tablename = '%1$s' AND indexdef ~* 'CREATE.*INDEX .* ON .*%1$s USING .* [(]%2$s[)] INCLUDE [(]%3$s[)]'";
    protected String tableName;
    protected List<RenameOrCreateIndex> indexes;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        if (StringUtils.isBlank((CharSequence)this.tableName) || CollectionUtils.isEmpty(this.indexes)) {
            return new SqlStatement[0];
        }
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName, true));){
            writer.write(String.format("Checking indexes for table %s", this.tableName));
            writer.newLine();
            int i = 0;
            for (RenameOrCreateIndex index : this.indexes) {
                String query = CollectionUtils.isEmpty(index.getIncludeColumns()) ? String.format("SELECT indexname FROM pg_indexes WHERE tablename = '%1$s' AND indexdef ~* 'CREATE.*INDEX .* ON .*%1$s USING .* [(]%2$s[)]'", this.tableName, index.getColumns().stream().collect(Collectors.joining(", "))) : String.format("SELECT indexname FROM pg_indexes WHERE tablename = '%1$s' AND indexdef ~* 'CREATE.*INDEX .* ON .*%1$s USING .* [(]%2$s[)] INCLUDE [(]%3$s[)]'", this.tableName, index.getColumns().stream().collect(Collectors.joining(", ")), index.getIncludeColumns().stream().collect(Collectors.joining(", ")));
                try {
                    ResultSet resultSet = connection.prepareStatement(query).executeQuery();
                    Throwable throwable = null;
                    try {
                        if (resultSet.next()) {
                            String currentIndexName = resultSet.getString("indexname");
                            if (!currentIndexName.equals(index.getNewName())) {
                                writer.write(String.format("Renaming index %s to %s", currentIndexName, index.getNewName()));
                                writer.newLine();
                                statements.add(this.generateRenameStatement(currentIndexName, index.getNewName()));
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)index.getCreateIndexStatement())) {
                            writer.write(String.format("Creating index %s with query: %s", index.getNewName(), index.getCreateIndexStatement()));
                            writer.newLine();
                            statements.add(new RawSqlStatement(index.getCreateIndexStatement()));
                        }
                        ++i;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Exception e) {
                    log.error("Error fetching index {} for {} table", new Object[]{index.getNewName(), this.tableName, e});
                }
            }
            writer.write(String.format("%d/%d indexes processed", i, this.indexes.size()));
            writer.newLine();
            writer.newLine();
        }
        catch (IOException e) {
            log.error(String.format("Error on writing data to file: %s", this.fileName), (Throwable)e);
        }
        return statements.toArray(new SqlStatement[0]);
    }

    private RawSqlStatement generateRenameStatement(String oldName, String newName) {
        String query = String.format("ALTER INDEX IF EXISTS %s RENAME TO %s", oldName, newName);
        return new RawSqlStatement(query);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

