/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.tabs;

import com.suncode.pwfl.upgrade.SystemUpgrader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MigrationTabSettings
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(MigrationTabSettings.class);
    private boolean isDatabaseMSSQL;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        LinkedList<SqlStatement> statements = new LinkedList<SqlStatement>();
        this.isDatabaseMSSQL = database instanceof MSSQLDatabase;
        for (File packagePath : this.getXpdlPackagesPaths()) {
            File[] xpdlVersions = packagePath.listFiles();
            File latestXpdlPackage = Arrays.stream(xpdlVersions).filter(File::isDirectory).max(Comparator.comparing(File::lastModified)).orElse(null);
            statements.addAll(this.readProcessFiles(latestXpdlPackage));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private List<File> getXpdlPackagesPaths() {
        File[] files = new File(this.getXpdlPath()).listFiles();
        if (files == null) {
            return new ArrayList<File>();
        }
        return Arrays.stream(files).filter(File::isDirectory).collect(Collectors.toList());
    }

    private String getXpdlPath() {
        String xpdlPath = SystemUpgrader.getSharkConf().getProperty("EXTERNAL_PACKAGES_REPOSITORY");
        File xpdl = new File(xpdlPath);
        xpdlPath = xpdl.isAbsolute() ? xpdl.getAbsolutePath() : FilenameUtils.normalize((String)(SystemUpgrader.getSharkConf().getProperty("RootDirectoryPath") + File.separatorChar + xpdlPath));
        return xpdlPath;
    }

    public List<SqlStatement> readProcessFiles(File latestXpdlPackage) {
        LinkedList<SqlStatement> processStatements = new LinkedList<SqlStatement>();
        try {
            File[] packageFiles;
            for (File processDir : packageFiles = latestXpdlPackage.listFiles()) {
                for (File processFile : processDir.listFiles()) {
                    if (!this.isXml(processFile)) continue;
                    File xmlFile = new File(processFile.toString());
                    DocumentBuilderFactory docbuildFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docbuildFactory.newDocumentBuilder();
                    Document document = docBuilder.parse(xmlFile);
                    document.getDocumentElement().normalize();
                    System.out.println("Root element name :- " + document.getDocumentElement().getNodeName());
                    NodeList nodeList = document.getElementsByTagName("Tabs");
                    NodeList tabNodes = nodeList.item(0).getChildNodes();
                    processStatements.addAll(this.getTaskStatements(xmlFile, tabNodes));
                }
            }
        }
        catch (Exception e) {
            log.error("Error during reading xml file", (Object)e.getMessage());
        }
        return processStatements;
    }

    private boolean isXml(File processFile) {
        return processFile != null && processFile.toString().endsWith(".xml");
    }

    private List<SqlStatement> getTaskStatements(File xmlFile, NodeList tabNodes) {
        LinkedList<SqlStatement> taskStatements = new LinkedList<SqlStatement>();
        taskStatements.add(this.setTabsVisabilityParameter(xmlFile));
        for (int i = 0; i < tabNodes.getLength(); ++i) {
            Node tabNode = tabNodes.item(i);
            if (!tabNode.hasAttributes()) continue;
            taskStatements.add(this.buildTaskStatement(xmlFile, tabNode));
        }
        return taskStatements;
    }

    private SqlStatement setTabsVisabilityParameter(File xmlFile) {
        String tabName = "taskTabSettingsVisability";
        String tabActivity = "true";
        String procTypeId = this.getProcTypeId(xmlFile);
        String taskName = this.getTaskTypeName(xmlFile);
        InsertStatement statement = new InsertStatement("", "", "pm_processdata");
        if (!this.isDatabaseMSSQL) {
            statement.addColumn(this.createSequence());
        }
        statement.addColumnValue("sprocessfieldname", (Object)tabName);
        statement.addColumnValue("sprocessfieldvalue", (Object)tabActivity);
        statement.addColumnValue("sprocesstypename", (Object)procTypeId);
        statement.addColumnValue("stasktypename", (Object)taskName);
        return statement;
    }

    private SqlStatement buildTaskStatement(File xmlFile, Node child) {
        String tabName = this.convertTabName(child.getNodeName());
        String tabActivity = child.getAttributes().item(0).getNodeValue();
        String procTypeId = this.getProcTypeId(xmlFile);
        String taskName = this.getTaskTypeName(xmlFile);
        InsertStatement statement = new InsertStatement("", "", "pm_processdata");
        if (!this.isDatabaseMSSQL) {
            statement.addColumn(this.createSequence());
        }
        statement.addColumnValue("sprocessfieldname", (Object)tabName);
        statement.addColumnValue("sprocessfieldvalue", (Object)tabActivity);
        statement.addColumnValue("sprocesstypename", (Object)procTypeId);
        statement.addColumnValue("stasktypename", (Object)taskName);
        return statement;
    }

    private String getTaskTypeName(File xmlFile) {
        String fileName = xmlFile.getName();
        String taskName = fileName.substring(0, fileName.indexOf("."));
        return taskName;
    }

    private String getProcTypeId(File xmlFile) {
        return xmlFile.getParentFile().getName();
    }

    private String convertTabName(String tabName) {
        switch (tabName) {
            case "ProcessDocuments": {
                tabName = "showDocumentsPanel";
                break;
            }
            case "Informations": {
                tabName = "showInfoPanel";
                break;
            }
            case "Description": {
                tabName = "showDescriptionPanel";
                break;
            }
            case "History": {
                tabName = "showHistoryPanel";
                break;
            }
            case "ProcessMap": {
                tabName = "showMapPanel";
            }
        }
        return tabName;
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_processdata_id_seq"));
        return config;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

