/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.parameters.extended;

import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.changes.parameters.SystemParamUpgradeChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import org.apache.commons.lang3.StringUtils;

public class AdminPasswordParamChange
implements CustomSqlChange {
    private static String ADMIN_PARAM_KEY = "AdminPassword";
    private static String ADMIN_PARAM_CATEGORY = "Authorization";
    private static String OLD_ADMIN_PASSWORD_PARAM = "DEFAULT_ADMINISTRATOR_PASSWORD";
    private static String DEFAULT_ADMIN_PASSWORD = "enhydra";

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        SystemParamUpgradeChange change = new SystemParamUpgradeChange();
        change.setCategory(ADMIN_PARAM_CATEGORY);
        change.setParameterKey(ADMIN_PARAM_KEY);
        change.setRemovable(Boolean.FALSE.toString());
        change.setHidden(Boolean.TRUE.toString());
        change.setParameterType(ParameterType.PASSWORD.toString());
        String currentAdminPassword = change.getSharkValue(OLD_ADMIN_PASSWORD_PARAM);
        change.setDefaultValue((String)StringUtils.defaultIfEmpty((CharSequence)currentAdminPassword, (CharSequence)DEFAULT_ADMIN_PASSWORD));
        return change.generateStatements(database);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setFileOpener(ResourceAccessor arg0) {
    }

    public void setUp() throws SetupException {
    }

    public ValidationErrors validate(Database arg0) {
        return null;
    }
}

