CREATE TABLE pm_dashboard
(
	id bigint NOT NULL,
	created timestamp without time zone NOT NULL,
	description character varying(255),
	name character varying(100) NOT NULL,
	owner_id numeric(19,0) NOT NULL,
	CONSTRAINT pm_dashboard_pkey PRIMARY KEY (id),
	CONSTRAINT fk_pm_dashboard_usertable FOREIGN KEY (owner_id)
		REFERENCES usertable (objectid) MATCH SIMPLE
			ON UPDATE NO ACTION ON DELETE CASCADE,
	CONSTRAINT uk_pm_dashboard_owner_id_name UNIQUE (owner_id, name)
);

CREATE SEQUENCE pm_dashboard_id
	INCREMENT 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 6
	CACHE 1;
ALTER TABLE pm_dashboard_id
	OWNER TO CURRENT_USER;

CREATE TABLE pm_dashboard_default
(
	id bigint NOT NULL,
	dashboard_id bigint NOT NULL,
	group_id numeric(19,0),
	user_id numeric(19,0),
	CONSTRAINT pm_dashboard_default_pkey PRIMARY KEY (id),
	CONSTRAINT fk_pm_dashboard_default_grouptable FOREIGN KEY (group_id)
		REFERENCES grouptable (objectid) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE CASCADE,
	CONSTRAINT fk_pm_dashboard_default_pm_dashboard FOREIGN KEY (dashboard_id)
		REFERENCES pm_dashboard (id) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_pm_dashboard_default_usertable FOREIGN KEY (user_id)
		REFERENCES usertable (objectid) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE CASCADE,
	CONSTRAINT uk_pm_dashboard_default_group_id UNIQUE (group_id),
	CONSTRAINT uk_pm_dashboard_default_user_id UNIQUE (user_id)
);

CREATE SEQUENCE pm_dashboard_default_id
	INCREMENT 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 1
	CACHE 1;
ALTER TABLE pm_dashboard_default_id
	OWNER TO CURRENT_USER;

CREATE TABLE pm_dashboard_gadget
(
	id bigint NOT NULL,
		key character varying(255) NOT NULL,
	collapsed boolean NOT NULL,
	height integer,
	layoutorder integer,
	positionx integer,
	width integer,
	dashboard_id bigint NOT NULL,
	CONSTRAINT pm_dashboard_gadget_pkey PRIMARY KEY (id),
	CONSTRAINT fk_pm_dashboard_gadget_pm_dashboard FOREIGN KEY (dashboard_id)
		REFERENCES pm_dashboard (id) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE SEQUENCE pm_dashboard_gadget_id
	INCREMENT 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 10
	CACHE 1;
ALTER TABLE pm_dashboard_gadget_id
	OWNER TO CURRENT_USER;

CREATE TABLE pm_dashboard_gadgetprop
(
	id bigint NOT NULL,
	name character varying(100),
	value character varying(4000),
	gadget_id bigint NOT NULL,
		CONSTRAINT pm_dashboard_gadgetprop_pkey PRIMARY KEY (id),
		CONSTRAINT fk_pm_dashboard_gadgetprop_pm_dashboard_gadget FOREIGN KEY (gadget_id)
			REFERENCES pm_dashboard_gadget (id) MATCH SIMPLE
			ON UPDATE NO ACTION ON DELETE NO ACTION,
		CONSTRAINT uk_pm_dashboard_gadgetprop_gadget_id_name UNIQUE (gadget_id, name)
);

CREATE SEQUENCE pm_dashboard_gadgetprop_id
	INCREMENT 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 10
	CACHE 1;
ALTER TABLE pm_dashboard_gadgetprop_id
	OWNER TO CURRENT_USER;

CREATE TABLE pm_dashboard_share
(
	type character varying(31) NOT NULL,
	id bigint NOT NULL,
	dashboard_id bigint NOT NULL,
	group_id numeric(19,0),
	user_id numeric(19,0),
	CONSTRAINT pm_dashboard_share_pkey PRIMARY KEY (id),
	CONSTRAINT fk_pm_dashboard_share_pm_dashboard FOREIGN KEY (dashboard_id)
		REFERENCES pm_dashboard (id) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_pm_dashboard_share_usertable FOREIGN KEY (user_id)
		REFERENCES usertable (objectid) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE CASCADE,
	CONSTRAINT fk_pm_dashboard_share_grouptable FOREIGN KEY (group_id)
		REFERENCES grouptable (objectid) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE SEQUENCE pm_dashboard_share_id_seq
	INCREMENT 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 1
	CACHE 1;
ALTER TABLE pm_dashboard_share_id_seq
	OWNER TO CURRENT_USER;