/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import co.elastic.clients.json.JsonData;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfo;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.indexer.client.ElasticClient;
import com.suncode.pwfl.indexer.workflow.activity.repository.ActivityIndexingRepository;
import com.suncode.pwfl.indexer.workflow.process.repository.ProcessIndexingRepository;
import com.suncode.pwfl.util.SpringContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexProcessesAndActivitiesChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(ReindexProcessesAndActivitiesChange.class);

    public void execute(Database database) throws CustomChangeException {
        Experimental experimental = (Experimental)SpringContext.getBean(Experimental.class);
        if (!experimental.hasFeature(ExperimentalFeature.ELASTIC)) {
            return;
        }
        ScheduledTaskInfoService scheduledTaskInfoService = (ScheduledTaskInfoService)SpringContext.getBean(ScheduledTaskInfoService.class);
        Optional lastIndexProcessesAndActivitiesTask = scheduledTaskInfoService.getByLastRun("com.suncode.pwfl.indexer.workflow.scheduledtask.IndexProcessesAndActivitiesTask", "execute");
        if (!lastIndexProcessesAndActivitiesTask.isPresent()) {
            log.error("Reindexing failed - index processes and activities scheduled task does not exist");
            return;
        }
        ElasticClient elasticClient = (ElasticClient)SpringContext.getBean(ElasticClient.class);
        ProcessIndexingRepository processIndexingRepository = (ProcessIndexingRepository)SpringContext.getBean(ProcessIndexingRepository.class);
        ActivityIndexingRepository activityIndexingRepository = (ActivityIndexingRepository)SpringContext.getBean(ActivityIndexingRepository.class);
        elasticClient.updateClusterTransientSettings((Map)ImmutableMap.of((Object)"action.destructive_requires_name", (Object)JsonData.of((Object)false)));
        boolean processIndicesDeleted = processIndexingRepository.deleteIndexes();
        boolean activityIndicesDeleted = activityIndexingRepository.deleteIndexes();
        elasticClient.updateClusterTransientSettings((Map)ImmutableMap.of((Object)"action.destructive_requires_name", (Object)JsonData.of((Object)true)));
        if (!processIndicesDeleted || !activityIndicesDeleted) {
            log.error("Reindexing failed - delete processes and activities indices failed");
            return;
        }
        ScheduledTasksManager.getInstance().getExecutor().executeTask(((ScheduledTaskInfo)lastIndexProcessesAndActivitiesTask.get()).getId(), 5L, TimeUnit.SECONDS);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

