/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.parameters.extended;

import com.suncode.pwfl.SystemContext;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.changes.parameters.SystemParamUpgradeChange;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.FilterRegistration;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;

public class SpnegoPreauthParamChange
implements CustomSqlChange {
    private static String CATEGORY = "Authorization";
    private static String SPNEGO_FILTER_NAME = "SpnegoHttpFilter";
    private static String PREAUTH_USERNAME_KEY = "spnego.preauth.username";
    private static String PREAUTH_PASSWORD_KEY = "spnego.preauth.password";
    private static String DEFAULT_PREAUTH_USERNAME = "Administrator";
    private static String DEFAULT_PREAUTH_PASSWORD = "plusmpm";

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        SystemParamUpgradeChange usernameChange = this.createUsernameChange();
        SystemParamUpgradeChange passwordChange = this.createPasswordChange();
        return (SqlStatement[])Stream.concat(Stream.of(usernameChange.generateStatements(database)), Stream.of(passwordChange.generateStatements(database))).toArray(SqlStatement[]::new);
    }

    private SystemParamUpgradeChange createUsernameChange() {
        SystemParamUpgradeChange change = new SystemParamUpgradeChange();
        change.setCategory(CATEGORY);
        change.setParameterKey(PREAUTH_USERNAME_KEY);
        change.setRemovable(Boolean.FALSE.toString());
        change.setParameterType(ParameterType.TEXT.toString());
        change.setDefaultValue(this.getFilterInitParameter(SPNEGO_FILTER_NAME, PREAUTH_USERNAME_KEY, DEFAULT_PREAUTH_USERNAME));
        return change;
    }

    private SystemParamUpgradeChange createPasswordChange() {
        SystemParamUpgradeChange change = new SystemParamUpgradeChange();
        change.setCategory(CATEGORY);
        change.setParameterKey(PREAUTH_PASSWORD_KEY);
        change.setRemovable(Boolean.FALSE.toString());
        change.setParameterType(ParameterType.PASSWORD.toString());
        change.setDefaultValue(this.getFilterInitParameter(SPNEGO_FILTER_NAME, PREAUTH_PASSWORD_KEY, DEFAULT_PREAUTH_PASSWORD));
        return change;
    }

    private String getFilterInitParameter(String filterName, String parameterName, String defaultValue) {
        Map initParameters;
        FilterRegistration filterRegistration = SystemContext.get().getServletContext().getFilterRegistration(filterName);
        if (filterRegistration != null && (initParameters = filterRegistration.getInitParameters()).containsKey(parameterName)) {
            return (String)initParameters.get(parameterName);
        }
        return defaultValue;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

