/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.pluginbundler;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Packages;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PluginBundler
implements AnalyzerPlugin {
    public int ordering() {
        return Integer.MAX_VALUE;
    }

    public boolean analyzeJar(Analyzer analyzer) {
        Set<Descriptors.PackageRef> embeddedPackages = PluginBundler.findEmbedded(analyzer);
        if (embeddedPackages.isEmpty()) {
            analyzer.getLogger().debug("PluginBundler: No embedded dependencies found in bundle classpath");
            return PluginBundler.proceed();
        }
        if (!Boolean.valueOf(analyzer.getProperty("Embed-Transitive")).booleanValue()) {
            analyzer.getLogger().warn("PluginBundler: <Embed-Transitive> instruction is not set - it is recommended to enable transitive embedding for a project");
        }
        Packages contained = analyzer.getContained();
        Packages referred = analyzer.getReferred();
        Map<Descriptors.PackageRef, Set<Descriptors.PackageRef>> usages = PluginBundler.buildUsageIndex(analyzer);
        referred.forEach((referredPackage, attrs) -> {
            analyzer.getLogger().trace("PluginBundler: testing {}", referredPackage);
            if (referredPackage.isJava()) {
                analyzer.getLogger().trace("PluginBundler: {} is a java package", referredPackage);
                return;
            }
            if (contained.containsKey(referredPackage)) {
                analyzer.getLogger().trace("PluginBundler: {} is contained withing the bundle", referredPackage);
                return;
            }
            Set usage = (Set)usages.get(referredPackage);
            if (usage == null || usage.isEmpty()) {
                analyzer.getLogger().debug("PluginBundler: package {} is not being used by any other package", referredPackage);
                return;
            }
            boolean usedByEmbeddedOnly = true;
            for (Descriptors.PackageRef usingPackage : usage) {
                boolean packageNotEmbedded;
                boolean bl = packageNotEmbedded = !embeddedPackages.contains(usingPackage);
                if (packageNotEmbedded) {
                    usedByEmbeddedOnly = false;
                }
                analyzer.getLogger().debug("PluginBundler: package '{}' is {}used by embedded package: {}", new Object[]{referredPackage, packageNotEmbedded ? "not " : "", usingPackage});
            }
            if (usedByEmbeddedOnly) {
                analyzer.getLogger().debug("PluginBundler: package '{}' marked as `optional` since it is not being used by any non-embedded package", referredPackage);
                attrs.put("resolution:", "optional");
            } else {
                analyzer.getLogger().debug("PluginBundler: package '{}' is being used by non-embedded dependencies, not marking it as `optional`", referredPackage);
            }
        });
        return PluginBundler.proceed();
    }

    private static Map<Descriptors.PackageRef, Set<Descriptors.PackageRef>> buildUsageIndex(Analyzer analyzer) {
        HashMap<Descriptors.PackageRef, Set<Descriptors.PackageRef>> usages = new HashMap<Descriptors.PackageRef, Set<Descriptors.PackageRef>>();
        analyzer.getUses().forEach((packageRef, usedPackages) -> usedPackages.forEach(usedPackage -> usages.compute((Descriptors.PackageRef)usedPackage, (key, set) -> {
            if (set == null) {
                set = new HashSet<Descriptors.PackageRef>();
            }
            set.add(packageRef);
            return set;
        })));
        return usages;
    }

    private static Set<Descriptors.PackageRef> findEmbedded(Analyzer analyzer) {
        return analyzer.getBundleClassPathTypes().keySet().stream().map(Descriptors.TypeRef::getPackageRef).collect(Collectors.toSet());
    }

    private static boolean proceed() {
        return false;
    }
}

