/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.suncode.pwfl.i18n.utils.SpringI18NUtils;
import com.suncode.pwfl.i18n.utils.SupportedLanguagesProvider;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class AbstractI18N {
    private static final Logger log = LoggerFactory.getLogger(AbstractI18N.class);
    protected Locale locale;
    protected ResourceBundle bundle;

    public AbstractI18N() {
        this(LocaleContextHolder.getLocale());
    }

    public AbstractI18N(Locale locale) {
        log.trace("Ustawiam lokalizacj\u0119 u\u017cytkownika...");
        this.locale = locale;
        log.trace("Ustawiono: " + locale.getLanguage());
        this.populateBundle();
    }

    @Deprecated(since="4.2", forRemoval=true)
    public AbstractI18N(javax.servlet.http.HttpServletRequest request) {
        log.trace("Ustawiam lokalizacj\u0119 u\u017cytkownika, sprawdzaj\u0105c czy ma w sesji zapisane obiekt ustawie\u0144 j\u0119zykowych...");
        this.locale = LocaleContextHolder.getLocale();
        log.trace("Ustawiono: " + this.locale.getLanguage());
        this.populateBundle();
    }

    public static Locale getFromBrowserSettings(HttpServletRequest httpServletRequest) {
        log.info("Pobieram ustawienia j\u0119zykowe z ustawie\u0144 przegl\u0105darki");
        Enumeration enumLocales = httpServletRequest.getLocales();
        Locale locale = (Locale)enumLocales.nextElement();
        log.info("Pobrano: " + locale.getLanguage());
        return locale;
    }

    public static Locale getFromUserSettings(String username) {
        log.info("Pobieram ustawienia j\u0119zykowe z ustawie\u0144 u\u017cytkownika");
        return Locale.getDefault();
    }

    public static List<Locale> getSupportedLocales() {
        String supportedLocalesParam;
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        if (SimulationUtils.isInSimulation()) {
            supportedLocalesParam = "en;pl";
        } else {
            SupportedLanguagesProvider provider = (SupportedLanguagesProvider)SpringI18NUtils.getContext().getBean(SupportedLanguagesProvider.class);
            supportedLocalesParam = provider.getSupportedLocalesParam();
        }
        for (String localeLang : supportedLocalesParam.split(";")) {
            supportedLocales.add(new Locale(localeLang));
        }
        return supportedLocales;
    }

    public static boolean isLocaleSupported(Locale locale) {
        return AbstractI18N.isLocaleSupported(locale.getLanguage());
    }

    private static boolean isLocaleSupported(String language) {
        return AbstractI18N.getSupportedLocales().contains(new Locale(language));
    }

    @Deprecated(since="4.2", forRemoval=true)
    public static Locale getLocale(javax.servlet.http.HttpServletRequest request) {
        return LocaleContextHolder.getLocale();
    }

    public static void setSessionLocale(HttpSession session, String localeName) {
        log.info("Ustawiam w sesji ustawienia jezykowe uzytkownika na " + localeName);
        Locale locale = null;
        if (!localeName.equals("default") && AbstractI18N.isLocaleSupported(localeName)) {
            locale = new Locale(localeName);
        }
        session.setAttribute("org.apache.struts.action.LOCALE", locale);
    }

    public static void removeSessionLocale(HttpSession session) {
        log.info("Usuwam z sesji ustawienia jezykowe uzytkownika");
        session.removeAttribute("org.apache.struts.action.LOCALE");
    }

    public String getLang() {
        return this.locale.getLanguage();
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public static void refresh() {
        log.info("Odwiezam paczke zasob\u00f3w");
        ResourceBundle.clearCache();
    }

    public abstract void populateBundle();

    public abstract String getString(String var1);

    public abstract String getStringSilent(String var1);

    public String getStringOrDefault(String key, String defaultValue) {
        if (this.containsTranslation(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    public boolean containsTranslation(String key) {
        return this.bundle != null && this.bundle.containsKey(key);
    }
}

