/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TranslationOverrider {
    private static final Logger log = LoggerFactory.getLogger(TranslationOverrider.class);

    public List<Property> overrideTranslations(List<Property> originalProperties, File bundleFile, Map<String, String> additionalTranslations) throws IOException {
        List<Property> properties = this.copy(originalProperties);
        CachedProperties cachedProperties = new CachedProperties(properties);
        if (bundleFile.exists()) {
            this.overrideByBundleProperties(bundleFile, cachedProperties);
            this.overrideByAdditionalTranslations(cachedProperties, additionalTranslations);
            this.addCommentedBundleProperties(bundleFile, cachedProperties);
            this.removeDuplicated(properties);
        }
        return properties;
    }

    private void overrideByBundleProperties(File bundleFile, CachedProperties propertiesToOverride) throws IOException {
        Multimap<String, String> bundleProperties = this.toProperties(bundleFile);
        this.forEach(bundleProperties, (key, keyValue) -> {
            String value = StringUtils.defaultString((String)keyValue);
            if (propertiesToOverride.contains((String)key)) {
                propertiesToOverride.filterByKey((String)key).filter(property -> !property.getValue().equals(value)).filter(property -> property.getCommented() == false).forEachOrdered(property -> property.setValue(value));
            } else {
                this.addUnknownPackageProperty(propertiesToOverride, (String)key, value, false);
            }
        });
    }

    public Multimap<String, String> toProperties(File propertiesFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            Properties properties = new Properties();
            properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            LinkedHashMultimap result = LinkedHashMultimap.create();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> TranslationOverrider.lambda$toProperties$4((Multimap)result, arg_0, arg_1)));
            LinkedHashMultimap linkedHashMultimap = result;
            return linkedHashMultimap;
        }
    }

    private void overrideByAdditionalTranslations(CachedProperties propertiesToOverride, Map<String, String> additionalTranslations) {
        LinkedHashMultimap additionalTranslationsMultimap = LinkedHashMultimap.create();
        additionalTranslations.forEach((arg_0, arg_1) -> TranslationOverrider.lambda$overrideByAdditionalTranslations$5((Multimap)additionalTranslationsMultimap, arg_0, arg_1));
        this.forceOverride(propertiesToOverride, (Multimap<String, String>)additionalTranslationsMultimap);
    }

    private static String normalizeTranslationText(String translationText) {
        return StringUtils.defaultString((String)translationText).replace("\r\n", "<br>").replace("\n", "<br>").trim();
    }

    private void forceOverride(CachedProperties propertiesToOverride, Multimap<String, String> overrideProperties) {
        this.forEach(overrideProperties, (key, keyValue) -> {
            String value = StringUtils.defaultString((String)keyValue);
            if (propertiesToOverride.contains((String)key)) {
                boolean alreadyExists = propertiesToOverride.filterByKeyAndValue((String)key, value).anyMatch(property -> property.getCommented() == false);
                if (!alreadyExists) {
                    this.commentOldAndAdd(propertiesToOverride, (String)key, value);
                }
            } else {
                this.addUnknownPackageProperty(propertiesToOverride, (String)key, value, false);
            }
        });
    }

    private void commentOldAndAdd(CachedProperties propertiesSnapshot, String key, String value) {
        propertiesSnapshot.filterByKey(key).filter(property -> property.getCommented() == false).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(oldProperty -> {
            oldProperty.setCommented(true);
            Property bundleProperty = this.copyAndSet((Property)oldProperty, value, false);
            this.addBundleProperty(propertiesSnapshot, (Property)oldProperty, bundleProperty, true);
        });
    }

    private void addCommentedBundleProperties(File bundle, CachedProperties propertiesSnapshot) throws IOException {
        Multimap<String, String> commentedBundleProperties = this.loadCommentedPropertiesMap(bundle);
        LinkedList propertiesToAdd = new LinkedList();
        this.forEach(commentedBundleProperties, (key, value) -> {
            boolean hasSameKeyProperties = propertiesSnapshot.contains((String)key);
            if (hasSameKeyProperties) {
                boolean alreadyExists = propertiesSnapshot.filterByKeyAndValue((String)key, (String)value).anyMatch(Property::getCommented);
                if (!alreadyExists) {
                    propertiesSnapshot.filterByKey((String)key).filter(property -> property.getPackageVersion().isPresent()).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(property -> {
                        Property snapshotProperty = this.copyAndSet((Property)property, (String)value, true);
                        propertiesToAdd.add(snapshotProperty);
                    });
                }
            } else {
                this.addUnknownPackageProperty(propertiesSnapshot, (String)key, (String)value, true);
            }
        });
        Collections.reverse(propertiesToAdd);
        propertiesToAdd.forEach(newProperty -> {
            if (newProperty.getPackageVersion().isPresent()) {
                propertiesSnapshot.filterByKey(newProperty.getKey()).filter(property -> property.getPackageVersion().isPresent()).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(lastUncommentedProperty -> this.addBundleProperty(propertiesSnapshot, (Property)lastUncommentedProperty, (Property)newProperty, false));
            } else {
                propertiesSnapshot.add((Property)newProperty);
            }
        });
    }

    private Multimap<String, String> loadCommentedPropertiesMap(File propertiesFile) throws IOException {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        this.readLines(propertiesFile).stream().filter(line -> line.matches("\\s*#\\s*[^= :]*=[^=]*$")).map(line -> line.replaceFirst("#", "")).map(line -> line.split("=", -1)).forEachOrdered(arg_0 -> TranslationOverrider.lambda$loadCommentedPropertiesMap$22((Multimap)result, arg_0));
        return result;
    }

    private List<String> readLines(File file) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private void removeDuplicated(List<Property> properties) {
        List filteredProperties = properties.stream().filter(this.isNotBlank()).filter(this.distinctByKey(Property::hashCodeIgnorePackage)).collect(Collectors.toList());
        properties.clear();
        properties.addAll(filteredProperties);
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public Predicate<Property> isNotBlank() {
        return p -> StringUtils.isNotBlank((String)p.getValue());
    }

    private List<Property> copy(List<Property> properties) {
        return properties.stream().map(Property::snapshot).collect(Collectors.toList());
    }

    private Property copyAndSet(Property property, String value, Boolean commented) {
        Property bundleProperty = property.snapshot();
        bundleProperty.setValue(value);
        bundleProperty.setCommented(commented);
        return bundleProperty;
    }

    private void addBundleProperty(CachedProperties propertiesSnapshot, Property propertyPlacement, Property bundleProperty, Boolean after) {
        int index = propertiesSnapshot.indexOf(propertyPlacement);
        if (index >= 0) {
            propertiesSnapshot.add(after != false ? index + 1 : index, bundleProperty);
        } else {
            log.warn("Cannot find index of property " + propertyPlacement.getKey());
            propertiesSnapshot.add(bundleProperty);
        }
    }

    private void addUnknownPackageProperty(CachedProperties propertiesSnapshot, String key, String value, Boolean commented) {
        Property unknownPackageProperty = new Property(key, value, Optional.empty());
        unknownPackageProperty.setCommented(commented);
        propertiesSnapshot.add(unknownPackageProperty);
    }

    private <T, K> void forEach(Multimap<T, K> multimap, BiConsumer<T, K> consumer) {
        multimap.keySet().forEach(key -> multimap.get(key).forEach(value -> consumer.accept(key, value)));
    }

    private static /* synthetic */ void lambda$loadCommentedPropertiesMap$22(Multimap result, String[] array) {
        result.put((Object)array[0].trim(), (Object)array[1].trim());
    }

    private static /* synthetic */ void lambda$overrideByAdditionalTranslations$5(Multimap additionalTranslationsMultimap, String translationKey, String translationText) {
        String normalizedTranslationText = TranslationOverrider.normalizeTranslationText(translationText);
        additionalTranslationsMultimap.put((Object)translationKey, (Object)normalizedTranslationText);
    }

    private static /* synthetic */ void lambda$toProperties$4(Multimap result, Object key, Object value) {
        result.put((Object)key.toString(), (Object)value.toString());
    }

    private static class CachedProperties {
        private final List<Property> properties;
        private final Map<String, List<Property>> propertyKeyToPropertiesCache;

        public CachedProperties(List<Property> properties) {
            this.properties = properties;
            this.propertyKeyToPropertiesCache = properties.stream().collect(Collectors.groupingBy(Property::getKey, HashMap::new, Collectors.toCollection(() -> new ArrayList(4))));
        }

        public boolean contains(String key) {
            return this.propertyKeyToPropertiesCache.containsKey(key);
        }

        public int indexOf(Property propertyPlacement) {
            return this.properties.indexOf(propertyPlacement);
        }

        public Stream<Property> filterByKey(String key) {
            return Optional.ofNullable(this.propertyKeyToPropertiesCache.get(key)).orElse(Collections.emptyList()).stream();
        }

        public Stream<Property> filterByKeyAndValue(String key, String value) {
            return this.filterByKey(key).filter(property -> property.getValue().equals(value));
        }

        public void add(Property property) {
            this.properties.add(property);
            this.onPropertyAdded(property);
        }

        public void add(int index, Property property) {
            this.properties.add(index, property);
            this.onPropertyAdded(property);
        }

        private void onPropertyAdded(Property property) {
            this.propertyKeyToPropertiesCache.computeIfAbsent(property.getKey(), k -> {
                ArrayList<Property> properties = new ArrayList<Property>(4);
                properties.add(property);
                return properties;
            });
        }
    }
}

